/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.optimizer.gui.view;

import de.rcenvironment.components.optimizer.common.Dimension;
import de.rcenvironment.components.optimizer.common.Measure;
import de.rcenvironment.components.optimizer.common.OptimizerReceiver;
import de.rcenvironment.components.optimizer.common.OptimizerResultService;
import de.rcenvironment.components.optimizer.common.OptimizerResultSet;
import de.rcenvironment.components.optimizer.common.ResultSet;
import de.rcenvironment.components.optimizer.common.ResultStructure;
import de.rcenvironment.components.optimizer.gui.view.DatasetNotificationSubscriber;
import de.rcenvironment.core.communication.common.ResolvableNodeId;
import de.rcenvironment.core.notification.NotificationSubscriber;
import de.rcenvironment.core.utils.common.rpc.RemoteOperationException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.LogFactory;

public final class OptimizerDatastore
extends ResultSet {
    private static final long serialVersionUID = 990775937058384209L;
    private static List<DatasetNotificationSubscriber> notificationSubscriber;
    private final List<OptimizerResultSet> datasets = Collections.synchronizedList(new LinkedList());
    private final List<OptimizerResultSetAddListener> listeners = new LinkedList<OptimizerResultSetAddListener>();
    private final Map<String, Double> minValues = new HashMap<String, Double>();
    private final Map<String, Double> maxValues = new HashMap<String, Double>();

    public OptimizerDatastore(String identifier, String title, ResultStructure structure) {
        super(identifier, title, structure);
    }

    public void addDataset(OptimizerResultSet dataset) {
        this.datasets.add(dataset);
        this.fireDatasetAdd(dataset);
        for (Dimension dimension : this.getStructure().getDimensions()) {
            this.adjustMinMaxRange(dataset, dimension.getName());
        }
        for (Measure measure : this.getStructure().getMeasures()) {
            this.adjustMinMaxRange(dataset, measure.getName());
        }
    }

    private void adjustMinMaxRange(OptimizerResultSet dataset, String key) {
        double value = dataset.getValue(key);
        if (this.minValues.get(key) == null || this.minValues.get(key) > value) {
            this.minValues.put(key, value);
        }
        if (this.maxValues.get(key) == null || this.maxValues.get(key) < value) {
            this.maxValues.put(key, value);
        }
    }

    public Collection<OptimizerResultSet> getDatasets() {
        return Collections.unmodifiableCollection(this.datasets);
    }

    public int getDatasetCount() {
        return this.datasets.size();
    }

    public Double getMinValue(String key) {
        return this.minValues.get(key);
    }

    public Double getMaxValue(String key) {
        return this.maxValues.get(key);
    }

    public static OptimizerDatastore connect(String identifier, ResolvableNodeId platform, OptimizerResultService optimizerResultService) {
        OptimizerReceiver receiver;
        block4: {
            try {
                receiver = optimizerResultService.createReceiver(identifier, platform);
                if (receiver != null) break block4;
                LogFactory.getLog(OptimizerDatastore.class).error((Object)("Failed to get values from node: " + platform));
                return null;
            }
            catch (RemoteOperationException remoteOperationException) {
                LogFactory.getLog(OptimizerDatastore.class).error((Object)("Failed to get values from remote node: " + platform));
                return null;
            }
        }
        OptimizerDatastore datastore = new OptimizerDatastore(identifier, receiver.getStudy().getTitle(), receiver.getStudy().getStructure());
        if (notificationSubscriber == null) {
            notificationSubscriber = new LinkedList<DatasetNotificationSubscriber>();
        }
        DatasetNotificationSubscriber newNotificationSubscriber = new DatasetNotificationSubscriber(datastore);
        receiver.setNotificationSubscriber((NotificationSubscriber)newNotificationSubscriber);
        receiver.initialize();
        notificationSubscriber.add(newNotificationSubscriber);
        return datastore;
    }

    public void addDatasetAddListener(OptimizerResultSetAddListener listener) {
        this.listeners.add(listener);
    }

    public void removeDatasetAddListener(OptimizerResultSetAddListener listener) {
        this.listeners.remove(listener);
    }

    private void fireDatasetAdd(OptimizerResultSet dataset) {
        OptimizerResultSetAddListener[] listenersArray;
        OptimizerResultSetAddListener[] optimizerResultSetAddListenerArray = listenersArray = this.listeners.toArray(new OptimizerResultSetAddListener[0]);
        int n = listenersArray.length;
        int n2 = 0;
        while (n2 < n) {
            OptimizerResultSetAddListener listener = optimizerResultSetAddListenerArray[n2];
            try {
                listener.handleStudyDatasetAdd(dataset);
            }
            catch (RuntimeException runtimeException) {
            }
            ++n2;
        }
    }

    public static interface OptimizerResultSetAddListener {
        public void handleStudyDatasetAdd(OptimizerResultSet var1);
    }
}

