/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.rule;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.log4j.rule.AbstractRule;
import org.apache.log4j.rule.Rule;
import org.apache.log4j.spi.LoggingEvent;

public class AndRule
extends AbstractRule {
    private final Rule firstRule;
    private final Rule secondRule;
    static final long serialVersionUID = -8233444426923854651L;

    private AndRule(Rule first, Rule second) {
        this.firstRule = first;
        this.secondRule = second;
    }

    public static Rule getRule(Stack stack) {
        if (stack.size() < 2) {
            throw new IllegalArgumentException("Invalid AND rule - expected two rules but received " + stack.size());
        }
        Object o2 = stack.pop();
        Object o1 = stack.pop();
        if (o2 instanceof Rule && o1 instanceof Rule) {
            Rule p2 = (Rule)o2;
            Rule p1 = (Rule)o1;
            return new AndRule(p1, p2);
        }
        throw new IllegalArgumentException("Invalid AND rule: " + o2 + "..." + o1);
    }

    public static Rule getRule(Rule firstParam, Rule secondParam) {
        return new AndRule(firstParam, secondParam);
    }

    @Override
    public boolean evaluate(LoggingEvent event, Map matches) {
        boolean result;
        if (matches == null) {
            return this.firstRule.evaluate(event, null) && this.secondRule.evaluate(event, null);
        }
        HashMap tempMatches1 = new HashMap();
        HashMap tempMatches2 = new HashMap();
        boolean bl = result = this.firstRule.evaluate(event, tempMatches1) && this.secondRule.evaluate(event, tempMatches2);
        if (result) {
            Set mainSet;
            Set value;
            Object key;
            for (Map.Entry entry : tempMatches1.entrySet()) {
                key = entry.getKey();
                value = (Set)entry.getValue();
                mainSet = (HashSet)matches.get(key);
                if (mainSet == null) {
                    mainSet = new HashSet();
                    matches.put(key, mainSet);
                }
                mainSet.addAll(value);
            }
            for (Map.Entry entry : tempMatches2.entrySet()) {
                key = entry.getKey();
                value = (Set)entry.getValue();
                mainSet = (Set)matches.get(key);
                if (mainSet == null) {
                    mainSet = new HashSet();
                    matches.put(key, mainSet);
                }
                mainSet.addAll(value);
            }
        }
        return result;
    }
}

