/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.toolkit.modules.concurrency.setup;

import de.rcenvironment.toolkit.core.api.ImmutableServiceRegistry;
import de.rcenvironment.toolkit.core.spi.module.AbstractToolkitModule;
import de.rcenvironment.toolkit.core.spi.module.ObjectGraph;
import de.rcenvironment.toolkit.core.spi.module.ShutdownHookReceiver;
import de.rcenvironment.toolkit.core.spi.module.ToolkitModule;
import de.rcenvironment.toolkit.modules.concurrency.api.ThreadPoolManagementAccess;
import de.rcenvironment.toolkit.modules.concurrency.internal.AsyncTaskServiceImpl;
import de.rcenvironment.toolkit.modules.concurrency.internal.ConcurrencyUtilsFactoryImpl;
import de.rcenvironment.toolkit.modules.concurrency.setup.ConcurrencyModuleConfiguration;
import de.rcenvironment.toolkit.modules.introspection.api.StatusCollectionRegistry;
import de.rcenvironment.toolkit.modules.introspection.setup.IntrospectionModule;
import de.rcenvironment.toolkit.modules.statistics.api.StatisticsTrackerService;
import de.rcenvironment.toolkit.modules.statistics.setup.StatisticsModule;
import java.util.Set;

public class ConcurrencyModule
extends AbstractToolkitModule<ConcurrencyModuleConfiguration> {
    public void registerMembers(ObjectGraph objectGraph) {
        objectGraph.registerObject(this.getConfiguration());
        objectGraph.registerServiceClass(AsyncTaskServiceImpl.class);
        objectGraph.registerServiceClass(ConcurrencyUtilsFactoryImpl.class);
    }

    public ConcurrencyModuleConfiguration createConfigurationObject() {
        return new ConcurrencyModuleConfiguration();
    }

    public void suggestMissingModuleDependencies(ObjectGraph objectGraph, Set<Class<? extends ToolkitModule<?>>> modulesToLoad) {
        if (objectGraph.isMissingService(StatusCollectionRegistry.class)) {
            modulesToLoad.add(IntrospectionModule.class);
        }
        if (objectGraph.isMissingService(StatisticsTrackerService.class)) {
            modulesToLoad.add(StatisticsModule.class);
        }
    }

    public void registerShutdownHooks(ImmutableServiceRegistry serviceRegistry, ShutdownHookReceiver shutdownHookReceiver) {
        final ThreadPoolManagementAccess threadPoolManagementAccess = (ThreadPoolManagementAccess)serviceRegistry.getService(ThreadPoolManagementAccess.class);
        shutdownHookReceiver.addShutdownHook(new Runnable(){

            @Override
            public void run() {
                threadPoolManagementAccess.shutdown();
            }
        });
    }
}

