/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.start.validators.internal;

import de.rcenvironment.core.configuration.ConfigurationService;
import de.rcenvironment.core.start.common.validation.api.InstanceValidationResult;
import de.rcenvironment.core.start.common.validation.api.InstanceValidationResultFactory;
import de.rcenvironment.core.start.common.validation.spi.DefaultInstanceValidator;
import de.rcenvironment.core.start.validators.internal.Messages;
import java.io.File;

public class ProfileDirectoryWritableValidator
extends DefaultInstanceValidator {
    private ConfigurationService configurationService;

    public InstanceValidationResult validate() {
        File profileDir = this.configurationService.getProfileDirectory();
        if (!profileDir.exists() || !profileDir.isDirectory()) {
            String errorMessage = String.valueOf(Messages.directoryRceFolderDoesNotExist) + profileDir.getAbsolutePath();
            return InstanceValidationResultFactory.createResultForFailureWhichRequiresInstanceShutdown((String)"RCE profile directory", (String)errorMessage);
        }
        if (!profileDir.canRead() || !profileDir.canWrite()) {
            String errorMessage = String.valueOf(Messages.directoryRceFolderNotReadWriteAble) + profileDir.getAbsolutePath();
            return InstanceValidationResultFactory.createResultForFailureWhichRequiresInstanceShutdown((String)"RCE profile directory", (String)errorMessage);
        }
        return InstanceValidationResultFactory.createResultForPassed((String)"RCE profile directory");
    }

    protected void bindConfigurationService(ConfigurationService newConfigurationService) {
        this.configurationService = newConfigurationService;
    }
}

