/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.instancemanagement.internal;

import de.rcenvironment.core.instancemanagement.InstanceStatus;
import de.rcenvironment.core.instancemanagement.internal.InstanceOperationException;
import de.rcenvironment.core.instancemanagement.internal.InstanceShutdownTask;
import de.rcenvironment.core.instancemanagement.internal.InstanceStarterTask;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.textstream.TextOutputReceiver;
import de.rcenvironment.toolkit.modules.concurrency.api.TaskDescription;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.FileUtils;

public class InstanceOperationsImpl {
    private static final String INSTANCEMANAGEMENT_LOCK = "instancemanagement.lock";
    private static final int WAIT_TIMEOUT_SEC = 60;
    private static final String STARTUP_INTERRUPTED_EXCEPTION = "Interrupted while waiting for the RCE startup to complete";
    private static final String COMMAND_ARGUMENTS_FILE_NAME = "im_command_arguments";
    private Map<String, BlockingQueue<Runnable>> profileNameToStartShutdownTasksQueue = new ConcurrentHashMap<String, BlockingQueue<Runnable>>();
    private Map<Runnable, CountDownLatch> taskToLatchMap = new ConcurrentHashMap<Runnable, CountDownLatch>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startInstanceUsingInstallation(List<File> profileDirList, File installationDir, ConcurrentMap<String, InstanceStatus> profileIdToInstanceStatusMap, long timeout, TextOutputReceiver userOutputReceiver, boolean startWithGUI) throws InstanceOperationException {
        File installationConfigDir = new File(installationDir, "configuration");
        if (!installationConfigDir.isDirectory()) {
            throw new InstanceOperationException("Expected to find an installation configuration directory at '" + installationConfigDir.getAbsolutePath() + "' but it does not seem to exist");
        }
        CountDownLatch startupOutputDetected = new CountDownLatch(profileDirList.size());
        AtomicBoolean startuptOutputIndicatesSuccess = new AtomicBoolean(true);
        long tempTimeout = this.calcTimeout(timeout);
        HashMap<String, InstanceOperationsWorkerTask> profileToWorkerTask = new HashMap<String, InstanceOperationsWorkerTask>();
        HashMap<String, InstanceStarterTask> profileToStarterTask = new HashMap<String, InstanceStarterTask>();
        for (File profile : profileDirList) {
            String commandArguments;
            CountDownLatch individualLatch = new CountDownLatch(1);
            InstanceStatus status = (InstanceStatus)profileIdToInstanceStatusMap.get(profile.getName());
            try {
                commandArguments = this.hasCommandArgumentsFile(profile) ? this.readCommandArguments(profile) : "";
            }
            catch (IOException iOException) {
                throw new InstanceOperationException("Failed to read command arguments file in profile directory: " + profile.getName());
            }
            InstanceStarterTask r = new InstanceStarterTask(tempTimeout, startWithGUI, userOutputReceiver, profile, installationDir, commandArguments, individualLatch, startupOutputDetected, startuptOutputIndicatesSuccess, status);
            profileToStarterTask.put(profile.getName(), r);
            Map<Runnable, CountDownLatch> map = this.taskToLatchMap;
            synchronized (map) {
                this.taskToLatchMap.put(r, individualLatch);
            }
            InstanceOperationsWorkerTask workerTask = this.doInstanceOperationStep(r, profile, tempTimeout, userOutputReceiver);
            if (workerTask == null) continue;
            profileToWorkerTask.put(profile.getName(), workerTask);
        }
        try {
            if (!startupOutputDetected.await(tempTimeout, TimeUnit.SECONDS)) {
                ArrayList<String> failedInstances = new ArrayList<String>();
                for (File profile : profileDirList) {
                    Future<?> future;
                    String instanceName = profile.getName();
                    InstanceStatus instanceStatus = (InstanceStatus)profileIdToInstanceStatusMap.get(instanceName);
                    if (instanceStatus.getInstanceState() != InstanceStatus.InstanceState.STARTING) continue;
                    instanceStatus.setInstanceState(InstanceStatus.InstanceState.NOTRUNNING);
                    failedInstances.add(instanceName);
                    InstanceOperationsWorkerTask workerTask = (InstanceOperationsWorkerTask)profileToWorkerTask.get(instanceName);
                    if (workerTask == null || (future = workerTask.getFutureOfTask((Runnable)profileToStarterTask.get(instanceName))) == null) continue;
                    future.cancel(true);
                }
                String message = "Timeout reached while waiting for startup to finish, aborting...(failed instances: ";
                for (String name : failedInstances) {
                    message = String.valueOf(message) + name + " ";
                }
                message = String.valueOf(message) + ")";
                throw new InstanceOperationException(message);
            }
            if (!startuptOutputIndicatesSuccess.get()) {
                throw new InstanceOperationException("Unexpected failure during startup.");
            }
        }
        catch (InterruptedException interruptedException) {
            throw new InstanceOperationException(STARTUP_INTERRUPTED_EXCEPTION);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownInstance(List<File> profileDirList, long timeout, TextOutputReceiver userOutputReceiver) throws InstanceOperationException {
        CountDownLatch startupOutputDetected = new CountDownLatch(profileDirList.size());
        long tempTimeout = this.calcTimeout(timeout);
        for (File profile : profileDirList) {
            CountDownLatch individualLatch = new CountDownLatch(1);
            InstanceShutdownTask r = new InstanceShutdownTask(profile, tempTimeout, userOutputReceiver, startupOutputDetected, individualLatch);
            Map<Runnable, CountDownLatch> map = this.taskToLatchMap;
            synchronized (map) {
                this.taskToLatchMap.put(r, individualLatch);
            }
            this.doInstanceOperationStep(r, profile, tempTimeout, userOutputReceiver);
        }
        try {
            if (!startupOutputDetected.await(tempTimeout, TimeUnit.SECONDS)) {
                throw new InstanceOperationException("Timeout reached while waiting for shutdown to finish, aborting...");
            }
        }
        catch (InterruptedException interruptedException) {
            throw new InstanceOperationException(STARTUP_INTERRUPTED_EXCEPTION);
        }
    }

    private String readCommandArguments(File profile) throws IOException {
        File commandArgumentsFile = new File(profile.getPath(), COMMAND_ARGUMENTS_FILE_NAME);
        return FileUtils.readFileToString((File)commandArgumentsFile, (Charset)Charsets.UTF_8);
    }

    public void writeCommandArguments(File profile, String argumentsToWrite) throws IOException {
        File commandArgumentsFile = new File(profile.getPath(), COMMAND_ARGUMENTS_FILE_NAME);
        FileUtils.writeStringToFile((File)commandArgumentsFile, (String)argumentsToWrite, (Charset)Charsets.UTF_8);
    }

    public boolean hasCommandArgumentsFile(File profile) {
        return new File(profile, COMMAND_ARGUMENTS_FILE_NAME).exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private InstanceOperationsWorkerTask doInstanceOperationStep(Runnable r, File profile, long timeout, TextOutputReceiver userOutputReceiver) throws InstanceOperationException {
        Map<String, BlockingQueue<Runnable>> map = this.profileNameToStartShutdownTasksQueue;
        synchronized (map) {
            if (this.profileNameToStartShutdownTasksQueue.containsKey(profile.getName())) {
                try {
                    this.profileNameToStartShutdownTasksQueue.get(profile.getName()).put(r);
                    return null;
                }
                catch (InterruptedException interruptedException) {
                    throw new InstanceOperationException(STARTUP_INTERRUPTED_EXCEPTION);
                }
            }
            LinkedBlockingQueue<Runnable> instanceStartupTaskQueue = new LinkedBlockingQueue<Runnable>();
            InstanceOperationsWorkerTask workerTask = new InstanceOperationsWorkerTask(instanceStartupTaskQueue, timeout, userOutputReceiver, profile);
            try {
                instanceStartupTaskQueue.put(r);
            }
            catch (InterruptedException interruptedException) {
                throw new InstanceOperationException(STARTUP_INTERRUPTED_EXCEPTION);
            }
            ConcurrencyUtils.getAsyncTaskService().submit((Runnable)workerTask);
            this.profileNameToStartShutdownTasksQueue.put(profile.getName(), instanceStartupTaskQueue);
            return workerTask;
        }
    }

    private long calcTimeout(long timeout) {
        long tempTimeout = timeout == 0L ? 60L : timeout;
        return tempTimeout;
    }

    private void releaseIMLockFile(File profile) throws IOException {
        block13: {
            File lockfile = new File(String.valueOf(profile.getAbsolutePath()) + "/" + INSTANCEMANAGEMENT_LOCK);
            FileLock lock = null;
            if (!lockfile.isFile()) {
                return;
            }
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (RandomAccessFile randomAccessFile = new RandomAccessFile(lockfile, "rw");){
                    lock = randomAccessFile.getChannel().tryLock();
                    if (lock != null) {
                        lock.release();
                        break block13;
                    }
                    throw new IOException("Could not release lock as it's hold by another instance.");
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new IOException("Unexpected error when trying to acquire a file lock on " + lockfile, e);
            }
        }
    }

    private void deleteIMFile(File profile, String name) throws IOException {
        if (profile.isDirectory()) {
            String fileName = "";
            fileName = name.equals("installation") ? name : INSTANCEMANAGEMENT_LOCK;
            File[] fileArray = profile.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.getName().equals(fileName)) {
                    boolean success = f.delete();
                    if (success) break;
                    throw new IOException("Failed to delete " + fileName + " file.");
                }
                ++n2;
            }
        }
    }

    private void releaseAndDeleteLockFile(File profile) throws IOException {
        this.releaseIMLockFile(profile);
        this.deleteIMFile(profile, INSTANCEMANAGEMENT_LOCK);
    }

    static /* synthetic */ Map access$0(InstanceOperationsImpl instanceOperationsImpl) {
        return instanceOperationsImpl.taskToLatchMap;
    }

    static /* synthetic */ void access$1(InstanceOperationsImpl instanceOperationsImpl, File file) throws IOException {
        instanceOperationsImpl.releaseAndDeleteLockFile(file);
    }

    private class InstanceOperationsWorkerTask
    implements Runnable {
        private final BlockingQueue<Runnable> sharedQueue;
        private final long timeout;
        private final TextOutputReceiver userOutputReceiver;
        private final File profile;
        private Map<Runnable, Future<?>> submittedRunnableToFutureMap;

        InstanceOperationsWorkerTask(BlockingQueue<Runnable> sharedQueue, long timeout, TextOutputReceiver userOutputreceiver, File profile) {
            this.sharedQueue = sharedQueue;
            this.timeout = timeout;
            this.userOutputReceiver = userOutputreceiver;
            this.profile = profile;
            this.submittedRunnableToFutureMap = new HashMap();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        @TaskDescription(value="IM start/stop execution")
        public void run() {
            do lbl-1000:
            // 3 sources

            {
                block14: {
                    if ((task = (Runnable)this.sharedQueue.poll()) != null) break block14;
                    if (!this.doCleanUp()) ** GOTO lbl-1000
                    return;
                }
                latch = null;
                var3_3 = InstanceOperationsImpl.access$0(InstanceOperationsImpl.this);
                synchronized (var3_3) {
                    latch = (CountDownLatch)InstanceOperationsImpl.access$0(InstanceOperationsImpl.this).get(task);
                }
                if (task == null) continue;
                future = ConcurrencyUtils.getAsyncTaskService().submit(task);
                var4_4 = this.submittedRunnableToFutureMap;
                synchronized (var4_4) {
                    this.submittedRunnableToFutureMap.put(task, future);
                }
                try {
                    if (latch != null) {
                        latch.await(this.timeout, TimeUnit.SECONDS);
                    }
                    InstanceOperationsImpl.access$1(InstanceOperationsImpl.this, this.profile);
                    var4_4 = InstanceOperationsImpl.access$0(InstanceOperationsImpl.this);
                    synchronized (var4_4) {
                        InstanceOperationsImpl.access$0(InstanceOperationsImpl.this).remove(task);
                    }
                }
                catch (InterruptedException v3) {
                    this.userOutputReceiver.addOutput("An error occured while waiting for instance with id: ");
                }
                catch (IOException e) {
                    this.userOutputReceiver.addOutput("Failed to release and/or delete IM lockfile. Aborted with message: " + e.getMessage());
                }
            } while (!this.doCleanUp());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Future<?> getFutureOfTask(Runnable task) {
            Map<Runnable, Future<?>> map = this.submittedRunnableToFutureMap;
            synchronized (map) {
                return this.submittedRunnableToFutureMap.get(task);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean doCleanUp() {
            Map map = InstanceOperationsImpl.this.profileNameToStartShutdownTasksQueue;
            synchronized (map) {
                block4: {
                    if (this.sharedQueue.isEmpty()) break block4;
                    return false;
                }
                InstanceOperationsImpl.this.profileNameToStartShutdownTasksQueue.remove(this.profile.getName());
                return true;
            }
        }
    }
}

