/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.verify;

import de.rcenvironment.core.component.execution.api.ComponentExecutionInformation;
import de.rcenvironment.core.component.execution.api.ComponentExecutionService;
import de.rcenvironment.core.utils.common.rpc.RemoteOperationException;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.core.utils.incubator.ServiceRegistryAccess;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncTaskService;
import de.rcenvironment.toolkit.modules.concurrency.api.TaskDescription;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ComponentResultVerificationInfoWizardPage
extends WizardPage {
    private static final String RETRIEVING = "[Fetching...]";
    private static final String UNKNOWN = "[Unknown]";
    private static final String TITLE = "Tool Result Verification";
    private String verificationToken = null;
    private Label compNameLabel;
    private Label wfNameLabel;
    private Label compHostLabel;
    private Label wfHostLabel;
    private AsyncTaskService asyncTaskService;
    private ComponentExecutionService componentExecutionService;
    private Button verifyButton;
    private Button denyButton;
    private Display display;
    private ComponentExecutionInformation compExeInfo = null;

    protected ComponentResultVerificationInfoWizardPage() {
        super(TITLE);
        this.setTitle(TITLE);
        ServiceRegistryAccess registryAccess = ServiceRegistry.createAccessFor((Object)((Object)this));
        this.asyncTaskService = (AsyncTaskService)registryAccess.getService(AsyncTaskService.class);
        this.componentExecutionService = (ComponentExecutionService)registryAccess.getService(ComponentExecutionService.class);
    }

    public void createControl(Composite parent) {
        this.display = parent.getDisplay();
        Composite content = new Composite(parent, 0);
        content.setLayout((Layout)new GridLayout(2, false));
        GridData layoutData = new GridData(4, 4, true, true);
        content.setLayoutData((Object)layoutData);
        Label compNameLeftLabel = new Label(content, 0);
        compNameLeftLabel.setText("Tool:");
        this.compNameLabel = new Label(content, 0);
        layoutData = new GridData(4, 0, true, false);
        this.compNameLabel.setLayoutData((Object)layoutData);
        Label compHostLeftLabel = new Label(content, 0);
        compHostLeftLabel.setText("Tool host machine:");
        this.compHostLabel = new Label(content, 0);
        layoutData = new GridData(4, 0, true, false);
        this.compHostLabel.setLayoutData((Object)layoutData);
        Label wfNameLeftLabel = new Label(content, 0);
        wfNameLeftLabel.setText("Workflow:");
        this.wfNameLabel = new Label(content, 0);
        layoutData = new GridData(4, 0, true, false);
        this.wfNameLabel.setLayoutData((Object)layoutData);
        Label wfHostLeftLabel = new Label(content, 0);
        wfHostLeftLabel.setText("Workflow host machine:");
        this.wfHostLabel = new Label(content, 0);
        layoutData = new GridData(4, 0, true, false);
        this.wfHostLabel.setLayoutData((Object)layoutData);
        Label separator = new Label(content, 258);
        layoutData = new GridData(768);
        layoutData.horizontalSpan = 2;
        separator.setLayoutData((Object)layoutData);
        Composite decisionComposite = new Composite(content, 0);
        decisionComposite.setLayout((Layout)new GridLayout(2, true));
        layoutData = new GridData(4, 4, true, true);
        layoutData.horizontalSpan = 2;
        decisionComposite.setLayoutData((Object)layoutData);
        this.verifyButton = new Button(decisionComposite, 16);
        this.verifyButton.setText("Approve tool results");
        layoutData = new GridData(4, 0, true, false);
        layoutData.horizontalAlignment = 131072;
        this.verifyButton.setLayoutData((Object)layoutData);
        this.verifyButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                this.widgetDefaultSelected(event);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                ComponentResultVerificationInfoWizardPage.this.validateInput();
            }
        });
        this.denyButton = new Button(decisionComposite, 16);
        this.denyButton.setText("Reject tool results");
        layoutData = new GridData(4, 0, true, false);
        layoutData.horizontalAlignment = 16384;
        this.denyButton.setLayoutData((Object)layoutData);
        this.denyButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                this.widgetDefaultSelected(event);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                ComponentResultVerificationInfoWizardPage.this.validateInput();
            }
        });
        this.setControl((Control)content);
        this.setComponentInfos();
        this.validateInput();
    }

    private void setComponentInfos() {
        if (this.compExeInfo == null) {
            this.compNameLabel.setText(UNKNOWN);
            this.wfNameLabel.setText(UNKNOWN);
            this.compHostLabel.setText(UNKNOWN);
            this.wfHostLabel.setText(UNKNOWN);
        } else {
            this.compNameLabel.setText(this.compExeInfo.getInstanceName());
            this.wfNameLabel.setText(this.compExeInfo.getWorkflowInstanceName());
            this.compHostLabel.setText(this.compExeInfo.getNodeId().getAssociatedDisplayName());
            this.wfHostLabel.setText(this.compExeInfo.getWorkflowNodeId().getAssociatedDisplayName());
        }
    }

    private void clearComponentInfos() {
        this.compNameLabel.setText(RETRIEVING);
        this.wfNameLabel.setText(RETRIEVING);
        this.compHostLabel.setText(RETRIEVING);
        this.wfHostLabel.setText(RETRIEVING);
    }

    private void setupDecisionButtons(boolean enable) {
        this.verifyButton.setEnabled(enable);
        this.denyButton.setEnabled(enable);
        if (!enable) {
            this.verifyButton.setSelection(enable);
            this.denyButton.setSelection(enable);
        }
    }

    private void validateInput(String errorMessage) {
        this.setErrorMessage(errorMessage);
        this.setPageComplete(false);
        this.setupDecisionButtons(false);
    }

    private void validateInput() {
        if (this.compNameLabel.getText().toString().equals(UNKNOWN)) {
            this.setErrorMessage("No tool run found that belongs to key: " + this.verificationToken);
            this.setPageComplete(false);
            this.setupDecisionButtons(false);
        } else if (this.compNameLabel.getText().toString().equals(RETRIEVING)) {
            this.setErrorMessage(null);
            this.setDescription("Verify results of tool run (as soon as information fetched)");
            this.setPageComplete(false);
            this.setupDecisionButtons(false);
        } else if (!this.verifyButton.getSelection() && !this.denyButton.getSelection()) {
            this.setErrorMessage("Decide whether to confirm or deny the tool results");
            this.setPageComplete(false);
            this.setupDecisionButtons(true);
        } else {
            this.setErrorMessage(null);
            this.setDescription("Verify results of tool run");
            this.setPageComplete(true);
            this.setupDecisionButtons(true);
        }
    }

    protected void setVerificationToken(final String verificationToken) {
        if (!(verificationToken == null || this.verificationToken != null && this.verificationToken.equals(verificationToken))) {
            this.verificationToken = verificationToken;
            this.clearComponentInfos();
            this.validateInput();
            this.asyncTaskService.submit(new Runnable(){

                @Override
                @TaskDescription(value="Fetch component information for result verification")
                public void run() {
                    try {
                        final ComponentExecutionInformation info = ComponentResultVerificationInfoWizardPage.this.componentExecutionService.getComponentExecutionInformation(verificationToken);
                        ComponentResultVerificationInfoWizardPage.this.display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (ComponentResultVerificationInfoWizardPage.this.verificationToken != null && ComponentResultVerificationInfoWizardPage.this.verificationToken.equals(verificationToken)) {
                                    ComponentResultVerificationInfoWizardPage.this.compExeInfo = info;
                                    ComponentResultVerificationInfoWizardPage.this.setComponentInfos();
                                    ComponentResultVerificationInfoWizardPage.this.validateInput();
                                }
                            }
                        });
                    }
                    catch (RemoteOperationException e) {
                        LogFactory.getLog(this.getClass()).error((Object)("Failed to fetch information about component execution: " + e.getMessage()));
                        ComponentResultVerificationInfoWizardPage.this.display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                ComponentResultVerificationInfoWizardPage.this.setComponentInfos();
                                ComponentResultVerificationInfoWizardPage.this.validateInput("Failed to find tool run: " + e.getMessage());
                            }
                        });
                    }
                }
            });
        }
    }

    protected String getVerificationToken() {
        return this.verificationToken;
    }

    protected boolean getVerificationResult() {
        return this.verifyButton.getSelection();
    }

    protected ComponentExecutionInformation getComponentExecutionInformation() {
        return this.compExeInfo;
    }
}

