/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.parts;

import de.rcenvironment.core.gui.workflow.parts.WorkflowLabelPart;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.draw2d.AbstractRouter;
import org.eclipse.draw2d.Bendpoint;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutListener;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.draw2d.graph.Path;
import org.eclipse.draw2d.graph.ShortestPathRouter;

public final class CustomShortestPathConnectionRouter
extends AbstractRouter {
    private Map<Connection, Object> constraintMap = new HashMap<Connection, Object>();
    private Map<IFigure, Rectangle> figuresToBounds;
    private Map<Connection, Path> connectionToPaths;
    private boolean isDirty = false;
    private ShortestPathRouter algorithm = new ShortestPathRouter();
    private IFigure container;
    private Set<Connection> staleConnections = new HashSet<Connection>();
    private LayoutListener listener = new LayoutTracker();
    private FigureListener figureListener = new FigureListener(){

        public void figureMoved(IFigure source) {
            Rectangle newBounds = source.getBounds().getCopy();
            if (CustomShortestPathConnectionRouter.this.algorithm.updateObstacle((Rectangle)CustomShortestPathConnectionRouter.this.figuresToBounds.get(source), newBounds)) {
                CustomShortestPathConnectionRouter.this.queueSomeRouting();
                CustomShortestPathConnectionRouter.this.isDirty = true;
            }
            if (!(source instanceof WorkflowLabelPart.TransparentLabel)) {
                CustomShortestPathConnectionRouter.this.figuresToBounds.put(source, newBounds);
            }
        }
    };
    private boolean ignoreInvalidate;

    public CustomShortestPathConnectionRouter(IFigure container) {
        this.algorithm = new ShortestPathRouter();
        this.container = container;
    }

    void addChild(IFigure child) {
        if (this.connectionToPaths == null) {
            return;
        }
        if (this.figuresToBounds.containsKey(child)) {
            return;
        }
        Rectangle bounds = child.getBounds().getCopy();
        if (!(child instanceof WorkflowLabelPart.TransparentLabel)) {
            this.algorithm.addObstacle(bounds);
            this.figuresToBounds.put(child, bounds);
            child.addFigureListener(this.figureListener);
            this.isDirty = true;
        }
    }

    private void hookAll() {
        this.figuresToBounds = new HashMap<IFigure, Rectangle>();
        int i = 0;
        while (i < this.container.getChildren().size()) {
            this.addChild((IFigure)this.container.getChildren().get(i));
            ++i;
        }
        this.container.addLayoutListener(this.listener);
    }

    private void unhookAll() {
        this.container.removeLayoutListener(this.listener);
        if (this.figuresToBounds != null) {
            Iterator<IFigure> figureItr = this.figuresToBounds.keySet().iterator();
            while (figureItr.hasNext()) {
                IFigure child = figureItr.next();
                if (child instanceof WorkflowLabelPart.TransparentLabel) continue;
                figureItr.remove();
                this.removeChild(child);
            }
            this.figuresToBounds = null;
        }
    }

    public Object getConstraint(Connection connection) {
        return this.constraintMap.get(connection);
    }

    public int getSpacing() {
        return this.algorithm.getSpacing();
    }

    public void invalidate(Connection connection) {
        if (this.ignoreInvalidate) {
            return;
        }
        this.staleConnections.add(connection);
        this.isDirty = true;
    }

    private void processLayout() {
        if (this.staleConnections.isEmpty()) {
            return;
        }
        this.staleConnections.iterator().next().revalidate();
    }

    private void processStaleConnections() {
        Iterator<Connection> iter = this.staleConnections.iterator();
        if (iter.hasNext() && this.connectionToPaths == null) {
            this.connectionToPaths = new HashMap<Connection, Path>();
            this.hookAll();
        }
        while (iter.hasNext()) {
            List constraint;
            Connection conn = iter.next();
            Path path = this.connectionToPaths.get(conn);
            if (path == null) {
                path = new Path((Object)conn);
                this.connectionToPaths.put(conn, path);
                this.algorithm.addPath(path);
            }
            if ((constraint = (List)this.getConstraint(conn)) == null) {
                constraint = Collections.EMPTY_LIST;
            }
            Point start = conn.getSourceAnchor().getReferencePoint().getCopy();
            Point end = conn.getTargetAnchor().getReferencePoint().getCopy();
            this.container.translateToRelative((Translatable)start);
            this.container.translateToRelative((Translatable)end);
            path.setStartPoint(start);
            path.setEndPoint(end);
            if (!constraint.isEmpty()) {
                PointList bends = new PointList(constraint.size());
                int i = 0;
                while (i < constraint.size()) {
                    Bendpoint bp = (Bendpoint)constraint.get(i);
                    bends.addPoint(bp.getLocation());
                    ++i;
                }
                path.setBendPoints(bends);
            } else {
                path.setBendPoints(null);
            }
            this.isDirty |= path.isDirty;
        }
        this.staleConnections.clear();
    }

    void queueSomeRouting() {
        if (this.connectionToPaths == null || this.connectionToPaths.isEmpty()) {
            return;
        }
        try {
            this.ignoreInvalidate = true;
            this.connectionToPaths.keySet().iterator().next().revalidate();
        }
        finally {
            this.ignoreInvalidate = false;
        }
    }

    public void remove(Connection connection) {
        this.staleConnections.remove(connection);
        this.constraintMap.remove(connection);
        if (this.connectionToPaths == null) {
            return;
        }
        Path path = this.connectionToPaths.remove(connection);
        this.algorithm.removePath(path);
        this.isDirty = true;
        if (this.connectionToPaths.isEmpty()) {
            this.unhookAll();
            this.connectionToPaths = null;
        } else {
            this.queueSomeRouting();
        }
    }

    void removeChild(IFigure child) {
        if (this.connectionToPaths == null) {
            return;
        }
        Rectangle bounds = child.getBounds().getCopy();
        boolean change = false;
        this.algorithm.removeObstacle(bounds);
        this.figuresToBounds.remove(child);
        child.removeFigureListener(this.figureListener);
        if (change) {
            this.isDirty = true;
            this.queueSomeRouting();
        }
    }

    public void route(Connection conn) {
        if (this.isDirty) {
            this.ignoreInvalidate = true;
            this.processStaleConnections();
            this.isDirty = false;
            List updated = this.algorithm.solve();
            int i = 0;
            while (i < updated.size()) {
                Path path = (Path)updated.get(i);
                Connection current = (Connection)path.data;
                current.revalidate();
                PointList points = path.getPoints().getCopy();
                PrecisionPoint ref1 = new PrecisionPoint(points.getPoint(1));
                PrecisionPoint ref2 = new PrecisionPoint(points.getPoint(points.size() - 2));
                current.translateToAbsolute((Translatable)ref1);
                current.translateToAbsolute((Translatable)ref2);
                Point start = current.getSourceAnchor().getLocation((Point)ref1).getCopy();
                Point end = current.getTargetAnchor().getLocation((Point)ref2).getCopy();
                current.translateToRelative((Translatable)start);
                current.translateToRelative((Translatable)end);
                points.setPoint(start, 0);
                points.setPoint(end, points.size() - 1);
                current.setPoints(points);
                ++i;
            }
            this.ignoreInvalidate = false;
        }
    }

    public void setConstraint(Connection connection, Object constraint) {
        this.staleConnections.add(connection);
        this.constraintMap.put(connection, constraint);
        this.isDirty = true;
    }

    public void setSpacing(int spacing) {
        this.algorithm.setSpacing(spacing);
    }

    private class LayoutTracker
    extends LayoutListener.Stub {
        private LayoutTracker() {
        }

        public void postLayout(IFigure containerFigure) {
            CustomShortestPathConnectionRouter.this.processLayout();
        }

        public void remove(IFigure child) {
            if (!(child instanceof WorkflowLabelPart.TransparentLabel)) {
                CustomShortestPathConnectionRouter.this.removeChild(child);
            }
        }

        public void setConstraint(IFigure child, Object constraint) {
            CustomShortestPathConnectionRouter.this.addChild(child);
        }
    }
}

