/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.execute;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionService;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowFileException;
import de.rcenvironment.core.component.workflow.execution.spi.WorkflowDescriptionLoaderCallback;
import de.rcenvironment.core.component.workflow.model.api.WorkflowDescription;
import de.rcenvironment.core.gui.workflow.GUIWorkflowDescriptionLoaderCallback;
import de.rcenvironment.core.gui.workflow.editor.WorkflowEditor;
import de.rcenvironment.core.gui.workflow.execute.Messages;
import de.rcenvironment.core.gui.workflow.execute.WorkflowExecutionWizard;
import de.rcenvironment.core.utils.common.CrossPlatformFilenameUtils;
import de.rcenvironment.core.utils.common.InvalidFilenameException;
import de.rcenvironment.core.utils.common.JsonUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public class ShowWorkflowExecutionWizardHandler
extends AbstractHandler {
    private static final String DUPLICATE_ID_WARNING_MSG = "Could not determine duplicate WF ids";
    private static final String GETTING_ATTR_WARNING_MSG = " - failed to get file attributes for: ";
    private static final String NODES = "nodes";
    private static final String IDENTIFIER = "identifier";
    private static final Pattern WORKFLOW_FILENAME_PATTERN = Pattern.compile("^.*\\.wf$");
    private static final Log LOGGER = LogFactory.getLog(ShowWorkflowExecutionWizardHandler.class);
    private final ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
    private WorkflowExecutionService workflowExecutionService = (WorkflowExecutionService)ServiceRegistry.createPublisherAccessFor((Object)((Object)this)).getService(WorkflowExecutionService.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        boolean wfFileOpenedInEditor;
        IFile wfFile = this.tryToGetWorkflowFileFromProjectExplorer(event);
        if (wfFile == null) {
            wfFile = this.tryToGetWorkflowFileFromWorkflowEditor();
            if (wfFile == null) {
                return null;
            }
            wfFileOpenedInEditor = true;
        } else {
            if (!this.checkForOpenRelatedDirtyWorkflowEditor(wfFile)) {
                return null;
            }
            wfFileOpenedInEditor = false;
        }
        this.searchAndReplaceDuplicateIDs(wfFile);
        try {
            CrossPlatformFilenameUtils.throwExceptionIfFilenameNotValid((String)wfFile.getName());
        }
        catch (InvalidFilenameException invalidFilenameException) {
            MessageDialog.open((int)4, null, (String)"Error during Workflow preparation", (String)"The workflow's file name is not valid on all supported platforms. Please rename the workflow.", (int)0);
            return null;
        }
        if (wfFileOpenedInEditor) {
            this.openWorkflowExecutionWizardWithWfFileFromEditor(wfFile);
        } else {
            this.openWorkflowExecutionWizardWithWfFileFromProjectExplorer(wfFile);
        }
        return null;
    }

    private void openWorkflowExecutionWizardWithWfFileFromEditor(IFile wfFile) {
        WorkflowDescription wfDescription = null;
        try {
            File wfFile2 = new File(wfFile.getLocation().toOSString());
            if (wfFile2.exists()) {
                wfDescription = this.workflowExecutionService.loadWorkflowDescriptionFromFile(wfFile2, (WorkflowDescriptionLoaderCallback)new GUIWorkflowDescriptionLoaderCallback());
            }
        }
        catch (WorkflowFileException | RuntimeException e) {
            LogFactory.getLog(((Object)((Object)this)).getClass()).error((Object)("Failed to load workflow: " + wfFile.getLocation().toOSString()), e);
            return;
        }
        if (wfDescription != null) {
            this.openWorkflowExecutionWizard(wfFile, wfDescription);
        } else {
            MessageDialog.open((int)4, null, (String)"Error Loading Workflow", (String)"The workflow file could not be found.\nMaybe it was renamed?", (int)0);
        }
    }

    private void openWorkflowExecutionWizardWithWfFileFromProjectExplorer(IFile wfFile) {
        final IFile finalWfFile = wfFile;
        Job job = new Job("Executing workflow"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    try {
                        monitor.beginTask("Loading workflow components", 2);
                        monitor.worked(1);
                        final WorkflowDescription wfDescription = ShowWorkflowExecutionWizardHandler.this.workflowExecutionService.loadWorkflowDescriptionFromFileConsideringUpdates(new File(finalWfFile.getRawLocation().toOSString()), (WorkflowDescriptionLoaderCallback)new GUIWorkflowDescriptionLoaderCallback());
                        monitor.worked(1);
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                ShowWorkflowExecutionWizardHandler.this.openWorkflowExecutionWizard(finalWfFile, wfDescription);
                            }
                        });
                    }
                    catch (WorkflowFileException e) {
                        LogFactory.getLog(((Object)((Object)this)).getClass()).error((Object)("Failed to load workflow: " + finalWfFile.getRawLocation().toOSString()), (Throwable)e);
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Workflow File Error", (String)e.getMessage());
                            }
                        });
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    private void openWorkflowExecutionWizard(IFile wfFile, WorkflowDescription wfDescription) {
        WorkflowExecutionWizard wfExecutionWizard = new WorkflowExecutionWizard(wfFile, wfDescription);
        WorkflowWizardDialog wizardDialog = new WorkflowWizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), wfExecutionWizard);
        wizardDialog.setBlockOnOpen(false);
        wizardDialog.open();
    }

    private boolean checkForOpenRelatedDirtyWorkflowEditor(IFile wfFile) {
        IEditorReference[] currentEditors;
        IEditorReference[] iEditorReferenceArray = currentEditors = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
        int n = currentEditors.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference editor = iEditorReferenceArray[n2];
            IEditorPart editorPart = (IEditorPart)editor.getPart(true);
            if (editorPart instanceof WorkflowEditor) {
                WorkflowEditor workflowEditor = (WorkflowEditor)editorPart;
                IFile editorFile = ((FileEditorInput)workflowEditor.getEditorInput()).getFile();
                if (wfFile.getProject().equals((Object)editorFile.getProject()) && wfFile.getName().equals(editorPart.getTitle()) && editorPart.isDirty()) {
                    return this.saveChangesDialog(editorPart);
                }
            }
            ++n2;
        }
        return true;
    }

    private IFile tryToGetWorkflowFileFromWorkflowEditor() {
        IEditorPart editor;
        IEditorPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (part instanceof IEditorPart && (editor = part) instanceof WorkflowEditor) {
            WorkflowEditor workflowEditor = (WorkflowEditor)editor;
            IEditorInput input = workflowEditor.getEditorInput();
            if (input instanceof FileEditorInput) {
                if (!workflowEditor.isDirty() || this.saveChangesDialog((IEditorPart)workflowEditor)) {
                    return ((FileEditorInput)input).getFile();
                }
            } else if (input instanceof FileStoreEditorInput) {
                MessageDialog.openInformation((Shell)part.getSite().getShell(), (String)"Workflow Run", (String)"Workflow file can not be executed. Please put the workflow into a project of your workspace first.\n\nDrag the workflow from the file system into the project explorer to a project of your choice. You can decide to either copy or only link it.\n\nIf you don't have a project yet, create one first via File->New->Project->General.");
            }
        }
        return null;
    }

    private IFile tryToGetWorkflowFileFromProjectExplorer(ExecutionEvent event) {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object next : structuredSelection) {
                IFile file;
                String filename;
                if (!(next instanceof IFile) || !WORKFLOW_FILENAME_PATTERN.matcher(filename = (file = (IFile)next).getName()).matches()) continue;
                return file;
            }
        }
        return null;
    }

    private boolean saveChangesDialog(IEditorPart editor) {
        IEditorPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (MessageDialog.openConfirm((Shell)part.getSite().getShell(), (String)Messages.askToSaveUnsavedEditorChangesTitle, (String)StringUtils.format((String)Messages.askToSaveUnsavedEditorChangesMessage, (Object[])new Object[]{editor.getTitle()}))) {
            editor.doSave(null);
            return true;
        }
        return false;
    }

    private void searchAndReplaceDuplicateIDs(IFile workflowFile) {
        String absoluteFilePath = workflowFile.getLocation().toString();
        Set<IResource> wfsWithDuplicateId = this.searchForDuplicateWFIdentifier(absoluteFilePath);
        if (wfsWithDuplicateId != null && !wfsWithDuplicateId.isEmpty()) {
            try {
                Path orig = Paths.get(absoluteFilePath, new String[0]);
                BasicFileAttributeView origAttrView = Files.getFileAttributeView(orig, BasicFileAttributeView.class, new LinkOption[0]);
                if (origAttrView == null) {
                    LOGGER.warn((Object)("Could not determine duplicate WF ids - failed to get file attributes for: " + absoluteFilePath));
                    return;
                }
                BasicFileAttributes attrOrig = origAttrView.readAttributes();
                for (IResource duplicate : wfsWithDuplicateId) {
                    Path duplicatePath = Paths.get(duplicate.getLocationURI());
                    BasicFileAttributeView attrViewDuplicate = Files.getFileAttributeView(duplicatePath, BasicFileAttributeView.class, new LinkOption[0]);
                    if (attrViewDuplicate == null) {
                        LOGGER.warn((Object)("Could not determine duplicate WF ids - failed to get file attributes for: " + absoluteFilePath));
                        continue;
                    }
                    BasicFileAttributes attrDuplicate = attrViewDuplicate.readAttributes();
                    if (attrOrig.creationTime().compareTo(attrDuplicate.creationTime()) > 0) {
                        this.replaceIdentifierInWorkflowFile(absoluteFilePath);
                        workflowFile.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                        continue;
                    }
                    this.replaceIdentifierInWorkflowFile(duplicate.getLocation().toString());
                    duplicate.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                }
            }
            catch (CoreException e) {
                LOGGER.warn((Object)DUPLICATE_ID_WARNING_MSG, (Throwable)e);
            }
            catch (IOException e) {
                LOGGER.warn((Object)DUPLICATE_ID_WARNING_MSG, (Throwable)e);
            }
        }
    }

    private void replaceIdentifierInWorkflowFile(String filePath) {
        try {
            File wfToEdit = new File(filePath);
            Map wfContent = (Map)this.mapper.readValue(wfToEdit, new HashMap().getClass());
            String wfContentString = FileUtils.readFileToString((File)wfToEdit);
            String idWorkflow = (String)wfContent.get(IDENTIFIER);
            wfContentString = wfContentString.replace(idWorkflow, UUID.randomUUID().toString());
            List nodes = (List)wfContent.get(NODES);
            if (nodes != null) {
                for (Map node : nodes) {
                    String nodeID = (String)node.get(IDENTIFIER);
                    wfContentString = wfContentString.replaceAll(nodeID, UUID.randomUUID().toString());
                }
            }
            FileUtils.write((File)wfToEdit, (CharSequence)wfContentString);
        }
        catch (IOException e) {
            LOGGER.warn((Object)DUPLICATE_ID_WARNING_MSG, (Throwable)e);
        }
    }

    private Set<IResource> searchForDuplicateWFIdentifier(String absoluteFilePath) {
        HashSet<IResource> duplicates;
        block10: {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceRoot root = workspace.getRoot();
            duplicates = new HashSet<IResource>();
            try {
                File file = new File(absoluteFilePath);
                if (!file.exists()) break block10;
                Map wfContent = (Map)this.mapper.readValue(file, new HashMap().getClass());
                IProject[] iProjectArray = root.getProjects();
                int n = iProjectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject p = iProjectArray[n2];
                    if (p.isOpen()) {
                        try {
                            IResource[] iResourceArray = p.members();
                            int n3 = iResourceArray.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                IResource possibleDuplicate;
                                IResource res = iResourceArray[n4];
                                if (res instanceof IFile && WORKFLOW_FILENAME_PATTERN.matcher(((IFile)res).getName()).matches() && (possibleDuplicate = this.checkFileForDuplicateID(wfContent, absoluteFilePath, res)) != null && !absoluteFilePath.equals(possibleDuplicate.getLocation().toString())) {
                                    duplicates.add(possibleDuplicate);
                                }
                                if (res instanceof IFolder && (possibleDuplicate = this.checkFolderForDuplicateId(wfContent, absoluteFilePath, res)) != null) {
                                    duplicates.addAll((Collection<IResource>)possibleDuplicate);
                                }
                                ++n4;
                            }
                        }
                        catch (CoreException e) {
                            LOGGER.warn((Object)DUPLICATE_ID_WARNING_MSG, (Throwable)e);
                        }
                        catch (IOException e) {
                            LOGGER.warn((Object)DUPLICATE_ID_WARNING_MSG, (Throwable)e);
                        }
                    }
                    ++n2;
                }
            }
            catch (IOException e) {
                LOGGER.warn((Object)DUPLICATE_ID_WARNING_MSG, (Throwable)e);
            }
        }
        return duplicates;
    }

    private Set<IResource> checkFolderForDuplicateId(Map<String, Object> wfContent, String absoluteFilePath, IResource res) throws JsonParseException, JsonMappingException, IOException, CoreException {
        HashSet<IResource> possibleDuplicates = new HashSet<IResource>();
        IResource[] iResourceArray = ((IFolder)res).members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource possibleDuplicate;
            IResource resource = iResourceArray[n2];
            if (resource instanceof IFolder) {
                possibleDuplicate = this.checkFolderForDuplicateId(wfContent, absoluteFilePath, resource);
                if (possibleDuplicate != null) {
                    possibleDuplicates.addAll((Collection<IResource>)possibleDuplicate);
                }
            } else if (resource instanceof IFile && WORKFLOW_FILENAME_PATTERN.matcher(((IFile)resource).getName()).matches() && (possibleDuplicate = this.checkFileForDuplicateID(wfContent, absoluteFilePath, resource)) != null && !absoluteFilePath.equals(possibleDuplicate.getLocation().toString())) {
                possibleDuplicates.add(possibleDuplicate);
            }
            ++n2;
        }
        return possibleDuplicates;
    }

    private IResource checkFileForDuplicateID(Map<String, Object> wfContent, String absoluteFilePath, IResource res) {
        try {
            File file = new File(res.getLocation().toString());
            if (file.exists()) {
                Map wfContentExisting = (Map)this.mapper.readValue(file, new HashMap().getClass());
                if (!absoluteFilePath.equals(res.getLocation().toString()) && wfContent.get(IDENTIFIER).equals(wfContentExisting.get(IDENTIFIER))) {
                    return res;
                }
            }
        }
        catch (IOException e) {
            LOGGER.warn((Object)StringUtils.format((String)"Skipped corrupted wf file: %s (%s)", (Object[])new Object[]{e.getMessage(), res.getLocation().toString()}));
        }
        return null;
    }

    private static final class WorkflowWizardDialog
    extends WizardDialog {
        WorkflowWizardDialog(Shell activeShell, Wizard workflowExecutionWizard) {
            super(activeShell, (IWizard)workflowExecutionWizard);
        }

        protected void createButtonsForButtonBar(Composite parent) {
            super.createButtonsForButtonBar(parent);
            Button okButton = this.getButton(16);
            if (okButton != null) {
                okButton.setText(Messages.executionWizardFinishButtonLabel);
            }
        }
    }
}

