/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.editor.properties;

import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.gui.utils.common.configuration.ConfigurationViewer;
import de.rcenvironment.core.gui.utils.common.configuration.ConfigurationViewerContentProvider;
import de.rcenvironment.core.gui.utils.common.configuration.ConfigurationViewerLabelProvider;
import de.rcenvironment.core.gui.utils.common.configuration.IConfigurationSource;
import de.rcenvironment.core.gui.workflow.editor.properties.ComponentPropertySource;
import de.rcenvironment.core.gui.workflow.editor.properties.WorkflowNodePropertySection;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class WorkflowNodePropertiesSection
extends WorkflowNodePropertySection {
    private static final String NULL_CONTROL_PROPERTY_KEY = "";
    private static final int MINIMUM_HEIGHT = 60;
    private final ConfigurationViewerContentProvider configurationViewerContentProvider = new ConfigurationViewerContentProvider();
    private final ConfigurationViewerLabelProvider configurationViewerLabelProvider = new ConfigurationViewerLabelProvider();
    private final ISelectionChangedListener propertyValueTextSynchronizer = new ConfigurationViewerSelectionChangedListener();
    private ConfigurationViewer configurationViewer;
    private Text propertyValueText;

    @Override
    protected void createCompositeContent(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        TabbedPropertySheetWidgetFactory toolkit = aTabbedPropertySheetPage.getWidgetFactory();
        Composite content = parent;
        content.setLayout((Layout)new GridLayout(1, true));
        GridData layoutData = new GridData(1808);
        parent.setLayoutData((Object)layoutData);
        SashForm sashForm = this.createSash(content, 512);
        toolkit.adapt((Composite)sashForm);
    }

    private SashForm createSash(Composite content, int style) {
        SashForm sashForm = new SashForm(content, style);
        this.configurationViewer = new ConfigurationViewer((Composite)sashForm, 66308);
        GridData layoutData = new GridData(1808);
        layoutData.minimumHeight = 60;
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.grabExcessVerticalSpace = true;
        this.configurationViewer.getTree().getParent().setLayoutData((Object)layoutData);
        this.configurationViewer.setContentProvider((IContentProvider)this.configurationViewerContentProvider);
        this.configurationViewer.setLabelProvider((IBaseLabelProvider)this.configurationViewerLabelProvider);
        this.propertyValueText = new Text((Composite)sashForm, 770);
        this.propertyValueText.setText(NULL_CONTROL_PROPERTY_KEY);
        layoutData = new GridData(1808);
        layoutData.minimumHeight = 60;
        this.propertyValueText.setLayoutData((Object)layoutData);
        this.propertyValueText.setData("property.control", (Object)NULL_CONTROL_PROPERTY_KEY);
        sashForm.setWeights(new int[]{3, 1});
        layoutData = new GridData(1808);
        layoutData.minimumHeight = 60;
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.grabExcessVerticalSpace = true;
        sashForm.setLayoutData((Object)layoutData);
        return sashForm;
    }

    @Override
    protected void afterInitializingModelBinding() {
        this.configurationViewer.addSelectionChangedListener(this.propertyValueTextSynchronizer);
    }

    @Override
    protected void beforeTearingDownModelBinding() {
        this.configurationViewer.removeSelectionChangedListener(this.propertyValueTextSynchronizer);
    }

    @Override
    protected WorkflowNodePropertySection.Synchronizer createSynchronizer() {
        return new PropertiesSynchronizer();
    }

    @Override
    public void refreshSection() {
        super.refreshSection();
        this.configurationViewer.setInput((Object)new PropertiesConfigurationSource(this.getCommandStack(), (WorkflowNode)this.getConfiguration()));
        this.configurationViewer.getTree().update();
    }

    private class ConfigurationViewerSelectionChangedListener
    implements ISelectionChangedListener {
        private ConfigurationViewerSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            Object firstElement;
            String propertyKey = WorkflowNodePropertiesSection.NULL_CONTROL_PROPERTY_KEY;
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            if (selection.size() == 1 && (firstElement = selection.getFirstElement()) instanceof TextPropertyDescriptor) {
                IPropertyDescriptor propertyDescriptor = (IPropertyDescriptor)firstElement;
                propertyKey = (String)propertyDescriptor.getId();
            }
            boolean validProperty = propertyKey != null && !propertyKey.equals(WorkflowNodePropertiesSection.NULL_CONTROL_PROPERTY_KEY);
            WorkflowNodePropertiesSection.this.propertyValueText.setEnabled(validProperty);
            WorkflowNodePropertiesSection.this.propertyValueText.setData("property.control", (Object)propertyKey);
            String value = WorkflowNodePropertiesSection.this.getProperty(propertyKey);
            WorkflowNodePropertiesSection.this.getUpdater().initializeControl((Control)WorkflowNodePropertiesSection.this.propertyValueText, propertyKey, value);
        }
    }

    protected class PropertiesConfigurationSource
    extends ComponentPropertySource
    implements IConfigurationSource {
        public PropertiesConfigurationSource(CommandStack stack, WorkflowNode node) {
            super(stack, node);
        }

        @Override
        public Object getPropertyValue(Object key) {
            return WorkflowNodePropertiesSection.this.getProperty((String)key);
        }

        @Override
        public void setPropertyValue(Object key, Object value) {
            String propertyName = (String)key;
            String propertyValue = (String)value;
            WorkflowNodePropertiesSection.this.setProperty(propertyName, propertyValue);
        }

        public IPropertyDescriptor[] getConfigurationPropertyDescriptors() {
            IPropertyDescriptor[] propertyDescriptors = this.getPropertyDescriptors();
            int propertyCount = propertyDescriptors.length;
            IPropertyDescriptor[] result = new IPropertyDescriptor[propertyCount];
            int index = 0;
            while (index < propertyCount) {
                result[index] = propertyDescriptors[index];
                ++index;
            }
            return result;
        }
    }

    protected class PropertiesSynchronizer
    extends WorkflowNodePropertySection.DefaultSynchronizer {
        protected PropertiesSynchronizer() {
        }

        @Override
        public void handlePropertyChange(String propertyName, String newValue, String oldValue) {
            super.handlePropertyChange(propertyName, newValue, oldValue);
            super.handlePropertyChange(propertyName, newValue, oldValue);
            WorkflowNodePropertiesSection.this.configurationViewer.refresh();
        }
    }
}

