/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.editor;

import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.gui.workflow.editor.Messages;
import de.rcenvironment.core.gui.workflow.editor.WorkflowEditorAction;
import de.rcenvironment.core.gui.workflow.parts.WorkflowNodePart;
import de.rcenvironment.core.utils.common.StringUtils;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.GEFActionConstants;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.actions.ActionFactory;

class WorkflowEditorContextMenuProvider
extends ContextMenuProvider {
    public static final String GROUP_NODE_ACTIONS = "de.rcenvironment.rce.gui.workflow.editor.nodeActions";
    private final ActionRegistry actionRegistry;
    private EditPartViewer viewer;

    WorkflowEditorContextMenuProvider(EditPartViewer viewer, ActionRegistry actionRegistry) {
        super(viewer);
        this.viewer = viewer;
        this.actionRegistry = actionRegistry;
    }

    public void buildContextMenu(IMenuManager menu) {
        if (this.viewer.getSelectedEditParts().size() > 0) {
            this.addContributedContextMenuActions(menu);
        }
        GEFActionConstants.addStandardActionGroups((IMenuManager)menu);
        IAction undo = this.actionRegistry.getAction((Object)ActionFactory.UNDO.getId());
        undo.setText(Messages.undo.concat(Messages.undoShortcut));
        IAction redo = this.actionRegistry.getAction((Object)ActionFactory.REDO.getId());
        redo.setText(Messages.redo.concat(Messages.redoShortcut));
        menu.appendToGroup("org.eclipse.gef.group.undo", undo);
        menu.appendToGroup("org.eclipse.gef.group.undo", redo);
    }

    private void addContributedContextMenuActions(IMenuManager menu) {
        IConfigurationElement[] confElements;
        menu.add((IContributionItem)new Separator(GROUP_NODE_ACTIONS));
        IConfigurationElement[] iConfigurationElementArray = confElements = Platform.getExtensionRegistry().getConfigurationElementsFor("de.rcenvironment.core.gui.workflow.editorActions");
        int n = confElements.length;
        int n2 = 0;
        while (n2 < n) {
            WorkflowNode node;
            final IConfigurationElement confElement = iConfigurationElementArray[n2];
            if (this.viewer.getSelectedEditParts().get(0) instanceof WorkflowNodePart && (node = (WorkflowNode)((WorkflowNodePart)this.viewer.getSelectedEditParts().get(0)).getModel()).getComponentDescription().getIdentifier().matches(confElement.getAttribute("component"))) {
                WorkflowEditorAction action;
                try {
                    WorkflowEditorAction actionObject = (WorkflowEditorAction)confElement.createExecutableExtension("class");
                    if (!(actionObject instanceof WorkflowEditorAction)) {
                        throw new RuntimeException(StringUtils.format((String)"Class in attribute 'class' is not a subtype of '%s'.", (Object[])new Object[]{WorkflowEditorAction.class.getName()}));
                    }
                    action = actionObject;
                }
                catch (CoreException e) {
                    throw new RuntimeException(e);
                }
                action.setWorkflowNode(node);
                menu.appendToGroup(GROUP_NODE_ACTIONS, (IAction)new Action(){

                    public String getText() {
                        return confElement.getAttribute("label");
                    }

                    public void run() {
                        action.performAction();
                    }

                    public boolean isEnabled() {
                        List selection = ((GraphicalViewer)WorkflowEditorContextMenuProvider.this.viewer).getSelectedEditParts();
                        return selection.size() == 1 && selection.get(0).getClass() == WorkflowNodePart.class;
                    }
                });
            }
            ++n2;
        }
    }
}

