/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow;

import de.rcenvironment.core.component.execution.api.ComponentState;
import de.rcenvironment.core.component.workflow.command.api.WorkflowExecutionDisplayService;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowState;
import de.rcenvironment.core.gui.resources.api.ImageManager;
import de.rcenvironment.core.gui.resources.api.ImageSource;
import de.rcenvironment.core.gui.resources.api.StandardImages;
import de.rcenvironment.core.gui.workflow.ActiveWorkflowShutdownListener;
import de.rcenvironment.core.gui.workflow.UncompletedJobsShutdownListener;
import de.rcenvironment.core.gui.workflow.view.WorkflowExecutionDisplayServiceImpl;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.core.utils.incubator.ServiceRegistryPublisherAccess;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String IMAGE_WORKFLOW_EDITOR_BACKGROUND = "de.rcenvironment.rce.gui.workflow.editor.background";
    public static final String IMAGE_INPUT = "de.rcenvironment.rce.gui.workflow.editor.input";
    public static final String IMAGE_OUTPUT = "de.rcenvironment.rce.gui.workflow.editor.output";
    public static final String IMAGE_ADD_INPUT = "de.rcenvironment.rce.gui.workflow.editor.addinput";
    public static final String IMAGE_ADD_OUTPUT = "de.rcenvironment.rce.gui.workflow.editor.addoutput";
    public static final String IMAGE_RCE_ICON_16 = "de.rcenvironment.rce.icon.16";
    public static final String IMAGE_RCE_ICON_32 = "de.rcenvironment.rce.icon.32";
    public static final String IMAGE_COPY = "de.rcenvironment.rce.gui.copy";
    public static final String UNKNOWN_STATE = "de.rcenvironment.rce.gui.workflow.state.unknown";
    private static Activator instance = null;
    private UncompletedJobsShutdownListener uncompletedJobsShutdownListener = null;
    private ActiveWorkflowShutdownListener undisposedWorkflowShutdownListener = null;
    private ServiceRegistryPublisherAccess serviceRegistryAccess = null;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        instance = this;
        this.serviceRegistryAccess = ServiceRegistry.createPublisherAccessFor((Object)((Object)this));
        this.serviceRegistryAccess.registerService(WorkflowExecutionDisplayService.class, (Object)new WorkflowExecutionDisplayServiceImpl());
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        instance = null;
        this.serviceRegistryAccess.dispose();
    }

    public synchronized void registerUndisposedWorkflowShutdownListener() {
        if (this.undisposedWorkflowShutdownListener == null) {
            this.undisposedWorkflowShutdownListener = new ActiveWorkflowShutdownListener();
            PlatformUI.getWorkbench().addWorkbenchListener((IWorkbenchListener)this.undisposedWorkflowShutdownListener);
        }
        if (this.uncompletedJobsShutdownListener == null) {
            this.uncompletedJobsShutdownListener = new UncompletedJobsShutdownListener();
            PlatformUI.getWorkbench().addWorkbenchListener((IWorkbenchListener)this.uncompletedJobsShutdownListener);
        }
    }

    public synchronized void unregisterUndisposedWorkflowShutdownListener() {
        if (this.undisposedWorkflowShutdownListener != null) {
            PlatformUI.getWorkbench().removeWorkbenchListener((IWorkbenchListener)this.undisposedWorkflowShutdownListener);
        }
        if (this.uncompletedJobsShutdownListener != null) {
            PlatformUI.getWorkbench().removeWorkbenchListener((IWorkbenchListener)this.uncompletedJobsShutdownListener);
        }
    }

    public static Activator getInstance() {
        return instance;
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        Bundle bundle = Platform.getBundle((String)"de.rcenvironment.core.gui.workflow");
        this.initializeImageRegistry1(reg, bundle);
        this.initializeImageRegistry2(reg, bundle);
        super.initializeImageRegistry(reg);
    }

    private void initializeImageRegistry1(ImageRegistry reg, Bundle bundle) {
        Path path = new Path("resources/icons/states/ready.gif");
        URL url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
        reg.put(ComponentState.IDLING.name(), desc);
        path = new Path("resources/icons/states/resetting.gif");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        reg.put(ComponentState.RESETTING.name(), desc);
        path = new Path("resources/icons/states/reset.png");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        reg.put(ComponentState.IDLING_AFTER_RESET.name(), desc);
        path = new Path("resources/icons/states/preparing.gif");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        reg.put(WorkflowState.INIT.name(), desc);
        reg.put(WorkflowState.PREPARING.name(), desc);
        reg.put(ComponentState.INIT.name(), desc);
        reg.put(ComponentState.PREPARING.name(), desc);
        reg.put(ComponentState.PREPARED.name(), desc);
        path = new Path("resources/icons/states/run_enabled.gif");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        reg.put(WorkflowState.RUNNING.name(), desc);
        reg.put(ComponentState.PROCESSING_INPUTS.name(), desc);
        reg.put(ComponentState.STARTING.name(), desc);
        path = new Path("resources/icons/states/run_and_wait_for_resources.png");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        reg.put(ComponentState.WAITING_FOR_RESOURCES.name(), desc);
        path = new Path("resources/icons/states/waiting_for_approval.png");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        reg.put(ComponentState.WAITING_FOR_APPROVAL.name(), desc);
        path = new Path("resources/icons/states/results_rejected.png");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        reg.put(ComponentState.RESULTS_REJECTED.name(), desc);
        reg.put(WorkflowState.RESULTS_REJECTED.name(), desc);
        path = new Path("resources/icons/states/suspend_disabled.gif");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        reg.put(WorkflowState.PAUSING.name(), desc);
        reg.put(ComponentState.PAUSING.name(), desc);
        path = new Path("resources/icons/states/suspend_enabled.gif");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        reg.put(WorkflowState.PAUSED.name(), desc);
        reg.put(ComponentState.PAUSED.name(), desc);
        path = new Path("resources/icons/states/resume_enabled.gif");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        reg.put(WorkflowState.RESUMING.name(), desc);
        reg.put(ComponentState.RESUMING.name(), desc);
        path = new Path("resources/icons/states/tearing_down.gif");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        reg.put(ComponentState.TEARING_DOWN.name(), desc);
        path = new Path("resources/icons/states/finished.gif");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        reg.put(WorkflowState.FINISHED.name(), desc);
        reg.put(ComponentState.FINISHED.name(), desc);
    }

    private void initializeImageRegistry2(ImageRegistry reg, Bundle bundle) {
        Path path = new Path("resources/icons/states/cancel_disabled.gif");
        URL url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
        reg.put(WorkflowState.CANCELING.name(), desc);
        reg.put(WorkflowState.CANCELING_AFTER_FAILED.name(), desc);
        reg.put(WorkflowState.CANCELING_AFTER_RESULTS_REJECTED.name(), desc);
        reg.put(ComponentState.CANCELLING.name(), desc);
        path = new Path("resources/icons/states/cancel_enabled.gif");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        reg.put(WorkflowState.CANCELLED.name(), desc);
        reg.put(ComponentState.CANCELED.name(), desc);
        path = new Path("resources/icons/states/failed.gif");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        reg.put(WorkflowState.FAILED.name(), desc);
        reg.put(ComponentState.FAILED.name(), desc);
        path = new Path("resources/icons/states/disposed.gif");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        reg.put(WorkflowState.DISPOSING.name(), desc);
        reg.put(WorkflowState.DISPOSED.name(), desc);
        reg.put(ComponentState.DISPOSING.name(), desc);
        reg.put(ComponentState.DISPOSED.name(), desc);
        path = new Path("/resources/icons/states/unknownState.gif");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        reg.put(WorkflowState.UNKNOWN.name(), desc);
        reg.put(ComponentState.UNKNOWN.name(), desc);
        path = new Path("resources/icons/states/finishedNoRun.gif");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        reg.put(ComponentState.FINISHED_WITHOUT_EXECUTION.name(), desc);
        path = new Path("resources/editor-background.png");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        reg.put(IMAGE_WORKFLOW_EDITOR_BACKGROUND, desc);
        path = new Path("resources/icons/endpoints/input.gif");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        reg.put(IMAGE_INPUT, desc);
        path = new Path("resources/icons/endpoints/output.gif");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        reg.put(IMAGE_OUTPUT, desc);
        path = new Path("resources/icons/endpoints/addInput.gif");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        reg.put(IMAGE_ADD_INPUT, desc);
        path = new Path("resources/icons/endpoints/addOutput.gif");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        reg.put(IMAGE_ADD_OUTPUT, desc);
        ImageManager sharedImageManager = ImageManager.getInstance();
        reg.put(IMAGE_RCE_ICON_16, sharedImageManager.getSharedImage((ImageSource)StandardImages.RCE_LOGO_16));
        reg.put(IMAGE_RCE_ICON_32, sharedImageManager.getSharedImage((ImageSource)StandardImages.RCE_LOGO_32));
        path = new Path("resources/icons/copy.gif");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        reg.put(IMAGE_COPY, desc);
    }
}

