/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.wizards.exampleproject;

import de.rcenvironment.core.configuration.ConfigurationService;
import de.rcenvironment.core.gui.wizards.exampleproject.NewExampleProjectWizardPage;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.core.utils.incubator.ServiceRegistryAccess;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.osgi.framework.Bundle;

public abstract class NewExampleProjectWizard
extends Wizard
implements INewWizard {
    private static final String ASTERISK = "*";
    private static final String APOSTROPH = "'";
    private NewExampleProjectWizardPage page;
    private ISelection selection;
    private Optional<Consumer<String>> projectNameListener = Optional.empty();
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    public NewExampleProjectWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.page = new NewExampleProjectWizardPage(this.selection, this);
        Bundle bundle = Platform.getBundle((String)this.getPluginID());
        Enumeration templateDirs = bundle.findEntries("templates", ASTERISK, false);
        while (templateDirs.hasMoreElements()) {
            URL elementURL = (URL)templateDirs.nextElement();
            String rawPath = elementURL.getPath();
            if (rawPath.endsWith("/.svn/")) continue;
            this.log.debug((Object)("Located template folder '" + elementURL + APOSTROPH));
        }
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        boolean copyTool;
        int copyToolAnswer;
        final String newProjectName = this.page.getNewProjectName();
        if (this.projectNameListener.isPresent()) {
            this.projectNameListener.get().accept(newProjectName);
        }
        if ((copyToolAnswer = this.page.getCreateTIExample()) == 1) {
            copyTool = true;
        } else {
            if (copyToolAnswer == -1) {
                return false;
            }
            copyTool = false;
        }
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        NewExampleProjectWizard.this.doFinish(NewExampleProjectWizard.this.getTemplateFoldername(), newProjectName, monitor, copyTool);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)realException.getMessage());
            return false;
        }
        return true;
    }

    private void copyExampleTool(Bundle bundle) {
        ServiceRegistryAccess serviceRegistryAccess = ServiceRegistry.createAccessFor((Object)((Object)this));
        ConfigurationService configurationService = (ConfigurationService)serviceRegistryAccess.getService(ConfigurationService.class);
        File integrationFolder = configurationService.getConfigurablePath(ConfigurationService.ConfigurablePathId.PROFILE_INTEGRATION_DATA);
        File commonsFolder = new File(new File(integrationFolder, "tools"), "common");
        if (!commonsFolder.exists()) {
            commonsFolder.mkdirs();
        }
        try {
            Enumeration toolFiles = bundle.findEntries("templates/integration_example", ASTERISK, true);
            while (toolFiles.hasMoreElements()) {
                URL elementURL = (URL)toolFiles.nextElement();
                String rawPath = elementURL.getPath();
                String targetPath = rawPath.replaceFirst("^/templates/\\w+/", "");
                File target = new File(commonsFolder, targetPath);
                if (target.isDirectory() || rawPath.endsWith("/")) {
                    target.mkdirs();
                    continue;
                }
                InputStream fileStream = null;
                try {
                    try {
                        fileStream = elementURL.openStream();
                        FileUtils.copyInputStreamToFile((InputStream)fileStream, (File)target);
                    }
                    catch (IOException e) {
                        this.log.error((Object)"Could not copy tool integration example", (Throwable)e);
                        if (fileStream == null) continue;
                        fileStream.close();
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    if (fileStream != null) {
                        fileStream.close();
                    }
                    throw throwable;
                }
                if (fileStream == null) continue;
                fileStream.close();
            }
        }
        catch (IOException e) {
            this.log.error((Object)"Could not copy tool integration example", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doFinish(String templateName, String newProjectName, IProgressMonitor monitor, boolean copyIntegrationExample) throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(newProjectName);
        project.create(monitor);
        project.open(monitor);
        monitor.worked(1);
        Bundle bundle = Platform.getBundle((String)this.getPluginID());
        Enumeration templateFiles = bundle.findEntries("templates/" + templateName, ASTERISK, true);
        this.log.debug((Object)("Copying project template '" + templateName + APOSTROPH));
        try {
            InputStream fileStream;
            while (true) {
                if (!templateFiles.hasMoreElements()) {
                    if (!copyIntegrationExample) return;
                    this.copyExampleTool(bundle);
                    return;
                }
                URL elementURL = (URL)templateFiles.nextElement();
                String rawPath = elementURL.getPath();
                if (rawPath.endsWith("/") || rawPath.contains("/.svn/")) {
                    this.log.debug((Object)("Ignoring template resource '" + elementURL));
                    continue;
                }
                String targetPath = rawPath.replaceFirst("^/templates/\\w+/", "");
                IFile file = project.getFile(targetPath);
                if (!file.getParent().exists()) {
                    IFolder parent = (IFolder)file.getParent();
                    parent.create(true, true, null);
                }
                this.log.debug((Object)("Copying template file '" + elementURL + " to '" + targetPath + APOSTROPH));
                fileStream = null;
                fileStream = elementURL.openStream();
                file.create(fileStream, true, monitor);
                continue;
                break;
            }
            finally {
                if (fileStream != null) {
                    fileStream.close();
                }
            }
        }
        catch (IOException e) {
            this.log.error((Object)"Error while creating example project", (Throwable)e);
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection newSelection) {
        this.selection = newSelection;
    }

    public void registerProjectNameListener(Consumer<String> consumer) {
        this.projectNameListener = Optional.of(consumer);
    }

    public abstract String getProjectDefaultName();

    public abstract String getPluginID();

    public abstract String getTemplateFoldername();
}

