/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.datamanagement.export.objects;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.rcenvironment.core.datamanagement.commons.ComponentRun;
import de.rcenvironment.core.datamanagement.commons.EndpointData;
import de.rcenvironment.core.datamanagement.export.matching.MatchResult;
import de.rcenvironment.core.datamanagement.export.matching.Matchable;
import de.rcenvironment.core.datamanagement.export.matching.Matcher;
import de.rcenvironment.core.datamanagement.export.objects.PlainEndpoint;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.FinalComponentRunState;
import de.rcenvironment.core.datamodel.api.TypedDatumSerializer;
import de.rcenvironment.core.utils.common.StringUtils;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PlainComponentRun
implements Comparable<PlainComponentRun>,
Matchable<PlainComponentRun> {
    @JsonProperty
    private Integer runCounter;
    @JsonProperty
    private FinalComponentRunState finalState;
    @JsonProperty
    private List<PlainEndpoint> inputs;
    @JsonProperty
    private List<PlainEndpoint> outputs;

    public PlainComponentRun() {
    }

    public PlainComponentRun(ComponentRun componentRun, TypedDatumSerializer typedDatumSerializer) {
        this.finalState = componentRun.getFinalState();
        this.runCounter = componentRun.getRunCounter();
        this.inputs = new LinkedList<PlainEndpoint>();
        this.outputs = new LinkedList<PlainEndpoint>();
        Set<EndpointData> endpoints = componentRun.getEndpointData();
        if (endpoints != null) {
            for (EndpointData endpoint : endpoints) {
                switch (endpoint.getEndpointInstance().getEndpointType()) {
                    case INPUT: {
                        this.inputs.add(new PlainEndpoint(endpoint, typedDatumSerializer));
                        break;
                    }
                    case OUTPUT: {
                        this.outputs.add(new PlainEndpoint(endpoint, typedDatumSerializer));
                        break;
                    }
                }
            }
            this.inputs.sort(null);
            this.outputs.sort(null);
        }
    }

    @Override
    public int compareTo(PlainComponentRun o) {
        return this.runCounter.compareTo(o.runCounter);
    }

    @Override
    public MatchResult matches(Map<DataType, Matcher> matchers, PlainComponentRun expected) {
        MatchResult result = new MatchResult();
        if (!this.runCounter.equals(expected.runCounter)) {
            result.addFailureCause(StringUtils.format((String)"The run counter %d does not match %d.", (Object[])new Object[]{this.runCounter, expected.runCounter}));
        }
        if (!this.finalState.equals((Object)expected.finalState)) {
            result.addFailureCause(StringUtils.format((String)"The final state %s does not match the expected final state %s.", (Object[])new Object[]{this.finalState, expected.finalState}));
        }
        this.matchEndpointDatums(matchers, result, this.inputs, expected.inputs, "input");
        this.matchEndpointDatums(matchers, result, this.outputs, expected.outputs, "output");
        return result;
    }

    private MatchResult matchEndpointDatums(Map<DataType, Matcher> matchers, MatchResult result, List<PlainEndpoint> actual, List<PlainEndpoint> expected, String typeAsString) {
        if (actual.size() == expected.size()) {
            int i = 0;
            while (i < actual.size()) {
                MatchResult nestedMatchResult = actual.get(i).matches(matchers, expected.get(i));
                if (!nestedMatchResult.hasMatched()) {
                    result.addFailureCause(StringUtils.format((String)"The actual %s datum %d does not match the expected %s datum", (Object[])new Object[]{typeAsString, i, typeAsString}), nestedMatchResult);
                }
                ++i;
            }
        } else {
            result.addFailureCause(StringUtils.format((String)"The number of %s datums %d do not match the expected number of %s datums %d", (Object[])new Object[]{typeAsString, actual.size(), typeAsString, expected.size()}));
        }
        return result;
    }
}

