/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.testutils;

import de.rcenvironment.core.authorization.api.AuthorizationPermissionSet;
import de.rcenvironment.core.authorization.api.AuthorizationService;
import de.rcenvironment.core.communication.common.LogicalNodeId;
import de.rcenvironment.core.component.management.api.DistributedComponentEntry;
import de.rcenvironment.core.component.management.internal.ComponentDataConverter;
import de.rcenvironment.core.component.model.api.ComponentInstallation;
import de.rcenvironment.core.component.model.configuration.impl.ConfigurationDefinitionImpl;
import de.rcenvironment.core.component.model.configuration.impl.ConfigurationExtensionDefinitionImpl;
import de.rcenvironment.core.component.model.endpoint.impl.EndpointDefinitionsProviderImpl;
import de.rcenvironment.core.component.model.impl.ComponentInstallationImpl;
import de.rcenvironment.core.component.model.impl.ComponentInterfaceImpl;
import de.rcenvironment.core.component.model.impl.ComponentRevisionImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public final class ComponentTestUtils {
    private ComponentTestUtils() {
    }

    public static ComponentInstallation createTestComponentInstallation(String identifier, String version, LogicalNodeId nodeId) {
        ComponentInterfaceImpl componentInterface = new ComponentInterfaceImpl();
        componentInterface.setIdentifier(identifier);
        componentInterface.setIdentifiers(Arrays.asList(identifier));
        componentInterface.setDisplayName(identifier);
        componentInterface.setVersion(version);
        componentInterface.setGroupName("Other");
        componentInterface.setInputDefinitionsProvider(new EndpointDefinitionsProviderImpl());
        componentInterface.setOutputDefinitionsProvider(new EndpointDefinitionsProviderImpl());
        componentInterface.setConfigurationDefinition(new ConfigurationDefinitionImpl());
        componentInterface.setConfigurationExtensionDefinitions(new HashSet<ConfigurationExtensionDefinitionImpl>());
        ComponentRevisionImpl componentRevision = new ComponentRevisionImpl();
        componentRevision.setComponentInterface(componentInterface);
        ComponentInstallationImpl componentInstallation = new ComponentInstallationImpl();
        componentInstallation.setComponentRevision(componentRevision);
        componentInstallation.setInstallationId(componentInterface.getIdentifierAndVersion());
        componentInstallation.setNodeIdObject(nodeId);
        return componentInstallation;
    }

    public static DistributedComponentEntry createTestDistributedComponentEntry(String identifier, String version, LogicalNodeId nodeId, AuthorizationPermissionSet permissionSet, AuthorizationService authorizationService) {
        ComponentInstallation compInst = ComponentTestUtils.createTestComponentInstallation(identifier, version, nodeId);
        return ComponentTestUtils.wrapIntoDistributedComponentEntry(compInst, permissionSet, authorizationService);
    }

    public static DistributedComponentEntry wrapIntoDistributedComponentEntry(ComponentInstallation compInst, AuthorizationPermissionSet permissionSet, AuthorizationService authorizationService) {
        return ComponentDataConverter.createLocalDistributedComponentEntry(compInst, permissionSet, authorizationService);
    }

    public static List<DistributedComponentEntry> convertToListOfDistributedComponentEntries(Collection<ComponentInstallation> compInsts) {
        return ComponentTestUtils.convertToListOfDistributedComponentEntries(compInsts, null, null);
    }

    public static List<DistributedComponentEntry> convertToListOfDistributedComponentEntries(Collection<ComponentInstallation> compInsts, AuthorizationPermissionSet permissionSet, AuthorizationService authorizationService) {
        ArrayList<DistributedComponentEntry> result = new ArrayList<DistributedComponentEntry>();
        for (ComponentInstallation ci : compInsts) {
            result.add(ComponentTestUtils.wrapIntoDistributedComponentEntry(ci, permissionSet, authorizationService));
        }
        return result;
    }
}

