/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.model.impl;

import de.rcenvironment.core.component.model.api.ComponentImageManagerService;
import de.rcenvironment.core.component.model.impl.ComponentImageChangeListener;
import de.rcenvironment.core.component.model.impl.ComponentImageManagerImpl;
import de.rcenvironment.core.component.spi.DistributedComponentKnowledgeListener;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Image;

public class ComponentImageContainer {
    private String componentId;
    private ComponentImageManagerService componentImageManager;
    private ComponentImageManagerImpl.ImagePackage imagePackage;
    private List<Runnable> toExecuteList;
    private ComponentImageChangeListener changeListener;

    public ComponentImageContainer(String componentId) {
        this.componentId = componentId;
        this.bindComponentImageService();
        this.receiveNewestImagePackage();
        this.toExecuteList = new ArrayList<Runnable>();
    }

    private void createComponentImageChangeListener() {
        this.changeListener = ComponentImageChangeListener.create(this.componentId, () -> {
            for (Runnable runnable : this.toExecuteList) {
                ConcurrencyUtils.getAsyncTaskService().execute("Component icon updates", runnable);
            }
        });
        ServiceRegistry.createPublisherAccessFor((Object)this).registerService(DistributedComponentKnowledgeListener.class, (Object)this.changeListener);
    }

    private void bindComponentImageService() {
        this.componentImageManager = (ComponentImageManagerService)ServiceRegistry.createAccessFor((Object)this).getService(ComponentImageManagerService.class);
    }

    public Image getComponentIcon16() {
        this.receiveNewestImagePackage();
        return this.imagePackage.getIcon16(this.componentId);
    }

    public Image getComponentIcon24() {
        this.receiveNewestImagePackage();
        return this.imagePackage.getIcon24(this.componentId);
    }

    public Image getComponentIcon32() {
        this.receiveNewestImagePackage();
        return this.imagePackage.getIcon32(this.componentId);
    }

    private void receiveNewestImagePackage() {
        this.imagePackage = this.componentImageManager.getImagePackage(this.componentId);
    }

    public synchronized void addComponentImageChangeListener(Runnable run) {
        this.toExecuteList.add(run);
        if (this.toExecuteList.size() == 1) {
            this.createComponentImageChangeListener();
        }
    }

    public synchronized void removeComponentImageChangeLIstener(Runnable run) {
        if (this.toExecuteList.contains(run)) {
            this.toExecuteList.remove(run);
            if (this.toExecuteList.isEmpty()) {
                ServiceRegistry.createPublisherAccessFor((Object)this).dispose();
                this.changeListener = null;
            }
        }
    }

    public String getComponentId() {
        return this.componentId;
    }
}

