/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.execution.impl;

import de.rcenvironment.core.component.execution.api.ConsoleRow;
import de.rcenvironment.core.utils.common.ComparatorUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import java.text.SimpleDateFormat;

public class ConsoleRowImpl
implements ConsoleRow {
    private static final long serialVersionUID = 5725183929182175975L;
    private String workflowIdentifier;
    private String componentIdentifier;
    private String workflowName;
    private String componentName;
    private ConsoleRow.Type type;
    private String payload;
    private long index;
    private long timestamp;
    private int componentRun;
    private long sequenceNumber;

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public long getIndex() {
        return this.index;
    }

    @Override
    public String getWorkflowIdentifier() {
        return this.workflowIdentifier;
    }

    @Override
    public String getComponentIdentifier() {
        return this.componentIdentifier;
    }

    @Override
    public String getWorkflowName() {
        return this.workflowName;
    }

    @Override
    public String getComponentName() {
        return this.componentName;
    }

    @Override
    public ConsoleRow.Type getType() {
        return this.type;
    }

    @Override
    public String getPayload() {
        return this.payload;
    }

    @Override
    public int getComponentRun() {
        return this.componentRun;
    }

    @Override
    public long getSequenzNumber() {
        return this.sequenceNumber;
    }

    public void setWorkflowIdentifier(String workflowIdentifier) {
        this.workflowIdentifier = workflowIdentifier;
    }

    public void setComponentIdentifier(String componentIdentifier) {
        this.componentIdentifier = componentIdentifier;
    }

    public void setWorkflowName(String workflowName) {
        this.workflowName = workflowName;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public void setType(ConsoleRow.Type type) {
        this.type = type;
    }

    public void setPayload(String payload) {
        payload = payload.replaceAll("[\\n\\r\\f\\a\\e\\x00]+", " ");
        this.payload = payload.replaceAll("\\t", "    ");
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void setSequenceNumber(long sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public void setComponentRun(int componentRun) {
        this.componentRun = componentRun;
    }

    @Override
    public void setIndex(long index) {
        this.index = index;
    }

    @Override
    public int compareTo(ConsoleRow o) {
        int compareResult = ComparatorUtils.compareLong((long)this.timestamp, (long)o.getTimestamp());
        if (compareResult == 0 && (compareResult = ComparatorUtils.compareLong((long)this.index, (long)o.getIndex())) == 0 && (compareResult = this.workflowIdentifier.compareTo(o.getWorkflowIdentifier())) == 0 && (compareResult = this.componentIdentifier.compareTo(o.getComponentIdentifier())) == 0) {
            compareResult = this.payload.compareTo(o.getPayload());
        }
        return compareResult;
    }

    public String toString() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd - HH:mm:ss,SSS");
        return StringUtils.format((String)"%s: %s - %s (%s@%s)", (Object[])new Object[]{df.format(this.timestamp), this.type.toString(), this.payload, this.componentName, this.workflowName});
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof ConsoleRow) {
            return this.compareTo((ConsoleRow)o) == 0;
        }
        return false;
    }
}

