/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.workflow.execution.impl;

import de.rcenvironment.core.communication.common.LogicalNodeId;
import de.rcenvironment.core.communication.common.NodeIdentifierUtils;
import de.rcenvironment.core.component.execution.api.ComponentExecutionIdentifier;
import de.rcenvironment.core.component.execution.api.ComponentExecutionInformation;
import de.rcenvironment.core.component.execution.impl.ComponentExecutionInformationImpl;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionContext;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionHandle;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionInformation;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowState;
import de.rcenvironment.core.component.workflow.model.api.WorkflowDescription;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNodeIdentifier;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class WorkflowExecutionInformationImpl
extends ComponentExecutionInformationImpl
implements WorkflowExecutionInformation {
    private static final long serialVersionUID = 8037878257248368500L;
    private long instantiationTime;
    private WorkflowDescription workflowDescription;
    private Map<WorkflowNodeIdentifier, ComponentExecutionInformation> componentExecutionInformations = new HashMap<WorkflowNodeIdentifier, ComponentExecutionInformation>();
    private LogicalNodeId nodeIdentifierStartedExecution;
    private String additionalInformation;
    private WorkflowState workflowState;
    private WorkflowExecutionHandle workflowExecutionHandle;
    private Long workflowDataManagementId = null;

    public WorkflowExecutionInformationImpl(WorkflowExecutionContext wfExeCtx) {
        this.setInstanceName(wfExeCtx.getInstanceName());
        this.setNodeId(wfExeCtx.getNodeId());
        this.setStorageNetworkDestination(wfExeCtx.getStorageNetworkDestination());
        this.setWorkflowDescription(wfExeCtx.getWorkflowDescription());
        this.setWorkflowExecutionContext(wfExeCtx);
        this.workflowExecutionHandle = wfExeCtx.getWorkflowExecutionHandle();
        this.instantiationTime = new Date().getTime();
    }

    @Override
    public WorkflowDescription getWorkflowDescription() {
        return this.workflowDescription;
    }

    @Override
    public WorkflowExecutionHandle getWorkflowExecutionHandle() {
        return this.workflowExecutionHandle;
    }

    @Override
    public long getStartTime() {
        return this.instantiationTime;
    }

    @Override
    public ComponentExecutionInformation getComponentExecutionInformation(WorkflowNodeIdentifier wfNodeId) {
        return this.componentExecutionInformations.get(wfNodeId);
    }

    @Override
    public Collection<ComponentExecutionInformation> getComponentExecutionInformations() {
        return this.componentExecutionInformations.values();
    }

    public void setWorkflowDescription(WorkflowDescription workflowDescription) {
        this.workflowDescription = workflowDescription;
    }

    @Override
    public LogicalNodeId getNodeIdStartedExecution() {
        return this.nodeIdentifierStartedExecution;
    }

    @Override
    public String getAdditionalInformationProvidedAtStart() {
        return this.additionalInformation;
    }

    private void setWorkflowExecutionContext(WorkflowExecutionContext wfExeCtx) {
        this.componentExecutionInformations.clear();
        for (WorkflowNode wfNode : wfExeCtx.getWorkflowDescription().getWorkflowNodes()) {
            ComponentExecutionInformationImpl componentExecutionInformation = new ComponentExecutionInformationImpl();
            ComponentExecutionIdentifier cei = wfExeCtx.getCompExeIdByWfNode(wfNode);
            componentExecutionInformation.setIdentifier(cei.toString());
            componentExecutionInformation.setInstanceName(wfNode.getName());
            componentExecutionInformation.setNodeId(NodeIdentifierUtils.parseArbitraryIdStringToLogicalNodeIdWithExceptionWrapping((String)wfNode.getComponentDescription().getComponentInstallation().getNodeId()));
            componentExecutionInformation.setComponentIdentifier(wfNode.getComponentDescription().getIdentifier());
            componentExecutionInformation.setStorageNetworkDestination(wfExeCtx.getStorageNetworkDestination());
            componentExecutionInformation.setWorkflowExecutionIdentifier(wfExeCtx.getExecutionIdentifier());
            componentExecutionInformation.setWorkflowInstanceName(wfExeCtx.getInstanceName());
            componentExecutionInformation.setWorkflowNodeId(wfExeCtx.getNodeId());
            this.componentExecutionInformations.put(wfNode.getIdentifierAsObject(), (ComponentExecutionInformation)componentExecutionInformation);
        }
        this.nodeIdentifierStartedExecution = wfExeCtx.getNodeIdStartedExecution();
        this.additionalInformation = wfExeCtx.getAdditionalInformationProvidedAtStart();
    }

    @Override
    public int compareTo(WorkflowExecutionInformation other) {
        return this.getWorkflowDescription().getName().compareToIgnoreCase(other.getWorkflowDescription().getName());
    }

    @Override
    public WorkflowState getWorkflowState() {
        return this.workflowState;
    }

    @Override
    public Long getWorkflowDataManagementId() {
        return this.workflowDataManagementId;
    }

    public void setWorkflowState(WorkflowState workflowState) {
        this.workflowState = workflowState;
    }

    public void setWorkflowDataManagementId(Long workflowDataManagementId) {
        this.workflowDataManagementId = workflowDataManagementId;
    }
}

