/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.integration;

import de.rcenvironment.core.component.api.ComponentException;
import de.rcenvironment.core.component.api.ComponentUtils;
import de.rcenvironment.core.component.datamanagement.api.ComponentDataManagementService;
import de.rcenvironment.core.component.datamanagement.api.ComponentHistoryDataItem;
import de.rcenvironment.core.component.execution.api.Component;
import de.rcenvironment.core.component.execution.api.ComponentContext;
import de.rcenvironment.core.component.execution.api.ComponentEventAnnouncement;
import de.rcenvironment.core.component.execution.api.ComponentEventAnnouncementDispatcher;
import de.rcenvironment.core.component.execution.api.ComponentLog;
import de.rcenvironment.core.component.execution.api.ConsoleRow;
import de.rcenvironment.core.component.execution.api.ConsoleRowUtils;
import de.rcenvironment.core.component.execution.api.ThreadHandler;
import de.rcenvironment.core.component.integration.IntegrationHistoryDataItem;
import de.rcenvironment.core.component.model.impl.ToolIntegrationConstants;
import de.rcenvironment.core.component.model.spi.DefaultComponent;
import de.rcenvironment.core.component.scripting.WorkflowConsoleForwardingWriter;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.TypedDatum;
import de.rcenvironment.core.datamodel.api.TypedDatumFactory;
import de.rcenvironment.core.datamodel.api.TypedDatumService;
import de.rcenvironment.core.datamodel.types.api.DirectoryReferenceTD;
import de.rcenvironment.core.datamodel.types.api.FileReferenceTD;
import de.rcenvironment.core.datamodel.types.api.FloatTD;
import de.rcenvironment.core.datamodel.types.api.MatrixTD;
import de.rcenvironment.core.datamodel.types.api.VectorTD;
import de.rcenvironment.core.scripting.ScriptDataTypeHelper;
import de.rcenvironment.core.scripting.ScriptingService;
import de.rcenvironment.core.scripting.ScriptingUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.TempFileServiceAccess;
import de.rcenvironment.core.utils.common.security.StringSubstitutionSecurityUtils;
import de.rcenvironment.core.utils.common.textstream.TextStreamWatcher;
import de.rcenvironment.core.utils.executor.LocalApacheCommandLineExecutor;
import de.rcenvironment.core.utils.scripting.ScriptLanguage;
import de.rcenvironment.toolkit.utils.text.TextLinesReceiver;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Semaphore;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.apache.commons.exec.OS;
import org.apache.commons.io.FileDeleteStrategy;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.Platform;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component
public class CommonToolIntegratorComponent
extends DefaultComponent {
    private static final Object PLATFORM_ACCESS_LOCK = new Object();
    private static final Object VERIFICATION_TOKEN_WRITE_LOCK = new Object();
    private static final String CURRENT_DIR = ".";
    private static final String KEEP_ON_FAILURE_ERROR_MSG = "\"Keep working directory(ies) in case of failure\" was active but is not supported by the tool, so it was deactivated.";
    private static final String DELETION_BEHAVIOR_ERROR_WARNING_MSG = "Chosen working directory deletion behavior not supported for tool %s. Valid one is automatically chosen: %s";
    private static final int MAX_TOOLS_COPIED_IN_PARALLEL = 1;
    private static final Semaphore COPY_TOOL_SEMAPHORE = new Semaphore(1, true);
    private static final Log LOG = LogFactory.getLog(CommonToolIntegratorComponent.class);
    private static final String SLASH = "/";
    private static final String ESCAPESLASH = "\\\\";
    private static final String PROPERTY_PLACEHOLDER = "${prop:%s}";
    private static final String ADD_PROPERTY_PLACEHOLDER = "${addProp:%s}";
    private static final String OUTPUT_PLACEHOLDER = "${out:%s}";
    private static final String INPUT_PLACEHOLDER = "${in:%s}";
    private static final String SCRIPT_LANGUAGE = "Jython";
    private static final String DIRECTORY_PLACEHOLDER_TEMPLATE = "${dir:%s}";
    private static final String QUOTE = "\"";
    private static final String SUBSTITUTION_ERROR_MESSAGE_PREFIX = " can not be substituted in the script, because it contains at least one unsecure character. See log message above to see which characters are affected";
    protected ComponentContext componentContext;
    protected ComponentLog componentLog;
    protected ComponentDataManagementService datamanagementService;
    protected ComponentEventAnnouncementDispatcher compEventAnnouncementDispatcher;
    protected File executionToolDirectory;
    protected File inputDirectory;
    protected File outputDirectory;
    protected IntegrationHistoryDataItem historyDataItem;
    protected Map<String, TypedDatum> lastRunStaticInputValues = null;
    protected Map<String, TypedDatum> lastRunStaticOutputValues = null;
    protected boolean needsToRun = true;
    protected String copyToolBehaviour;
    private ScriptingService scriptingService;
    private TypedDatumFactory typedDatumFactory;
    private File baseWorkingDirectory;
    private File iterationDirectory;
    private File configDirectory;
    private File sourceToolDirectory;
    private String rootWDPath;
    private int runCount;
    private File currentWorkingDirectory;
    private String deleteToolBehaviour;
    private boolean useIterationDirectories;
    private boolean dontCrashOnNonZeroExitCodes;
    private File jythonPath;
    private String workingPath;
    private boolean setToolDirectoryAsWorkingDirectory;
    private TextStreamWatcher stdoutWatcher;
    private TextStreamWatcher stderrWatcher;
    private Writer stdoutWriter;
    private Writer stderrWriter;
    private Map<String, Object> stateMap;
    private boolean keepOnFailure;
    private Map<String, String> outputMapping;
    private LocalApacheCommandLineExecutor executor;
    private Set<String> outputsWithNotAValueWritten = new HashSet<String>();
    private volatile boolean canceled;

    public void setComponentContext(ComponentContext componentContext) {
        this.componentContext = componentContext;
        this.componentLog = componentContext.getLog();
        this.compEventAnnouncementDispatcher = (ComponentEventAnnouncementDispatcher)componentContext.getService(ComponentEventAnnouncementDispatcher.class);
    }

    public boolean treatStartAsComponentRun() {
        return this.componentContext.getInputs().isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws ComponentException {
        URL platformUrl;
        String toolDirPath;
        String toolName;
        block21: {
            this.canceled = false;
            this.datamanagementService = (ComponentDataManagementService)this.componentContext.getService(ComponentDataManagementService.class);
            this.scriptingService = (ScriptingService)this.componentContext.getService(ScriptingService.class);
            this.typedDatumFactory = ((TypedDatumService)this.componentContext.getService(TypedDatumService.class)).getFactory();
            this.lastRunStaticInputValues = new HashMap<String, TypedDatum>();
            this.lastRunStaticOutputValues = new HashMap<String, TypedDatum>();
            toolName = this.componentContext.getConfigurationValue("toolName");
            this.rootWDPath = this.componentContext.getConfigurationValue("rootWorkingDirectory");
            toolDirPath = this.componentContext.getConfigurationValue("toolDirectory");
            platformUrl = null;
            Object object = PLATFORM_ACCESS_LOCK;
            synchronized (object) {
                platformUrl = Platform.getInstallLocation().getURL();
            }
            if (platformUrl == null) {
                throw new ComponentException("Unable to access the platform installation location. This points to an error in the underlying eclipse platform. Please try to execute this component again.");
            }
            if (toolDirPath.equals(CURRENT_DIR) || toolDirPath.startsWith("./")) {
                try {
                    toolDirPath = toolDirPath.replaceFirst(CURRENT_DIR, platformUrl.toURI().toString());
                }
                catch (URISyntaxException e) {
                    LOG.debug((Object)"Could not get installation dir with URI, trying URL. ", (Throwable)e);
                    String path = platformUrl.getPath();
                    if (path.isEmpty()) break block21;
                    toolDirPath = toolDirPath.replaceFirst(CURRENT_DIR, path);
                }
            }
        }
        this.sourceToolDirectory = new File(toolDirPath);
        if (!this.sourceToolDirectory.isAbsolute()) {
            try {
                this.sourceToolDirectory = new File(new File(platformUrl.toURI()), toolDirPath);
            }
            catch (URISyntaxException uRISyntaxException) {
                this.sourceToolDirectory = new File(new File(platformUrl.getPath()), toolDirPath);
            }
        }
        this.useIterationDirectories = Boolean.parseBoolean(this.componentContext.getConfigurationValue("useIterationDirectories"));
        this.copyToolBehaviour = this.componentContext.getConfigurationValue("copyToolBehavior");
        this.dontCrashOnNonZeroExitCodes = this.componentContext.getConfigurationValue("dontCrashOnNonZeroExitCodes") != null && Boolean.parseBoolean(this.componentContext.getConfigurationValue("dontCrashOnNonZeroExitCodes"));
        boolean bl = this.setToolDirectoryAsWorkingDirectory = this.componentContext.getConfigurationValue("setToolDirAsWorkingDir") != null && Boolean.parseBoolean(this.componentContext.getConfigurationValue("setToolDirAsWorkingDir"));
        if (this.copyToolBehaviour == null) {
            this.copyToolBehaviour = "never";
        }
        this.getToolDeleteBehaviour();
        try {
            if (this.rootWDPath == null || this.rootWDPath.isEmpty()) {
                this.baseWorkingDirectory = TempFileServiceAccess.getInstance().createManagedTempDir(toolName);
            } else {
                this.baseWorkingDirectory = new File(String.valueOf(this.rootWDPath) + File.separator + toolName + "_" + UUID.randomUUID().toString() + File.separator);
                this.baseWorkingDirectory.mkdirs();
            }
            FileUtils.write((File)new File(this.baseWorkingDirectory, "rce-workflow-info.txt"), (CharSequence)("Workflow name: " + this.componentContext.getWorkflowInstanceName()));
            if (!this.useIterationDirectories) {
                this.iterationDirectory = this.baseWorkingDirectory;
                this.currentWorkingDirectory = this.baseWorkingDirectory;
                this.createFolderStructure(this.baseWorkingDirectory);
            }
            if (this.copyToolBehaviour.equals("once")) {
                this.copySandboxToolConsideringRestriction(this.baseWorkingDirectory);
            }
            if (this.copyToolBehaviour.equals("never")) {
                this.executionToolDirectory = this.sourceToolDirectory;
            }
        }
        catch (IOException e) {
            throw new ComponentException("Failed to create working directory", (Throwable)e);
        }
        this.prepareJythonForUsingModules();
        this.initializeNewHistoryDataItem();
        this.stateMap = new HashMap<String, Object>();
        if (this.treatStartAsComponentRun()) {
            this.processInputs();
            if (this.historyDataItem != null) {
                this.historyDataItem.setWorkingDirectory(this.currentWorkingDirectory.getAbsolutePath());
            }
        }
        if ((this.copyToolBehaviour.equals("always") || this.deleteToolBehaviour.equals("deleteWorkingDirectoriesAfterIteration")) && !this.useIterationDirectories) {
            throw new ComponentException("Tool shall be copied always but working directory is not new for each run. Please check tool configuration \"Launch Settings\".");
        }
    }

    protected boolean isMockMode() {
        boolean isMockMode = false;
        if (Boolean.valueOf(this.componentContext.getConfigurationValue("imitationModeSupported")).booleanValue() && this.componentContext.getConfigurationValue("isImitationMode") != null) {
            isMockMode = Boolean.valueOf(this.componentContext.getConfigurationValue("isImitationMode"));
        }
        return isMockMode;
    }

    private void getToolDeleteBehaviour() {
        boolean deleteAlwaysActive = Boolean.parseBoolean(this.componentContext.getConfigurationValue("deleteWorkingDirectoriesAfterIteration"));
        boolean deleteNeverActive = Boolean.parseBoolean(this.componentContext.getConfigurationValue("deleteWorkingDirectoriesNever"));
        boolean deleteOnceActive = Boolean.parseBoolean(this.componentContext.getConfigurationValue("deleteWorkingDirectoriesAfterWorkflowExecution"));
        if (this.componentContext.getConfigurationValue("chosenDeleteTempDirBehavior") != null) {
            this.deleteToolBehaviour = this.componentContext.getConfigurationValue("chosenDeleteTempDirBehavior");
        } else {
            this.determineDeletionBehaviour(deleteNeverActive, deleteOnceActive);
        }
        if ("deleteWorkingDirectoriesAfterIteration".equals(this.deleteToolBehaviour) && !deleteAlwaysActive || "deleteWorkingDirectoriesAfterWorkflowExecution".equals(this.deleteToolBehaviour) && !deleteOnceActive || "deleteWorkingDirectoriesNever".equals(this.deleteToolBehaviour) && !deleteNeverActive) {
            String displayname = this.determineDeletionBehaviour(deleteNeverActive, deleteOnceActive);
            this.componentLog.componentWarn(StringUtils.format((String)DELETION_BEHAVIOR_ERROR_WARNING_MSG, (Object[])new Object[]{this.componentContext.getInstanceName(), displayname}));
        }
        this.keepOnFailure = false;
        if (this.checkIfKeepOnFailureCanBeActive()) {
            this.keepOnFailure = Boolean.parseBoolean(this.componentContext.getConfigurationValue("keepOnFailure"));
        } else {
            this.keepOnFailure = Boolean.parseBoolean(this.componentContext.getConfigurationValue("keepOnFailure"));
            if (this.keepOnFailure) {
                this.keepOnFailure = false;
                this.componentLog.componentWarn(StringUtils.format((String)KEEP_ON_FAILURE_ERROR_MSG, (Object[])new Object[0]));
            }
        }
    }

    private boolean checkIfKeepOnFailureCanBeActive() {
        if (this.componentContext.getConfigurationValue("keepOnFailure") != null && !"deleteWorkingDirectoriesNever".equals(this.deleteToolBehaviour)) {
            if ("deleteWorkingDirectoriesAfterIteration".equals(this.deleteToolBehaviour)) {
                return Boolean.parseBoolean(this.componentContext.getConfigurationValue("deleteWorkingDirectoriesKeepOnErrorIteration"));
            }
            if ("deleteWorkingDirectoriesAfterWorkflowExecution".equals(this.deleteToolBehaviour)) {
                return Boolean.parseBoolean(this.componentContext.getConfigurationValue("deleteWorkingDirectoriesKeepOnErrorOnce"));
            }
        }
        return false;
    }

    private String determineDeletionBehaviour(boolean deleteNeverActive, boolean deleteOnceActive) {
        String chosenDisplayName = "\"Delete after every run.\"";
        this.deleteToolBehaviour = "deleteWorkingDirectoriesAfterIteration";
        if (deleteOnceActive) {
            this.deleteToolBehaviour = "deleteWorkingDirectoriesAfterWorkflowExecution";
            chosenDisplayName = "\"Delete after workflow execution.\"";
        } else if (deleteNeverActive) {
            this.deleteToolBehaviour = "deleteWorkingDirectoriesNever";
            chosenDisplayName = "\"Do not delete\"";
        }
        return chosenDisplayName;
    }

    public void processInputs() throws ComponentException {
        HashMap<String, TypedDatum> inputValues = new HashMap<String, TypedDatum>();
        if (this.componentContext != null && this.componentContext.getInputsWithDatum() != null) {
            for (String inputName : this.componentContext.getInputsWithDatum()) {
                inputValues.put(inputName, this.componentContext.readInput(inputName));
            }
        }
        if (this.useIterationDirectories) {
            this.currentWorkingDirectory = this.iterationDirectory = new File(this.baseWorkingDirectory, "" + this.runCount++);
            this.createFolderStructure(this.iterationDirectory);
            if (this.copyToolBehaviour.equals("always")) {
                this.copySandboxToolConsideringRestriction(this.iterationDirectory);
            }
        }
        HashMap<String, String> inputNamesToLocalFile = new HashMap<String, String>();
        for (String inputName : inputValues.keySet()) {
            if (this.componentContext.getInputDataType(inputName) == DataType.FileReference) {
                inputNamesToLocalFile.put(inputName, this.copyInputFileToInputFolder(inputName, inputValues));
                continue;
            }
            if (this.componentContext.getInputDataType(inputName) != DataType.DirectoryReference) continue;
            inputNamesToLocalFile.put(inputName, this.copyInputFileToInputFolder(inputName, inputValues));
        }
        HashSet<String> configFileNames = new HashSet<String>();
        for (String configKey : this.componentContext.getConfigurationKeys()) {
            String configFilename = this.componentContext.getConfigurationMetaDataValue(configKey, "propertyConfigFilename");
            if (configFilename == null || configFilename.isEmpty()) continue;
            configFileNames.add(configFilename);
        }
        for (String filename : configFileNames) {
            File f = new File(this.configDirectory, filename);
            try {
                if (f.exists()) {
                    f.delete();
                }
                f.createNewFile();
                for (String configKey : this.componentContext.getConfigurationKeys()) {
                    String configFilename = this.componentContext.getConfigurationMetaDataValue(configKey, "propertyConfigFilename");
                    if (configFilename == null || configFilename.isEmpty() || !configFilename.equals(filename)) continue;
                    List lines = FileUtils.readLines((File)f);
                    lines.add(String.valueOf(configKey) + "=" + this.componentContext.getConfigurationValue(configKey));
                    FileUtils.writeLines((File)f, (Collection)lines);
                }
            }
            catch (IOException e) {
                throw new ComponentException("Failed to write configuration file: " + f.getAbsolutePath(), (Throwable)e);
            }
        }
        String preScript = this.componentContext.getConfigurationValue("preScript");
        this.beforePreScriptExecution(inputValues, inputNamesToLocalFile);
        this.needsToRun = this.needToRun(inputValues, inputNamesToLocalFile);
        if (this.needsToRun) {
            for (String inputName : inputValues.keySet()) {
                if (!this.componentContext.isStaticInput(inputName) || !inputValues.containsKey(inputName)) continue;
                this.lastRunStaticInputValues.put(inputName, (TypedDatum)inputValues.get(inputName));
            }
            if (this.isMockMode()) {
                this.performRunInMockMode(inputValues, inputNamesToLocalFile);
            } else {
                this.performRunInNormalMode(preScript, inputValues, inputNamesToLocalFile);
            }
        } else {
            for (String outputName : this.lastRunStaticOutputValues.keySet()) {
                this.componentContext.writeOutput(outputName, this.lastRunStaticOutputValues.get(outputName));
            }
        }
        this.afterPostScriptExecution(inputValues, inputNamesToLocalFile);
        if (!Boolean.valueOf(this.componentContext.getConfigurationValue("requiresOutputApproval")).booleanValue()) {
            this.deleteCurrentWorkingDirectoryIfRequired();
        }
        if (this.needsToRun) {
            try {
                this.closeConsoleWriters();
            }
            catch (IOException e) {
                LOG.error((Object)"Failed to close console writers", (Throwable)e);
            }
        } else {
            this.componentLog.componentInfo("Skipped tool execution as input(s) didn't change - output(s) from previous run sent");
        }
        this.storeHistoryDataItem();
    }

    private void deleteCurrentWorkingDirectoryIfRequired() {
        if (this.useIterationDirectories && "deleteWorkingDirectoriesAfterIteration".equals(this.deleteToolBehaviour)) {
            try {
                FileUtils.deleteDirectory((File)this.currentWorkingDirectory);
            }
            catch (IOException e) {
                LOG.error((Object)StringUtils.format((String)"Failed to delete current working directory: %s", (Object[])new Object[]{this.currentWorkingDirectory.getAbsolutePath()}), (Throwable)e);
            }
        }
    }

    private void performRunInNormalMode(String preScript, Map<String, TypedDatum> inputValues, Map<String, String> inputNamesToLocalFile) throws ComponentException {
        int exitCode;
        this.runScript(preScript, inputValues, inputNamesToLocalFile, "Pre");
        this.beforeCommandExecution(inputValues, inputNamesToLocalFile);
        this.componentContext.announceExternalProgramStart();
        try {
            exitCode = this.runCommand(inputValues, inputNamesToLocalFile);
        }
        finally {
            this.componentContext.announceExternalProgramTermination();
        }
        this.afterCommandExecution(inputValues, inputNamesToLocalFile);
        if (this.canceled) {
            return;
        }
        String postScript = this.componentContext.getConfigurationValue("postScript");
        if (postScript != null) {
            postScript = ComponentUtils.replaceVariable((String)postScript, (String)String.valueOf(exitCode), (String)"exitCode", (String)ADD_PROPERTY_PLACEHOLDER);
        }
        this.runScript(postScript, inputValues, inputNamesToLocalFile, "Post");
    }

    private void performRunInMockMode(Map<String, TypedDatum> inputValues, Map<String, String> inputNamesToLocalFile) throws ComponentException {
        this.beforeCommandExecution(inputValues, inputNamesToLocalFile);
        this.afterCommandExecution(inputValues, inputNamesToLocalFile);
        String postScript = this.componentContext.getConfigurationValue("imitationScript");
        this.runScript(postScript, inputValues, inputNamesToLocalFile, "Tool run imitation");
    }

    protected void afterPostScriptExecution(Map<String, TypedDatum> inputValues, Map<String, String> inputNamesToLocalFile) throws ComponentException {
    }

    protected void beforePreScriptExecution(Map<String, TypedDatum> inputValues, Map<String, String> inputNamesToLocalFile) throws ComponentException {
    }

    protected void beforeCommandExecution(Map<String, TypedDatum> inputValues, Map<String, String> inputNamesToLocalFile) throws ComponentException {
    }

    protected void afterCommandExecution(Map<String, TypedDatum> inputValues, Map<String, String> inputNamesToLocalFile) throws ComponentException {
    }

    protected boolean needToRun(Map<String, TypedDatum> inputValues, Map<String, String> inputNamesToLocalFile) throws ComponentException {
        return true;
    }

    public void completeStartOrProcessInputsAfterFailure() throws ComponentException {
        this.storeHistoryDataItem();
    }

    public void tearDown(Component.FinalComponentState state) {
        super.tearDown(state);
        switch (state) {
            case CANCELLED: 
            case FAILED: {
                this.deleteBaseWorkingDirectory(false);
                break;
            }
            case FINISHED: {
                this.deleteBaseWorkingDirectory(true);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int runCommand(Map<String, TypedDatum> inputValues, Map<String, String> inputNamesToLocalFile) throws ComponentException {
        String commScript = null;
        int exitCode = 0;
        if (OS.isFamilyWindows() && Boolean.parseBoolean(this.componentContext.getConfigurationValue("enableCommandScriptWindows"))) {
            commScript = this.componentContext.getConfigurationValue("commandScriptWindows");
            commScript = this.replacePlaceholder(commScript, inputValues, inputNamesToLocalFile, StringSubstitutionSecurityUtils.SubstitutionContext.WINDOWS_BATCH);
        } else if (OS.isFamilyUnix() && Boolean.parseBoolean(this.componentContext.getConfigurationValue("enableCommandScriptLinux"))) {
            commScript = this.componentContext.getConfigurationValue("commandScriptLinux");
            commScript = this.replacePlaceholder(commScript, inputValues, inputNamesToLocalFile, StringSubstitutionSecurityUtils.SubstitutionContext.LINUX_BASH);
        } else {
            throw new ComponentException(StringUtils.format((String)"No command(s) for operating system %s defined", (Object[])new Object[]{System.getProperty("os.name")}));
        }
        try {
            this.componentLog.componentInfo("Executing command(s)...");
            CommonToolIntegratorComponent commonToolIntegratorComponent = this;
            synchronized (commonToolIntegratorComponent) {
                this.executor = this.setToolDirectoryAsWorkingDirectory ? new LocalApacheCommandLineExecutor(this.executionToolDirectory) : new LocalApacheCommandLineExecutor(this.currentWorkingDirectory);
                if (this.canceled) {
                    this.executor.cancel();
                }
                this.executor.executeScript(commScript, null);
                this.stdoutWatcher = ConsoleRowUtils.logToWorkflowConsole((ComponentLog)this.componentLog, (InputStream)this.executor.getStdout(), (ConsoleRow.Type)ConsoleRow.Type.TOOL_OUT, null, (boolean)false);
                this.stderrWatcher = ConsoleRowUtils.logToWorkflowConsole((ComponentLog)this.componentLog, (InputStream)this.executor.getStderr(), (ConsoleRow.Type)ConsoleRow.Type.TOOL_ERROR, null, (boolean)false);
                if (this.canceled) {
                    this.stdoutWatcher.cancel();
                    this.stderrWatcher.cancel();
                }
            }
            try {
                exitCode = this.executor.waitForTermination();
                this.stdoutWatcher.waitForTermination();
                this.stderrWatcher.waitForTermination();
            }
            catch (CancellationException cancellationException) {
                LOG.debug((Object)"Execution canceled while waiting for termination of TextStreamWatcher.");
                exitCode = 1;
            }
            this.componentLog.componentInfo("Command(s) executed - exit code: " + exitCode);
            if (this.historyDataItem != null) {
                this.historyDataItem.setExitCode(exitCode);
            }
            if (this.canceled) {
                return exitCode;
            }
            if (!this.dontCrashOnNonZeroExitCodes && exitCode != 0) {
                throw new ComponentException(StringUtils.format((String)"Command(s) execution terminated abnormally with exit code: %d", (Object[])new Object[]{exitCode}));
            }
        }
        catch (IOException | InterruptedException e) {
            throw new ComponentException("Failed to execute command(s)", (Throwable)e);
        }
        return exitCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runScript(String script, Map<String, TypedDatum> inputValues, Map<String, String> inputNamesToLocalFile, String scriptPrefix) throws ComponentException {
        Object object = ScriptingUtils.SCRIPT_EVAL_LOCK_OBJECT;
        synchronized (object) {
            Object exitCode = null;
            if (script != null && !script.isEmpty()) {
                ScriptLanguage scriptLanguage = ScriptLanguage.getByName((String)SCRIPT_LANGUAGE);
                ScriptEngine engine = this.scriptingService.createScriptEngine(scriptLanguage);
                Map<String, Object> scriptExecConfig = null;
                engine.put("config", scriptExecConfig);
                this.prepareScriptOutputForRun(engine);
                this.componentLog.componentInfo(StringUtils.format((String)"Executing %s script...", (Object[])new Object[]{scriptPrefix.toLowerCase()}));
                if (this.useIterationDirectories) {
                    this.workingPath = this.createJythonPath(this.currentWorkingDirectory);
                }
                script = this.replacePlaceholder(script, inputValues, inputNamesToLocalFile, StringSubstitutionSecurityUtils.SubstitutionContext.JYTHON);
                try {
                    String inputFile;
                    engine.eval("RCE_Bundle_Jython_Path = \"" + this.jythonPath.getAbsolutePath().replaceAll(ESCAPESLASH, SLASH) + QUOTE);
                    if (!this.setToolDirectoryAsWorkingDirectory) {
                        engine.eval("RCE_Temp_working_path = \"" + this.workingPath + QUOTE);
                        String inputFileFactoryPath = String.valueOf(this.workingPath) + "Input";
                        inputFile = ScriptingUtils.prepareInputFileFactoryScript((String)inputFileFactoryPath.replaceAll(ESCAPESLASH, SLASH));
                    } else {
                        engine.eval("RCE_Temp_working_path = \"" + this.createJythonPath(this.executionToolDirectory) + QUOTE);
                        inputFile = ScriptingUtils.prepareInputFileFactoryScript((String)this.executionToolDirectory.getAbsolutePath().replaceAll(ESCAPESLASH, SLASH));
                    }
                    String headerScript = ScriptingUtils.prepareHeaderScript(this.stateMap, (ComponentContext)this.componentContext, (File)this.inputDirectory, new LinkedList());
                    engine.eval(headerScript);
                    String orderedDictionary = ScriptingUtils.prepareOrderedDictionaryScript();
                    engine.eval(orderedDictionary);
                    engine.eval(inputFile);
                    engine.eval(this.prepareTableInput(inputValues));
                    exitCode = engine.eval(script);
                    String footerScript = "\nRCE_Dict_OutputChannels = RCE.get_output_internal()\nRCE_CloseOutputChannelsList = RCE.get_closed_outputs_internal()\nRCE_writtenInputFiles = RCE.get_written_input_files()\n" + StringUtils.format((String)"sys.stdout.write('%s')\nsys.stderr.write('%s')\nsys.stdout.flush()\nsys.stderr.flush()", (Object[])new Object[]{"c02abd1c-67bc-4974-902b-439cd2b14efc", "c02abd1c-67bc-4974-902b-439cd2b14efc"});
                    engine.eval(footerScript);
                    ((WorkflowConsoleForwardingWriter)engine.getContext().getWriter()).awaitPrintingLinesFinished();
                    ((WorkflowConsoleForwardingWriter)engine.getContext().getErrorWriter()).awaitPrintingLinesFinished();
                    String message = StringUtils.format((String)"%s script executed", (Object[])new Object[]{scriptPrefix});
                    if (exitCode != null) {
                        this.componentLog.componentInfo(String.valueOf(message) + " - exit code: " + exitCode);
                    } else {
                        this.componentLog.componentInfo(message);
                    }
                }
                catch (ScriptException e) {
                    throw new ComponentException(StringUtils.format((String)"Failed to execute %s script", (Object[])new Object[]{scriptPrefix.toLowerCase()}), (Throwable)e);
                }
                catch (InterruptedException e) {
                    LOG.error((Object)StringUtils.format((String)"Failed to wait for stdout or stderr writer of to finish (%s (%s))", (Object[])new Object[]{this.componentContext.getInstanceName(), this.componentContext.getExecutionIdentifier()}), (Throwable)e);
                }
                if (!(exitCode == null || exitCode instanceof Integer && (Integer)exitCode == 0)) {
                    throw new ComponentException(StringUtils.format((String)"Execution of %s script terminated abnormally - exit code: %s", (Object[])new Object[]{scriptPrefix.toLowerCase(), exitCode}));
                }
                this.writeOutputValues(engine, scriptExecConfig);
            }
        }
    }

    private String prepareTableInput(Map<String, TypedDatum> inputValues) {
        String script = "";
        for (String inputName : inputValues.keySet()) {
            if (this.componentContext.getInputDataType(inputName) == DataType.Vector) {
                script = String.valueOf(script) + inputName + "= [";
                FloatTD[] floatTDArray = ((VectorTD)inputValues.get(inputName)).toArray();
                int n = floatTDArray.length;
                int n2 = 0;
                while (n2 < n) {
                    FloatTD floatEntry = floatTDArray[n2];
                    script = String.valueOf(script) + floatEntry.getFloatValue() + ",";
                    ++n2;
                }
                script = String.valueOf(script.substring(0, script.length() - 1)) + "]\n";
            }
            if (this.componentContext.getInputDataType(inputName) != DataType.Matrix) continue;
            script = String.valueOf(script) + inputName + "= [";
            MatrixTD matrix = (MatrixTD)this.componentContext.readInput(inputName);
            int i = 0;
            while (i < matrix.getRowDimension()) {
                script = String.valueOf(script) + "[";
                int j = 0;
                while (j < matrix.getColumnDimension()) {
                    script = String.valueOf(script) + matrix.getFloatTDOfElement(i, j).getFloatValue() + ",";
                    ++j;
                }
                script = String.valueOf(script.substring(0, script.length() - 1)) + "],";
                ++i;
            }
            script = String.valueOf(script.substring(0, script.length() - 1)) + "]\n";
        }
        return script;
    }

    private void writeOutputValues(ScriptEngine engine, Map<String, Object> scriptExecConfig) throws ComponentException {
        Bindings bindings = engine.getBindings(100);
        for (String key : bindings.keySet()) {
            Object value = bindings.get(key);
            if (value != null && value.getClass().getSimpleName().equals("NativeJavaObject")) {
                try {
                    value = value.getClass().getMethod("unwrap", new Class[0]).invoke(value, new Object[0]);
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    throw new ComponentException("Failed to extract output values from post script", (Throwable)e);
                }
            }
            if (scriptExecConfig != null) {
                scriptExecConfig.put(key, value);
            }
            if (value == null || !this.outputMapping.containsKey(key)) continue;
            if (this.componentContext.getOutputDataType(this.outputMapping.get(key)) == DataType.FileReference || this.componentContext.getOutputDataType(this.outputMapping.get(key)) == DataType.DirectoryReference) {
                File file = new File(value.toString());
                if (!file.isAbsolute()) {
                    file = new File(this.currentWorkingDirectory, value.toString());
                }
                if (!file.exists()) {
                    throw new ComponentException(StringUtils.format((String)"File for output '%s' doesn't exist: %s", (Object[])new Object[]{this.outputMapping.get(key), file.getAbsolutePath()}));
                }
                try {
                    FileReferenceTD uuid;
                    String filename;
                    String metafilename;
                    if (this.componentContext.getOutputDataType(this.outputMapping.get(key)) == DataType.FileReference) {
                        metafilename = this.componentContext.getOutputMetaDataValue(this.outputMapping.get(key), "endpointFileName");
                        filename = file.getName();
                        if (metafilename != null && !metafilename.isEmpty()) {
                            filename = metafilename;
                        }
                        uuid = this.datamanagementService.createFileReferenceTDFromLocalFile(this.componentContext, file, filename);
                        this.componentContext.writeOutput(this.outputMapping.get(key), (TypedDatum)uuid);
                        this.lastRunStaticOutputValues.put(this.outputMapping.get(key), (TypedDatum)uuid);
                        continue;
                    }
                    metafilename = this.componentContext.getOutputMetaDataValue(this.outputMapping.get(key), "endpointFileName");
                    filename = file.getName();
                    if (metafilename != null && !metafilename.isEmpty()) {
                        filename = metafilename;
                    }
                    uuid = this.datamanagementService.createDirectoryReferenceTDFromLocalDirectory(this.componentContext, file, filename);
                    this.componentContext.writeOutput(this.outputMapping.get(key), (TypedDatum)uuid);
                    this.lastRunStaticOutputValues.put(this.outputMapping.get(key), (TypedDatum)uuid);
                    continue;
                }
                catch (IOException e) {
                    throw new ComponentException(StringUtils.format((String)"Failed to store file/directory '%s' into the data management - if it is not stored in the data management it can not be sent as value for output '%s'", (Object[])new Object[]{file.getAbsolutePath(), this.outputMapping.get(key)}), (Throwable)e);
                }
            }
            TypedDatum valueTD = ScriptDataTypeHelper.parseToTypedDatum((Object)value, (TypedDatumFactory)this.typedDatumFactory, (DataType)this.componentContext.getOutputDataType(this.outputMapping.get(key)));
            this.componentContext.writeOutput(this.outputMapping.get(key), valueTD);
            this.lastRunStaticOutputValues.put(this.outputMapping.get(key), valueTD);
        }
        ScriptingUtils.writeAPIOutput(this.stateMap, (ComponentContext)this.componentContext, (ScriptEngine)engine, (String)this.workingPath, (ComponentHistoryDataItem)this.historyDataItem, this.lastRunStaticOutputValues);
        this.outputsWithNotAValueWritten.addAll(ScriptingUtils.getOutputsSendingNotAValue((ScriptEngine)engine, (ComponentContext)this.componentContext));
        for (String outputName : (List)engine.get("RCE_CloseOutputChannelsList")) {
            this.componentContext.closeOutput(outputName);
        }
        Map stateMapOutput = (Map)engine.get("RCE_STATE_VARIABLES");
        for (String key : stateMapOutput.keySet()) {
            this.stateMap.put(key, stateMapOutput.get(key));
        }
    }

    private String replacePlaceholder(String script, Map<String, TypedDatum> inputValues, Map<String, String> inputNamesToLocalFile, StringSubstitutionSecurityUtils.SubstitutionContext context) throws ComponentException {
        if (inputValues != null) {
            for (String inputName : inputValues.keySet()) {
                if (!inputValues.containsKey(inputName) || !script.contains(StringUtils.format((String)INPUT_PLACEHOLDER, (Object[])new Object[]{inputName}))) continue;
                if (this.componentContext.getInputDataType(inputName) == DataType.FileReference) {
                    script = script.replace(StringUtils.format((String)INPUT_PLACEHOLDER, (Object[])new Object[]{inputName}), inputNamesToLocalFile.get(inputName).replaceAll(ESCAPESLASH, SLASH));
                    continue;
                }
                if (this.componentContext.getInputDataType(inputName) == DataType.DirectoryReference) {
                    script = script.replace(StringUtils.format((String)INPUT_PLACEHOLDER, (Object[])new Object[]{inputName}), inputNamesToLocalFile.get(inputName).replaceAll(ESCAPESLASH, SLASH));
                    continue;
                }
                if (this.componentContext.getInputDataType(inputName) == DataType.Vector) {
                    script = script.replace(StringUtils.format((String)INPUT_PLACEHOLDER, (Object[])new Object[]{inputName}), this.validate(inputName, context, StringUtils.format((String)"Name of Vector '%s' can not be substituted in the script, because it contains at least one unsecure character. See log message above to see which characters are affected", (Object[])new Object[]{inputName})));
                    continue;
                }
                if (this.componentContext.getInputDataType(inputName) == DataType.Matrix) {
                    script = script.replace(StringUtils.format((String)INPUT_PLACEHOLDER, (Object[])new Object[]{inputName}), this.validate(inputName, context, StringUtils.format((String)"Name of Vector '%s' can not be substituted in the script, because it contains at least one unsecure character. See log message above to see which characters are affected", (Object[])new Object[]{inputName})));
                    continue;
                }
                String value = inputValues.get(inputName).toString();
                if (context == StringSubstitutionSecurityUtils.SubstitutionContext.JYTHON && this.componentContext.getInputDataType(inputName) == DataType.Boolean) {
                    value = String.valueOf(value.substring(0, 1).toUpperCase()) + value.substring(1);
                }
                script = script.replace(StringUtils.format((String)INPUT_PLACEHOLDER, (Object[])new Object[]{inputName}), this.validate(value, context, StringUtils.format((String)"Value '%s' from input '%s' can not be substituted in the script, because it contains at least one unsecure character. See log message above to see which characters are affected", (Object[])new Object[]{value, inputName})));
            }
        }
        script = this.replaceOutputVariables(script, this.componentContext.getOutputs(), OUTPUT_PLACEHOLDER);
        HashMap<String, String> properties = new HashMap<String, String>();
        for (String configKey : this.componentContext.getConfigurationKeys()) {
            String value = this.componentContext.getConfigurationValue(configKey);
            this.validate(value, context, StringUtils.format((String)"Value '%s' of property '%s' can not be substituted in the script, because it contains at least one unsecure character. See log message above to see which characters are affected", (Object[])new Object[]{value, configKey}));
            properties.put(configKey, this.componentContext.getConfigurationValue(configKey));
        }
        script = ComponentUtils.replacePropertyVariables((String)script, properties, (String)PROPERTY_PLACEHOLDER);
        script = ComponentUtils.replaceVariable((String)script, (String)this.configDirectory.getAbsolutePath(), (String)ToolIntegrationConstants.DIRECTORIES_PLACEHOLDER[0], (String)DIRECTORY_PLACEHOLDER_TEMPLATE);
        script = ComponentUtils.replaceVariable((String)script, (String)this.currentWorkingDirectory.getAbsolutePath(), (String)ToolIntegrationConstants.DIRECTORIES_PLACEHOLDER[1], (String)DIRECTORY_PLACEHOLDER_TEMPLATE);
        script = ComponentUtils.replaceVariable((String)script, (String)this.currentWorkingDirectory.getAbsolutePath(), (String)(String.valueOf(ToolIntegrationConstants.DIRECTORIES_PLACEHOLDER[1]) + "Dir"), (String)DIRECTORY_PLACEHOLDER_TEMPLATE);
        script = ComponentUtils.replaceVariable((String)script, (String)this.inputDirectory.getAbsolutePath(), (String)ToolIntegrationConstants.DIRECTORIES_PLACEHOLDER[2], (String)DIRECTORY_PLACEHOLDER_TEMPLATE);
        script = ComponentUtils.replaceVariable((String)script, (String)this.outputDirectory.getAbsolutePath(), (String)ToolIntegrationConstants.DIRECTORIES_PLACEHOLDER[4], (String)DIRECTORY_PLACEHOLDER_TEMPLATE);
        script = ComponentUtils.replaceVariable((String)script, (String)this.executionToolDirectory.getAbsolutePath(), (String)ToolIntegrationConstants.DIRECTORIES_PLACEHOLDER[3], (String)DIRECTORY_PLACEHOLDER_TEMPLATE);
        return script;
    }

    private String replaceOutputVariables(String script, Set<String> outputs, String outputPlaceholder) {
        this.outputMapping = new HashMap<String, String>();
        for (String outputName : outputs) {
            String outputID = "_RCE_OUTPUT_" + UUID.randomUUID().toString().replaceAll("-", "_");
            script = script.replace(StringUtils.format((String)outputPlaceholder, (Object[])new Object[]{outputName}), outputID);
            this.outputMapping.put(outputID, outputName);
        }
        return script;
    }

    private String validate(String key, StringSubstitutionSecurityUtils.SubstitutionContext context, String errorMsg) throws ComponentException {
        if (!StringSubstitutionSecurityUtils.isSafeForSubstitutionInsideDoubleQuotes((String)key, (StringSubstitutionSecurityUtils.SubstitutionContext)context)) {
            throw new ComponentException(errorMsg);
        }
        return key;
    }

    private String copyInputFileToInputFolder(String inputName, Map<String, TypedDatum> inputValues) throws ComponentException {
        File targetFile = null;
        TypedDatum fileReference = inputValues.get(inputName);
        try {
            if (this.componentContext.getInputDataType(inputName) == DataType.FileReference) {
                String fileName = ((FileReferenceTD)fileReference).getFileName();
                targetFile = new File(this.inputDirectory.getAbsolutePath(), String.valueOf(inputName) + File.separator + fileName);
                if (targetFile.exists()) {
                    FileUtils.forceDelete((File)targetFile);
                }
                this.datamanagementService.copyFileReferenceTDToLocalFile(this.componentContext, (FileReferenceTD)fileReference, targetFile);
            } else {
                targetFile = new File(this.inputDirectory.getAbsolutePath(), inputName);
                if (targetFile.exists()) {
                    FileUtils.forceDelete((File)targetFile);
                }
                this.datamanagementService.copyDirectoryReferenceTDToLocalDirectory(this.componentContext, (DirectoryReferenceTD)fileReference, targetFile);
                targetFile = new File(targetFile, ((DirectoryReferenceTD)fileReference).getDirectoryName());
            }
        }
        catch (IOException e) {
            throw new ComponentException(StringUtils.format((String)"Failed to write incoming file of input '%s' into working directory: %s", (Object[])new Object[]{inputName, targetFile.getAbsolutePath()}), (Throwable)e);
        }
        return targetFile.getAbsolutePath();
    }

    private void copySandboxTool(File directory) throws ComponentException {
        File targetToolDir = new File(directory + File.separator + this.sourceToolDirectory.getName());
        boolean copiedToolDir = false;
        try {
            FileUtils.copyDirectory((File)this.sourceToolDirectory, (File)targetToolDir);
            this.componentLog.componentInfo("Copied tool directory '" + this.sourceToolDirectory.getName() + "' to working directory");
            copiedToolDir = true;
        }
        catch (IOException e) {
            throw new ComponentException(StringUtils.format((String)"Failed to copy tool directory: %s", (Object[])new Object[]{this.sourceToolDirectory.getAbsolutePath()}), (Throwable)e);
        }
        if (copiedToolDir) {
            this.executionToolDirectory = targetToolDir;
            Iterator it = FileUtils.iterateFiles((File)targetToolDir, null, (boolean)true);
            while (it.hasNext()) {
                File f = (File)it.next();
                f.setExecutable(true, false);
            }
        }
    }

    private void copySandboxToolConsideringRestriction(File directory) throws ComponentException {
        try {
            COPY_TOOL_SEMAPHORE.acquire();
        }
        catch (InterruptedException e) {
            throw new ComponentException("Internal error: Interrupted while waiting for the release to copy the tool", (Throwable)e);
        }
        try {
            this.copySandboxTool(directory);
        }
        finally {
            COPY_TOOL_SEMAPHORE.release();
        }
    }

    private void createFolderStructure(File directory) {
        this.inputDirectory = new File(String.valueOf(directory.getAbsolutePath()) + File.separator + "Input" + File.separator);
        this.inputDirectory.mkdirs();
        this.outputDirectory = new File(String.valueOf(directory.getAbsolutePath()) + File.separator + "Output" + File.separator);
        this.outputDirectory.mkdirs();
        this.configDirectory = new File(String.valueOf(directory.getAbsolutePath()) + File.separator + "Config" + File.separator);
        this.configDirectory.mkdirs();
        this.componentLog.componentInfo("Created working directory: " + directory.getAbsolutePath());
    }

    private void deleteBaseWorkingDirectory(boolean workflowSuccess) {
        if (("deleteWorkingDirectoriesAfterWorkflowExecution".equals(this.deleteToolBehaviour) || "deleteWorkingDirectoriesAfterIteration".equals(this.deleteToolBehaviour)) && (!this.keepOnFailure || workflowSuccess) && this.baseWorkingDirectory != null && this.baseWorkingDirectory.exists()) {
            try {
                if (this.rootWDPath == null || this.rootWDPath.isEmpty()) {
                    TempFileServiceAccess.getInstance().disposeManagedTempDirOrFile(this.baseWorkingDirectory);
                } else {
                    FileDeleteStrategy.FORCE.delete(this.baseWorkingDirectory);
                }
                this.componentLog.componentInfo("Deleted working directory: " + this.baseWorkingDirectory.getAbsolutePath());
            }
            catch (IOException e) {
                this.baseWorkingDirectory.deleteOnExit();
                LOG.error((Object)StringUtils.format((String)"Failed to delete working directory: %s", (Object[])new Object[]{this.baseWorkingDirectory.getAbsolutePath()}), (Throwable)e);
            }
        }
    }

    @Reference(cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.STATIC)
    protected void bindScriptingService(ScriptingService service) {
        this.scriptingService = service;
    }

    @Reference(cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.STATIC)
    protected void bindComponentDataManagementService(ComponentDataManagementService compDataManagementService) {
        this.datamanagementService = compDataManagementService;
    }

    private void prepareScriptOutputForRun(ScriptEngine scriptEngine) {
        StringWriter out = new StringWriter(1024);
        StringWriter err = new StringWriter(1024);
        this.stdoutWriter = new WorkflowConsoleForwardingWriter((Object)out, this.componentLog, ConsoleRow.Type.TOOL_OUT);
        this.stderrWriter = new WorkflowConsoleForwardingWriter((Object)err, this.componentLog, ConsoleRow.Type.TOOL_ERROR);
        scriptEngine.getContext().setWriter(this.stdoutWriter);
        scriptEngine.getContext().setErrorWriter(this.stderrWriter);
    }

    private void prepareJythonForUsingModules() throws ComponentException {
        try {
            this.jythonPath = ScriptingUtils.getJythonPath();
        }
        catch (IOException e) {
            throw new ComponentException("Internal error: Failed to initialize Jython", (Throwable)e);
        }
        if (this.jythonPath == null) {
            throw new ComponentException("Internal error: Failed to initialize Jython");
        }
        File file = new File(this.baseWorkingDirectory.getAbsolutePath(), "jython-import-" + UUID.randomUUID().toString() + ".tmp");
        this.workingPath = this.createJythonPath(file);
    }

    private String createJythonPath(File file) {
        String path = file.getAbsolutePath();
        path = path.replaceAll(ESCAPESLASH, SLASH);
        String[] splitted = path.split(SLASH);
        path = "";
        int lastEntry = splitted.length;
        if (!file.isDirectory()) {
            --lastEntry;
        }
        int i = 0;
        while (i < lastEntry) {
            path = String.valueOf(path) + splitted[i] + SLASH;
            ++i;
        }
        return path;
    }

    protected void closeConsoleWriters() throws IOException {
        if (this.stdoutWriter != null) {
            this.stdoutWriter.flush();
            this.stdoutWriter.close();
        }
        if (this.stderrWriter != null) {
            this.stderrWriter.flush();
            this.stderrWriter.close();
        }
    }

    protected void initializeNewHistoryDataItem() {
        if (Boolean.valueOf(this.componentContext.getConfigurationValue("storeComponentHistoryData")).booleanValue()) {
            this.historyDataItem = new IntegrationHistoryDataItem(this.componentContext.getComponentIdentifier());
        }
    }

    private void storeHistoryDataItem() {
        if (this.historyDataItem != null) {
            this.historyDataItem.setWorkingDirectory(this.currentWorkingDirectory.getAbsolutePath());
        }
        if (this.historyDataItem != null && Boolean.valueOf(this.componentContext.getConfigurationValue("storeComponentHistoryData")).booleanValue()) {
            this.componentContext.writeFinalHistoryDataItem((ComponentHistoryDataItem)this.historyDataItem);
        }
    }

    public synchronized void onStartInterrupted(ThreadHandler executingThreadHandler) {
        this.canceled = true;
        if (this.executor != null) {
            this.executor.cancel();
        }
    }

    public synchronized void onProcessInputsInterrupted(ThreadHandler executingThreadHandler) {
        this.canceled = true;
        if (this.executor != null) {
            this.executor.cancel();
        }
    }

    public void handleVerificationToken(String verificationToken) throws ComponentException {
        String verificationTokenFilePath;
        String[] recipients;
        String tokenLocation = this.componentContext.getConfigurationValue("verificationKeyLocation");
        if (tokenLocation == null) {
            tokenLocation = this.currentWorkingDirectory.getAbsolutePath();
        }
        boolean verificationTokenAnnounced = false;
        String verificationTokenFileContent = this.createVerificationFileContent(verificationToken);
        File verificationTokenFile = this.writeVerificationTokenToFile(tokenLocation, verificationTokenFileContent);
        if (verificationTokenFile != null) {
            verificationTokenAnnounced = true;
        }
        if ((recipients = this.getEmailRecipientsForApprovalRequestAnnouncement()).length > 0 && this.announceRequestForOutputApprovalViaMail(verificationTokenFileContent, verificationTokenFilePath = verificationTokenFile == null ? "n/a" : verificationTokenFile.getAbsolutePath(), recipients)) {
            verificationTokenAnnounced = true;
        }
        if (!verificationTokenAnnounced) {
            throw new ComponentException("Failed to announce verification key; neither file was created nor an email was sent");
        }
        this.componentLog.componentInfo("Waiting for approval...");
    }

    private String createVerificationFileContent(String verificationToken) {
        String contentTemplate;
        try {
            contentTemplate = IOUtils.toString((InputStream)CommonToolIntegratorComponent.class.getResourceAsStream("/file_template_result_verification.txt"));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load file template for verification key file", e);
        }
        return StringUtils.format((String)contentTemplate, (Object[])new Object[]{verificationToken, this.componentContext.getComponentName(), this.componentContext.getExecutionCount(), this.currentWorkingDirectory, this.componentContext.getWorkflowInstanceName()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File writeVerificationTokenToFile(String tokenLocation, String verificationTokenFileContent) {
        File verificationTokenFile;
        String baseVerificationFileName;
        String verificationFileName = baseVerificationFileName = "verification-key";
        Object object = VERIFICATION_TOKEN_WRITE_LOCK;
        synchronized (object) {
            int i = 1;
            while (true) {
                if (!new File(new File(tokenLocation), verificationFileName).exists()) {
                    verificationTokenFile = new File(new File(tokenLocation), verificationFileName);
                    try {
                        FileUtils.write((File)verificationTokenFile, (CharSequence)verificationTokenFileContent);
                        break;
                    }
                    catch (IOException e) {
                        String message = "Failed to create file with verification key";
                        LOG.error((Object)message, (Throwable)e);
                        this.componentLog.componentError(String.valueOf(message) + "; " + e.getMessage());
                        return null;
                    }
                }
                verificationFileName = String.valueOf(baseVerificationFileName) + " (" + i++ + ")";
            }
        }
        this.componentLog.componentInfo("File with verification key created");
        return verificationTokenFile;
    }

    private String[] getEmailRecipientsForApprovalRequestAnnouncement() {
        String recipientsString = this.componentContext.getConfigurationValue("verificationKeyEmailRecipients");
        if (recipientsString == null) {
            return new String[0];
        }
        return recipientsString.trim().split(";");
    }

    private boolean announceRequestForOutputApprovalViaMail(String verificationTokenFileContent, String verificationTokenFilePath, String[] recipients) {
        String contentTemplate;
        int i = 0;
        while (i < recipients.length) {
            recipients[i] = recipients[i].trim();
            ++i;
        }
        String subject = StringUtils.format((String)"Request for result approval for tool '%s'", (Object[])new Object[]{this.componentContext.getComponentName()});
        try {
            contentTemplate = IOUtils.toString((InputStream)CommonToolIntegratorComponent.class.getResourceAsStream("/mail_template_result_verification.txt"));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load file template for verification key email", e);
        }
        String verificationTokenMailContent = StringUtils.format((String)contentTemplate, (Object[])new Object[]{this.componentContext.getComponentName(), verificationTokenFileContent, verificationTokenFilePath});
        ComponentEventAnnouncement compEventAnnouncement = ComponentEventAnnouncement.createAnnouncement((ComponentEventAnnouncement.WorkflowEventType)ComponentEventAnnouncement.WorkflowEventType.REQUEST_FOR_OUTPUT_APPROVAL, (String)subject, (String)verificationTokenMailContent);
        if (this.compEventAnnouncementDispatcher.dispatchWorkflowEventAnnouncementViaMail(recipients, compEventAnnouncement, new TextLinesReceiver(){

            public void addLines(List<String> lines) {
                for (String line : lines) {
                    this.addLine(line);
                }
            }

            public void addLines(String ... lines) {
                String[] stringArray = lines;
                int n = lines.length;
                int n2 = 0;
                while (n2 < n) {
                    String line = stringArray[n2];
                    CommonToolIntegratorComponent.this.componentLog.componentError(line);
                    LOG.error((Object)line);
                    ++n2;
                }
            }

            public void addLine(String line) {
                this.addLines(line);
            }
        })) {
            this.componentLog.componentInfo("Email with verification key sent");
            return true;
        }
        return false;
    }

    public void completeStartOrProcessInputsAfterVerificationDone() throws ComponentException {
        this.deleteCurrentWorkingDirectoryIfRequired();
    }

    protected Set<String> getOutputsWithNotAValueWritten() {
        return this.outputsWithNotAValueWritten;
    }
}

