/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.connection.impl;

import de.rcenvironment.core.communication.channel.MessageChannelService;
import de.rcenvironment.core.communication.channel.MessageChannelState;
import de.rcenvironment.core.communication.common.CommunicationException;
import de.rcenvironment.core.communication.connection.api.ConnectionSetup;
import de.rcenvironment.core.communication.connection.api.ConnectionSetupListener;
import de.rcenvironment.core.communication.connection.api.ConnectionSetupState;
import de.rcenvironment.core.communication.connection.api.DisconnectReason;
import de.rcenvironment.core.communication.model.NetworkContactPoint;
import de.rcenvironment.core.communication.transport.spi.MessageChannel;
import de.rcenvironment.core.communication.utils.NetworkContactPointUtils;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.incubator.AbstractFixedTransitionsStateMachine;
import de.rcenvironment.core.utils.incubator.StateChangeException;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncTaskService;
import de.rcenvironment.toolkit.modules.concurrency.api.TaskDescription;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConnectionSetupImpl
implements ConnectionSetup {
    private static final int MINIMUM_INITIAL_DELAY_MSEC = 5000;
    private static final int SEC_TO_MSEC_FACTOR = 1000;
    private static final int NO_MAXIMUM_AUTO_RETRY_DELAY = 0;
    private static final ConnectionSetupState[][] VALID_STATE_TRANSITIONS = new ConnectionSetupState[][]{{ConnectionSetupState.DISCONNECTED, ConnectionSetupState.CONNECTING}, {ConnectionSetupState.CONNECTING, ConnectionSetupState.CONNECTED}, {ConnectionSetupState.CONNECTED, ConnectionSetupState.DISCONNECTING}, {ConnectionSetupState.DISCONNECTING, ConnectionSetupState.DISCONNECTED}, {ConnectionSetupState.CONNECTING, ConnectionSetupState.DISCONNECTED}, {ConnectionSetupState.DISCONNECTED, ConnectionSetupState.WAITING_TO_RECONNECT}, {ConnectionSetupState.WAITING_TO_RECONNECT, ConnectionSetupState.CONNECTING}, {ConnectionSetupState.WAITING_TO_RECONNECT, ConnectionSetupState.DISCONNECTED}, {ConnectionSetupState.CONNECTED, ConnectionSetupState.DISCONNECTED}};
    private static final int STATE_WAITING_POLLING_INTERVAL = 25;
    private NetworkContactPoint ncp;
    private String displayName;
    private MessageChannelService channelService;
    private final StateMachine stateMachine = new StateMachine();
    private final AsyncTaskService threadPool = ConcurrencyUtils.getAsyncTaskService();
    private final Log log = LogFactory.getLog(this.getClass());
    private ConnectionSetupListener listener;
    private long id;
    private boolean connnectOnStartup;
    private boolean autoRetryEnabled;
    private int autoRetryInitialDelayMsec;
    private int autoRetryMaximumDelayMsec;
    private float autoRetryDelayMultiplier;

    public ConnectionSetupImpl(NetworkContactPoint ncp, String displayName, long id, boolean connnectOnStartup, MessageChannelService channelService, ConnectionSetupListener listener) {
        this.ncp = ncp;
        this.displayName = displayName;
        this.id = id;
        this.connnectOnStartup = connnectOnStartup;
        this.channelService = channelService;
        this.listener = listener;
        Map<String, String> attributes = ncp.getAttributes();
        this.parseAutoRetryConfiguration(attributes);
    }

    @Override
    public void connectSync() throws CommunicationException {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public void signalStartIntent() {
        this.stateMachine.postEvent(new StateMachineEvent(StateMachineEventType.START_REQUESTED));
    }

    @Override
    public void signalStopIntent() {
        this.stateMachine.postEvent(new StateMachineEvent(StateMachineEventType.STOP_REQUESTED));
    }

    @Override
    public void awaitState(ConnectionSetupState targetState, int timeoutMsec) throws TimeoutException, InterruptedException {
        if (this.stateMachine.getState() == targetState) {
            return;
        }
        int timeRemaining = timeoutMsec;
        while (timeRemaining > 0) {
            int waitTime = Math.min(25, timeRemaining);
            Thread.sleep(waitTime);
            if (this.stateMachine.getState() == targetState) {
                return;
            }
            timeRemaining -= 25;
        }
        throw new TimeoutException();
    }

    @Override
    public ConnectionSetupState getState() {
        return (ConnectionSetupState)this.stateMachine.getState();
    }

    @Override
    public DisconnectReason getDisconnectReason() {
        return this.stateMachine.getLastDisconnectReason();
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public boolean getConnnectOnStartup() {
        return this.connnectOnStartup;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getNetworkContactPointString() {
        return NetworkContactPointUtils.toDefinitionString(this.ncp);
    }

    @Override
    public boolean equalsHostAndPort(NetworkContactPoint netCP) {
        return this.ncp.getHost().equals(netCP.getHost()) && this.ncp.getPort() == netCP.getPort();
    }

    public void onMessageChannelClosed(MessageChannel messageChannel) {
        this.log.debug((Object)("Message channel closed, adapting state of connection setup " + this.id + "; channel state: " + (Object)((Object)messageChannel.getState())));
        if (messageChannel.getState() == MessageChannelState.MARKED_AS_BROKEN) {
            this.stateMachine.postEvent(new StateMachineEvent(StateMachineEventType.CHANNEL_BROKEN, messageChannel));
        } else if (messageChannel.isClosedBecauseMirrorChannelClosed()) {
            this.stateMachine.postEvent(new StateMachineEvent(StateMachineEventType.CHANNEL_CLOSED_BY_REMOTE, messageChannel));
        } else {
            this.stateMachine.postEvent(new StateMachineEvent(StateMachineEventType.CHANNEL_CLOSED_BY_OWN_REQUEST, messageChannel));
        }
    }

    @Override
    public MessageChannel getCurrentChannel() {
        return this.stateMachine.getConnectedMessageChannel();
    }

    @Override
    public String getCurrentChannelId() {
        MessageChannel channel = this.stateMachine.getConnectedMessageChannel();
        if (channel != null) {
            return channel.getChannelId();
        }
        return null;
    }

    @Override
    public String getLastChannelId() {
        MessageChannel channel = this.stateMachine.getLastConnectedMessageChannel();
        if (channel != null) {
            return channel.getChannelId();
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        return ((ConnectionSetupImpl)obj).id == this.id;
    }

    public int hashCode() {
        return ConnectionSetupImpl.class.hashCode() ^ (int)this.id;
    }

    private void parseAutoRetryConfiguration(Map<String, String> attributes) {
        this.autoRetryEnabled = false;
        this.autoRetryDelayMultiplier = 1.0f;
        this.autoRetryMaximumDelayMsec = 0;
        String attrInitialDelay = attributes.get("autoRetryInitialDelay");
        if (attrInitialDelay != null) {
            try {
                String attrMaxDelay;
                this.autoRetryInitialDelayMsec = 1000 * Integer.parseInt(attrInitialDelay);
                if (this.autoRetryInitialDelayMsec < 5000) {
                    this.log.warn((Object)("Initial auto-retry delay cannot be less than 5000; disabling for connection " + this.getDisplayName()));
                    return;
                }
                String attrMultiplier = attributes.get("autoRetryDelayMultiplier");
                this.autoRetryDelayMultiplier = attrMultiplier == null || attrMultiplier.isEmpty() ? 1.0f : Float.parseFloat(attrMultiplier);
                if (this.autoRetryDelayMultiplier < 1.0f) {
                    this.log.warn((Object)"Auto-retry backoff multiplier cannot be less than 1; setting to 1");
                    this.autoRetryDelayMultiplier = 1.0f;
                }
                if ((attrMaxDelay = attributes.get("autoRetryMaximumDelay")) != null) {
                    this.autoRetryMaximumDelayMsec = 1000 * Integer.parseInt(attrMaxDelay);
                    if (this.autoRetryMaximumDelayMsec < this.autoRetryInitialDelayMsec) {
                        this.log.warn((Object)("Maximum auto-retry delay cannot be less than initial delay; disabling maximum delay for connection " + this.getDisplayName()));
                        this.autoRetryMaximumDelayMsec = 0;
                    }
                }
                this.autoRetryEnabled = true;
                this.log.debug((Object)StringUtils.format((String)"Parsed auto-retry settings for connection \"%s\": Initial delay=%d msec, maximum=%d msec, multiplier=%s", (Object[])new Object[]{this.getDisplayName(), this.autoRetryInitialDelayMsec, this.autoRetryMaximumDelayMsec, Float.valueOf(this.autoRetryDelayMultiplier)}));
            }
            catch (NumberFormatException numberFormatException) {
                this.log.warn((Object)("Failed to parse auto-retry settings for connection setup " + this.getNetworkContactPointString()));
            }
        }
    }

    private final class StateMachine
    extends AbstractFixedTransitionsStateMachine<ConnectionSetupState, StateMachineEvent> {
        private boolean isConnectionIntended;
        private MessageChannel connectedMessageChannel;
        private MessageChannel lastConnectedMessageChannel;
        private DisconnectReason lastDisconnectReason;
        private int consecutiveConnectionFailures;
        private boolean currentConnectAttemptIsAutoRetry;
        private AsyncConnectTask currentConnectTask;
        private long currentConnectTaskId;
        private long currentAutoRetryWaitExpiredTaskId;

        StateMachine() {
            super((Enum)ConnectionSetupState.DISCONNECTED, (Enum[][])VALID_STATE_TRANSITIONS);
            this.currentConnectAttemptIsAutoRetry = false;
            this.currentConnectTask = null;
        }

        public synchronized MessageChannel getConnectedMessageChannel() {
            return this.connectedMessageChannel;
        }

        public synchronized MessageChannel getLastConnectedMessageChannel() {
            return this.lastConnectedMessageChannel;
        }

        public synchronized DisconnectReason getLastDisconnectReason() {
            return this.lastDisconnectReason;
        }

        protected ConnectionSetupState processEvent(ConnectionSetupState currentState, StateMachineEvent event) throws StateChangeException {
            ConnectionSetupImpl.this.log.debug((Object)StringUtils.format((String)"Processing event %s while in state %s", (Object[])new Object[]{event, currentState}));
            switch (event.getType()) {
                case START_REQUESTED: {
                    this.isConnectionIntended = true;
                    switch (currentState) {
                        case DISCONNECTED: {
                            this.connectAsync(false);
                            return ConnectionSetupState.CONNECTING;
                        }
                        case WAITING_TO_RECONNECT: {
                            this.connectAsync(false);
                            return ConnectionSetupState.CONNECTING;
                        }
                    }
                    ConnectionSetupImpl.this.log.debug((Object)("Ignoring connection START request while in state " + (Object)((Object)currentState)));
                    return null;
                }
                case STOP_REQUESTED: {
                    this.isConnectionIntended = false;
                    switch (currentState) {
                        case CONNECTED: {
                            this.lastDisconnectReason = DisconnectReason.ACTIVE_SHUTDOWN;
                            if (this.connectedMessageChannel != null) {
                                this.disconnectAsync(this.connectedMessageChannel);
                                return ConnectionSetupState.DISCONNECTING;
                            }
                            ConnectionSetupImpl.this.log.warn((Object)("Undefined active channel when processing event " + event));
                            return null;
                        }
                        case CONNECTING: {
                            ++this.currentConnectTaskId;
                            if (this.currentConnectTask != null) {
                                ConnectionSetupImpl.this.log.debug((Object)"Cancelling connect attempt");
                                this.currentConnectTask.attemptToCancel();
                            } else {
                                ConnectionSetupImpl.this.log.warn((Object)("Unexpected state: Connection is " + (Object)((Object)ConnectionSetupState.CONNECTING) + ", but there is no associated task"));
                            }
                            return ConnectionSetupState.DISCONNECTED;
                        }
                        case WAITING_TO_RECONNECT: {
                            this.lastDisconnectReason = DisconnectReason.ACTIVE_SHUTDOWN;
                            return ConnectionSetupState.DISCONNECTED;
                        }
                    }
                    ConnectionSetupImpl.this.log.warn((Object)("Ignoring STOP request as state " + (Object)((Object)currentState) + " is not supported yet"));
                    return null;
                }
                case CONNECT_ATTEMPT_SUCCESSFUL: {
                    MessageChannel newChannel = event.getRelatedChannel();
                    if (!this.checkForCurrentAttemptId(event, this.currentConnectTaskId)) {
                        ConnectionSetupImpl.this.log.warn((Object)("Connection established, but it belongs to an outdated connect request; triggering disconnect of channel " + newChannel));
                        this.disconnectAsync(newChannel);
                        return null;
                    }
                    this.currentConnectTask = null;
                    if (!this.isConnectionIntended) {
                        ConnectionSetupImpl.this.log.warn((Object)("Connection established, but no connection is intended anymore; triggering disconnect of channel " + newChannel));
                        this.disconnectAsync(newChannel);
                        return null;
                    }
                    if (currentState != ConnectionSetupState.CONNECTING) {
                        ConnectionSetupImpl.this.log.debug((Object)("Discarding event " + event + " as the current state is not " + (Object)((Object)ConnectionSetupState.CONNECTING)));
                        return null;
                    }
                    this.connectedMessageChannel = newChannel;
                    this.lastConnectedMessageChannel = newChannel;
                    if (this.consecutiveConnectionFailures == 0) {
                        ConnectionSetupImpl.this.log.info((Object)StringUtils.format((String)"Network connection established: \"%s\"", (Object[])new Object[]{ConnectionSetupImpl.this.displayName}));
                    } else {
                        ConnectionSetupImpl.this.log.info((Object)StringUtils.format((String)"Network connection \"%s\" was successfully established after %d failed attempts", (Object[])new Object[]{ConnectionSetupImpl.this.displayName, this.consecutiveConnectionFailures}));
                    }
                    return ConnectionSetupState.CONNECTED;
                }
                case CONNECT_ATTEMPT_FAILED: {
                    boolean triggerAutoRetry;
                    if (!this.checkForCurrentAttemptId(event, this.currentConnectTaskId)) {
                        return null;
                    }
                    this.currentConnectTask = null;
                    ++this.consecutiveConnectionFailures;
                    boolean wasAutoRetryAttempt = this.currentConnectAttemptIsAutoRetry;
                    if (wasAutoRetryAttempt) {
                        this.lastDisconnectReason = DisconnectReason.FAILED_TO_AUTO_RECONNECT;
                        triggerAutoRetry = true;
                    } else {
                        this.lastDisconnectReason = DisconnectReason.FAILED_TO_CONNECT;
                        triggerAutoRetry = this.isConnectionIntended && ConnectionSetupImpl.this.autoRetryEnabled;
                    }
                    ConnectionSetupImpl.this.listener.onConnectionAttemptFailed(ConnectionSetupImpl.this, this.consecutiveConnectionFailures == 1, triggerAutoRetry);
                    if (triggerAutoRetry) {
                        return ConnectionSetupState.WAITING_TO_RECONNECT;
                    }
                    return ConnectionSetupState.DISCONNECTED;
                }
                case CHANNEL_CLOSED_BY_OWN_REQUEST: 
                case CHANNEL_BROKEN: 
                case CHANNEL_CLOSED_BY_REMOTE: {
                    return this.handleDisconnectEvent(event);
                }
                case AUTO_RETRY_DELAY_EXPIRED: {
                    if (currentState != ConnectionSetupState.WAITING_TO_RECONNECT) {
                        return null;
                    }
                    if (this.currentAutoRetryWaitExpiredTaskId != event.getTaskId()) {
                        ConnectionSetupImpl.this.log.debug((Object)"Ignoring an outdated auto-retry timer callback");
                        return null;
                    }
                    ConnectionSetupImpl.this.log.debug((Object)("Reconnect delay expired, auto-retrying connection " + ConnectionSetupImpl.this.displayName));
                    this.connectAsync(true);
                    return ConnectionSetupState.CONNECTING;
                }
            }
            ConnectionSetupImpl.this.log.warn((Object)("Unprocessed event: " + event));
            return null;
        }

        private boolean checkForCurrentAttemptId(StateMachineEvent event, long currentAttemptId) {
            if (currentAttemptId <= 0L) {
                throw new IllegalStateException();
            }
            if (currentAttemptId == event.getTaskId()) {
                return true;
            }
            ConnectionSetupImpl.this.log.debug((Object)StringUtils.format((String)"Ignoring event of type %s as it refers to attempt #%d while the current attempt is #%d", (Object[])new Object[]{event.getType(), event.getTaskId(), currentAttemptId}));
            return false;
        }

        private ConnectionSetupState handleDisconnectEvent(StateMachineEvent event) {
            if (event.getRelatedChannel() != this.connectedMessageChannel) {
                ConnectionSetupImpl.this.log.debug((Object)("Ignoring " + (Object)((Object)StateMachineEventType.CHANNEL_BROKEN) + " event as it refers to message channel " + event.getRelatedChannel() + ", while the current channel is " + this.connectedMessageChannel));
                return null;
            }
            boolean triggerAutoRetry = false;
            switch (event.getType()) {
                case CHANNEL_CLOSED_BY_OWN_REQUEST: {
                    this.lastDisconnectReason = DisconnectReason.ACTIVE_SHUTDOWN;
                    break;
                }
                case CHANNEL_BROKEN: {
                    triggerAutoRetry = ConnectionSetupImpl.this.autoRetryEnabled;
                    this.lastDisconnectReason = DisconnectReason.ERROR;
                    break;
                }
                case CHANNEL_CLOSED_BY_REMOTE: {
                    triggerAutoRetry = ConnectionSetupImpl.this.autoRetryEnabled;
                    this.lastDisconnectReason = DisconnectReason.REMOTE_SHUTDOWN;
                    break;
                }
                default: {
                    throw new RuntimeException("Should not be reached with event type " + (Object)((Object)event.getType()));
                }
            }
            ConnectionSetupImpl.this.listener.onConnectionClosed(ConnectionSetupImpl.this, this.lastDisconnectReason, triggerAutoRetry);
            ConnectionSetupImpl.this.log.info((Object)StringUtils.format((String)"Network connection closed (%s): \"%s\"", (Object[])new Object[]{this.lastDisconnectReason.getDisplayText(), ConnectionSetupImpl.this.displayName}));
            if (triggerAutoRetry) {
                this.consecutiveConnectionFailures = 1;
                return ConnectionSetupState.WAITING_TO_RECONNECT;
            }
            return ConnectionSetupState.DISCONNECTED;
        }

        private void connectAsync(boolean isAutoRetry) {
            this.currentConnectAttemptIsAutoRetry = isAutoRetry;
            if (!isAutoRetry) {
                this.consecutiveConnectionFailures = 0;
            }
            ++this.currentConnectTaskId;
            this.currentConnectTask = new AsyncConnectTask(this.currentConnectTaskId, isAutoRetry);
            ConnectionSetupImpl.this.threadPool.execute((Runnable)this.currentConnectTask);
        }

        private void disconnectAsync(MessageChannel channel) {
            ConnectionSetupImpl.this.threadPool.execute((Runnable)new AsyncDisconnectTask(channel));
        }

        protected void onStateChanged(ConnectionSetupState oldState, ConnectionSetupState newState) {
            ConnectionSetupImpl.this.log.debug((Object)("Connection setup " + ConnectionSetupImpl.this.displayName + " changed state from " + (Object)((Object)oldState) + " to " + (Object)((Object)newState)));
            switch (newState) {
                case CONNECTING: {
                    if (this.connectedMessageChannel != null) {
                        ConnectionSetupImpl.this.log.error((Object)("Internal error: Current message channel was not 'null' when transitioning from " + (Object)((Object)oldState) + " to " + (Object)((Object)newState)));
                        this.connectedMessageChannel = null;
                    }
                    this.lastDisconnectReason = null;
                    break;
                }
                case DISCONNECTING: {
                    break;
                }
                case DISCONNECTED: {
                    this.connectedMessageChannel = null;
                    break;
                }
                case WAITING_TO_RECONNECT: {
                    this.connectedMessageChannel = null;
                    long targetDelay = this.calculateNextAutoRetryDelay();
                    ConnectionSetupImpl.this.log.debug((Object)StringUtils.format((String)"Scheduling auto-retry of connection %s in %d msec (failure count: %d, delay multiplier: %s, maximum: %d)", (Object[])new Object[]{ConnectionSetupImpl.this.displayName, targetDelay, this.consecutiveConnectionFailures, Float.valueOf(ConnectionSetupImpl.this.autoRetryDelayMultiplier), ConnectionSetupImpl.this.autoRetryMaximumDelayMsec}));
                    long taskId = ++this.currentAutoRetryWaitExpiredTaskId;
                    ConnectionSetupImpl.this.threadPool.scheduleAfterDelay((Runnable)new AsyncAutoRetryTrigger(taskId), targetDelay);
                    break;
                }
            }
            ConnectionSetupImpl.this.listener.onStateChanged(ConnectionSetupImpl.this, oldState, newState);
        }

        protected void onStateChangeException(StateMachineEvent event, StateChangeException e) {
            ConnectionSetupImpl.this.log.error((Object)("Invalid state change attempt, cause by event " + event), (Throwable)e);
        }

        private long calculateNextAutoRetryDelay() {
            long targetDelay = Math.round((double)ConnectionSetupImpl.this.autoRetryInitialDelayMsec * Math.pow(ConnectionSetupImpl.this.autoRetryDelayMultiplier, this.consecutiveConnectionFailures - 1));
            if (ConnectionSetupImpl.this.autoRetryMaximumDelayMsec != 0) {
                targetDelay = Math.min(targetDelay, (long)ConnectionSetupImpl.this.autoRetryMaximumDelayMsec);
            }
            return targetDelay;
        }

        private final class AsyncAutoRetryTrigger
        implements Runnable {
            private final long taskId;

            private AsyncAutoRetryTrigger(long taskId) {
                this.taskId = taskId;
            }

            @Override
            @TaskDescription(value="Communication Layer: ConnectionSetup auto-reconnect timer")
            public void run() {
                StateMachine.this.postEvent(new StateMachineEvent(StateMachineEventType.AUTO_RETRY_DELAY_EXPIRED, null, this.taskId));
            }
        }

        private final class AsyncConnectTask
        implements Runnable {
            private final long taskId;
            private final boolean isAutoRetry;
            private volatile Future<MessageChannel> future;

            AsyncConnectTask(long taskId, boolean isAutoRetry) {
                this.taskId = taskId;
                this.isAutoRetry = isAutoRetry;
            }

            @Override
            @TaskDescription(value="Communication Layer: ConnectionSetup connecting")
            public void run() {
                try {
                    this.future = ConnectionSetupImpl.this.channelService.connect(ConnectionSetupImpl.this.ncp, true);
                    try {
                        MessageChannel newMessageChannel = this.future.get();
                        ConnectionSetupImpl.this.log.debug((Object)("Message channel " + newMessageChannel.getChannelId() + " established for connection setup " + ConnectionSetupImpl.this.id));
                        ConnectionSetupImpl.this.channelService.registerNewOutgoingChannel(newMessageChannel);
                        StateMachine.this.postEvent(new StateMachineEvent(StateMachineEventType.CONNECT_ATTEMPT_SUCCESSFUL, newMessageChannel, this.taskId));
                    }
                    catch (InterruptedException interruptedException) {
                        throw new CommunicationException("The connection attempt was interrupted");
                    }
                    catch (ExecutionException e) {
                        throw this.unwrapFailedToConnectException(e);
                    }
                }
                catch (CommunicationException e) {
                    String exceptionString = e.getCause() == null ? e.getMessage() : e.toString();
                    if (this.isAutoRetry) {
                        ConnectionSetupImpl.this.log.info((Object)StringUtils.format((String)"Failed to auto-reconnect to \"%s\": %s (Connection details: %s)", (Object[])new Object[]{ConnectionSetupImpl.this.displayName, exceptionString, ConnectionSetupImpl.this.getNetworkContactPointString()}));
                    } else {
                        ConnectionSetupImpl.this.log.warn((Object)StringUtils.format((String)"Failed to connect to \"%s\": %s (Connection details: %s)", (Object[])new Object[]{ConnectionSetupImpl.this.displayName, exceptionString, ConnectionSetupImpl.this.getNetworkContactPointString()}));
                    }
                    StateMachine.this.postEvent(new StateMachineEvent(StateMachineEventType.CONNECT_ATTEMPT_FAILED, null, this.taskId));
                }
                catch (CancellationException cancellationException) {
                    ConnectionSetupImpl.this.log.info((Object)StringUtils.format((String)"The connect attempt to \"%s\" was cancelled", (Object[])new Object[]{ConnectionSetupImpl.this.displayName}));
                }
            }

            public void attemptToCancel() {
                Future<MessageChannel> copyOfFuture = this.future;
                if (copyOfFuture != null) {
                    copyOfFuture.cancel(true);
                }
            }

            private CommunicationException unwrapFailedToConnectException(ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof CommunicationException) {
                    return (CommunicationException)cause;
                }
                if (cause != null) {
                    return new CommunicationException(cause);
                }
                return new CommunicationException(e);
            }
        }

        private final class AsyncDisconnectTask
        implements Runnable {
            private final MessageChannel channel;

            private AsyncDisconnectTask(MessageChannel channel) {
                this.channel = channel;
            }

            @Override
            @TaskDescription(value="Communication Layer: ConnectionSetup disconnecting")
            public void run() {
                ConnectionSetupImpl.this.channelService.closeOutgoingChannel(this.channel);
            }
        }
    }

    private static final class StateMachineEvent {
        private final StateMachineEventType type;
        private final MessageChannel relatedChannel;
        private final long taskId;

        StateMachineEvent(StateMachineEventType type) {
            this(type, null, 0L);
        }

        StateMachineEvent(StateMachineEventType type, MessageChannel relatedChannel) {
            this(type, relatedChannel, 0L);
        }

        StateMachineEvent(StateMachineEventType type, MessageChannel relatedChannel, long taskId) {
            if (taskId < 0L) {
                throw new IllegalArgumentException();
            }
            this.type = type;
            this.relatedChannel = relatedChannel;
            this.taskId = taskId;
        }

        public StateMachineEventType getType() {
            return this.type;
        }

        public MessageChannel getRelatedChannel() {
            return this.relatedChannel;
        }

        public long getTaskId() {
            return this.taskId;
        }

        public String toString() {
            return StringUtils.format((String)"%s (#%d, %s)", (Object[])new Object[]{this.type.name(), this.taskId, this.relatedChannel});
        }
    }

    protected static enum StateMachineEventType {
        START_REQUESTED,
        STOP_REQUESTED,
        CONNECT_ATTEMPT_SUCCESSFUL,
        CONNECT_ATTEMPT_FAILED,
        AUTO_RETRY_DELAY_EXPIRED,
        CHANNEL_CLOSED_BY_OWN_REQUEST,
        CHANNEL_BROKEN,
        CHANNEL_CLOSED_BY_REMOTE;

    }
}

