/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.search;

import com.ibm.icu.text.MessageFormat;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.wst.sse.ui.internal.SSEUIMessages;
import org.eclipse.wst.sse.ui.internal.editor.EditorPluginImageHelper;
import org.eclipse.wst.sse.ui.internal.search.BasicSearchMatchElement;

public class BasicSearchLabelProvider
extends LabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    private static final String MATCH_BG_ID = "org.eclipse.wst.sse.ui.search.MATCH_BG";
    private static final StyledString.Styler HIGHLIGHT_WRITE_STYLE;
    private AbstractTextSearchViewPage fPage;

    static {
        JFaceResources.getColorRegistry().put(MATCH_BG_ID, new RGB(206, 204, 247));
        HIGHLIGHT_WRITE_STYLE = StyledString.createColorRegistryStyler(null, (String)MATCH_BG_ID);
    }

    public BasicSearchLabelProvider() {
        this(null);
    }

    public BasicSearchLabelProvider(AbstractTextSearchViewPage page) {
        this.fPage = page;
    }

    public Image getImage(Object element) {
        return EditorPluginImageHelper.getInstance().getImage("icons/full/obj16/occ_match.gif");
    }

    public final String getText(Object element) {
        return this.getStyledText(element).getString();
    }

    public StyledString getStyledText(Object obj) {
        StyledString styledText = new StyledString();
        BasicSearchMatchElement element = null;
        if (obj instanceof Match) {
            Match match = (Match)obj;
            if (match.getElement() instanceof BasicSearchMatchElement) {
                element = (BasicSearchMatchElement)match.getElement();
            }
        } else if (obj instanceof BasicSearchMatchElement) {
            element = (BasicSearchMatchElement)obj;
        }
        int matchCount = 0;
        Match[] matches = new Match[]{};
        if (this.fPage != null) {
            matches = this.fPage.getInput().getMatches(obj);
            matchCount = matches.length;
        }
        if (element != null) {
            String message = element.getLine().trim();
            int trimedAmount = element.getLine().indexOf(message);
            String lineNum = String.valueOf(element.getLineNum() + 1) + ": ";
            styledText.append(lineNum, StyledString.QUALIFIER_STYLER);
            styledText.append(message);
            int i = 0;
            while (i < matchCount) {
                int offset = matches[i].getOffset() - element.geLineOffset() + lineNum.length() - trimedAmount;
                styledText.setStyle(offset, matches[i].getLength(), HIGHLIGHT_WRITE_STYLE);
                ++i;
            }
        } else {
            styledText.append(obj.toString());
        }
        if (matchCount > 1) {
            String matchesMsg = " " + MessageFormat.format((String)SSEUIMessages.TextSearchLabelProvider_matchCountFormat, (Object[])new Object[]{new Integer(matchCount)});
            styledText.append(matchesMsg, StyledString.COUNTER_STYLER);
        }
        return styledText;
    }
}

