/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.EnumSet;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.SearchPattern;
import org.eclipse.jetty.util.Utf8StringBuilder;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class MultiPartParser {
    public static final Logger LOG = Log.getLogger(MultiPartParser.class);
    static final byte COLON = 58;
    static final byte TAB = 9;
    static final byte LINE_FEED = 10;
    static final byte CARRIAGE_RETURN = 13;
    static final byte SPACE = 32;
    static final byte[] CRLF = new byte[]{13, 10};
    static final byte SEMI_COLON = 59;
    private static final EnumSet<State> __delimiterStates = EnumSet.of(State.DELIMITER, State.DELIMITER_CLOSE, State.DELIMITER_PADDING);
    private final boolean DEBUG = LOG.isDebugEnabled();
    private final Handler _handler;
    private final SearchPattern _delimiterSearch;
    private String _fieldName;
    private String _fieldValue;
    private State _state = State.PREAMBLE;
    private FieldState _fieldState = FieldState.FIELD;
    private int _partialBoundary = 2;
    private boolean _cr;
    private ByteBuffer _patternBuffer;
    private final Utf8StringBuilder _string = new Utf8StringBuilder();
    private int _length;
    private int _totalHeaderLineLength = -1;
    private int _maxHeaderLineLength = 998;
    private static final CharState[] __charState = new CharState[256];

    public MultiPartParser(Handler handler, String boundary) {
        this._handler = handler;
        String delimiter = "\r\n--" + boundary;
        this._patternBuffer = ByteBuffer.wrap(delimiter.getBytes(StandardCharsets.US_ASCII));
        this._delimiterSearch = SearchPattern.compile((byte[])this._patternBuffer.array());
    }

    public void reset() {
        this._state = State.PREAMBLE;
        this._fieldState = FieldState.FIELD;
        this._partialBoundary = 2;
    }

    public Handler getHandler() {
        return this._handler;
    }

    public State getState() {
        return this._state;
    }

    public boolean isState(State state) {
        return this._state == state;
    }

    private boolean hasNextByte(ByteBuffer buffer) {
        return BufferUtil.hasContent((ByteBuffer)buffer);
    }

    private byte getNextByte(ByteBuffer buffer) {
        byte ch = buffer.get();
        CharState s = __charState[0xFF & ch];
        switch (s) {
            case LF: {
                this._cr = false;
                return ch;
            }
            case CR: {
                if (this._cr) {
                    throw new BadMessageException("Bad EOL");
                }
                this._cr = true;
                if (buffer.hasRemaining()) {
                    return this.getNextByte(buffer);
                }
                return 0;
            }
            case LEGAL: {
                if (this._cr) {
                    throw new BadMessageException("Bad EOL");
                }
                return ch;
            }
        }
        throw new IllegalCharacterException(this._state, ch, buffer);
    }

    private void setString(String s) {
        this._string.reset();
        this._string.append(s);
        this._length = s.length();
    }

    private String takeString() {
        String s = this._string.toString();
        if (s.length() > this._length) {
            s = s.substring(0, this._length);
        }
        this._string.reset();
        this._length = -1;
        return s;
    }

    public boolean parse(ByteBuffer buffer, boolean last) {
        boolean handle = false;
        block8: while (!handle && BufferUtil.hasContent((ByteBuffer)buffer)) {
            switch (this._state) {
                case PREAMBLE: {
                    this.parsePreamble(buffer);
                    continue block8;
                }
                case DELIMITER: 
                case DELIMITER_PADDING: 
                case DELIMITER_CLOSE: {
                    this.parseDelimiter(buffer);
                    continue block8;
                }
                case BODY_PART: {
                    handle = this.parseMimePartHeaders(buffer);
                    continue block8;
                }
                case FIRST_OCTETS: 
                case OCTETS: {
                    handle = this.parseOctetContent(buffer);
                    continue block8;
                }
                case EPILOGUE: {
                    BufferUtil.clear((ByteBuffer)buffer);
                    continue block8;
                }
                case END: {
                    handle = true;
                    continue block8;
                }
            }
            throw new IllegalStateException();
        }
        if (last && BufferUtil.isEmpty((ByteBuffer)buffer)) {
            if (this._state == State.EPILOGUE) {
                this._state = State.END;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("messageComplete {}", new Object[]{this});
                }
                return this._handler.messageComplete();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("earlyEOF {}", new Object[]{this});
            }
            this._handler.earlyEOF();
            return true;
        }
        return handle;
    }

    private void parsePreamble(ByteBuffer buffer) {
        int delimiter;
        if (this._partialBoundary > 0) {
            int partial = this._delimiterSearch.startsWith(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining(), this._partialBoundary);
            if (partial > 0) {
                if (partial == this._delimiterSearch.getLength()) {
                    buffer.position(buffer.position() + partial - this._partialBoundary);
                    this._partialBoundary = 0;
                    this.setState(State.DELIMITER);
                    return;
                }
                this._partialBoundary = partial;
                BufferUtil.clear((ByteBuffer)buffer);
                return;
            }
            this._partialBoundary = 0;
        }
        if ((delimiter = this._delimiterSearch.match(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining())) >= 0) {
            buffer.position(delimiter - buffer.arrayOffset() + this._delimiterSearch.getLength());
            this.setState(State.DELIMITER);
            return;
        }
        this._partialBoundary = this._delimiterSearch.endsWith(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining());
        BufferUtil.clear((ByteBuffer)buffer);
    }

    private void parseDelimiter(ByteBuffer buffer) {
        block4: while (__delimiterStates.contains((Object)this._state) && this.hasNextByte(buffer)) {
            byte b = this.getNextByte(buffer);
            if (b == 0) {
                return;
            }
            if (b == 10) {
                this.setState(State.BODY_PART);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("startPart {}", new Object[]{this});
                }
                this._handler.startPart();
                return;
            }
            switch (this._state) {
                case DELIMITER: {
                    if (b == 45) {
                        this.setState(State.DELIMITER_CLOSE);
                        continue block4;
                    }
                    this.setState(State.DELIMITER_PADDING);
                    continue block4;
                }
                case DELIMITER_CLOSE: {
                    if (b == 45) {
                        this.setState(State.EPILOGUE);
                        return;
                    }
                    this.setState(State.DELIMITER_PADDING);
                    continue block4;
                }
            }
        }
    }

    protected boolean parseMimePartHeaders(ByteBuffer buffer) {
        byte b;
        block29: while (this._state == State.BODY_PART && this.hasNextByte(buffer) && (b = this.getNextByte(buffer)) != 0) {
            if (b != 10) {
                ++this._totalHeaderLineLength;
            }
            if (this._totalHeaderLineLength > this._maxHeaderLineLength) {
                throw new IllegalStateException("Header Line Exceeded Max Length");
            }
            switch (this._fieldState) {
                case FIELD: {
                    switch (b) {
                        case 9: 
                        case 32: {
                            if (this._fieldName == null) {
                                throw new IllegalStateException("First field folded");
                            }
                            if (this._fieldValue == null) {
                                this._string.reset();
                                this._length = 0;
                            } else {
                                this.setString(this._fieldValue);
                                this._string.append(' ');
                                ++this._length;
                                this._fieldValue = null;
                            }
                            this.setState(FieldState.VALUE);
                            continue block29;
                        }
                        case 10: {
                            this.handleField();
                            this.setState(State.FIRST_OCTETS);
                            this._partialBoundary = 2;
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("headerComplete {}", new Object[]{this});
                            }
                            if (!this._handler.headerComplete()) continue block29;
                            return true;
                        }
                    }
                    this.handleField();
                    this.setState(FieldState.IN_NAME);
                    this._string.reset();
                    this._string.append(b);
                    this._length = 1;
                    continue block29;
                }
                case IN_NAME: {
                    switch (b) {
                        case 58: {
                            this._fieldName = this.takeString();
                            this._length = -1;
                            this.setState(FieldState.VALUE);
                            continue block29;
                        }
                        case 32: {
                            this.setState(FieldState.AFTER_NAME);
                            continue block29;
                        }
                        case 10: {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Line Feed in Name {}", new Object[]{this});
                            }
                            this.handleField();
                            this.setState(FieldState.FIELD);
                            continue block29;
                        }
                    }
                    this._string.append(b);
                    this._length = this._string.length();
                    continue block29;
                }
                case AFTER_NAME: {
                    switch (b) {
                        case 58: {
                            this._fieldName = this.takeString();
                            this._length = -1;
                            this.setState(FieldState.VALUE);
                            continue block29;
                        }
                        case 10: {
                            this._fieldName = this.takeString();
                            this._string.reset();
                            this._fieldValue = "";
                            this._length = -1;
                            continue block29;
                        }
                        case 32: {
                            continue block29;
                        }
                    }
                    throw new IllegalCharacterException(this._state, b, buffer);
                }
                case VALUE: {
                    switch (b) {
                        case 10: {
                            this._string.reset();
                            this._fieldValue = "";
                            this._length = -1;
                            this.setState(FieldState.FIELD);
                            continue block29;
                        }
                        case 9: 
                        case 32: {
                            continue block29;
                        }
                    }
                    this._string.append(b);
                    this._length = this._string.length();
                    this.setState(FieldState.IN_VALUE);
                    continue block29;
                }
                case IN_VALUE: {
                    switch (b) {
                        case 32: {
                            this._string.append(b);
                            continue block29;
                        }
                        case 10: {
                            if (this._length > 0) {
                                this._fieldValue = this.takeString();
                                this._length = -1;
                                this._totalHeaderLineLength = -1;
                            }
                            this.setState(FieldState.FIELD);
                            continue block29;
                        }
                    }
                    this._string.append(b);
                    if (b <= 32 && b >= 0) continue block29;
                    this._length = this._string.length();
                    continue block29;
                }
            }
            throw new IllegalStateException(this._state.toString());
        }
        return false;
    }

    private void handleField() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("parsedField:  _fieldName={} _fieldValue={} {}", new Object[]{this._fieldName, this._fieldValue, this});
        }
        if (this._fieldName != null && this._fieldValue != null) {
            this._handler.parsedField(this._fieldName, this._fieldValue);
        }
        this._fieldValue = null;
        this._fieldName = null;
    }

    protected boolean parseOctetContent(ByteBuffer buffer) {
        int delimiter;
        ByteBuffer content;
        if (this._partialBoundary > 0) {
            int partial = this._delimiterSearch.startsWith(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining(), this._partialBoundary);
            if (partial > 0) {
                if (partial == this._delimiterSearch.getLength()) {
                    buffer.position(buffer.position() + this._delimiterSearch.getLength() - this._partialBoundary);
                    this.setState(State.DELIMITER);
                    this._partialBoundary = 0;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Content={}, Last={} {}", new Object[]{BufferUtil.toDetailString((ByteBuffer)BufferUtil.EMPTY_BUFFER), true, this});
                    }
                    return this._handler.content(BufferUtil.EMPTY_BUFFER, true);
                }
                this._partialBoundary = partial;
                BufferUtil.clear((ByteBuffer)buffer);
                return false;
            }
            content = this._patternBuffer.slice();
            if (this._state == State.FIRST_OCTETS) {
                this.setState(State.OCTETS);
                content.position(2);
            }
            content.limit(this._partialBoundary);
            this._partialBoundary = 0;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Content={}, Last={} {}", new Object[]{BufferUtil.toDetailString((ByteBuffer)content), false, this});
            }
            if (this._handler.content(content, false)) {
                return true;
            }
        }
        if ((delimiter = this._delimiterSearch.match(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining())) >= 0) {
            content = buffer.slice();
            content.limit(delimiter - buffer.arrayOffset() - buffer.position());
            buffer.position(delimiter - buffer.arrayOffset() + this._delimiterSearch.getLength());
            this.setState(State.DELIMITER);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Content={}, Last={} {}", new Object[]{BufferUtil.toDetailString((ByteBuffer)content), true, this});
            }
            return this._handler.content(content, true);
        }
        this._partialBoundary = this._delimiterSearch.endsWith(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining());
        if (this._partialBoundary > 0) {
            content = buffer.slice();
            content.limit(content.limit() - this._partialBoundary);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Content={}, Last={} {}", new Object[]{BufferUtil.toDetailString((ByteBuffer)content), false, this});
            }
            BufferUtil.clear((ByteBuffer)buffer);
            return this._handler.content(content, false);
        }
        content = buffer.slice();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Content={}, Last={} {}", new Object[]{BufferUtil.toDetailString((ByteBuffer)content), false, this});
        }
        BufferUtil.clear((ByteBuffer)buffer);
        return this._handler.content(content, false);
    }

    private void setState(State state) {
        if (this.DEBUG) {
            LOG.debug("{} --> {}", new Object[]{this._state, state});
        }
        this._state = state;
    }

    private void setState(FieldState state) {
        if (this.DEBUG) {
            LOG.debug("{}:{} --> {}", new Object[]{this._state, this._fieldState, state});
        }
        this._fieldState = state;
    }

    public String toString() {
        return String.format("%s{s=%s}", new Object[]{this.getClass().getSimpleName(), this._state});
    }

    static {
        Arrays.fill((Object[])__charState, (Object)CharState.ILLEGAL);
        MultiPartParser.__charState[10] = CharState.LF;
        MultiPartParser.__charState[13] = CharState.CR;
        MultiPartParser.__charState[9] = CharState.LEGAL;
        MultiPartParser.__charState[32] = CharState.LEGAL;
        MultiPartParser.__charState[33] = CharState.LEGAL;
        MultiPartParser.__charState[35] = CharState.LEGAL;
        MultiPartParser.__charState[36] = CharState.LEGAL;
        MultiPartParser.__charState[37] = CharState.LEGAL;
        MultiPartParser.__charState[38] = CharState.LEGAL;
        MultiPartParser.__charState[39] = CharState.LEGAL;
        MultiPartParser.__charState[42] = CharState.LEGAL;
        MultiPartParser.__charState[43] = CharState.LEGAL;
        MultiPartParser.__charState[45] = CharState.LEGAL;
        MultiPartParser.__charState[46] = CharState.LEGAL;
        MultiPartParser.__charState[94] = CharState.LEGAL;
        MultiPartParser.__charState[95] = CharState.LEGAL;
        MultiPartParser.__charState[96] = CharState.LEGAL;
        MultiPartParser.__charState[124] = CharState.LEGAL;
        MultiPartParser.__charState[126] = CharState.LEGAL;
        MultiPartParser.__charState[34] = CharState.LEGAL;
        MultiPartParser.__charState[92] = CharState.LEGAL;
        MultiPartParser.__charState[40] = CharState.LEGAL;
        MultiPartParser.__charState[41] = CharState.LEGAL;
        Arrays.fill((Object[])__charState, 33, 40, (Object)CharState.LEGAL);
        Arrays.fill((Object[])__charState, 42, 92, (Object)CharState.LEGAL);
        Arrays.fill((Object[])__charState, 93, 127, (Object)CharState.LEGAL);
        Arrays.fill((Object[])__charState, 128, 256, (Object)CharState.LEGAL);
    }

    private static class IllegalCharacterException
    extends IllegalArgumentException {
        private IllegalCharacterException(State state, byte ch, ByteBuffer buffer) {
            super(String.format("Illegal character 0x%X", ch));
            LOG.warn(String.format("Illegal character 0x%X in state=%s for buffer %s", new Object[]{ch, state, BufferUtil.toDetailString((ByteBuffer)buffer)}), new Object[0]);
        }
    }

    public static interface Handler {
        default public void startPart() {
        }

        default public void parsedField(String name, String value) {
        }

        default public boolean headerComplete() {
            return false;
        }

        default public boolean content(ByteBuffer item, boolean last) {
            return false;
        }

        default public boolean messageComplete() {
            return false;
        }

        default public void earlyEOF() {
        }
    }

    static enum CharState {
        ILLEGAL,
        CR,
        LF,
        LEGAL;

    }

    public static enum State {
        PREAMBLE,
        DELIMITER,
        DELIMITER_PADDING,
        DELIMITER_CLOSE,
        BODY_PART,
        FIRST_OCTETS,
        OCTETS,
        EPILOGUE,
        END;

    }

    public static enum FieldState {
        FIELD,
        IN_NAME,
        AFTER_NAME,
        VALUE,
        IN_VALUE;

    }
}

