/*
 * Decompiled with CFR 0.152.
 */
package de.vonloesch.pdf4eclipse.model;

import de.vonloesch.pdf4eclipse.model.IPDFFile;
import de.vonloesch.pdf4eclipse.model.jpedal.JPedalPDFFile;
import de.vonloesch.pdf4eclipse.model.sun.SunPDFFile;
import java.io.File;
import java.io.IOException;
import org.jpedal.PdfDecoder;

public class PDFFactory {
    private static PDFFactory instance;
    public static final int STRATEGY_SUN = 1;
    public static final int STRATEGY_JPEDAL = 2;
    public static final int STRATEGY_SUN_JPEDAL = 3;
    private static final int MAX_PAGES_CHECK = 20;

    protected PDFFactory() {
    }

    public static IPDFFile openPDFFile(File file, int strategy) throws IOException {
        if (instance == null) {
            instance = new PDFFactory();
        }
        if (strategy == 1) {
            return new SunPDFFile(file);
        }
        if (strategy == 2 || strategy == 3) {
            JPedalPDFFile f2 = new JPedalPDFFile(file);
            if (strategy == 2) {
                return f2;
            }
            PdfDecoder decoder = f2.getInternalDecoder();
            decoder.setRenderMode(1);
            boolean hasCIDFont = false;
            try {
                int i = 1;
                while (i <= decoder.getPageCount() && i <= 20) {
                    decoder.decodePage(i);
                    if (decoder.getInfo(373243460).indexOf("CIDFontType0") > 0) {
                        hasCIDFont = true;
                        break;
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (hasCIDFont) {
                decoder.setRenderMode(7);
                return f2;
            }
            f2.close();
            return new SunPDFFile(file);
        }
        return null;
    }
}

