/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.editor.handlers;

import de.rcenvironment.core.gui.workflow.editor.WorkflowEditor;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.gef.palette.ConnectionCreationToolEntry;
import org.eclipse.gef.palette.PaletteGroup;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public class SelectConnectionToolHandler
extends AbstractHandler {
    private WorkflowEditor editor;
    private PaletteViewer paletteViewer;

    public Object execute(ExecutionEvent arg0) throws ExecutionException {
        IEditorPart activePart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (activePart instanceof WorkflowEditor) {
            this.editor = (WorkflowEditor)activePart;
            this.paletteViewer = this.editor.getPaletteViewer();
            this.editor.setFocus();
            this.switchToConnectionTool();
        }
        return null;
    }

    private void switchToConnectionTool() {
        if (this.paletteViewer != null && !this.isConnectionToolSelected()) {
            for (Object paletteGroupObject : this.paletteViewer.getPaletteRoot().getChildren()) {
                if (!(paletteGroupObject instanceof PaletteGroup)) continue;
                PaletteGroup paletteGroup = (PaletteGroup)paletteGroupObject;
                for (Object paletteEntryObject : paletteGroup.getChildren()) {
                    if (!(paletteEntryObject instanceof ConnectionCreationToolEntry)) continue;
                    this.paletteViewer.setActiveTool((ToolEntry)((ConnectionCreationToolEntry)paletteEntryObject));
                }
            }
        }
    }

    private boolean isConnectionToolSelected() {
        return this.paletteViewer.getActiveTool() instanceof ConnectionCreationToolEntry;
    }
}

