/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.integration.workflow.command;

import de.rcenvironment.core.command.common.CommandException;
import de.rcenvironment.core.command.spi.CommandContext;
import de.rcenvironment.core.command.spi.CommandDescription;
import de.rcenvironment.core.command.spi.CommandPlugin;
import de.rcenvironment.core.component.api.ComponentIdRules;
import de.rcenvironment.core.component.integration.workflow.WorkflowIntegrationService;
import de.rcenvironment.core.component.integration.workflow.command.ParseResult;
import de.rcenvironment.core.component.integration.workflow.command.WfIntegrateCommandParser;
import de.rcenvironment.core.component.workflow.execution.api.PersistentWorkflowDescriptionLoaderService;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowFileException;
import de.rcenvironment.core.component.workflow.model.api.WorkflowDescription;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.workflow.execution.function.EndpointAdapter;
import de.rcenvironment.core.workflow.execution.function.EndpointAdapters;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import java.util.stream.Collectors;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class WfIntegrateCommandPlugin
implements CommandPlugin {
    private WorkflowIntegrationService workflowIntegrationService;
    private PersistentWorkflowDescriptionLoaderService workflowLoaderService;

    public Collection<CommandDescription> getCommandDescriptions() {
        return Arrays.asList(new CommandDescription("wf integrate", "<toolname> <workflow file>", false, "integrate a workflow file as a component", new String[0]));
    }

    public void execute(CommandContext commandContext) throws CommandException {
        commandContext.consumeExpectedToken("wf");
        commandContext.consumeExpectedToken("integrate");
        this.performWfIntegrate(commandContext);
    }

    private void performWfIntegrate(CommandContext context) throws CommandException {
        WorkflowDescription desc;
        boolean verbose = context.consumeNextTokenIfEquals("-v");
        String componentname = context.consumeNextToken();
        if (componentname == null) {
            throw CommandException.syntaxError((String)"Missing component name", (CommandContext)context);
        }
        Optional idValidationError = ComponentIdRules.validateComponentIdRules((String)componentname);
        if (idValidationError.isPresent()) {
            throw CommandException.syntaxError((String)"Invalid component ID", (CommandContext)context);
        }
        String filename = context.consumeNextToken();
        if (filename == null) {
            throw CommandException.missingFilename((CommandContext)context);
        }
        try {
            desc = this.workflowLoaderService.loadWorkflowDescriptionFromFile(new File(filename), null);
        }
        catch (WorkflowFileException workflowFileException) {
            throw CommandException.executionError((String)StringUtils.format((String)"Workflow file at '%s' could not be parsed", (Object[])new Object[]{filename}), (CommandContext)context);
        }
        WfIntegrateCommandParser parser = new WfIntegrateCommandParser();
        LinkedList<EndpointAdapter> unpackedParseResults = new LinkedList<EndpointAdapter>();
        LinkedList<String> parseErrors = new LinkedList<String>();
        while (context.hasRemainingTokens()) {
            Collection<ParseResult<EndpointAdapter>> exposureParameters = parser.parseEndpointAdapterDefinition(context, desc);
            for (ParseResult<EndpointAdapter> parameter : exposureParameters) {
                if (parameter.isSuccessfulResult()) {
                    unpackedParseResults.add(parameter.getResult());
                    continue;
                }
                parseErrors.add(parameter.getErrorDisplayMessage());
            }
        }
        String parseErrorMessage = parseErrors.stream().collect(Collectors.joining("\n"));
        if (!parseErrorMessage.isEmpty()) {
            throw CommandException.syntaxError((String)StringUtils.format((String)"Could not parse endpoint adapter definitions: \n%s", (Object[])new Object[]{parseErrorMessage}), (CommandContext)context);
        }
        if (verbose) {
            unpackedParseResults.stream().filter(definition -> definition.isInputAdapter()).map(definition -> definition.toString()).forEach(definitionString -> context.getOutputReceiver().addOutput(StringUtils.format((String)"Input Adapter : %s", (Object[])new Object[]{definitionString})));
            unpackedParseResults.stream().filter(definition -> definition.isOutputAdapter()).map(definition -> definition.toString()).forEach(definitionString -> context.getOutputReceiver().addOutput(StringUtils.format((String)"Output Adapter: %s", (Object[])new Object[]{definitionString})));
        }
        EndpointAdapters.Builder endpointAdapters = new EndpointAdapters.Builder();
        for (EndpointAdapter parseResult : unpackedParseResults) {
            endpointAdapters.addEndpointAdapter(parseResult);
        }
        try {
            this.workflowIntegrationService.integrateWorkflowFileAsComponent(desc, componentname, endpointAdapters.build());
        }
        catch (IOException iOException) {
            throw CommandException.executionError((String)StringUtils.format((String)"Could not integrate workflow '%s' as component '%s'", (Object[])new Object[]{filename, componentname}), (CommandContext)context);
        }
    }

    @Reference
    public void bindWorkflowIntegrationService(WorkflowIntegrationService service) {
        this.workflowIntegrationService = service;
    }

    @Reference
    public void bindWorkflowLoaderService(PersistentWorkflowDescriptionLoaderService service) {
        this.workflowLoaderService = service;
    }
}

