/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.routing.internal;

import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import java.io.Serializable;
import java.util.Date;

public final class TopologyNode
implements Comparable<TopologyNode>,
Cloneable,
Serializable {
    private static final int INITIAL_SEQUENCE_NUMBER = -1;
    private static final long serialVersionUID = -2179209415622826744L;
    private final Date createdTime = new Date();
    private final InstanceNodeSessionId nodeId;
    private long lastSequenceNumber = -1L;
    private int lastGraphHashCode = 0;
    private boolean routing;
    private String displayName;
    private boolean isWorkflowHost;

    public TopologyNode(InstanceNodeSessionId nodeId) {
        this.nodeId = nodeId;
        this.routing = true;
    }

    public TopologyNode(InstanceNodeSessionId nodeId, boolean routing) {
        this.nodeId = nodeId;
        this.routing = routing;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Deprecated
    public boolean getIsWorkflowHost() {
        return this.isWorkflowHost;
    }

    @Deprecated
    public void setIsWorkflowHost(boolean isWorkflowHost) {
        this.isWorkflowHost = isWorkflowHost;
    }

    public TopologyNode clone() {
        return new TopologyNode(this.getNodeIdentifier());
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public synchronized long getSequenceNumber() {
        return this.lastSequenceNumber;
    }

    public InstanceNodeSessionId getNodeIdentifier() {
        return this.nodeId;
    }

    public synchronized void setLastSequenceNumber(long lastSequenceNumber) {
        this.lastSequenceNumber = lastSequenceNumber;
    }

    public synchronized long invalidateSequenceNumber() {
        long newValue = System.currentTimeMillis();
        if (newValue <= this.lastSequenceNumber) {
            newValue = this.lastSequenceNumber + 1L;
        }
        this.lastSequenceNumber = newValue;
        return this.lastSequenceNumber;
    }

    public String toString() {
        return String.valueOf(this.getNodeIdentifier().toString()) + "(" + this.getSequenceNumber() + ")";
    }

    @Override
    public int compareTo(TopologyNode networkNode) {
        return Integer.valueOf(this.hashCode()).compareTo(networkNode.hashCode());
    }

    public int hashCode() {
        return this.getNodeIdentifier().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof TopologyNode) {
            return obj.hashCode() == this.hashCode();
        }
        return false;
    }

    public int getLastGraphHashCode() {
        return this.lastGraphHashCode;
    }

    public void setLastGraphHashCode(int lastGraphHashCode) {
        this.lastGraphHashCode = lastGraphHashCode;
    }

    public boolean isRouting() {
        return this.routing;
    }

    public void setRouting(boolean routing) {
        this.routing = routing;
    }
}

