/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.scpinputloader.execution;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.rcenvironment.core.component.api.ComponentException;
import de.rcenvironment.core.component.datamanagement.api.ComponentDataManagementService;
import de.rcenvironment.core.component.execution.api.ComponentContext;
import de.rcenvironment.core.component.model.api.LocalExecutionOnly;
import de.rcenvironment.core.component.model.spi.DefaultComponent;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.TypedDatum;
import de.rcenvironment.core.datamodel.api.TypedDatumFactory;
import de.rcenvironment.core.datamodel.api.TypedDatumSerializer;
import de.rcenvironment.core.datamodel.api.TypedDatumService;
import de.rcenvironment.core.datamodel.types.api.DirectoryReferenceTD;
import de.rcenvironment.core.datamodel.types.api.FileReferenceTD;
import de.rcenvironment.core.datamodel.types.api.ShortTextTD;
import de.rcenvironment.core.utils.common.StringUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

@LocalExecutionOnly
public class ScpInputLoaderComponent
extends DefaultComponent {
    private ComponentContext componentContext;
    private ComponentDataManagementService dataManagementService;
    private File uploadDirectory;
    private TypedDatumFactory typedDatumFactory;

    public void setComponentContext(ComponentContext componentContext) {
        this.componentContext = componentContext;
    }

    public boolean treatStartAsComponentRun() {
        return this.componentContext.getOutputs().size() > 0;
    }

    public void start() throws ComponentException {
        this.typedDatumFactory = ((TypedDatumService)this.componentContext.getService(TypedDatumService.class)).getFactory();
        this.dataManagementService = (ComponentDataManagementService)this.componentContext.getService(ComponentDataManagementService.class);
        TypedDatumSerializer serializer = ((TypedDatumService)this.componentContext.getService(TypedDatumService.class)).getSerializer();
        ObjectMapper mapper = new ObjectMapper();
        this.uploadDirectory = new File(this.componentContext.getConfigurationValue("UploadDirectory"));
        File inputsDescriptionFile = new File(this.uploadDirectory, this.componentContext.getConfigurationValue("InputsDescriptionFile"));
        if (!inputsDescriptionFile.exists()) {
            throw new ComponentException("Inputs description file inputs.json does not exist in the input directory. Possible reason: The component was called in a local workflow; it should only be used in an SSH remote access workflow. ");
        }
        boolean uncompressedInput = Boolean.valueOf(this.componentContext.getConfigurationValue("UncompressedUpload"));
        boolean simpleFormat = Boolean.valueOf(this.componentContext.getConfigurationValue("SimpleDescriptionFormat"));
        try {
            Map outputsMap = (Map)mapper.readValue(inputsDescriptionFile, new HashMap().getClass());
            for (String outputName : this.componentContext.getOutputs()) {
                TypedDatum outputTD;
                Object valueObj = outputsMap.get(outputName);
                if (valueObj == null) continue;
                String value = valueObj.toString();
                DataType type = this.componentContext.getOutputDataType(outputName);
                if (simpleFormat) {
                    outputTD = this.getTypedDatumFromSimpleString(value, type, uncompressedInput);
                } else {
                    TypedDatum deserializedTD = serializer.deserialize(value);
                    switch (type) {
                        case DirectoryReference: {
                            outputTD = this.getTypedDatumForDirectory(((DirectoryReferenceTD)deserializedTD).getDirectoryReference(), ((DirectoryReferenceTD)deserializedTD).getDirectoryName(), uncompressedInput);
                            break;
                        }
                        case FileReference: {
                            outputTD = this.getTypedDatumForFile(((FileReferenceTD)deserializedTD).getFileReference(), ((FileReferenceTD)deserializedTD).getFileName(), uncompressedInput);
                            break;
                        }
                        default: {
                            outputTD = deserializedTD;
                        }
                    }
                }
                this.componentContext.writeOutput(outputName, outputTD);
            }
        }
        catch (IOException iOException) {
            throw new ComponentException("Could not parse inputs.json description file.");
        }
    }

    private TypedDatum getTypedDatumFromSimpleString(String value, DataType type, boolean uncompressed) throws ComponentException {
        ShortTextTD datum;
        try {
            switch (type) {
                case ShortText: {
                    datum = this.typedDatumFactory.createShortText(value);
                    break;
                }
                case Boolean: {
                    datum = this.typedDatumFactory.createBoolean(Boolean.parseBoolean(value));
                    break;
                }
                case Float: {
                    datum = this.typedDatumFactory.createFloat(Double.parseDouble(value));
                    break;
                }
                case Integer: {
                    datum = this.typedDatumFactory.createInteger(Long.parseLong(value));
                    break;
                }
                case FileReference: {
                    datum = this.getTypedDatumForFile(value, value, uncompressed);
                    break;
                }
                case DirectoryReference: {
                    datum = this.getTypedDatumForDirectory(value, value, uncompressed);
                    break;
                }
                default: {
                    throw new ComponentException("Internal error: Given data type is not supported: " + type);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new ComponentException("Input datum " + value + " could not be parsed to type " + type);
        }
        return datum;
    }

    private TypedDatum getTypedDatumForFile(String fileRef, String origFileName, boolean uncompressed) throws ComponentException {
        File file = new File(this.uploadDirectory, fileRef);
        if (!file.exists()) {
            throw new ComponentException(StringUtils.format((String)"Given path doesn't refer to a file in the input directory: %s", (Object[])new Object[]{file.getName()}));
        }
        try {
            if (uncompressed) {
                return this.dataManagementService.createFileReferenceTDFromLocalFile(this.componentContext, file, origFileName);
            }
            return this.dataManagementService.createFileReferenceTDFromLocalCompressedFile(this.componentContext, file, origFileName);
        }
        catch (IOException e) {
            throw new ComponentException("Failed to store file into the data management - if it is not stored in the data management, it can not be sent as output value: " + file.getAbsolutePath(), (Throwable)e);
        }
    }

    private TypedDatum getTypedDatumForDirectory(String directory, String origDirName, boolean uncompressed) throws ComponentException {
        File dir = new File(this.uploadDirectory, directory);
        if (!dir.exists()) {
            throw new ComponentException(StringUtils.format((String)"Directory doesn't exist on node in the input directory: %s", (Object[])new Object[]{dir.getName()}));
        }
        try {
            if (uncompressed) {
                return this.dataManagementService.createDirectoryReferenceTDFromLocalDirectory(this.componentContext, dir, origDirName);
            }
            return this.dataManagementService.createDirectoryReferenceTDFromLocalCompressedFile(this.componentContext, dir, origDirName);
        }
        catch (IOException e) {
            throw new ComponentException("Failed to store directory into the data management - if it is not stored in the data management, it can not be sent as output value: " + dir.getAbsolutePath(), (Throwable)e);
        }
    }
}

