/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.outputwriter.gui;

import de.rcenvironment.components.outputwriter.common.OutputWriterComponentConstants;
import de.rcenvironment.components.outputwriter.gui.Messages;
import de.rcenvironment.components.outputwriter.gui.OutputWriterGuiUtils;
import de.rcenvironment.core.component.model.endpoint.api.EndpointMetaDataDefinition;
import de.rcenvironment.core.component.workflow.model.spi.ComponentInstanceProperties;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.EndpointActionType;
import de.rcenvironment.core.datamodel.api.EndpointType;
import de.rcenvironment.core.gui.resources.api.ImageManager;
import de.rcenvironment.core.gui.resources.api.ImageSource;
import de.rcenvironment.core.gui.resources.api.StandardImages;
import de.rcenvironment.core.gui.utils.incubator.AlphanumericalTextContraintListener;
import de.rcenvironment.core.gui.workflow.editor.properties.EndpointEditDialog;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class OutputWriterEndpointEditDialog
extends EndpointEditDialog {
    private static final String NO_DATA_STRING = "-";
    private static final char[] FORBIDDEN_CHARS = new char[]{'/', '\\', ':', '*', '?', '\"', '>', '<', '|'};
    private static final int MINUS_ONE = -1;
    private static final String COLON = ":";
    private final Set<String> paths;
    private Text result;
    private CLabel hintLabel;

    public OutputWriterEndpointEditDialog(Shell parentShell, EndpointActionType actionType, ComponentInstanceProperties configuration, EndpointType direction, String id, boolean isStatic, EndpointMetaDataDefinition metaData, Map<String, String> metadataValues, Set<String> paths) {
        super(parentShell, actionType, configuration, direction, id, isStatic, metaData, metadataValues);
        this.paths = paths;
    }

    protected Control createDialogArea(Composite parent) {
        Control superControl = super.createDialogArea(parent);
        this.hintLabel = new CLabel((Composite)superControl, 0);
        this.hintLabel.setText("You are adding a primitive data type input. Therefore, you also \nneed to add this input to a target file in the data sheet tab \nof this Output Writer component.");
        this.hintLabel.setImage(ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.INFORMATION_16));
        return superControl;
    }

    protected void createSettings(Map<Integer, String> sortedKeyMap, Composite container) {
        String key = "filename";
        String text = this.metaData.getGuiName(key);
        String value = (String)this.metadataValues.get(key);
        Label nameLabel = new Label(container, 0);
        nameLabel.setText(String.valueOf(text) + "    ");
        this.result = new Text(container, 2052);
        this.result.setLayoutData((Object)new GridData(4, 4, true, false));
        if (value == null || value.equals(NO_DATA_STRING)) {
            value = "";
        }
        this.result.setText(value);
        this.result.addListener(25, (Listener)new AlphanumericalTextContraintListener(FORBIDDEN_CHARS));
        this.widgetToKeyMap.put(this.result, key);
        this.result.addModifyListener((ModifyListener)new EndpointEditDialog.MethodPropertiesModifyListener((EndpointEditDialog)this));
        new Label(container, 0).setText("");
        Composite placeholderComp = new Composite(container, 0);
        GridLayout placeholderCompLayout = new GridLayout(2, false);
        placeholderCompLayout.marginWidth = 0;
        placeholderComp.setLayout((Layout)placeholderCompLayout);
        placeholderComp.setLayoutData((Object)new GridData(768));
        CCombo placeholderCombo = OutputWriterGuiUtils.createPlaceholderCombo(placeholderComp, OutputWriterComponentConstants.WORDLIST);
        OutputWriterGuiUtils.createPlaceholderInsertButton(placeholderComp, placeholderCombo, this.result);
        new Label(container, 0).setText(String.valueOf(Messages.targetFolder) + COLON);
        Combo directoryCombo = new Combo(container, 8);
        directoryCombo.setLayoutData((Object)new GridData(768));
        if (!this.paths.contains("[root]")) {
            directoryCombo.add("[root]");
        }
        for (String path : this.paths) {
            if (path.equals(NO_DATA_STRING)) continue;
            directoryCombo.add(path);
        }
        int index = -1;
        String[] stringArray = directoryCombo.getItems();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            if (item.equals(this.metadataValues.get("folderForSaving"))) {
                index = directoryCombo.indexOf(item);
            }
            ++n2;
        }
        if (index >= 0) {
            directoryCombo.select(index);
        } else {
            directoryCombo.select(0);
        }
        this.metadataValues.put("folderForSaving", directoryCombo.getText());
        new Label(container, 0).setText(String.valueOf(Messages.subFolder) + COLON);
        final Text additionalFolder = new Text(container, 2052);
        additionalFolder.setMessage(Messages.optionalMessage);
        additionalFolder.setLayoutData((Object)new GridData(4, 4, true, false));
        additionalFolder.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                OutputWriterEndpointEditDialog.this.metadataValues.put("folderForSaving", "[root]" + File.separator + ((Text)arg0.getSource()).getText());
            }
        });
        new Label(container, 0).setText("");
        new Label(container, 0).setText(Messages.onlyOneSubfolderMessage);
        new Label(container, 0).setText("");
        Composite placeholderComp2 = new Composite(container, 0);
        GridLayout placeholderComp2Layout = new GridLayout(2, false);
        placeholderComp2Layout.marginWidth = 0;
        placeholderComp2.setLayout((Layout)placeholderComp2Layout);
        placeholderComp2.setLayoutData((Object)new GridData(768));
        final CCombo placeholderCombo2 = OutputWriterGuiUtils.createPlaceholderCombo(placeholderComp2, OutputWriterComponentConstants.WORDLIST_SUBFOLDER);
        final Button insertButton2 = OutputWriterGuiUtils.createPlaceholderInsertButton(placeholderComp2, placeholderCombo2, additionalFolder);
        if (directoryCombo.getSelectionIndex() > 0) {
            additionalFolder.setEnabled(false);
            placeholderCombo2.setEnabled(false);
            insertButton2.setEnabled(false);
        }
        directoryCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                OutputWriterEndpointEditDialog.this.metadataValues.put("folderForSaving", ((Combo)arg0.getSource()).getText());
                additionalFolder.setEnabled(((Combo)arg0.getSource()).getText().equals("[root]"));
                placeholderCombo2.setEnabled(((Combo)arg0.getSource()).getText().equals("[root]"));
                insertButton2.setEnabled(((Combo)arg0.getSource()).getText().equals("[root]"));
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
        additionalFolder.addListener(25, (Listener)new AlphanumericalTextContraintListener(FORBIDDEN_CHARS));
    }

    public Map<String, String> getMetadataValues() {
        Map metaData = super.getMetadataValues();
        if (!this.currentDataType.equals((Object)DataType.DirectoryReference) && !this.currentDataType.equals((Object)DataType.FileReference)) {
            metaData.put("filename", NO_DATA_STRING);
            metaData.put("folderForSaving", NO_DATA_STRING);
        }
        return metaData;
    }

    protected boolean validateMetaDataInputs() {
        List<String> forbiddenFilenames = Arrays.asList(OutputWriterComponentConstants.PROBLEMATICFILENAMES_WIN);
        this.hintLabel.setVisible(!this.comboDataType.getText().equals(DataType.FileReference.getDisplayName()) && !this.comboDataType.getText().equals(DataType.DirectoryReference.getDisplayName()));
        return super.validateMetaDataInputs() && !forbiddenFilenames.contains(this.result.getText().toUpperCase());
    }
}

