/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.doe.gui.properties;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.rcenvironment.components.doe.common.DOEAlgorithms;
import de.rcenvironment.components.doe.common.DOEConstants;
import de.rcenvironment.components.doe.common.DOEUtils;
import de.rcenvironment.components.doe.gui.properties.Messages;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.gui.utils.common.components.PropertyTabGuiHelper;
import de.rcenvironment.core.gui.utils.incubator.NumericalTextConstraintListener;
import de.rcenvironment.core.gui.workflow.editor.properties.ValidatingWorkflowNodePropertySection;
import de.rcenvironment.core.gui.workflow.editor.properties.WorkflowNodePropertySection;
import de.rcenvironment.core.utils.common.JsonUtils;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.exec.OS;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class DOESection
extends ValidatingWorkflowNodePropertySection {
    protected static final Log LOGGER = LogFactory.getLog(DOESection.class);
    private static final String ERROR = "Error";
    private static final String NULL = "null";
    private static final String COULD_NOT_READ_TABLE_ERROR = "Could not read table. ";
    private static final int MAX_GUI_ELEMENTS = OS.isFamilyUnix() ? 2000 : 10000;
    private Combo algorithmSelection;
    private Button loadTable;
    private Button saveTable;
    private Table table;
    private Composite tableComposite;
    private Label runLabel;
    private Spinner runSpinner;
    private Label seedLabel;
    private Spinner seedSpinner;
    private Button codedValuesButton;
    private Text startSample;
    private Text endSample;
    private TableViewer viewer;
    private String[][] tableValues;
    private Label outputsWarningLabel;
    private Button clearTableButton;

    protected void createCompositeContent(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createCompositeContent(parent, aTabbedPropertySheetPage);
        TabbedPropertySheetWidgetFactory factory = aTabbedPropertySheetPage.getWidgetFactory();
        Section sectionProperties = factory.createSection(parent, 320);
        sectionProperties.setText(Messages.sectionHeader);
        sectionProperties.marginWidth = 5;
        sectionProperties.marginHeight = 5;
        Composite mainComposite = new Composite((Composite)sectionProperties, 0);
        mainComposite.setLayout((Layout)new GridLayout(1, false));
        mainComposite.setBackground(Display.getCurrent().getSystemColor(1));
        GridData mainData = new GridData(1808);
        mainComposite.setLayoutData((Object)mainData);
        Composite algorithmComposite = new Composite(mainComposite, 0);
        algorithmComposite.setLayout((Layout)new GridLayout(4, false));
        algorithmComposite.setBackground(Display.getCurrent().getSystemColor(1));
        this.algorithmSelection = new Combo(algorithmComposite, 2056);
        this.algorithmSelection.setItems(DOEConstants.ALGORITMS);
        GridData selectionData = new GridData(1808);
        selectionData.horizontalSpan = 2;
        this.algorithmSelection.setLayoutData((Object)selectionData);
        this.algorithmSelection.setData("property.control", (Object)"method");
        this.algorithmSelection.addSelectionListener((SelectionListener)new AlgorithmSelectionListener());
        this.seedLabel = new Label(algorithmComposite, 0);
        this.seedLabel.setText(Messages.seedLabel);
        this.seedSpinner = new Spinner(algorithmComposite, 2048);
        this.seedSpinner.setMaximum(Integer.MAX_VALUE);
        this.seedSpinner.setData("property.control", (Object)"seedNumber");
        this.seedSpinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                DOESection.this.fillTable();
            }
        });
        Composite runComposite = new Composite(algorithmComposite, 0);
        GridLayout runLayout = new GridLayout(2, false);
        runLayout.marginWidth = 0;
        runComposite.setLayout((Layout)runLayout);
        GridData runData = new GridData();
        runData.horizontalSpan = 4;
        runData.horizontalIndent = 0;
        runComposite.setLayoutData((Object)runData);
        this.runLabel = new Label(runComposite, 0);
        this.runSpinner = new Spinner(runComposite, 2048);
        this.runSpinner.setData("property.control", (Object)"runNumber");
        this.runSpinner.setMaximum(Integer.MAX_VALUE);
        this.runSpinner.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                DOESection.this.fillTable();
                if (DOESection.this.getProperty("method").equals("Custom design table")) {
                    ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
                    try {
                        DOESection.this.setPropertyNotUndoable("table", mapper.writeValueAsString(DOESection.this.viewer.getInput()));
                    }
                    catch (IOException e) {
                        LOGGER.error((Object)e);
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        GridData spinnerData = new GridData();
        this.runSpinner.setLayoutData((Object)spinnerData);
        GridLayout failedrunLayout = new GridLayout(3, false);
        failedrunLayout.marginWidth = 0;
        this.tableComposite = new Composite(mainComposite, 0);
        this.tableComposite.setLayout((Layout)failedrunLayout);
        this.tableComposite.setBackground(Display.getCurrent().getSystemColor(1));
        GridData tableData = new GridData(1808);
        this.tableComposite.setLayoutData((Object)tableData);
        Label startLabel = new Label(this.tableComposite, 0);
        startLabel.setText(Messages.sampleStart);
        this.startSample = new Text(this.tableComposite, 2048);
        GridData startData = new GridData();
        startData.widthHint = 60;
        startData.horizontalSpan = 2;
        this.startSample.addVerifyListener((VerifyListener)new NumericalTextConstraintListener(this.startSample, 6));
        this.startSample.setLayoutData((Object)startData);
        this.startSample.setData("property.control", (Object)"startSample");
        new Label(this.tableComposite, 0).setText(Messages.sampleEnd);
        this.endSample = new Text(this.tableComposite, 2048);
        GridData endData = new GridData();
        endData.widthHint = 60;
        endData.horizontalSpan = 2;
        this.endSample.setLayoutData((Object)endData);
        this.endSample.addVerifyListener((VerifyListener)new NumericalTextConstraintListener(this.endSample, 6));
        this.endSample.setData("property.control", (Object)"endSample");
        this.addTableComposite();
        sectionProperties.setClient((Control)mainComposite);
    }

    private void addTableComposite() {
        Composite buttonsComp = new Composite(this.tableComposite, 0);
        GridLayout tableLayout = new GridLayout(5, false);
        tableLayout.marginWidth = 0;
        buttonsComp.setLayout((Layout)tableLayout);
        GridData buttonsData = new GridData(1808);
        buttonsData.horizontalSpan = 3;
        buttonsComp.setLayoutData((Object)buttonsData);
        this.saveTable = new Button(buttonsComp, 8);
        this.saveTable.setText(Messages.saveTableButton);
        this.saveTable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                DOESection.this.saveTable();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
        this.loadTable = new Button(buttonsComp, 8);
        this.loadTable.setText(Messages.loadTableButton);
        this.loadTable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                DOESection.this.loadTable();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
        GridData loadData = new GridData();
        this.loadTable.setLayoutData((Object)loadData);
        this.clearTableButton = new Button(buttonsComp, 8);
        this.clearTableButton.setText("Clear table");
        this.clearTableButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                DOESection.this.setProperty("table", "");
                DOESection.this.fillTableHeader();
                DOESection.this.fillTable();
                DOESection.this.refreshSection();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
        this.codedValuesButton = new Button(buttonsComp, 32);
        this.codedValuesButton.setText(Messages.codedValuesButton);
        this.codedValuesButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }

            public void widgetSelected(SelectionEvent arg0) {
                DOESection.this.fillTable();
            }
        });
        this.outputsWarningLabel = new Label(buttonsComp, 0);
        this.outputsWarningLabel.setForeground(Display.getCurrent().getSystemColor(3));
        this.viewer = new TableViewer(buttonsComp, 68354);
        int operations = 19;
        Transfer[] transferTypes = new Transfer[]{FileTransfer.getInstance()};
        this.viewer.addDropSupport(operations, transferTypes, (DropTargetListener)new TableDropListener((Viewer)this.viewer));
        this.viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.viewer.setInput((Object)this.tableValues);
        this.table = this.viewer.getTable();
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        GridData data = new GridData(4, 4, true, true);
        data.minimumHeight = 200;
        data.horizontalSpan = 5;
        this.table.setLayoutData((Object)data);
        this.table.setData("property.control", (Object)"table");
    }

    private void saveTable() {
        FileDialog dialog = new FileDialog(this.tableComposite.getShell(), 8192);
        dialog.setFilterExtensions(new String[]{"*.csv", "*.*"});
        String path = dialog.open();
        LinkedList<String> outputs = new LinkedList<String>();
        for (EndpointDescription e : this.getOutputs()) {
            outputs.add(e.getName());
        }
        Collections.sort(outputs);
        DOEUtils.writeTableToCSVFile((Object[][])this.tableValues, (String)path, outputs);
    }

    private void loadTable() {
        String path = PropertyTabGuiHelper.selectFileFromFileSystem((Shell)this.tableComposite.getShell(), (String[])new String[]{"*.csv", "*.*"}, (String)"Open table file...");
        if (path != null) {
            this.loadTableFromFile(path);
        }
    }

    private boolean loadTableFromFile(String path) {
        boolean success;
        block13: {
            success = true;
            try {
                File csvData = new File(path);
                CSVParser parser = CSVParser.parse((String)FileUtils.readFileToString((File)csvData), (CSVFormat)CSVFormat.newFormat((char)';').withIgnoreSurroundingSpaces().withAllowMissingColumnNames().withRecordSeparator("\n"));
                List records = parser.getRecords();
                if (Character.isLetter(((CSVRecord)records.get(0)).get(0).charAt(0))) {
                    records.remove(0);
                }
                String[][] values = new String[records.size()][];
                int count = 0;
                for (CSVRecord record : records) {
                    int size = this.getOutputs().size();
                    values[count] = new String[size];
                    int i = 0;
                    while (i < size) {
                        if (record.size() > i) {
                            String number = record.get(i);
                            if (number.equals(NULL)) {
                                values[count][i] = "";
                            } else {
                                Matcher matcher = Pattern.compile("(\\+|-)?\\d+(,|.)?\\d*(e|E)?(\\+|-)?\\d*").matcher(number);
                                if (count == 0 && i == 0 && matcher.find()) {
                                    number = matcher.group();
                                }
                                values[count][i] = number.replaceAll("\"", " ").replaceAll(",", ".");
                            }
                        } else {
                            values[count][i] = "";
                        }
                        ++i;
                    }
                    ++count;
                }
                ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
                this.setProperty("table", mapper.writeValueAsString((Object)values));
                this.setProperty("startSample", "0");
                this.setProperty("endSample", Integer.toString(count - 1));
                this.setProperty("runNumber", Integer.toString(count));
                this.setProperty("method", "Custom design table");
                this.algorithmSelection.select(this.algorithmSelection.indexOf("Custom design table"));
                this.refreshSection();
                if (values[0] != null && values[0].length > this.getOutputs().size()) {
                    MessageDialog.openInformation((Shell)this.getComposite().getShell(), (String)"Warning", (String)"There are more values per run in the loaded table than outputs defined.");
                }
            }
            catch (IOException e) {
                LOGGER.error((Object)e);
                success = false;
                if (!success) {
                    MessageDialog.openInformation((Shell)this.getComposite().getShell(), (String)ERROR, (String)("Could not load table from file.\n\nReason: " + e.getMessage()));
                }
            }
            catch (NumberFormatException e) {
                LOGGER.error((Object)e);
                success = false;
                if (success) break block13;
                MessageDialog.openInformation((Shell)this.getComposite().getShell(), (String)ERROR, (String)("Could not load table because of a syntax error.\n\nReason: " + e.getMessage()));
            }
        }
        return success;
    }

    private void fillTableHeader() {
        if (this.getOutputs() != null) {
            Object[] titles = new String[this.getOutputs().size()];
            int j = 0;
            for (EndpointDescription e : this.getOutputs()) {
                titles[j++] = e.getName();
            }
            Arrays.sort(titles);
            this.table.setRedraw(false);
            while (this.table.getColumnCount() > 0) {
                this.table.getColumns()[0].dispose();
            }
            int i = 0;
            while (i < titles.length + 1) {
                TableViewerColumn column = new TableViewerColumn(this.viewer, 0);
                if (i == 0) {
                    column.getColumn().setText(Messages.sampleNum);
                } else {
                    column.getColumn().setText((String)titles[i - 1]);
                }
                final int k = i;
                column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                    public String getText(Object element) {
                        String returnValue = "";
                        if (DOESection.this.tableValues != null) {
                            if (k == 0) {
                                int i = 0;
                                while (i < DOESection.this.tableValues.length) {
                                    if (DOESection.this.tableValues[i] == (String[])element) {
                                        returnValue = String.valueOf(i);
                                    }
                                    ++i;
                                }
                            } else if (k - 1 < ((String[])element).length) {
                                returnValue = String.valueOf(((String[])element)[k - 1]);
                            }
                        }
                        if (returnValue == null || returnValue.equals(DOESection.NULL)) {
                            returnValue = "";
                        }
                        return returnValue;
                    }
                });
                this.table.getColumn(i).pack();
                if (i != 0) {
                    column.setEditingSupport((EditingSupport)new TextEditingSupport((ColumnViewer)this.viewer, this.table, i));
                }
                ++i;
            }
            i = 0;
            while (i < titles.length) {
                this.table.getColumn(i).pack();
                ++i;
            }
            this.table.setRedraw(true);
        }
    }

    public void refreshSection() {
        super.refreshSection();
        this.aboutToBeShown();
    }

    public void aboutToBeShown() {
        super.aboutToBeShown();
        this.fillTableHeader();
        this.algorithmSelection.setText(this.getProperty("method"));
        this.fillTable();
        this.updateActivation();
        if (this.startSample.getText() != null && !this.startSample.getText().isEmpty() && this.getProperty("startSample") != null && !this.startSample.getText().equals(this.getProperty("startSample"))) {
            this.startSample.setText(this.getProperty("startSample"));
        }
        if (this.endSample.getText() != null && !this.endSample.getText().isEmpty() && this.getProperty("endSample") != null && !this.endSample.getText().equals(this.getProperty("endSample"))) {
            this.endSample.setText(this.getProperty("endSample"));
        }
    }

    protected void beforeTearingDownModelBinding() {
        super.beforeTearingDownModelBinding();
        this.outputsWarningLabel.setText("");
    }

    public void fillTable() {
        this.table.setRedraw(false);
        this.table.clearAll();
        if (this.getOutputs() == null) {
            this.table.setRedraw(true);
            return;
        }
        int varCount = this.getOutputs().size();
        if (!(varCount >= 2 || this.algorithmSelection.getText().equals("Custom design table") || this.algorithmSelection.getText().equals("Custom design table as input") || this.algorithmSelection.getText().equals("Monte Carlo design"))) {
            this.table.setRedraw(true);
            return;
        }
        this.tableValues = this.createTableValues();
        if (this.tableValues != null && this.tableValues.length * varCount <= MAX_GUI_ELEMENTS) {
            this.viewer.setInput((Object)this.tableValues);
            Object[] endpointNames = new String[this.getOutputs().size()];
            int j = 0;
            for (EndpointDescription e : this.getOutputs()) {
                endpointNames[j++] = e.getName();
            }
            Arrays.sort(endpointNames);
            int i = 0;
            while (i < this.tableValues.length) {
                TableItem current = null;
                current = this.table.getItemCount() == 0 || this.table.getItemCount() <= i ? new TableItem(this.table, 0) : this.table.getItem(i);
                current.setText(0, String.valueOf(i));
                int k = 0;
                while (k < this.tableValues[i].length) {
                    if (!this.getProperty("method").equals("Custom design table") && this.codedValuesButton.getSelection()) {
                        EndpointDescription currentEndpoint = null;
                        for (EndpointDescription e : this.getOutputs()) {
                            if (!e.getName().equals(endpointNames[k])) continue;
                            currentEndpoint = e;
                        }
                        if (currentEndpoint != null && this.tableValues != null && this.tableValues[i] != null && this.tableValues[i][k] != null) {
                            Double low = Double.valueOf(currentEndpoint.getMetaDataValue("lower"));
                            Double up = Double.valueOf(currentEndpoint.getMetaDataValue("upper"));
                            this.tableValues[i][k] = String.valueOf(DOEAlgorithms.convertValue((Double)low, (Double)up, (Double)Double.parseDouble(this.tableValues[i][k])));
                        }
                    }
                    ++k;
                }
                ++i;
            }
            this.viewer.refresh();
            TableColumn[] tableColumnArray = this.table.getColumns();
            int n = tableColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumn c = tableColumnArray[n2];
                c.pack();
                ++n2;
            }
        } else if (this.outputsWarningLabel != null && this.tableValues != null && this.tableValues.length * varCount > MAX_GUI_ELEMENTS) {
            this.outputsWarningLabel.setVisible(true);
            this.outputsWarningLabel.setText(Messages.tooMuchElements);
            this.outputsWarningLabel.pack();
        }
        this.table.setRedraw(true);
    }

    private String[][] createTableValues() {
        int varCount = this.getOutputs().size();
        String algorithm = this.algorithmSelection.getText();
        if (varCount == 0 && !algorithm.equals("Custom design table as input")) {
            return null;
        }
        int runCount = 0;
        if (this.runSpinner != null) {
            runCount = this.runSpinner.getSelection();
        }
        int seedCount = 0;
        if (this.seedSpinner != null) {
            seedCount = this.seedSpinner.getSelection();
        }
        Double[][] tableValuesDouble = null;
        switch (algorithm) {
            case "Full factorial design": {
                if (this.runSpinner.getSelection() < 2) break;
                tableValuesDouble = DOEAlgorithms.populateTableFullFactorial((int)varCount, (int)runCount);
                break;
            }
            case "Latin hypercube design": {
                tableValuesDouble = DOEAlgorithms.populateTableLatinHypercube((int)varCount, (int)runCount, (int)seedCount);
                break;
            }
            case "Monte Carlo design": {
                tableValuesDouble = DOEAlgorithms.populateTableMonteCarlo((int)varCount, (int)runCount, (int)seedCount);
                break;
            }
            case "Custom design table": {
                ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
                try {
                    String startSampleString;
                    String endSampleString;
                    if (this.getProperty("table") != null && !this.getProperty("table").isEmpty()) {
                        tableValuesDouble = (Double[][])mapper.readValue(this.getProperty("table"), Double[][].class);
                    }
                    if (tableValuesDouble != null && tableValuesDouble.length > 0 && runCount != tableValuesDouble.length) {
                        tableValuesDouble = (Double[][])Arrays.copyOf(tableValuesDouble, runCount);
                    }
                    if ((endSampleString = this.getProperty("endSample")) != null && !endSampleString.isEmpty() && runCount > 0 && Integer.parseInt(endSampleString) >= runCount) {
                        this.setProperty("endSample", String.valueOf(runCount - 1));
                    }
                    if ((startSampleString = this.getProperty("startSample")) == null || startSampleString.isEmpty()) break;
                    if (endSampleString != null && !endSampleString.isEmpty() && Integer.parseInt(startSampleString) > Integer.parseInt(endSampleString)) {
                        this.setProperty("startSample", endSampleString);
                        break;
                    }
                    if (Integer.parseInt(startSampleString) < runCount || runCount == 0) break;
                    this.setProperty("startSample", String.valueOf(runCount - 1));
                }
                catch (IOException e) {
                    LOGGER.error((Object)COULD_NOT_READ_TABLE_ERROR, (Throwable)e);
                }
                break;
            }
            case "Custom design table as input": {
                if (!this.node.getInputDescriptionsManager().isValidEndpointName("Custom table")) break;
                HashMap metaData = new HashMap();
                this.node.getInputDescriptionsManager().addDynamicEndpointDescription("startTable", "Custom table", DataType.Matrix, metaData);
                break;
            }
        }
        if (!algorithm.equals("Custom design table as input") && !this.node.getInputDescriptionsManager().isValidEndpointName("Custom table")) {
            this.node.getInputDescriptionsManager().removeDynamicEndpointDescription("Custom table");
        }
        if (tableValuesDouble != null && tableValuesDouble.length > 0) {
            String[][] returnValues = new String[tableValuesDouble.length][tableValuesDouble[0].length];
            int i = 0;
            while (i < tableValuesDouble.length) {
                if (tableValuesDouble[i] != null) {
                    returnValues[i] = new String[tableValuesDouble[i].length];
                    int j = 0;
                    while (j < tableValuesDouble[i].length) {
                        returnValues[i][j] = String.valueOf(tableValuesDouble[i][j]);
                        ++j;
                    }
                } else {
                    returnValues[i] = new String[varCount];
                    Arrays.fill(returnValues[i], "");
                }
                ++i;
            }
            this.tableValues = returnValues;
            return returnValues;
        }
        this.tableValues = !"Custom design table".equals(algorithm) ? new String[0][varCount] : new String[runCount][varCount];
        return this.tableValues;
    }

    private void updateActivation() {
        boolean isCustomDesignTable = this.algorithmSelection.getText().equals("Custom design table");
        this.loadTable.setEnabled(isCustomDesignTable);
        this.clearTableButton.setEnabled(isCustomDesignTable);
        this.startSample.setEnabled(isCustomDesignTable);
        this.endSample.setEnabled(isCustomDesignTable);
        this.runLabel.setEnabled(true);
        this.runSpinner.setEnabled(true);
        this.seedSpinner.setEnabled(false);
        this.seedLabel.setEnabled(false);
        this.codedValuesButton.setEnabled(true);
        this.table.setEnabled(true);
        this.saveTable.setEnabled(true);
        this.outputsWarningLabel.setText("");
        this.outputsWarningLabel.setVisible(false);
        if (this.algorithmSelection.getText().equals("Custom design table as input")) {
            this.activateGUIElements(false);
        } else if (this.algorithmSelection.getText().equals("Full factorial design")) {
            this.runLabel.setText(Messages.numLevelsLabel);
        } else if (this.algorithmSelection.getText().equals("Latin hypercube design") || this.algorithmSelection.getText().equals("Monte Carlo design")) {
            this.runLabel.setText(Messages.desiredRunsLabel);
            this.seedSpinner.setEnabled(true);
            this.seedLabel.setEnabled(true);
        } else {
            this.runLabel.setText(Messages.desiredRunsLabel);
            this.runLabel.setEnabled(true);
            this.runSpinner.setEnabled(true);
            this.codedValuesButton.setEnabled(false);
        }
        if (this.getOutputs().isEmpty() && !this.algorithmSelection.getText().equals("Full factorial design") && !this.algorithmSelection.getText().equals("Latin hypercube design")) {
            this.outputsWarningLabel.setVisible(true);
            this.outputsWarningLabel.setText(Messages.minOneOutput);
            this.activateGUIElements(false);
        } else if (this.getOutputs().size() < 2 && (this.algorithmSelection.getText().equals("Full factorial design") || this.algorithmSelection.getText().equals("Latin hypercube design"))) {
            this.outputsWarningLabel.setVisible(true);
            this.outputsWarningLabel.setText(Messages.minTwoOutputs);
            this.activateGUIElements(false);
        } else if (this.algorithmSelection.getText().equals("Custom design table")) {
            if (this.getProperty("table") == null || this.getProperty("table").isEmpty()) {
                this.outputsWarningLabel.setVisible(true);
                this.outputsWarningLabel.setText(Messages.noTableLong);
            } else if (this.getProperty("table") != null) {
                ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
                try {
                    Double[][] tableValuesDouble = (Double[][])mapper.readValue(this.getProperty("table"), Double[][].class);
                    int runNumber = Integer.parseInt(this.getProperty("runNumber"));
                    int i = 0;
                    while (i <= runNumber && tableValuesDouble != null && i < tableValuesDouble.length) {
                        int j = 0;
                        while (j < tableValuesDouble[i].length) {
                            if (tableValuesDouble[i][j] == null) {
                                this.outputsWarningLabel.setVisible(true);
                                this.outputsWarningLabel.setText(Messages.noTableLong);
                            }
                            ++j;
                        }
                        if (!this.outputsWarningLabel.isVisible()) {
                            ++i;
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException e) {
                    this.logger.error((Object)e.getStackTrace());
                }
            }
        }
        if (!(this.outputsWarningLabel == null || this.outputsWarningLabel.isVisible() || this.tableValues == null || this.tableValues.length == 0 || this.tableValues.length * this.getOutputs().size() <= MAX_GUI_ELEMENTS && this.tableValues.length != 0 || this.algorithmSelection.getText().equals("Custom design table as input"))) {
            this.outputsWarningLabel.setVisible(true);
            this.outputsWarningLabel.setText(Messages.tooMuchElements);
        }
        if (this.outputsWarningLabel.getText().isEmpty()) {
            this.outputsWarningLabel.setVisible(false);
        }
        this.outputsWarningLabel.pack();
        this.runLabel.getParent().pack();
    }

    private void activateGUIElements(boolean enabled) {
        this.saveTable.setEnabled(enabled);
        this.table.setEnabled(enabled);
        this.loadTable.setEnabled(enabled);
        this.clearTableButton.setEnabled(enabled);
        this.codedValuesButton.setEnabled(enabled);
        this.startSample.setEnabled(enabled);
        this.endSample.setEnabled(enabled);
        this.runSpinner.setEnabled(enabled);
        this.seedSpinner.setEnabled(enabled);
        this.table.clearAll();
        this.table.redraw();
    }

    protected Set<EndpointDescription> getOutputs() {
        HashSet<EndpointDescription> outputs = new HashSet<EndpointDescription>(super.getOutputs());
        Iterator outputsIterator = outputs.iterator();
        while (outputsIterator.hasNext()) {
            EndpointDescription next = (EndpointDescription)outputsIterator.next();
            if (!"toForward".equals(next.getDynamicEndpointIdentifier()) && !"Done".equals(next.getName()) && !"Number of samples".equals(next.getName())) continue;
            outputsIterator.remove();
        }
        return outputs;
    }

    protected DOESectionUpdater createUpdater() {
        return new DOESectionUpdater();
    }

    private class AlgorithmSelectionListener
    implements SelectionListener {
        private AlgorithmSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent arg0) {
            this.widgetSelected(arg0);
        }

        public void widgetSelected(SelectionEvent arg0) {
            if (DOESection.this.algorithmSelection.getText().equals("Full factorial design") && DOESection.this.runSpinner.getSelection() < 2) {
                DOESection.this.setProperties("method", DOESection.this.algorithmSelection.getText(), "runNumber", "2");
            } else {
                DOESection.this.setProperty("method", DOESection.this.algorithmSelection.getText());
            }
            DOESection.this.refreshSection();
        }
    }

    protected class DOESectionUpdater
    extends WorkflowNodePropertySection.DefaultUpdater {
        protected DOESectionUpdater() {
            super((WorkflowNodePropertySection)DOESection.this);
        }

        public void updateControl(Control control, String propertyName, String newValue, String oldValue) {
            super.updateControl(control, propertyName, newValue, oldValue);
            DOESection.this.aboutToBeShown();
        }
    }

    public class TableDropListener
    extends ViewerDropAdapter {
        protected TableDropListener(Viewer viewer) {
            super(viewer);
        }

        public void drop(DropTargetEvent event) {
            super.drop(event);
        }

        public boolean performDrop(Object arg0) {
            String[] fileDrops = (String[])arg0;
            if (fileDrops.length != 1 || !fileDrops[0].endsWith(".csv")) {
                return false;
            }
            String fileLocation = fileDrops[0];
            boolean success = DOESection.this.loadTableFromFile(fileLocation);
            if (success) {
                DOESection.this.algorithmSelection.select(DOESection.this.algorithmSelection.indexOf("Custom design table"));
                DOESection.this.setProperty("method", "Custom design table");
                DOESection.this.updateActivation();
                DOESection.this.fillTable();
            }
            return true;
        }

        public boolean validateDrop(Object arg0, int arg1, TransferData arg2) {
            return true;
        }
    }

    private class TextEditingSupport
    extends EditingSupport {
        private final TextCellEditor editor;
        private final int columnNumber;
        private final ColumnViewer viewer;

        TextEditingSupport(ColumnViewer viewer, Table table, int columnNumber) {
            super(viewer);
            this.editor = new TextCellEditor((Composite)table);
            this.editor.setValidator(new ICellEditorValidator(){

                public String isValid(Object arg0) {
                    try {
                        Double.parseDouble((String)arg0);
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (((String)arg0).isEmpty()) {
                            return null;
                        }
                        return "No";
                    }
                    return null;
                }
            });
            this.columnNumber = columnNumber;
            this.viewer = viewer;
        }

        protected boolean canEdit(Object arg0) {
            return DOESection.this.getProperty("method").equals("Custom design table");
        }

        protected CellEditor getCellEditor(Object arg0) {
            return this.editor;
        }

        protected Object getValue(Object arg0) {
            String returnValue = ((String[])arg0)[this.columnNumber - 1];
            if (returnValue == null || returnValue.equals(DOESection.NULL)) {
                returnValue = "";
            }
            return returnValue;
        }

        protected void setValue(Object arg0, Object arg1) {
            ((String[])arg0)[this.columnNumber - 1] = (String)arg1;
            ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
            String[][] eliminateNull = (String[][])this.viewer.getInput();
            int i = 0;
            while (i < eliminateNull.length) {
                int j = 0;
                while (j < eliminateNull[i].length) {
                    if (eliminateNull[i][j] == null || eliminateNull[i][j].equals(DOESection.NULL)) {
                        eliminateNull[i][j] = "";
                    }
                    ++j;
                }
                ++i;
            }
            try {
                DOESection.this.setProperty("table", mapper.writeValueAsString(this.viewer.getInput()));
            }
            catch (IOException e) {
                LOGGER.error((Object)e);
            }
            this.viewer.refresh();
            DOESection.this.refreshSection();
        }
    }
}

