/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import com.sun.media.jai.codec.FileSeekableStream;
import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageDecoder;
import com.sun.media.jai.codec.SeekableStream;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.media.jai.InterpolationBicubic;
import javax.media.jai.JAI;
import javax.media.jai.NullOpImage;
import org.jpedal.io.ColorSpaceConvertor;

public class JAITiffHelper {
    private ImageDecoder dec;
    private int pageCount = 0;

    public JAITiffHelper(String string) {
        try {
            File file = new File(string);
            FileSeekableStream fileSeekableStream = new FileSeekableStream(file);
            this.dec = ImageCodec.createImageDecoder((String)"tiff", (SeekableStream)fileSeekableStream, null);
            this.pageCount = this.dec.getNumPages();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public int getTiffPageCount() {
        return this.pageCount;
    }

    public BufferedImage getImage(int n) {
        BufferedImage bufferedImage = null;
        try {
            NullOpImage nullOpImage = new NullOpImage(this.dec.decodeAsRenderedImage(n), null, null, 2);
            bufferedImage = JAI.create((String)"affine", (RenderedImage)nullOpImage, null, (Object)new InterpolationBicubic(1)).getAsBufferedImage();
            bufferedImage = ColorSpaceConvertor.convertColorspace(bufferedImage, 10);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return bufferedImage;
    }
}

