/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.reconcile.validator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilableModel;
import org.eclipse.jface.text.reconciler.IReconcileResult;
import org.eclipse.jface.text.reconciler.IReconcileStep;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.sse.ui.internal.IReleasable;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.reconcile.DocumentAdapter;
import org.eclipse.wst.sse.ui.internal.reconcile.StructuredTextReconcilingStrategy;
import org.eclipse.wst.sse.ui.internal.reconcile.TemporaryAnnotation;
import org.eclipse.wst.sse.ui.internal.reconcile.validator.ReconcileStepForValidator;
import org.eclipse.wst.sse.ui.internal.reconcile.validator.ValidatorMetaData;
import org.eclipse.wst.validation.ValidationFramework;
import org.eclipse.wst.validation.Validator;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;

public class ValidatorStrategy
extends StructuredTextReconcilingStrategy {
    private static final boolean DEBUG_VALIDATION_CAPABLE_BUT_DISABLED = Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.wst.sse.ui/debug/reconcilerValidatorEnablement"));
    private static final boolean DEBUG_VALIDATION_UNSUPPORTED = Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.wst.sse.ui/debug/reconcilerValidatorSupported"));
    private static final Object NO_FILE = new Object();
    private String[] fContentTypeIds = null;
    private List fMetaData = null;
    private HashMap fVidToVStepMap = null;
    private List fTotalScopeValidatorsAlreadyRun = new ArrayList();
    private boolean fValidatorsSuspended = false;
    private Object fFile;
    private boolean fIsCancelled = false;

    public ValidatorStrategy(ISourceViewer sourceViewer, String contentType) {
        super(sourceViewer);
        this.fMetaData = new ArrayList();
        this.fContentTypeIds = this.calculateParentContentTypeIds(contentType);
        this.fVidToVStepMap = new HashMap();
    }

    public void addValidatorMetaData(ValidatorMetaData vmd) {
        this.fMetaData.add(vmd);
    }

    public void beginProcessing() {
        this.fTotalScopeValidatorsAlreadyRun.clear();
    }

    private String[] calculateParentContentTypeIds(String contentTypeId) {
        HashSet<String> parentTypes = new HashSet<String>();
        IContentTypeManager ctManager = Platform.getContentTypeManager();
        IContentType ct = ctManager.getContentType(contentTypeId);
        String id = contentTypeId;
        while (ct != null && id != null) {
            parentTypes.add(id);
            ct = ctManager.getContentType(id);
            if (ct == null) continue;
            IContentType baseType = ct.getBaseType();
            String string = id = baseType != null ? baseType.getId() : null;
        }
        return parentTypes.toArray(new String[parentTypes.size()]);
    }

    @Override
    protected boolean canHandlePartition(String partitionType) {
        ValidatorMetaData vmd = null;
        int i = 0;
        while (i < this.fMetaData.size()) {
            vmd = (ValidatorMetaData)this.fMetaData.get(i);
            if (vmd.canHandlePartitionType(this.getContentTypeIds(), partitionType)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    protected boolean containsStep(IReconcileStep step) {
        return this.fVidToVStepMap.containsValue(step);
    }

    @Override
    public void createReconcileSteps() {
    }

    public void endProcessing() {
        this.fTotalScopeValidatorsAlreadyRun.clear();
    }

    public String[] getContentTypeIds() {
        return this.fContentTypeIds;
    }

    public void reconcile(ITypedRegion tr, DirtyRegion dr) {
        if (this.isCanceled() || this.fMetaData.isEmpty() || this.fValidatorsSuspended) {
            return;
        }
        IDocument doc = this.getDocument();
        if (doc == null) {
            return;
        }
        String partitionType = tr.getType();
        ValidatorMetaData vmd = null;
        ArrayList<IReconcileResult> annotationsToAdd = new ArrayList<IReconcileResult>();
        ArrayList<ReconcileStepForValidator> stepsRanOnThisDirtyRegion = new ArrayList<ReconcileStepForValidator>(1);
        HashSet<String> disabledValsBySourceId = new HashSet<String>(20);
        HashSet<String> disabledValsByClass = new HashSet<String>(20);
        IFile file = this.getFile();
        if (file != null) {
            if (!file.isAccessible()) {
                return;
            }
            Set disabledValidators = null;
            try {
                disabledValidators = ValidationFramework.getDefault().getDisabledValidatorsFor((IResource)file);
            }
            catch (Exception e) {
                Logger.logException(e);
            }
            if (disabledValidators != null) {
                for (Validator v : disabledValidators) {
                    Validator.V1 v1 = null;
                    try {
                        v1 = v.asV1Validator();
                    }
                    catch (Exception e) {
                        Logger.logException(e);
                    }
                    if (v1 != null) {
                        disabledValsByClass.add(v1.getId());
                        continue;
                    }
                    if (v.getSourceId() == null) continue;
                    String[] sourceIDs = StringUtils.unpack((String)v.getSourceId());
                    disabledValsBySourceId.addAll(Arrays.asList(sourceIDs));
                }
            }
        }
        int i = 0;
        while (i < this.fMetaData.size() && !this.isCanceled()) {
            vmd = (ValidatorMetaData)this.fMetaData.get(i);
            if (vmd.canHandlePartitionType(this.getContentTypeIds(), partitionType)) {
                if (!disabledValsBySourceId.contains(vmd.getValidatorId()) && !disabledValsByClass.contains(vmd.getValidatorClass())) {
                    if (DEBUG_VALIDATION_UNSUPPORTED) {
                        Logger.log(1, "Source validator " + vmd.getValidatorId() + " handling (content types:[" + StringUtils.pack((String[])this.getContentTypeIds()) + "] partition type:" + partitionType);
                    }
                    int validatorScope = vmd.getValidatorScope();
                    ReconcileStepForValidator validatorStep = null;
                    Object o = this.fVidToVStepMap.get(vmd.getValidatorId());
                    if (o != null) {
                        validatorStep = (ReconcileStepForValidator)o;
                    } else {
                        IValidator validator = vmd.createValidator();
                        validatorStep = new ReconcileStepForValidator(validator, validatorScope);
                        validatorStep.setInputModel(new DocumentAdapter(doc));
                        this.fVidToVStepMap.put(vmd.getValidatorId(), validatorStep);
                    }
                    if (!this.fTotalScopeValidatorsAlreadyRun.contains(vmd) && !this.fIsCancelled) {
                        annotationsToAdd.addAll(Arrays.asList(validatorStep.reconcile(dr, (IRegion)dr)));
                        stepsRanOnThisDirtyRegion.add(validatorStep);
                        if (validatorScope == 0) {
                            this.fTotalScopeValidatorsAlreadyRun.add(vmd);
                        }
                    }
                } else if (DEBUG_VALIDATION_CAPABLE_BUT_DISABLED) {
                    String message = "Source validator able (id:" + vmd.getValidatorId() + " class:" + vmd.getValidatorClass() + " but skipped because it was reported as disabled";
                    Logger.log(1, message);
                }
            } else if (DEBUG_VALIDATION_UNSUPPORTED) {
                Logger.log(1, "Source validator " + vmd.getValidatorId() + " can not handle (content types:[" + StringUtils.pack((String[])this.getContentTypeIds()) + "] partition type:" + partitionType);
            }
            ++i;
        }
        TemporaryAnnotation[] annotationsToRemove = this.getAnnotationsToRemove(dr, stepsRanOnThisDirtyRegion);
        if (annotationsToRemove.length + annotationsToAdd.size() > 0 && !this.fIsCancelled) {
            this.smartProcess(annotationsToRemove, annotationsToAdd.toArray(new IReconcileResult[annotationsToAdd.size()]));
        }
    }

    @Override
    public void release() {
        super.release();
        this.fIsCancelled = true;
        Iterator it = this.fVidToVStepMap.values().iterator();
        IReconcileStep step = null;
        while (it.hasNext()) {
            step = (IReconcileStep)it.next();
            if (!(step instanceof IReleasable)) continue;
            ((IReleasable)step).release();
        }
        this.fFile = null;
    }

    @Override
    public void setDocument(IDocument document) {
        super.setDocument(document);
        this.fFile = null;
        try {
            IFile file;
            this.fValidatorsSuspended = false;
            if (document != null && (file = this.getFile()) != null) {
                this.fValidatorsSuspended = !file.isAccessible() || ValidationFramework.getDefault().isSuspended(file.getProject()) || ValidationFramework.getDefault().getProjectSettings(file.getProject()).getSuspend();
            }
        }
        catch (Exception e) {
            this.fValidatorsSuspended = true;
            Logger.logException(e);
        }
        Iterator it = this.fVidToVStepMap.values().iterator();
        IReconcileStep step = null;
        while (it.hasNext()) {
            step = (IReconcileStep)it.next();
            step.setInputModel((IReconcilableModel)new DocumentAdapter(document));
        }
    }

    private IFile getFile() {
        if (this.fFile == null) {
            IFile file;
            IPath path;
            this.fFile = NO_FILE;
            ITextFileBuffer buffer = FileBuffers.getTextFileBufferManager().getTextFileBuffer(this.getDocument());
            if (buffer != null && buffer.getLocation() != null && (path = buffer.getLocation()).segmentCount() > 1 && (file = ResourcesPlugin.getWorkspace().getRoot().getFile(path)).isAccessible()) {
                this.fFile = file;
            }
        }
        if (this.fFile != NO_FILE) {
            return (IFile)this.fFile;
        }
        return null;
    }
}

