/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.pattern.EmptySequenceTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.Converter;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.PlainType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.StringConverter;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;

public final class AtomicSequenceConverter
extends UnaryExpression {
    public static ToStringMappingFunction TO_STRING_MAPPER = new ToStringMappingFunction();
    private PlainType requiredItemType;
    private Converter converter;
    private boolean allConverted;

    public AtomicSequenceConverter(Expression sequence, PlainType requiredItemType, boolean allConverted) {
        super(sequence);
        this.requiredItemType = requiredItemType;
        this.allConverted = allConverted;
    }

    public static AtomicSequenceConverter makeUntypedSequenceConverter(Configuration config, Expression operand, PlainType requiredItemType) {
        TypeHierarchy th = config.getTypeHierarchy();
        AtomicSequenceConverter atomicSeqConverter = new AtomicSequenceConverter(operand, requiredItemType, operand.getItemType(th) == BuiltInAtomicType.UNTYPED_ATOMIC);
        ConversionRules rules = config.getConversionRules();
        Converter untypedConverter = requiredItemType.isAtomicType() ? rules.getConverter(BuiltInAtomicType.UNTYPED_ATOMIC, (AtomicType)requiredItemType) : new StringConverter.StringToUnionConverter(requiredItemType, rules);
        UntypedConverter converter = new UntypedConverter(rules, untypedConverter);
        atomicSeqConverter.setConverter(converter);
        return atomicSeqConverter;
    }

    public static AtomicSequenceConverter makeUntypedSequenceRejector(Configuration config, final Expression operand, final PlainType requiredItemType) {
        TypeHierarchy th = config.getTypeHierarchy();
        AtomicSequenceConverter atomicSeqConverter = new AtomicSequenceConverter(operand, requiredItemType, operand.getItemType(th) == BuiltInAtomicType.UNTYPED_ATOMIC);
        ConversionRules rules = config.getConversionRules();
        Converter untypedConverter = new Converter(){

            public ConversionResult convert(AtomicValue input) {
                ValidationFailure vf = new ValidationFailure("Implicit conversion of untypedAtomic value to " + requiredItemType.toString() + " is not allowed");
                vf.setErrorCode("XPTY0117");
                vf.setLocator(operand);
                return vf;
            }
        };
        UntypedConverter converter = new UntypedConverter(rules, untypedConverter);
        atomicSeqConverter.setConverter(converter);
        return atomicSeqConverter;
    }

    public void allocateConverter(Configuration config) {
        ItemType sourceType = this.operand.getItemType(config.getTypeHierarchy());
        final ConversionRules rules = config.getConversionRules();
        if (sourceType instanceof EmptySequenceTest) {
            this.converter = Converter.IDENTITY_CONVERTER;
        } else if (!(sourceType instanceof AtomicType)) {
            this.converter = null;
        } else if (this.requiredItemType instanceof AtomicType) {
            this.converter = rules.getConverter((AtomicType)sourceType, (AtomicType)this.requiredItemType);
        } else if (((SimpleType)((Object)this.requiredItemType)).isUnionType()) {
            this.converter = new StringConverter.StringToUnionConverter(this.requiredItemType, rules);
        }
        if (this.converter == null) {
            this.converter = new Converter(rules){

                public ConversionResult convert(AtomicValue input) {
                    Converter converter = rules.getConverter(input.getPrimitiveType(), (AtomicType)AtomicSequenceConverter.this.requiredItemType);
                    if (converter == null) {
                        return new ValidationFailure("Cannot convert value from " + input.getPrimitiveType() + " to " + AtomicSequenceConverter.this.requiredItemType);
                    }
                    return converter.convert(input);
                }
            };
        }
    }

    public Converter getConverter() {
        return this.converter;
    }

    public void setConverter(Converter converter) {
        this.converter = converter;
    }

    public boolean isAllItemsConverted() {
        return this.allConverted;
    }

    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.operand = visitor.simplify(this.operand);
        if (this.operand instanceof Literal && this.requiredItemType instanceof AtomicType) {
            if (Literal.isEmptySequence(this.operand)) {
                return new Literal(EmptySequence.getInstance());
            }
            Configuration config = visitor.getConfiguration();
            AtomicType sourceType = (AtomicType)this.operand.getItemType(config.getTypeHierarchy());
            this.converter = config.getConversionRules().getConverter(sourceType, (AtomicType)this.requiredItemType);
            ValueRepresentation val = SequenceExtent.makeSequenceExtent(this.iterate(visitor.getStaticContext().makeEarlyEvaluationContext()));
            return Literal.makeLiteral(Value.asValue(val));
        }
        return this;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        this.operand = visitor.typeCheck(this.operand, contextItemType);
        Configuration config = visitor.getConfiguration();
        TypeHierarchy th = config.getTypeHierarchy();
        if (th.isSubType(this.operand.getItemType(th), this.requiredItemType)) {
            return this.operand;
        }
        if (this.converter == null) {
            this.allocateConverter(config);
        }
        return this;
    }

    public Expression optimize(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        Expression e = super.optimize(visitor, contextItemType);
        if (e != this) {
            return e;
        }
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        if (this.operand instanceof AtomicSequenceConverter) {
            AtomicSequenceConverter asc = (AtomicSequenceConverter)this.operand;
            ItemType ascType = asc.getItemType(th);
            if (ascType == this.requiredItemType) {
                return this.operand;
            }
            if (!(this.requiredItemType != BuiltInAtomicType.STRING && this.requiredItemType != BuiltInAtomicType.UNTYPED_ATOMIC || ascType != BuiltInAtomicType.STRING && ascType != BuiltInAtomicType.UNTYPED_ATOMIC)) {
                AtomicSequenceConverter old = (AtomicSequenceConverter)this.operand;
                AtomicSequenceConverter asc2 = new AtomicSequenceConverter(old.getBaseExpression(), this.requiredItemType, old.isAllItemsConverted());
                return asc2.typeCheck(visitor, contextItemType).optimize(visitor, contextItemType);
            }
        }
        return this;
    }

    public int computeSpecialProperties() {
        int p = super.computeSpecialProperties() | 0x400000;
        if (this.converter instanceof UntypedConverter) {
            return p | 0x2000000;
        }
        return p;
    }

    public Expression copy() {
        AtomicSequenceConverter atomicConverter = new AtomicSequenceConverter(this.getBaseExpression().copy(), this.requiredItemType, this.allConverted);
        atomicConverter.setConverter(this.converter);
        return atomicConverter;
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        SequenceIterator<? extends Item> base = this.operand.iterate(context);
        if (this.converter == Converter.TO_STRING) {
            return new ItemMappingIterator<Item, StringValue>(base, TO_STRING_MAPPER, true);
        }
        AtomicSequenceMappingFunction mapper = new AtomicSequenceMappingFunction();
        mapper.setConverter(this.converter);
        return new ItemMappingIterator<AtomicValue, AtomicValue>(base, mapper, true);
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        Item item = this.operand.evaluateItem(context);
        if (item == null) {
            return null;
        }
        return this.converter.convert((AtomicValue)item).asAtomic();
    }

    public ItemType getItemType(TypeHierarchy th) {
        if (this.allConverted) {
            return this.requiredItemType;
        }
        return Type.getCommonSuperType(this.requiredItemType, this.operand.getItemType(th), th);
    }

    public int computeCardinality() {
        return this.operand.getCardinality();
    }

    public boolean equals(Object other) {
        return super.equals(other) && this.requiredItemType.equals(((AtomicSequenceConverter)other).requiredItemType);
    }

    public int hashCode() {
        return super.hashCode() ^ this.requiredItemType.hashCode();
    }

    public void explain(ExpressionPresenter destination) {
        destination.startElement("convertItems");
        destination.emitAttribute("to", this.requiredItemType.toString(destination.getNamePool()));
        this.operand.explain(destination);
        destination.endElement();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ToStringMappingFunction
    implements ItemMappingFunction<Item, StringValue> {
        @Override
        public StringValue mapItem(Item item) throws XPathException {
            return StringValue.makeStringValue(item.getStringValueCS());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AtomicSequenceMappingFunction
    implements ItemMappingFunction<AtomicValue, AtomicValue> {
        private Converter converter;

        public void setConverter(Converter converter) {
            this.converter = converter;
        }

        @Override
        public AtomicValue mapItem(AtomicValue item) throws XPathException {
            return this.converter.convert(item).asAtomic();
        }
    }

    public static class UntypedConverter
    extends Converter {
        Converter untypedConverter = null;

        public UntypedConverter(ConversionRules rules, Converter converter) {
            super(rules);
            this.untypedConverter = converter;
        }

        public ConversionResult convert(AtomicValue input) {
            if (input instanceof UntypedAtomicValue) {
                return this.untypedConverter.convert(input);
            }
            return input;
        }
    }
}

