/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.toolkitbridge.api;

import de.rcenvironment.core.toolkitbridge.api.StaticToolkitHolder;
import de.rcenvironment.toolkit.core.api.ImmutableServiceRegistry;
import de.rcenvironment.toolkit.core.api.Toolkit;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public final class ToolkitBridge {
    private static final Object sharedInitializationLock = ToolkitBridge.class;
    private static Toolkit toolkitInstance;
    private static ToolkitBridge osgiBridgeInstance;
    private static List<Runnable> deferredRunnables;
    private final ImmutableServiceRegistry toolkitServiceRegistry;
    private final BundleContext bundleContext;
    private final List<ServiceRegistration<?>> serviceRegistrations = new ArrayList();
    private final Log log = LogFactory.getLog(this.getClass());

    private ToolkitBridge(Toolkit toolkit, BundleContext bundleContext) {
        this.toolkitServiceRegistry = toolkit.getServiceRegistry();
        this.bundleContext = bundleContext;
        if (bundleContext == null) {
            throw new IllegalArgumentException("Creating a ToolkitBridge instance without an OSGi BundleContext is not allowed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize(Toolkit toolkit, BundleContext bundleContext) {
        Object object = sharedInitializationLock;
        synchronized (object) {
            toolkitInstance = toolkit;
            StaticToolkitHolder.setInstance(toolkit);
            osgiBridgeInstance = new ToolkitBridge(toolkit, bundleContext);
            osgiBridgeInstance.registerOsgiServices();
            if (deferredRunnables != null) {
                LogFactory.getLog(ToolkitBridge.class).debug((Object)("Running " + deferredRunnables.size() + " deferred task(s) after toolkit initialization"));
                for (Runnable runnable : deferredRunnables) {
                    runnable.run();
                }
                deferredRunnables = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dispose() {
        Object object = sharedInitializationLock;
        synchronized (object) {
            try {
                osgiBridgeInstance.unregisterOsgiServices();
                toolkitInstance.shutdown();
                toolkitInstance = null;
            }
            finally {
                osgiBridgeInstance = null;
                StaticToolkitHolder.setInstance(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void afterToolkitAvailable(Runnable runnable) {
        Object object = sharedInitializationLock;
        synchronized (object) {
            if (osgiBridgeInstance != null) {
                runnable.run();
            } else {
                if (deferredRunnables == null) {
                    deferredRunnables = new ArrayList<Runnable>();
                }
                deferredRunnables.add(runnable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerOsgiServices() {
        List<ServiceRegistration<?>> list = this.serviceRegistrations;
        synchronized (list) {
            for (Class apiClass : this.toolkitServiceRegistry.listServices()) {
                this.serviceRegistrations.add(this.bundleContext.registerService(apiClass.getName(), this.toolkitServiceRegistry.getService(apiClass), null));
                this.log.debug((Object)("Registered RCE Tookit service " + apiClass.getName() + " as an OSGi service"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterOsgiServices() {
        List<ServiceRegistration<?>> list = this.serviceRegistrations;
        synchronized (list) {
            for (ServiceRegistration<?> registration : this.serviceRegistrations) {
                registration.unregister();
            }
            this.serviceRegistrations.clear();
        }
        this.log.debug((Object)"Unregistered all toolkit OSGi services");
    }
}

