/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.execute;

import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.gui.resources.api.ImageManager;
import de.rcenvironment.core.gui.resources.api.ImageSource;
import de.rcenvironment.core.gui.resources.api.StandardImages;
import de.rcenvironment.core.gui.workflow.execute.CheckboxLabelProvider;
import de.rcenvironment.core.gui.workflow.execute.Messages;
import de.rcenvironment.core.gui.workflow.execute.TargetNodeEditingSupport;
import de.rcenvironment.core.gui.workflow.execute.TreeNode;
import de.rcenvironment.core.gui.workflow.execute.Updatable;
import de.rcenvironment.core.gui.workflow.execute.WorkflowNodeTargetPlatformLabelProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;

public abstract class AbstractUpdateBehavior
implements Updatable {
    public static boolean allCheckboxesClicked = false;
    protected boolean columnImageActive = true;
    protected List<CCombo> comboList;
    protected List<Button> btnList;
    protected WorkflowNodeTargetPlatformLabelProvider instanceProvider;
    protected TargetNodeEditingSupport editingSupport;
    protected CheckboxLabelProvider checkProvider;
    protected CCombo masterCombo;
    protected boolean noCheckboxSelected = true;
    protected Button masterButton;
    protected Image uncheckedImg;
    protected Image checkDisabled;
    protected String savedIndex;

    public AbstractUpdateBehavior(WorkflowNodeTargetPlatformLabelProvider instanceProvider, CheckboxLabelProvider checkboxProvider) {
        this.btnList = checkboxProvider.getBtnList();
        this.instanceProvider = instanceProvider;
        this.comboList = instanceProvider.getComboList();
        this.editingSupport = instanceProvider.getEditingSupport();
        this.checkProvider = checkboxProvider;
        this.uncheckedImg = ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.CHECK_UNCHECKED);
        this.checkDisabled = ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.CHECK_DISABLED);
    }

    @Override
    public void setComboColor(Color color) {
    }

    @Override
    public void disposeWidgets() {
        this.checkProvider.clearButtonList();
        this.instanceProvider.clearComboList();
    }

    void prepareValuesForMasterCombo() {
        if (this.comboList != null && this.comboList.get(0) != null && this.masterCombo != null) {
            ArrayList<Button> enabledButtons = new ArrayList<Button>();
            for (Button b : this.btnList) {
                if (!b.isEnabled() || !b.getSelection()) continue;
                enabledButtons.add(b);
            }
            if (enabledButtons.isEmpty()) {
                this.enableOrDisableMasterCombo();
                return;
            }
            WorkflowNode node = null;
            if (((Button)enabledButtons.get(0)).getData("CHECK_BOX") instanceof WorkflowNode) {
                node = (WorkflowNode)((Button)enabledButtons.get(0)).getData("CHECK_BOX");
                this.setComboValues(node, enabledButtons);
            } else {
                TreeNode treeNode = (TreeNode)((Button)enabledButtons.get(0)).getData("CHECK_BOX");
                if (treeNode.isChildElement()) {
                    node = treeNode.getWorkflowNode();
                    this.setComboValues(node, enabledButtons);
                } else {
                    for (TreeNode n : treeNode.getChildrenNodes()) {
                        WorkflowNode wfNode = n.getWorkflowNode();
                        this.setComboValues(wfNode, enabledButtons);
                    }
                }
            }
            this.enableOrDisableMasterCombo();
        }
    }

    private void setComboValues(WorkflowNode node, List<Button> enabledButtons) {
        if (node != null) {
            List<String> commonValues = this.editingSupport.getValues(node);
            WorkflowNode enabledNode = null;
            int i = 1;
            while (i < enabledButtons.size()) {
                if (enabledButtons.get(i).getData("CHECK_BOX") instanceof WorkflowNode) {
                    enabledNode = (WorkflowNode)enabledButtons.get(i).getData("CHECK_BOX");
                } else {
                    TreeNode n = (TreeNode)enabledButtons.get(i).getData("CHECK_BOX");
                    if (n.isChildElement()) {
                        enabledNode = n.getWorkflowNode();
                    }
                }
                if (enabledNode != null) {
                    List<String> values = this.editingSupport.getValues(enabledNode);
                    commonValues.retainAll(values);
                }
                ++i;
            }
            TreeSet<String> treeSet = new TreeSet<String>();
            for (String item : commonValues) {
                treeSet.add(item);
            }
            commonValues.clear();
            treeSet.addAll(commonValues);
            this.masterCombo.removeAll();
            for (String string : treeSet) {
                this.masterCombo.add(string);
            }
            boolean containsSetAnyAlready = false;
            int i2 = 0;
            while (i2 < this.masterCombo.getItemCount()) {
                if (this.masterCombo.getItem(i2).equals(Messages.anyRemote)) {
                    containsSetAnyAlready = true;
                    break;
                }
                ++i2;
            }
            if (!containsSetAnyAlready) {
                this.masterCombo.add(Messages.anyRemote);
            }
        }
    }

    private void enableOrDisableMasterCombo() {
        this.masterCombo.select(0);
        if (this.noCheckboxSelected) {
            this.masterCombo.setEnabled(false);
        }
    }

    protected void checkIfDisableMasterBtn() {
        if (this.masterButton != null) {
            boolean isThereAnyButtonChecked = false;
            for (Button btn : this.btnList) {
                if (btn.getSelection()) {
                    isThereAnyButtonChecked = true;
                    this.noCheckboxSelected = false;
                    break;
                }
                this.noCheckboxSelected = true;
            }
            if (!isThereAnyButtonChecked) {
                this.masterButton.setEnabled(false);
                this.masterCombo.setEnabled(false);
            } else {
                this.masterCombo.setEnabled(true);
                this.masterButton.setEnabled(true);
            }
        }
    }

    protected boolean isCheckBoxColumnEnabled() {
        for (Button b : this.btnList) {
            if (!b.isEnabled()) continue;
            this.columnImageActive = true;
            return true;
        }
        this.columnImageActive = false;
        return false;
    }

    public void setMasterCombo(CCombo masterCombo) {
        this.masterCombo = masterCombo;
    }

    public void setMasterButton(Button masterButton) {
        this.masterButton = masterButton;
    }

    public void saveIndexOfComboBeforeRefresh() {
        this.savedIndex = this.masterCombo.getText();
    }

    public void setSavedComboIndex() {
        int i = 0;
        while (i < this.masterCombo.getItemCount()) {
            if (this.masterCombo.getItem(i).equals(this.savedIndex)) {
                this.masterCombo.select(i);
                return;
            }
            ++i;
        }
    }
}

