/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.communication.views.contributors;

import de.rcenvironment.core.communication.sshconnection.SshConnectionContext;
import de.rcenvironment.core.communication.uplink.client.session.api.SshUplinkConnectionListener;
import de.rcenvironment.core.communication.uplink.client.session.api.SshUplinkConnectionListenerAdapter;
import de.rcenvironment.core.communication.uplink.client.session.api.SshUplinkConnectionService;
import de.rcenvironment.core.communication.uplink.client.session.api.SshUplinkConnectionSetup;
import de.rcenvironment.core.gui.communication.views.contributors.AddSshUplinkConnectionDialog;
import de.rcenvironment.core.gui.communication.views.contributors.EditSshUplinkConnectionDialog;
import de.rcenvironment.core.gui.communication.views.contributors.EnterPassphraseDialog;
import de.rcenvironment.core.gui.communication.views.contributors.NetworkViewCallback;
import de.rcenvironment.core.gui.communication.views.contributors.NetworkViewContributorBase;
import de.rcenvironment.core.gui.communication.views.internal.AnchorPoints;
import de.rcenvironment.core.gui.communication.views.model.NetworkGraphNodeWithContext;
import de.rcenvironment.core.gui.communication.views.model.SimpleNetworkViewNode;
import de.rcenvironment.core.gui.communication.views.spi.NetworkViewContributor;
import de.rcenvironment.core.gui.communication.views.spi.SelfRenderingNetworkViewNode;
import de.rcenvironment.core.gui.communication.views.spi.StandardUserNodeActionNode;
import de.rcenvironment.core.gui.communication.views.spi.StandardUserNodeActionType;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.core.utils.incubator.ServiceRegistryPublisherAccess;
import java.net.URL;
import java.util.Collection;
import java.util.WeakHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.MessageBox;

public class SshUplinkConnectionSetupsListContributor
extends NetworkViewContributorBase {
    private static final AnchorPoints PARENT_ANCHOR = AnchorPoints.SSH_UPLINK_SECTION_PARENT_NODE;
    private static final int ROOT_PRIORITY = 30;
    private final Log log = LogFactory.getLog(this.getClass());
    private SelfRenderingNetworkViewNode rootNode;
    private final Image connectedImage;
    private final Image disconnectedImage;
    private final ServiceRegistryPublisherAccess serviceRegistryAccess;
    private SshUplinkConnectionService sshUplinkConnectionService;
    private Collection<SshUplinkConnectionSetup> sshUplinkConnectionSetups;
    private final WeakHashMap<SshUplinkConnectionSetup, SshUplinkConnectionSetupNode> wrapperMap = new WeakHashMap();
    private NetworkViewCallback callback;

    public SshUplinkConnectionSetupsListContributor(NetworkViewCallback callback) {
        this.connectedImage = ImageDescriptor.createFromURL((URL)this.getClass().getResource("/resources/icons/connectUplink.png")).createImage();
        this.disconnectedImage = ImageDescriptor.createFromURL((URL)this.getClass().getResource("/resources/icons/disconnectUplink.png")).createImage();
        this.serviceRegistryAccess = ServiceRegistry.createPublisherAccessFor((Object)this);
        this.sshUplinkConnectionService = (SshUplinkConnectionService)this.serviceRegistryAccess.getService(SshUplinkConnectionService.class);
        this.sshUplinkConnectionSetups = this.sshUplinkConnectionService.getAllSshConnectionSetups();
        this.registerListeners();
        this.callback = callback;
    }

    @Override
    public int getRootElementsPriority() {
        return 30;
    }

    @Override
    public Object[] getTopLevelElements(Object parentNode) {
        if (parentNode != PARENT_ANCHOR) {
            return null;
        }
        boolean hasChildren = this.sshUplinkConnectionSetups != null && !this.sshUplinkConnectionSetups.isEmpty();
        this.rootNode = new SimpleNetworkViewNode("Uplink Connections", this.disconnectedImage, this, hasChildren);
        return new Object[]{this.rootNode};
    }

    @Override
    public int getInstanceDataElementsPriority() {
        return 0;
    }

    public void showAddConnectionDialog() {
        AddSshUplinkConnectionDialog dialog = new AddSshUplinkConnectionDialog(this.treeViewer.getTree().getShell());
        if (dialog.open() == 0) {
            boolean isGateway;
            boolean usePassphrase;
            String connectionName = dialog.getConnectionName();
            final boolean connectImmediately = dialog.getAutoRetry();
            boolean autoRetry = dialog.getConnectImmediately();
            final String host = dialog.getHost();
            final int port = dialog.getPort();
            String qualifier = dialog.getQualifier();
            String username = dialog.getUsername();
            final String passphrase = dialog.getPassphrase();
            final boolean storePassphrase = dialog.shouldStorePassPhrase();
            String keyfileLocation = dialog.getKeyfileLocation();
            final SshConnectionContext contextUplinkSSH = new SshConnectionContext(null, connectionName, qualifier, host, port, username, keyfileLocation, usePassphrase = dialog.getUsePassphrase(), connectImmediately, autoRetry, isGateway = dialog.isGateway());
            if (this.sshUplinkConnectionService.sshUplinkConnectionAlreadyExists(contextUplinkSSH)) {
                this.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageBox errorDialog = new MessageBox(SshUplinkConnectionSetupsListContributor.this.treeViewer.getTree().getShell(), 33);
                        errorDialog.setMessage(StringUtils.format((String)"SSH Uplink connection with host %s and port %d already exists.", (Object[])new Object[]{host, port}));
                        errorDialog.open();
                    }
                });
                return;
            }
            ConcurrencyUtils.getAsyncTaskService().execute("Create new SSH Uplink Connection.", new Runnable(){

                @Override
                public void run() {
                    String id = SshUplinkConnectionSetupsListContributor.this.sshUplinkConnectionService.addSshUplinkConnection(contextUplinkSSH);
                    SshUplinkConnectionSetupsListContributor.this.sshUplinkConnectionService.setAuthPhraseForSshConnection(id, passphrase, storePassphrase);
                    if (connectImmediately) {
                        SshUplinkConnectionSetupsListContributor.this.sshUplinkConnectionService.connectSession(id, passphrase);
                    }
                }
            });
        }
    }

    @Override
    public Object[] getChildrenForNetworkInstanceNode(NetworkGraphNodeWithContext instanceNode) {
        throw this.newUnexpectedCallException();
    }

    @Override
    public boolean hasChildren(Object parentNode) {
        throw this.newUnexpectedCallException();
    }

    @Override
    public Object[] getChildren(Object node) {
        if (node != this.rootNode) {
            throw this.newUnexpectedCallException();
        }
        if (this.sshUplinkConnectionSetups.isEmpty()) {
            return EMPTY_ARRAY;
        }
        Object[] nodes = new SshUplinkConnectionSetupNode[this.sshUplinkConnectionSetups.size()];
        int pos = 0;
        for (SshUplinkConnectionSetup setup : this.sshUplinkConnectionSetups) {
            SshUplinkConnectionSetupNode setupNode = new SshUplinkConnectionSetupNode(setup.getId(), setup);
            nodes[pos++] = setupNode;
        }
        return nodes;
    }

    @Override
    public Object getParent(Object node) {
        if (node == this.rootNode) {
            return PARENT_ANCHOR;
        }
        return this.rootNode;
    }

    @Override
    public String getText(Object node) {
        throw this.newUnexpectedCallException();
    }

    @Override
    public Image getImage(Object node) {
        throw this.newUnexpectedCallException();
    }

    @Override
    public void dispose() {
        this.connectedImage.dispose();
        this.disconnectedImage.dispose();
        this.serviceRegistryAccess.dispose();
    }

    private void registerListeners() {
        SshUplinkConnectionListenerAdapter listener = new SshUplinkConnectionListenerAdapter(){

            public void onCollectionChanged(final Collection<SshUplinkConnectionSetup> connections) {
                SshUplinkConnectionSetupsListContributor.this.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        SshUplinkConnectionSetupsListContributor.this.sshUplinkConnectionSetups = connections;
                        if ((this).SshUplinkConnectionSetupsListContributor.this.treeViewer.getControl().isDisposed()) {
                            return;
                        }
                        (this).SshUplinkConnectionSetupsListContributor.this.treeViewer.refresh((Object)PARENT_ANCHOR, false);
                        (this).SshUplinkConnectionSetupsListContributor.this.treeViewer.setExpandedState((Object)SshUplinkConnectionSetupsListContributor.this.rootNode, true);
                    }
                });
            }

            public void onConnected(final SshUplinkConnectionSetup setup) {
                SshUplinkConnectionSetupsListContributor.this.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if ((this).SshUplinkConnectionSetupsListContributor.this.treeViewer.getControl().isDisposed()) {
                            return;
                        }
                        SshUplinkConnectionSetupNode node = SshUplinkConnectionSetupsListContributor.this.getSetupNodeForSetup(setup);
                        (this).SshUplinkConnectionSetupsListContributor.this.treeViewer.refresh((Object)node);
                        (this).SshUplinkConnectionSetupsListContributor.this.treeViewer.setExpandedState((Object)node, true);
                        SshUplinkConnectionSetupsListContributor.this.callback.onStateChanged(node);
                    }
                });
            }

            public void onConnectionAttemptFailed(final SshUplinkConnectionSetup setup, final String reason, boolean firstConsecutiveFailure, final boolean willAutoRetry) {
                if (firstConsecutiveFailure) {
                    SshUplinkConnectionSetupsListContributor.this.display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageBox dialog = new MessageBox((this).SshUplinkConnectionSetupsListContributor.this.treeViewer.getTree().getShell(), 33);
                            String retryMessage = "\n\nWill not try to reconnect.";
                            if (willAutoRetry) {
                                retryMessage = "\n\nWill automatically try to reconnect.";
                            }
                            dialog.setMessage(StringUtils.format((String)"Uplink connection attempt to host %s on port %s failed:\n%s%s", (Object[])new Object[]{setup.getHost(), setup.getPort(), reason, retryMessage}));
                            dialog.open();
                        }
                    });
                }
                SshUplinkConnectionSetupsListContributor.this.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if ((this).SshUplinkConnectionSetupsListContributor.this.treeViewer.getControl().isDisposed()) {
                            return;
                        }
                        SshUplinkConnectionSetupNode node = SshUplinkConnectionSetupsListContributor.this.getSetupNodeForSetup(setup);
                        (this).SshUplinkConnectionSetupsListContributor.this.treeViewer.refresh((Object)node);
                        SshUplinkConnectionSetupsListContributor.this.callback.onStateChanged(node);
                    }
                });
            }

            public void onConnectionClosed(final SshUplinkConnectionSetup setup, boolean willAutoRetry) {
                SshUplinkConnectionSetupsListContributor.this.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if ((this).SshUplinkConnectionSetupsListContributor.this.treeViewer.getControl().isDisposed()) {
                            return;
                        }
                        SshUplinkConnectionSetupNode node = SshUplinkConnectionSetupsListContributor.this.getSetupNodeForSetup(setup);
                        (this).SshUplinkConnectionSetupsListContributor.this.treeViewer.refresh((Object)node);
                        SshUplinkConnectionSetupsListContributor.this.callback.onStateChanged(node);
                    }
                });
            }
        };
        this.sshUplinkConnectionService.addListener((SshUplinkConnectionListener)listener);
    }

    private SshUplinkConnectionSetupNode getSetupNodeForSetup(SshUplinkConnectionSetup setup) {
        return this.wrapperMap.get(setup);
    }

    private final class SshUplinkConnectionSetupNode
    implements SelfRenderingNetworkViewNode,
    StandardUserNodeActionNode {
        private final String connectionId;
        private final SshUplinkConnectionSetup sshConnectionSetup;

        SshUplinkConnectionSetupNode(String connectionId, SshUplinkConnectionSetup setup) {
            this.connectionId = connectionId;
            this.sshConnectionSetup = setup;
            SshUplinkConnectionSetupsListContributor.this.wrapperMap.put(setup, this);
        }

        @Override
        public NetworkViewContributor getContributor() {
            return SshUplinkConnectionSetupsListContributor.this;
        }

        @Override
        public boolean isActionApplicable(StandardUserNodeActionType actionType) {
            switch (actionType) {
                case START: {
                    return this.sshConnectionSetup.getSession() == null;
                }
                case STOP: {
                    return this.sshConnectionSetup.isConnected() || this.sshConnectionSetup.isWaitingForRetry();
                }
                case EDIT: {
                    return !this.sshConnectionSetup.isConnected() && !this.sshConnectionSetup.isWaitingForRetry();
                }
                case DELETE: {
                    return !this.sshConnectionSetup.isConnected() && !this.sshConnectionSetup.isWaitingForRetry();
                }
            }
            return false;
        }

        @Override
        public void performAction(StandardUserNodeActionType actionType) {
            switch (actionType) {
                case START: {
                    SshUplinkConnectionSetupsListContributor.this.display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (SshUplinkConnectionSetupNode.this.sshConnectionSetup.getUsePassphrase()) {
                                EnterPassphraseDialog dialog;
                                String passphrase = SshUplinkConnectionSetupsListContributor.this.sshUplinkConnectionService.retrieveUplinkConnectionPassword(SshUplinkConnectionSetupNode.this.connectionId);
                                if (passphrase == null && (dialog = new EnterPassphraseDialog(((SshUplinkConnectionSetupNode)SshUplinkConnectionSetupNode.this).SshUplinkConnectionSetupsListContributor.this.treeViewer.getTree().getShell())).open() == 0) {
                                    passphrase = dialog.getPassphrase();
                                    SshUplinkConnectionSetupsListContributor.this.sshUplinkConnectionService.setAuthPhraseForSshConnection(SshUplinkConnectionSetupNode.this.connectionId, dialog.getPassphrase(), dialog.getStorePassphrase());
                                }
                                final String passphraseToConnect = passphrase;
                                ConcurrencyUtils.getAsyncTaskService().execute("Connect SSH Uplink session.", new Runnable(){

                                    @Override
                                    public void run() {
                                        SshUplinkConnectionSetupsListContributor.this.sshUplinkConnectionService.connectSession(SshUplinkConnectionSetupNode.this.connectionId, passphraseToConnect);
                                    }
                                });
                            } else {
                                ConcurrencyUtils.getAsyncTaskService().execute("Connect SSH Uplink session.", new Runnable(){

                                    @Override
                                    public void run() {
                                        SshUplinkConnectionSetupsListContributor.this.sshUplinkConnectionService.connectSession(SshUplinkConnectionSetupNode.this.connectionId);
                                    }
                                });
                            }
                        }
                    });
                    break;
                }
                case STOP: {
                    ConcurrencyUtils.getAsyncTaskService().execute("Disconnect SSH Uplink Connection.", new Runnable(){

                        @Override
                        public void run() {
                            SshUplinkConnectionSetupsListContributor.this.sshUplinkConnectionService.disconnectSession(SshUplinkConnectionSetupNode.this.connectionId);
                        }
                    });
                    break;
                }
                case EDIT: {
                    this.performEdit();
                    break;
                }
                case DELETE: {
                    ConcurrencyUtils.getAsyncTaskService().execute("Dispose SSH Uplink Connection.", new Runnable(){

                        @Override
                        public void run() {
                            SshUplinkConnectionSetupsListContributor.this.sshUplinkConnectionService.disposeConnection(SshUplinkConnectionSetupNode.this.connectionId);
                        }
                    });
                    break;
                }
            }
        }

        private void performEdit() {
            String storedPassphrase = null;
            if (this.sshConnectionSetup.getUsePassphrase()) {
                storedPassphrase = SshUplinkConnectionSetupsListContributor.this.sshUplinkConnectionService.retrieveUplinkConnectionPassword(this.sshConnectionSetup.getId());
            }
            EditSshUplinkConnectionDialog dialog = new EditSshUplinkConnectionDialog(SshUplinkConnectionSetupsListContributor.this.treeViewer.getTree().getShell(), this.sshConnectionSetup.getDisplayName(), this.sshConnectionSetup.getHost(), this.sshConnectionSetup.getPort(), this.sshConnectionSetup.getQualifier(), this.sshConnectionSetup.getUsername(), this.sshConnectionSetup.getKeyfileLocation(), this.sshConnectionSetup.getUsePassphrase(), storedPassphrase != null, this.sshConnectionSetup.getConnectOnStartUp(), this.sshConnectionSetup.getAutoRetry(), this.sshConnectionSetup.isGateway());
            if (storedPassphrase != null) {
                dialog.setPassphrase(storedPassphrase);
            }
            final String id = this.sshConnectionSetup.getId();
            if (dialog.open() == 0) {
                final String connectionName = dialog.getConnectionName();
                final boolean connectImmediately = dialog.getConnectImmediately();
                final String host = dialog.getHost();
                final int port = dialog.getPort();
                final String username = dialog.getUsername();
                final String passphrase = dialog.getPassphrase();
                final boolean storePassphrase = dialog.shouldStorePassPhrase();
                final String keyfileLocation = dialog.getKeyfileLocation();
                final boolean usePassphrase = dialog.getUsePassphrase();
                final boolean autoRetry = dialog.getAutoRetry();
                final String qualifier = dialog.getQualifier();
                final boolean isGateway = dialog.isGateway();
                ConcurrencyUtils.getAsyncTaskService().execute("Edit SSH Connection.", new Runnable(){

                    @Override
                    public void run() {
                        SshUplinkConnectionSetupsListContributor.this.sshUplinkConnectionService.editSshUplinkConnection(new SshConnectionContext(id, connectionName, qualifier, host, port, username, keyfileLocation, usePassphrase, connectImmediately, autoRetry, isGateway));
                        SshUplinkConnectionSetupsListContributor.this.sshUplinkConnectionService.setAuthPhraseForSshConnection(id, passphrase, storePassphrase);
                        if (connectImmediately) {
                            SshUplinkConnectionSetupsListContributor.this.sshUplinkConnectionService.connectSession(id, passphrase);
                        }
                    }
                });
            }
        }

        @Override
        public String getText() {
            String status = "connected";
            if (!SshUplinkConnectionSetupsListContributor.this.sshUplinkConnectionService.isConnected(this.connectionId)) {
                status = SshUplinkConnectionSetupsListContributor.this.sshUplinkConnectionService.isWaitingForRetry(this.connectionId) ? "disconnected, waiting for retry" : "disconnected";
            }
            return StringUtils.format((String)"%s (%s)", (Object[])new Object[]{this.sshConnectionSetup.getDisplayName(), status});
        }

        @Override
        public Image getImage() {
            if (SshUplinkConnectionSetupsListContributor.this.sshUplinkConnectionService.isConnected(this.connectionId)) {
                return SshUplinkConnectionSetupsListContributor.this.connectedImage;
            }
            return SshUplinkConnectionSetupsListContributor.this.disconnectedImage;
        }

        @Override
        public boolean getHasChildren() {
            return false;
        }
    }
}

