/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.model.impl;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import de.rcenvironment.core.component.model.api.ComponentColor;
import de.rcenvironment.core.component.model.api.ComponentInterface;
import de.rcenvironment.core.component.model.api.ComponentShape;
import de.rcenvironment.core.component.model.api.ComponentSize;
import de.rcenvironment.core.component.model.configuration.api.ConfigurationDefinition;
import de.rcenvironment.core.component.model.configuration.api.ConfigurationExtensionDefinition;
import de.rcenvironment.core.component.model.configuration.impl.ConfigurationDefinitionImpl;
import de.rcenvironment.core.component.model.configuration.impl.ConfigurationExtensionDefinitionImpl;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDefinitionsProvider;
import de.rcenvironment.core.component.model.endpoint.impl.EndpointDefinitionsProviderImpl;
import de.rcenvironment.core.utils.common.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.codec.digest.DigestUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ComponentInterfaceImpl
implements ComponentInterface,
Serializable {
    private static final long serialVersionUID = 778538723444342052L;
    private String displayName;
    private String groupName;
    private byte[] icon16;
    private byte[] icon24;
    private byte[] icon32;
    private ComponentSize size;
    private ComponentColor color;
    private ComponentShape shape;
    private String identifier;
    private String version;
    private List<String> identifiers;
    private EndpointDefinitionsProviderImpl inputDefinitionsProvider;
    private EndpointDefinitionsProviderImpl outputDefinitionsProvider;
    private ConfigurationDefinitionImpl configurationDefinition;
    private Set<ConfigurationExtensionDefinitionImpl> configurationExtensionDefinitions = new HashSet<ConfigurationExtensionDefinitionImpl>();
    private boolean localExecutionOnly = false;
    private boolean performLazyDisposal = false;
    private boolean isDeprecated = false;
    private boolean canHandleNotAValueDataTypes = false;
    private boolean loopDriverSupportsDiscard = false;
    private boolean isLoopDriver = false;
    private String documentationHash = "";
    private String iconHash;

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Override
    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    @Override
    public byte[] getIcon16() {
        return this.icon16;
    }

    public void setIcon16(byte[] icon16) {
        this.icon16 = icon16;
        this.updateIconHash();
    }

    @Override
    public byte[] getIcon24() {
        return this.icon24;
    }

    public void setIcon24(byte[] icon24) {
        this.icon24 = icon24;
        this.updateIconHash();
    }

    @Override
    public byte[] getIcon32() {
        return this.icon32;
    }

    @Override
    public String getDocumentationHash() {
        return this.documentationHash;
    }

    public void setIcon32(byte[] icon32) {
        this.icon32 = icon32;
        this.updateIconHash();
    }

    public void setDocumentationHash(String docuHash) {
        this.documentationHash = docuHash;
    }

    @Override
    public ComponentSize getSize() {
        return this.size;
    }

    public void setSize(ComponentSize size) {
        this.size = size;
    }

    @Override
    public ComponentColor getColor() {
        return this.color;
    }

    public void setColor(ComponentColor color) {
        this.color = color;
    }

    @Override
    public ComponentShape getShape() {
        return this.shape;
    }

    public void setShape(ComponentShape shape) {
        this.shape = shape;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public String getIdentifierAndVersion() {
        if (this.version != null && !this.identifier.endsWith("/" + this.version)) {
            return String.valueOf(this.identifier) + "/" + this.version;
        }
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    @Override
    public List<String> getIdentifiers() {
        ArrayList<String> resultIdentifiers = new ArrayList<String>();
        for (String id : this.identifiers) {
            if (this.version != null && !id.endsWith("/" + this.version)) {
                resultIdentifiers.add(String.valueOf(id) + "/" + this.version);
                continue;
            }
            resultIdentifiers.add(id);
        }
        return resultIdentifiers;
    }

    public void setIdentifiers(List<String> identifiers) {
        this.identifiers = identifiers;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public EndpointDefinitionsProvider getInputDefinitionsProvider() {
        return this.inputDefinitionsProvider;
    }

    public void setInputDefinitionsProvider(EndpointDefinitionsProviderImpl inputDefinitionsProvider) {
        this.inputDefinitionsProvider = inputDefinitionsProvider;
    }

    @Override
    public EndpointDefinitionsProvider getOutputDefinitionsProvider() {
        return this.outputDefinitionsProvider;
    }

    public void setOutputDefinitionsProvider(EndpointDefinitionsProviderImpl outputDefinitionsProvider) {
        this.outputDefinitionsProvider = outputDefinitionsProvider;
    }

    @Override
    public ConfigurationDefinition getConfigurationDefinition() {
        return this.configurationDefinition;
    }

    public void setConfigurationDefinition(ConfigurationDefinitionImpl configurationDefinition) {
        this.configurationDefinition = configurationDefinition;
    }

    @Override
    public Set<ConfigurationExtensionDefinition> getConfigurationExtensionDefinitions() {
        return new HashSet<ConfigurationExtensionDefinition>(this.configurationExtensionDefinitions);
    }

    public void setConfigurationExtensionDefinitions(Set<ConfigurationExtensionDefinitionImpl> configurationExtensionDefinitions) {
        this.configurationExtensionDefinitions = configurationExtensionDefinitions;
    }

    @Override
    public boolean getLocalExecutionOnly() {
        return this.localExecutionOnly;
    }

    public void setLocalExecutionOnly(boolean localExecutionOnly) {
        this.localExecutionOnly = localExecutionOnly;
    }

    @Override
    public boolean getPerformLazyDisposal() {
        return this.performLazyDisposal;
    }

    public void setPerformLazyDisposal(boolean performLazyDisposal) {
        this.performLazyDisposal = performLazyDisposal;
    }

    @Override
    public boolean getIsDeprecated() {
        return this.isDeprecated;
    }

    public void setIsDeprecated(boolean isDeprecated) {
        this.isDeprecated = isDeprecated;
    }

    @Override
    public boolean getCanHandleNotAValueDataTypes() {
        return this.canHandleNotAValueDataTypes;
    }

    public void setCanHandleNotAValueDataTypes(boolean canHandleNotAValueDataTypes) {
        this.canHandleNotAValueDataTypes = canHandleNotAValueDataTypes;
    }

    @Override
    public boolean getLoopDriverSupportsDiscard() {
        return this.loopDriverSupportsDiscard;
    }

    public void setLoopDriverSupportsDiscard(boolean loopDriverSupportsDiscard) {
        this.loopDriverSupportsDiscard = loopDriverSupportsDiscard;
    }

    @Override
    public boolean getIsLoopDriver() {
        return this.isLoopDriver;
    }

    public void setIsLoopDriver(boolean isLoopDriver) {
        this.isLoopDriver = isLoopDriver;
    }

    public String toString() {
        return StringUtils.format((String)"ComponentInterface(id=%s)", (Object[])new Object[]{this.getIdentifierAndVersion()});
    }

    private void updateIconHash() {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[][] byArrayArray = new byte[][]{this.icon16, this.icon24, this.icon32};
        int n = byArrayArray.length;
        int n2 = 0;
        while (n2 < n) {
            byte[] iconX = byArrayArray[n2];
            if (iconX != null) {
                outputStream.write(iconX, 0, iconX.length);
            }
            ++n2;
        }
        byte[] concatenated = outputStream.toByteArray();
        this.iconHash = DigestUtils.md5Hex((byte[])concatenated);
    }

    @Override
    public String getIconHash() {
        return this.iconHash;
    }
}

