/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.routing.internal;

import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.communication.routing.internal.TopologyLink;
import java.io.Serializable;
import java.util.List;

public class NetworkRoute
implements Serializable {
    private static final long serialVersionUID = 1477187382233968105L;
    private final InstanceNodeSessionId source;
    private final InstanceNodeSessionId destination;
    private final List<TopologyLink> path;
    private final List<InstanceNodeSessionId> nodes;
    private final long computationalEffort;

    public NetworkRoute(InstanceNodeSessionId source, InstanceNodeSessionId destination, List<TopologyLink> path, List<InstanceNodeSessionId> nodes, long computationalEffort) {
        this.source = source;
        this.destination = destination;
        this.path = path;
        this.nodes = nodes;
        this.computationalEffort = computationalEffort;
    }

    public TopologyLink getFirstLink() {
        if (this.path.size() <= 0) {
            return null;
        }
        return this.path.get(0);
    }

    public InstanceNodeSessionId getNextNode() {
        return this.nodes.get(0);
    }

    public boolean validate() {
        return this.path.size() > 0 && this.nodes.size() > 0 && !this.source.equals(this.destination);
    }

    public int getLength() {
        return this.path.size();
    }

    public InstanceNodeSessionId getSource() {
        return this.source;
    }

    public InstanceNodeSessionId getDestination() {
        return this.destination;
    }

    public List<TopologyLink> getPath() {
        return this.path;
    }

    public List<InstanceNodeSessionId> getNodes() {
        return this.nodes;
    }

    public long getComputationalEffort() {
        return this.computationalEffort;
    }
}

