/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.configuration;

import de.rcenvironment.core.communication.sshconnection.InitialUplinkConnectionConfig;
import de.rcenvironment.core.configuration.ConfigurationSegment;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.naming.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UplinkConnectionsConfiguration {
    private List<InitialUplinkConnectionConfig> providedConnectionConfigs = new ArrayList<InitialUplinkConnectionConfig>();
    private final Log log = LogFactory.getLog(this.getClass());

    public UplinkConnectionsConfiguration() {
    }

    public UplinkConnectionsConfiguration(ConfigurationSegment configuration) {
        Map connectionElements = configuration.listElements("uplinkConnections");
        if (connectionElements != null) {
            for (Map.Entry entry : connectionElements.entrySet()) {
                ConfigurationSegment configPart = (ConfigurationSegment)entry.getValue();
                String id = (String)entry.getKey();
                try {
                    InitialUplinkConnectionConfig connection = this.parseConnectionEntry(configPart);
                    connection.setId(id);
                    this.providedConnectionConfigs.add(connection);
                }
                catch (ConfigurationException e) {
                    this.log.error((Object)("Error in connection entry " + (String)entry.getKey()), (Throwable)e);
                }
            }
        }
    }

    private InitialUplinkConnectionConfig parseConnectionEntry(ConfigurationSegment connectionPart) throws ConfigurationException {
        InitialUplinkConnectionConfig connection = new InitialUplinkConnectionConfig();
        connection.setHost(connectionPart.getString("host"));
        connection.setPort(connectionPart.getLong("port").intValue());
        connection.setUser(connectionPart.getString("loginName"));
        connection.setDisplayName(connectionPart.getString("displayName"));
        connection.setQualifier(connectionPart.getString("clientID", "default"));
        connection.setKeyFileLocation(connectionPart.getString("keyfileLocation"));
        connection.setUsePassphrase(connectionPart.getBoolean("noPassphrase", Boolean.valueOf(false)) == false);
        connection.setConnectOnStartup(connectionPart.getBoolean("connectOnStartup", Boolean.valueOf(false)));
        connection.setAutoRetry(connectionPart.getBoolean("autoRetry", Boolean.valueOf(false)));
        connection.setIsGateway(connectionPart.getBoolean("isGateway", Boolean.valueOf(false)));
        return connection;
    }

    public List<InitialUplinkConnectionConfig> getProvidedConnectionConfigs() {
        return this.providedConnectionConfigs;
    }
}

