/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.uplink.network.channel.internal;

import de.rcenvironment.core.communication.uplink.client.execution.api.ToolExecutionEventHandler;
import de.rcenvironment.core.communication.uplink.client.execution.api.ToolExecutionProvider;
import de.rcenvironment.core.communication.uplink.client.execution.api.ToolExecutionRequest;
import de.rcenvironment.core.communication.uplink.client.execution.api.ToolExecutionRequestResponse;
import de.rcenvironment.core.communication.uplink.client.execution.api.ToolExecutionResult;
import de.rcenvironment.core.communication.uplink.client.session.api.ClientSideUplinkSession;
import de.rcenvironment.core.communication.uplink.client.session.api.ClientSideUplinkSessionEventHandler;
import de.rcenvironment.core.communication.uplink.client.session.api.ToolExecutionHandle;
import de.rcenvironment.core.communication.uplink.common.internal.MessageType;
import de.rcenvironment.core.communication.uplink.network.channel.internal.AbstractExecutionChannelEndpoint;
import de.rcenvironment.core.communication.uplink.network.channel.internal.ToolExecutionChannelState;
import de.rcenvironment.core.communication.uplink.network.channel.internal.ToolExecutionProviderEventTransferObject;
import de.rcenvironment.core.communication.uplink.network.internal.MessageBlock;
import de.rcenvironment.core.utils.common.exception.ProtocolException;
import java.io.IOException;
import java.util.List;

public class ToolExecutionChannelInitiatorEndpoint
extends AbstractExecutionChannelEndpoint {
    private ToolExecutionProvider executionProvider;
    private ToolExecutionHandle executionHandle;
    private ToolExecutionEventHandler executionEventHandler;
    private AbstractExecutionChannelEndpoint.DirectoryDownloadWrapper directoryDownloadWrapper;

    public ToolExecutionChannelInitiatorEndpoint(ClientSideUplinkSession session, long channelId, ClientSideUplinkSessionEventHandler sessionEventHandler) {
        super(session, channelId);
    }

    public void initiateToolExecution(ToolExecutionRequest toolExecutionRequest, ToolExecutionEventHandler eventHandler) throws IOException {
        this.executionEventHandler = eventHandler;
        this.executionHandle = new ToolExecutionHandle(){

            @Override
            public void requestCancel() {
                try {
                    ToolExecutionChannelInitiatorEndpoint.this.enqueueMessageBlockForSending(ToolExecutionChannelInitiatorEndpoint.this.messageConverter.createToolCancellationRequest());
                }
                catch (IOException e) {
                    ToolExecutionChannelInitiatorEndpoint.this.log.error((Object)("Failed to deliver a tool cancellation request through an Uplink connection: " + e.toString()));
                }
            }
        };
        this.enqueueMessageBlockForSending(this.messageConverter.encodeToolExecutionRequest(toolExecutionRequest));
        this.channelState = ToolExecutionChannelState.EXPECTING_EXECUTION_REQUEST_RESPONSE;
    }

    @Override
    public void dispose() {
    }

    @Override
    protected synchronized boolean processMessageInternal(MessageBlock messageBlock) throws IOException {
        MessageType messageType = messageBlock.getType();
        if (messageType == MessageType.CHANNEL_CLOSE) {
            return false;
        }
        switch (this.channelState) {
            case EXPECTING_EXECUTION_REQUEST_RESPONSE: {
                this.validateActualVersusExpectedMessageType(messageType, MessageType.TOOL_EXECUTION_REQUEST_RESPONSE);
                ToolExecutionRequestResponse response = this.messageConverter.decodeToolExecutionRequestResponse(messageBlock);
                if (!response.isAccepted()) {
                    this.log.debug((Object)"Failed to set up remote tool execution, aborting");
                    this.executionEventHandler.onContextClosing();
                    return false;
                }
                this.log.debug((Object)"Successfully set up remote tool execution, preparing to upload the input files");
                this.channelState = ToolExecutionChannelState.EXPECTING_NO_MESSAGES;
                this.executionEventHandler.onInputUploadsStarting();
                this.uploadInputFiles();
                this.executionEventHandler.onInputUploadsFinished();
                this.executionEventHandler.onExecutionStarting();
                this.channelState = ToolExecutionChannelState.EXPECTING_EXECUTION_EVENTS;
                return true;
            }
            case EXPECTING_EXECUTION_EVENTS: {
                if (messageType == MessageType.TOOL_EXECUTION_EVENTS) {
                    List<ToolExecutionProviderEventTransferObject> toolExecutionEvents = this.messageConverter.decodeToolExecutionEvents(messageBlock);
                    for (ToolExecutionProviderEventTransferObject event : toolExecutionEvents) {
                        this.executionEventHandler.processToolExecutionEvent(event.t, event.d);
                    }
                    return true;
                }
                this.validateActualVersusExpectedMessageType(messageType, MessageType.TOOL_EXECUTION_FINISHED);
                ToolExecutionResult toolExecutionResult = this.messageConverter.decodeToolExecutionResult(messageBlock);
                this.executionEventHandler.onExecutionFinished(toolExecutionResult);
                this.ensureNotDefinedYet(this.directoryDownloadWrapper);
                this.directoryDownloadWrapper = new AbstractExecutionChannelEndpoint.DirectoryDownloadWrapper(this.executionEventHandler.getOutputDirectoryReceiver());
                this.executionEventHandler.onOutputDownloadsStarting();
                this.channelState = ToolExecutionChannelState.EXPECTING_DIRECTORY_DOWNLOAD;
                return true;
            }
            case EXPECTING_DIRECTORY_DOWNLOAD: {
                this.ensure(this.directoryDownloadWrapper != null);
                this.directoryDownloadWrapper.processMessageBlock(messageBlock);
                if (this.directoryDownloadWrapper.isFinished()) {
                    this.channelState = ToolExecutionChannelState.EXPECTING_NO_MESSAGES;
                    this.executionEventHandler.onOutputDownloadsFinished();
                    this.executionEventHandler.onContextClosing();
                    return false;
                }
                return true;
            }
        }
        throw new ProtocolException("Received an unexpected message block (type: " + (Object)((Object)messageType) + ") while in state " + (Object)((Object)this.channelState));
    }

    private void uploadInputFiles() throws IOException {
        new AbstractExecutionChannelEndpoint.DirectoryUploadWrapper(this.executionEventHandler.getInputDirectoryProvider()).performDirectoryUpload();
    }

    public ToolExecutionHandle getExecutionHandle() {
        return this.executionHandle;
    }
}

