/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.authentication.internal;

import de.rcenvironment.core.authentication.AuthenticationService;
import de.rcenvironment.core.authentication.LDAPUser;
import de.rcenvironment.core.authentication.SingleUser;
import de.rcenvironment.core.authentication.User;
import de.rcenvironment.core.authentication.internal.AuthenticationConfiguration;
import de.rcenvironment.core.configuration.ConfigurationService;
import de.rcenvironment.core.utils.incubator.Assertions;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;

public class AuthenticationServiceImpl
implements AuthenticationService {
    private static final String REFERRAL = "follow";
    private static final String CONTEXT_FACTORY_CLASS = "com.sun.jndi.ldap.LdapCtxFactory";
    private static final String LDAP_AUTH_METHOD = "simple";
    private static final String LDAP_PROTOCOL = "ldap://";
    private static final String ASSERTIONS_PARAMETER_NULL = "The parameter \"%s\" must not be null.";
    private static final Log LOGGER = LogFactory.getLog(AuthenticationServiceImpl.class);
    private AuthenticationConfiguration myConfiguration;
    private ConfigurationService configurationService;
    private String bundleSymbolicName;

    protected void activate(BundleContext context) {
        this.bundleSymbolicName = context.getBundle().getSymbolicName();
        this.myConfiguration = new AuthenticationConfiguration();
    }

    protected void bindConfigurationService(ConfigurationService newConfigurationService) {
        this.configurationService = newConfigurationService;
    }

    @Override
    public AuthenticationService.LDAPAuthenticationResult authenticate(String username, String password) {
        if (password == null || password.trim().isEmpty() || username == null || username.trim().isEmpty()) {
            return AuthenticationService.LDAPAuthenticationResult.PASSWORD__OR_USERNAME_INVALID;
        }
        String baseDn = this.myConfiguration.getLdapBaseDn();
        String server = this.myConfiguration.getLdapServer();
        String domain = this.myConfiguration.getLdapDomain();
        try {
            this.connect(server, baseDn, String.valueOf(username) + "@" + domain, password);
        }
        catch (NamingException namingException) {
            return AuthenticationService.LDAPAuthenticationResult.PASSWORD_OR_USERNAME_INCORRECT;
        }
        return AuthenticationService.LDAPAuthenticationResult.AUTHENTICATED;
    }

    @Override
    public User createUser(String userIdLdap, int validityInDays) {
        Assertions.isDefined((Object)userIdLdap, (String)ASSERTIONS_PARAMETER_NULL);
        return new LDAPUser(userIdLdap, validityInDays, this.myConfiguration.getLdapDomain());
    }

    @Override
    public User createUser(int validityInDays) {
        return new SingleUser(validityInDays);
    }

    private void connect(String server, String baseDn, String dn, String password) throws NamingException {
        Properties env = new Properties();
        env.setProperty("java.naming.factory.initial", CONTEXT_FACTORY_CLASS);
        env.setProperty("java.naming.provider.url", LDAP_PROTOCOL + server);
        env.setProperty("java.naming.security.authentication", LDAP_AUTH_METHOD);
        env.setProperty("java.naming.security.principal", dn);
        env.setProperty("java.naming.security.credentials", password);
        env.setProperty("java.naming.referral", REFERRAL);
        new InitialDirContext(env);
    }
}

