/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.cpacs.vampzeroinitializer.gui;

import de.rcenvironment.components.cpacs.vampzeroinitializer.gui.FormToolkitSwtHelper;
import de.rcenvironment.components.cpacs.vampzeroinitializer.gui.GuiInputParser;
import de.rcenvironment.components.cpacs.vampzeroinitializer.gui.InputTransferable;
import de.rcenvironment.components.cpacs.vampzeroinitializer.gui.ParameterCompositeWrapper;
import de.rcenvironment.components.cpacs.vampzeroinitializer.gui.ParameterTreeContentProvider;
import de.rcenvironment.components.cpacs.vampzeroinitializer.gui.ParameterTreeLabelProvider;
import de.rcenvironment.components.cpacs.vampzeroinitializer.gui.ToolspecificOutputWriter;
import de.rcenvironment.components.cpacs.vampzeroinitializer.gui.model.Component;
import de.rcenvironment.components.cpacs.vampzeroinitializer.gui.model.Discipline;
import de.rcenvironment.components.cpacs.vampzeroinitializer.gui.model.Parameter;
import de.rcenvironment.core.gui.utils.common.components.PropertyTabGuiHelper;
import de.rcenvironment.core.utils.common.xml.XMLException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class MainGuiController {
    private static final int SIZE_200 = 200;
    private static final Log LOGGER = LogFactory.getLog(MainGuiController.class);
    private List<Component> modifiedComponents = new ArrayList<Component>();
    private FormToolkitSwtHelper factory;
    private TreeViewer viewer;
    private InputTransferable listener;
    private String xmlPath = null;
    private List<Control> disposables = new LinkedList<Control>();
    private List<Component> components;
    private GuiInputParser guiInputParser = new GuiInputParser();
    private ToolspecificOutputWriter toolspecificOutputWriter = new ToolspecificOutputWriter();

    public MainGuiController(FormToolkitSwtHelper factory, InputTransferable performListener) {
        this.factory = factory;
        this.listener = performListener;
    }

    public MainGuiController(FormToolkitSwtHelper factory, InputTransferable performListener, String guiXmlPath) {
        this.factory = factory;
        this.listener = performListener;
        this.xmlPath = guiXmlPath;
    }

    public void dispose() {
        while (this.disposables.size() > 0) {
            if (!(this.disposables instanceof LinkedList)) continue;
            ((Control)((LinkedList)this.disposables).getLast()).dispose();
            ((LinkedList)this.disposables).removeLast();
        }
    }

    public Composite createControls() {
        List<Component> componentsTemp = null;
        if (this.xmlPath != null && new File(this.xmlPath).canRead()) {
            boolean killSwitch = false;
            try {
                FileInputStream fis = new FileInputStream(this.xmlPath);
                componentsTemp = this.guiInputParser.parse(fis);
                fis.close();
            }
            catch (XMLException | IOException | XPathExpressionException e) {
                LOGGER.error((Object)e);
                killSwitch = true;
            }
            if (killSwitch) {
                return null;
            }
        } else {
            try {
                componentsTemp = this.guiInputParser.parse(this.getClass().getClassLoader().getResourceAsStream("resources/gui.xml"));
            }
            catch (XMLException | XPathExpressionException e) {
                LOGGER.error((Object)e.getCause().getMessage());
                componentsTemp = new ArrayList<Component>();
            }
        }
        this.components = componentsTemp;
        Composite mainComposite = this.factory.createMainComposite();
        this.disposables.add((Control)mainComposite);
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 5;
        layout.horizontalSpacing = 4;
        layout.verticalSpacing = 4;
        mainComposite.setLayout((Layout)layout);
        final Composite comboComposite = this.factory.createComposite(mainComposite, 3, 3);
        this.disposables.add((Control)comboComposite);
        final Combo componentCombo = this.factory.createCombo(comboComposite, null, null);
        final Combo disciplineCombo = this.factory.createCombo(comboComposite, null, null);
        Button loadButton = this.factory.createButton(comboComposite, "Load configuration...", new Listener(){

            public void handleEvent(Event event) {
                IFile file = PropertyTabGuiHelper.selectFileFromProjects((Shell)comboComposite.getShell(), (String)"Foo", (String)"FooBar");
                if (file != null) {
                    StringWriter writer = new StringWriter();
                    try {
                        IOUtils.copy((InputStream)file.getContents(), (Writer)writer);
                        String theString = writer.toString();
                        MainGuiController.this.setSelectedParameters(theString);
                    }
                    catch (IOException iOException) {
                        LOGGER.error((Object)"Cannot read content from file.");
                    }
                    catch (CoreException coreException) {
                        LOGGER.error((Object)"Cannot read content from file.");
                    }
                }
            }
        }, new int[0]);
        this.disposables.add((Control)componentCombo);
        this.disposables.add((Control)disciplineCombo);
        this.disposables.add((Control)loadButton);
        Label separator = this.factory.createSeparator(mainComposite, true, new int[0]);
        ((TableWrapData)separator.getLayoutData()).valign = 128;
        ((TableWrapData)separator.getLayoutData()).rowspan = 2;
        this.disposables.add((Control)separator);
        Composite rightComposite = this.factory.createComposite(mainComposite);
        this.disposables.add((Control)rightComposite);
        TableWrapData td = new TableWrapData();
        td.align = 128;
        td.valign = 128;
        td.grabHorizontal = true;
        td.grabVertical = true;
        td.rowspan = 2;
        rightComposite.setLayoutData((Object)td);
        rightComposite.setLayout((Layout)new GridLayout(1, false));
        Button createButton = new Button(rightComposite, 0x800008);
        this.disposables.add((Control)createButton);
        createButton.setText("Create CPACS");
        createButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                MainGuiController.this.listener.transfer(MainGuiController.this.toolspecificOutputWriter.createOutput(MainGuiController.this.modifiedComponents));
            }
        });
        createButton.setLayoutData((Object)new GridData(131072, 128, false, false));
        createButton.setImage(this.factory.saveImage);
        this.viewer = new TreeViewer(rightComposite, 2060);
        this.disposables.add((Control)this.viewer.getTree());
        this.viewer.setContentProvider((IContentProvider)new ParameterTreeContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ParameterTreeLabelProvider((Device)this.viewer.getTree().getDisplay()));
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer);
        HashSet<List<Component>> set = new HashSet<List<Component>>();
        set.add(this.modifiedComponents);
        this.viewer.setInput(set);
        GridData gd = new GridData(4, 4, true, true);
        gd.minimumHeight = 200;
        gd.minimumWidth = 200;
        Composite contentComposite = this.factory.createComposite(mainComposite, 1, 1);
        this.disposables.add((Control)contentComposite);
        contentComposite.setLayoutData((Object)new TableWrapData(128, 128, 1, 1));
        contentComposite.setLayout((Layout)new GridLayout(1, false));
        for (Component component : this.components) {
            componentCombo.add(component.getName());
        }
        for (Discipline discipline : this.components.get(0).getDisciplines()) {
            disciplineCombo.add(discipline.getName());
        }
        final ParameterCompositeWrapper parameterCompositeWrapper = new ParameterCompositeWrapper(this.factory, contentComposite, this.modifiedComponents);
        parameterCompositeWrapper.setDiscipline(this.components.get(0).getDisciplines().get(0));
        parameterCompositeWrapper.setViewer(this.viewer);
        this.viewer.getTree().setLayoutData((Object)gd);
        this.viewer.getTree().addListener(13, this.getTreeViewListener(componentCombo, disciplineCombo, parameterCompositeWrapper, contentComposite));
        this.viewer.getTree().addKeyListener(this.getKeyAdapter());
        componentCombo.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                String newSelection = componentCombo.getText();
                Component component = MainGuiController.this.getComponentForName(MainGuiController.this.components, newSelection);
                MainGuiController.this.fillDisciplines(disciplineCombo, component);
                parameterCompositeWrapper.setDiscipline(component.getDisciplines().get(0));
                parameterCompositeWrapper.redraw();
                disciplineCombo.select(0);
            }
        });
        disciplineCombo.addListener(13, this.getDisciplineComboListener(disciplineCombo, parameterCompositeWrapper, componentCombo));
        componentCombo.select(0);
        disciplineCombo.select(0);
        return mainComposite;
    }

    private Listener getDisciplineComboListener(final Combo disciplineCombo, final ParameterCompositeWrapper parameterCompositeWrapper, final Combo componentCombo) {
        return new Listener(){

            public void handleEvent(Event event) {
                String newSelection = disciplineCombo.getText();
                Component component = MainGuiController.this.getComponentForName(MainGuiController.this.components, componentCombo.getText());
                parameterCompositeWrapper.setDiscipline(component.getDisciplineForName(newSelection));
                parameterCompositeWrapper.redraw();
            }
        };
    }

    private Listener getTreeViewListener(final Combo componentCombo, final Combo disciplineCombo, final ParameterCompositeWrapper parameterCompositeWrapper, final Composite contentComposite) {
        return new Listener(){

            public void handleEvent(Event event) {
                if (MainGuiController.this.viewer.getTree().getSelectionCount() != 1) {
                    return;
                }
                TreeItem[] items = MainGuiController.this.viewer.getTree().getSelection();
                TreeItem item = items[0];
                String path = item.getText();
                while (item.getParentItem() != null) {
                    item = item.getParentItem();
                    path = String.valueOf(item.getText()) + "/\\/" + path;
                }
                String[] parameterBreakDown = path.split("/\\\\/");
                if (parameterBreakDown.length < 2) {
                    return;
                }
                if (!componentCombo.getText().equals(parameterBreakDown[1])) {
                    Component component = MainGuiController.this.getComponentForName(MainGuiController.this.components, parameterBreakDown[1]);
                    componentCombo.select(componentCombo.indexOf(component.getName()));
                    MainGuiController.this.fillDisciplines(disciplineCombo, component);
                    if (parameterBreakDown.length > 2) {
                        parameterCompositeWrapper.setDiscipline(component.getDisciplineForName(parameterBreakDown[2]));
                        parameterCompositeWrapper.redraw();
                        disciplineCombo.select(disciplineCombo.indexOf(parameterBreakDown[2]));
                    } else {
                        parameterCompositeWrapper.setDiscipline(component.getDisciplines().get(0));
                        parameterCompositeWrapper.redraw();
                        disciplineCombo.select(0);
                    }
                } else if (parameterBreakDown.length > 2 && !disciplineCombo.getText().equals(parameterBreakDown[2])) {
                    parameterCompositeWrapper.setDiscipline(MainGuiController.this.getComponentForName(MainGuiController.this.components, parameterBreakDown[1]).getDisciplineForName(parameterBreakDown[2]));
                    parameterCompositeWrapper.redraw();
                    disciplineCombo.select(disciplineCombo.indexOf(parameterBreakDown[2]));
                }
                if (parameterBreakDown.length > 3) {
                    for (Component component : MainGuiController.this.modifiedComponents) {
                        if (!component.getName().equals(parameterBreakDown[1])) continue;
                        Parameter param = component.getDisciplineForName(parameterBreakDown[2]).getParameterForName(parameterBreakDown[3]);
                        parameterCompositeWrapper.setName(param.getName());
                        parameterCompositeWrapper.setDescription(param.getDescription());
                        parameterCompositeWrapper.setValue(param.getValue());
                        parameterCompositeWrapper.setFactor(param.getFactor());
                    }
                    org.eclipse.swt.widgets.List paramList = (org.eclipse.swt.widgets.List)((Composite)contentComposite.getChildren()[0]).getChildren()[0];
                    int i = 0;
                    int n = paramList.getItemCount();
                    while (i < n) {
                        if (paramList.getItem(i).equals(parameterBreakDown[3])) {
                            paramList.setSelection(i);
                            break;
                        }
                        ++i;
                    }
                }
            }
        };
    }

    private KeyListener getKeyAdapter() {
        return new KeyAdapter(){

            public void keyReleased(KeyEvent event) {
                if (event.character == '\u007f') {
                    if (MainGuiController.this.viewer.getTree().getSelectionCount() != 1) {
                        return;
                    }
                    TreeItem[] items = MainGuiController.this.viewer.getTree().getSelection();
                    TreeItem item = items[0];
                    String path = item.getText();
                    while (item.getParentItem() != null) {
                        item = item.getParentItem();
                        path = String.valueOf(item.getText()) + "/\\/" + path;
                    }
                    String[] parameterBreakDown = path.split("/\\\\/");
                    if (parameterBreakDown.length < 4) {
                        return;
                    }
                    Discipline discipline = MainGuiController.this.getComponentForName(MainGuiController.this.modifiedComponents, parameterBreakDown[1]).getDisciplineForName(parameterBreakDown[2]);
                    discipline.getParameters().remove(discipline.getParameterForName(parameterBreakDown[3]));
                    if (discipline.getParameters().size() == 0) {
                        discipline.getComponent().getDisciplines().remove(discipline);
                        if (discipline.getComponent().getDisciplines().size() == 0) {
                            MainGuiController.this.modifiedComponents.remove(discipline.getComponent());
                        }
                    }
                    MainGuiController.this.viewer.refresh();
                }
            }
        };
    }

    private void fillDisciplines(Combo disciplineCombo, Component component) {
        disciplineCombo.removeAll();
        for (Discipline discipline : component.getDisciplines()) {
            disciplineCombo.add(discipline.getName());
        }
    }

    public void setSelectedParameters(String configuration) {
        try {
            List<Component> setComponents = this.guiInputParser.parse(configuration);
            this.modifiedComponents.clear();
            for (Component setComponent : setComponents) {
                Component compDefinition = this.getComponentForName(this.components, setComponent.getName());
                if (compDefinition == null) {
                    LOGGER.warn((Object)("Ignoring component setting " + setComponent.getName()));
                    continue;
                }
                if (this.getComponentForName(this.modifiedComponents, setComponent.getName()) != null) {
                    LOGGER.warn((Object)("Ignoring duplicate component setting " + setComponent.getName()));
                    continue;
                }
                Component newComponent = new Component();
                newComponent.setName(setComponent.getName());
                this.modifiedComponents.add(newComponent);
                for (Discipline setDiscipline : setComponent.getDisciplines()) {
                    Discipline discDefinition = compDefinition.getDisciplineForName(setDiscipline.getName());
                    if (discDefinition == null) {
                        LOGGER.warn((Object)("Ignoring discipline setting " + setDiscipline.getName()));
                        continue;
                    }
                    if (newComponent.getDisciplineForName(setDiscipline.getName()) != null) {
                        LOGGER.warn((Object)("Ignoring duplicate discipline setting " + setDiscipline.getName()));
                        continue;
                    }
                    Discipline newDiscipline = new Discipline();
                    newDiscipline.setName(setDiscipline.getName());
                    newComponent.getDisciplines().add(newDiscipline);
                    for (Parameter setParameter : setDiscipline.getParameters()) {
                        Parameter paramDefinition = discDefinition.getParameterForName(setParameter.getName());
                        if (paramDefinition == null) {
                            LOGGER.warn((Object)("Ignoring parameter setting " + setParameter.getName()));
                            continue;
                        }
                        if (newDiscipline.getParameterForName(setParameter.getName()) != null) {
                            LOGGER.warn((Object)("Ignoring duplicate parameter setting " + setParameter.getName()));
                            continue;
                        }
                        Parameter newParameter = new Parameter(setParameter);
                        newParameter.setName(setParameter.getName());
                        newDiscipline.getParameters().add(newParameter);
                    }
                }
            }
            this.viewer.refresh();
            this.viewer.expandAll();
        }
        catch (XMLException | XPathExpressionException e) {
            LOGGER.error((Object)"Error parsing earlier vampzero configuration", e);
        }
    }

    private Component getComponentForName(List<Component> comp, String name) {
        assert (comp != null);
        assert (comp.size() > 0);
        assert (name != null);
        for (Component component : comp) {
            if (!component.getName().equals(name)) continue;
            return component;
        }
        return null;
    }
}

