/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.utils.executor.context.impl;

import de.rcenvironment.core.utils.executor.CommandLineExecutor;
import de.rcenvironment.core.utils.executor.context.spi.ExecutorContext;
import de.rcenvironment.core.utils.executor.context.spi.SandboxStrategy;
import java.io.IOException;

public class ContinuousSandboxStrategy
implements SandboxStrategy {
    private CommandLineExecutor singleExecutor;
    private ExecutorContext executionEnvironment;

    public ContinuousSandboxStrategy(ExecutorContext executionEnvironment) {
        this.executionEnvironment = executionEnvironment;
    }

    @Override
    public CommandLineExecutor prepareExecutionPhase() throws IOException {
        if (this.singleExecutor == null) {
            this.singleExecutor = this.executionEnvironment.setUpSandboxedExecutor();
        }
        return this.singleExecutor;
    }

    @Override
    public void afterExecutionPhase(CommandLineExecutor executor) throws IOException {
        if (executor != this.singleExecutor) {
            throw new IllegalStateException("Provided executor does not match internal executor");
        }
    }

    @Override
    public void beforeSessionTeardown() throws IOException {
        this.executionEnvironment.tearDownSandbox(this.singleExecutor);
    }
}

