/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.instancemanagement.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class ConfigurationSegmentFactory {
    private static final String PORT = "port";
    private static final String HOST = "host";
    private static final String IP = "ip";
    private static final String ENABLED = "enabled";

    private ConfigurationSegmentFactory() {
    }

    public static SegmentBuilder getSegmentBuilder() {
        return new ConfigurationSegmentFactory().new SegmentBuilder();
    }

    public class AuthorizationSegment
    implements Segment {
        @Override
        public String getPath() {
            return "authorization/";
        }
    }

    public class BackgroundMonitoringSegment
    implements Segment {
        @Override
        public String getPath() {
            return "backgroundMonitoring/";
        }

        public ConfigurationKey enableIds() {
            return new ConfigurationKey(){

                @Override
                public String getConfigurationKey() {
                    return "enableIds";
                }
            };
        }

        public ConfigurationKey intervalSeconds() {
            return new ConfigurationKey(){

                @Override
                public String getConfigurationKey() {
                    return "intervalSeconds";
                }
            };
        }
    }

    public class ClusterComponentSettingsSegment
    implements Segment {
        @Override
        public String getPath() {
            return "componentSettings/de.rcenvironment.cluster";
        }

        public ConfigurationKey maxChannels() {
            return new ConfigurationKey(){

                @Override
                public String getConfigurationKey() {
                    return "maxChannels";
                }
            };
        }
    }

    public class ComponentSettingsSegment
    implements Segment {
        private final ClusterComponentSettingsSegment clusterComponent;

        public ComponentSettingsSegment() {
            this.clusterComponent = new ClusterComponentSettingsSegment();
        }

        @Override
        public String getPath() {
            return "componentSettings/";
        }

        public ClusterComponentSettingsSegment getClusterComponentSettings() {
            return this.clusterComponent;
        }
    }

    public static interface ConfigurationKey {
        public String getConfigurationKey();
    }

    private abstract class ConnectionSegment
    implements Segment {
        private final String name;

        ConnectionSegment(String name) {
            this.name = name;
        }

        @Override
        public String getPath() {
            return "network/connections/" + this.name;
        }

        abstract ConfigurationKey host();

        abstract ConfigurationKey port();
    }

    public class GeneralSegment
    implements Segment {
        public ConfigurationKey comment() {
            return new ConfigurationKey(){

                @Override
                public String getConfigurationKey() {
                    return "comment";
                }
            };
        }

        public ConfigurationKey instanceName() {
            return new ConfigurationKey(){

                @Override
                public String getConfigurationKey() {
                    return "instanceName";
                }
            };
        }

        public ConfigurationKey isWorkflowHost() {
            return new ConfigurationKey(){

                @Override
                public String getConfigurationKey() {
                    return "isWorkflowHost";
                }
            };
        }

        public ConfigurationKey isRelay() {
            return new ConfigurationKey(){

                @Override
                public String getConfigurationKey() {
                    return "isRelay";
                }
            };
        }

        public ConfigurationKey tempDirectory() {
            return new ConfigurationKey(){

                @Override
                public String getConfigurationKey() {
                    return "tempDirectory";
                }
            };
        }

        public ConfigurationKey enableDeprecatedInputTab() {
            return new ConfigurationKey(){

                @Override
                public String getConfigurationKey() {
                    return "enableDeprecatedInputTab";
                }
            };
        }

        @Override
        public String getPath() {
            return "general/";
        }
    }

    public class IpFilterSegment
    implements Segment {
        @Override
        public String getPath() {
            return "network/ipFilter";
        }

        public ConfigurationKey enabled() {
            return new ConfigurationKey(){

                @Override
                public String getConfigurationKey() {
                    return ConfigurationSegmentFactory.ENABLED;
                }
            };
        }

        public ConfigurationKey allowedIps() {
            return new ConfigurationKey(){

                @Override
                public String getConfigurationKey() {
                    return "allowedIPs";
                }
            };
        }
    }

    public class NetworkConnectionListSegment
    implements Segment {
        private Map<String, NetworkConnectionSegment> connectionNameToConnectionSegmentMap = new ConcurrentHashMap<String, NetworkConnectionSegment>();

        @Override
        public String getPath() {
            return "network/connections";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public NetworkConnectionSegment getOrCreateConnection(String name) {
            Map<String, NetworkConnectionSegment> map = this.connectionNameToConnectionSegmentMap;
            synchronized (map) {
                if (this.connectionNameToConnectionSegmentMap.containsKey(name)) {
                    return this.connectionNameToConnectionSegmentMap.get(name);
                }
                NetworkConnectionSegment segment = new NetworkConnectionSegment(name);
                this.connectionNameToConnectionSegmentMap.put(name, segment);
                return segment;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isConnectionPresent(String name) {
            Map<String, NetworkConnectionSegment> map = this.connectionNameToConnectionSegmentMap;
            synchronized (map) {
                return this.connectionNameToConnectionSegmentMap.containsKey(name);
            }
        }
    }

    public class NetworkConnectionSegment
    extends ConnectionSegment {
        public NetworkConnectionSegment(String name) {
            super(name);
        }

        @Override
        public ConfigurationKey host() {
            return new ConfigurationKey(){

                @Override
                public String getConfigurationKey() {
                    return ConfigurationSegmentFactory.HOST;
                }
            };
        }

        @Override
        public ConfigurationKey port() {
            return new ConfigurationKey(){

                @Override
                public String getConfigurationKey() {
                    return ConfigurationSegmentFactory.PORT;
                }
            };
        }

        public ConfigurationKey connectOnStartup() {
            return new ConfigurationKey(){

                @Override
                public String getConfigurationKey() {
                    return "connectOnStartup";
                }
            };
        }

        public ConfigurationKey autoRetryInitialDelay() {
            return new ConfigurationKey(){

                @Override
                public String getConfigurationKey() {
                    return "autoRetryInitialDelay";
                }
            };
        }

        public ConfigurationKey autoRetryDelayMultiplier() {
            return new ConfigurationKey(){

                @Override
                public String getConfigurationKey() {
                    return "autoRetryDelayMultiplier";
                }
            };
        }

        public ConfigurationKey autoRetryMaximumDelay() {
            return new ConfigurationKey(){

                @Override
                public String getConfigurationKey() {
                    return "autoRetryMaximumDelay";
                }
            };
        }
    }

    public class NetworkSegment
    implements Segment {
        private final NetworkConnectionListSegment connections;
        private final ServerPortListSegment ports;
        private final IpFilterSegment ipFilter;

        public NetworkSegment() {
            this.connections = new NetworkConnectionListSegment();
            this.ports = new ServerPortListSegment();
            this.ipFilter = new IpFilterSegment();
        }

        @Override
        public String getPath() {
            return "network/";
        }

        public NetworkConnectionListSegment connections() {
            return this.connections;
        }

        public ServerPortListSegment ports() {
            return this.ports;
        }

        public IpFilterSegment ipFilter() {
            return this.ipFilter;
        }

        public ConfigurationKey requestTimeoutMsec() {
            return new ConfigurationKey(){

                @Override
                public String getConfigurationKey() {
                    return "requestTimeoutMsec";
                }
            };
        }

        public ConfigurationKey forwardingTimeoutMsec() {
            return new ConfigurationKey(){

                @Override
                public String getConfigurationKey() {
                    return "forwardingTimeoutMsec";
                }
            };
        }
    }

    public class PublishingSegment
    implements Segment {
        @Override
        public String getPath() {
            return "publishing/";
        }

        public ConfigurationKey components() {
            return new ConfigurationKey(){

                @Override
                public String getConfigurationKey() {
                    return "components";
                }
            };
        }
    }

    public static interface Segment {
        public String getPath();
    }

    public class SegmentBuilder {
        private final SegmentContainer container;

        public SegmentBuilder() {
            this.container = new SegmentContainer();
        }

        public GeneralSegment general() {
            return this.container.getGeneralSegment();
        }

        public BackgroundMonitoringSegment backgroundMonitoring() {
            return this.container.getBackgroundMonitoringSegment();
        }

        public NetworkSegment network() {
            return this.container.getNetworkSegment();
        }

        public SshRemoteAccessSegment sshRemoteAccess() {
            return this.container.getRemoteAccess();
        }

        public UplinkSegment uplink() {
            return this.container.getUplink();
        }

        public PublishingSegment publishing() {
            return this.container.getPublishingSegment();
        }

        public AuthorizationSegment authorization() {
            return this.container.getAuthorizationSegment();
        }

        public ComponentSettingsSegment componentSettings() {
            return this.container.getComponentSettings();
        }

        public SshServerSegment sshServer() {
            return this.container.getSshServer();
        }
    }

    private final class SegmentContainer {
        private final GeneralSegment generalSegment;
        private final BackgroundMonitoringSegment backgroundMonitoringSegment;
        private final NetworkSegment network;
        private final SshRemoteAccessSegment remoteAccess;
        private final UplinkSegment uplink;
        private final PublishingSegment publishing;
        private final AuthorizationSegment authorization;
        private final ComponentSettingsSegment componentSettings;
        private final SshServerSegment sshServer;

        SegmentContainer() {
            this.generalSegment = new GeneralSegment();
            this.backgroundMonitoringSegment = new BackgroundMonitoringSegment();
            this.network = new NetworkSegment();
            this.publishing = new PublishingSegment();
            this.authorization = new AuthorizationSegment();
            this.remoteAccess = new SshRemoteAccessSegment();
            this.uplink = new UplinkSegment();
            this.componentSettings = new ComponentSettingsSegment();
            this.sshServer = new SshServerSegment();
        }

        public GeneralSegment getGeneralSegment() {
            return this.generalSegment;
        }

        public BackgroundMonitoringSegment getBackgroundMonitoringSegment() {
            return this.backgroundMonitoringSegment;
        }

        public NetworkSegment getNetworkSegment() {
            return this.network;
        }

        public PublishingSegment getPublishingSegment() {
            return this.publishing;
        }

        public AuthorizationSegment getAuthorizationSegment() {
            return this.authorization;
        }

        public SshRemoteAccessSegment getRemoteAccess() {
            return this.remoteAccess;
        }

        public UplinkSegment getUplink() {
            return this.uplink;
        }

        public ComponentSettingsSegment getComponentSettings() {
            return this.componentSettings;
        }

        public SshServerSegment getSshServer() {
            return this.sshServer;
        }
    }

    public class ServerPortListSegment
    implements Segment {
        private Map<String, ServerPortSegment> portSegmentNameToServerPortSegmentMap = new HashMap<String, ServerPortSegment>();

        @Override
        public String getPath() {
            return "network/serverPorts";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ServerPortSegment getOrCreateServerPort(String name) {
            Map<String, ServerPortSegment> map = this.portSegmentNameToServerPortSegmentMap;
            synchronized (map) {
                if (this.portSegmentNameToServerPortSegmentMap.containsKey(name)) {
                    return this.portSegmentNameToServerPortSegmentMap.get(name);
                }
                ServerPortSegment segment = new ServerPortSegment(name);
                this.portSegmentNameToServerPortSegmentMap.put(name, segment);
                return segment;
            }
        }
    }

    public class ServerPortSegment
    implements Segment {
        private final String name;

        public ServerPortSegment(String name) {
            this.name = name;
        }

        @Override
        public String getPath() {
            return "network/serverPorts/" + this.name;
        }

        public ConfigurationKey port() {
            return new ConfigurationKey(){

                @Override
                public String getConfigurationKey() {
                    return ConfigurationSegmentFactory.PORT;
                }
            };
        }

        public ConfigurationKey ip() {
            return new ConfigurationKey(){

                @Override
                public String getConfigurationKey() {
                    return ConfigurationSegmentFactory.IP;
                }
            };
        }
    }

    public class SshAccountListSegment
    implements Segment {
        private final Map<String, SshAccountSegment> sshAccountNameToSshAccountSegmentMap = new HashMap<String, SshAccountSegment>();

        @Override
        public String getPath() {
            return "sshServer/accounts";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SshAccountSegment getOrCreateSshAccount(String name) {
            Map<String, SshAccountSegment> map = this.sshAccountNameToSshAccountSegmentMap;
            synchronized (map) {
                if (this.sshAccountNameToSshAccountSegmentMap.containsKey(name)) {
                    return this.sshAccountNameToSshAccountSegmentMap.get(name);
                }
                SshAccountSegment segment = new SshAccountSegment(name);
                this.sshAccountNameToSshAccountSegmentMap.put(name, segment);
                return segment;
            }
        }
    }

    public class SshAccountRoleListSegment
    implements Segment {
        private final Map<String, SshAccountRoleSegment> sshRoleNameToSegmentMap = new HashMap<String, SshAccountRoleSegment>();

        @Override
        public String getPath() {
            return "sshServer/roles";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SshAccountRoleSegment getOrCreateSshRole(String name) {
            Map<String, SshAccountRoleSegment> map = this.sshRoleNameToSegmentMap;
            synchronized (map) {
                if (this.sshRoleNameToSegmentMap.containsKey(name)) {
                    return this.sshRoleNameToSegmentMap.get(name);
                }
                SshAccountRoleSegment segment = new SshAccountRoleSegment(name);
                this.sshRoleNameToSegmentMap.put(name, segment);
                return segment;
            }
        }
    }

    public class SshAccountRoleSegment
    implements Segment {
        private final String name;

        public SshAccountRoleSegment(String name) {
            this.name = name;
        }

        @Override
        public String getPath() {
            return "sshServer/roles/" + this.name;
        }

        public ConfigurationKey getAllowedCommandPatterns() {
            return new ConfigurationKey(){

                @Override
                public String getConfigurationKey() {
                    return "allowedCommandPatterns";
                }
            };
        }
    }

    public class SshAccountSegment
    implements Segment {
        private final String name;

        public SshAccountSegment(String name) {
            this.name = name;
        }

        @Override
        public String getPath() {
            return "sshServer/accounts/" + this.name;
        }

        public ConfigurationKey role() {
            return new ConfigurationKey(){

                @Override
                public String getConfigurationKey() {
                    return "role";
                }
            };
        }

        public ConfigurationKey passwordHash() {
            return new ConfigurationKey(){

                @Override
                public String getConfigurationKey() {
                    return "passwordHash";
                }
            };
        }

        public ConfigurationKey enabled() {
            return new ConfigurationKey(){

                @Override
                public String getConfigurationKey() {
                    return ConfigurationSegmentFactory.ENABLED;
                }
            };
        }
    }

    public class SshConnectionListSegment
    implements Segment {
        private Map<String, SshConnectionSegment> sshConnectionNameToSegmentMap = new HashMap<String, SshConnectionSegment>();

        @Override
        public String getPath() {
            return "sshRemoteAccess/sshConnections";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SshConnectionSegment getOrCreateSshConnection(String connectionName) {
            Map<String, SshConnectionSegment> map = this.sshConnectionNameToSegmentMap;
            synchronized (map) {
                if (this.sshConnectionNameToSegmentMap.containsKey(connectionName)) {
                    return this.sshConnectionNameToSegmentMap.get(connectionName);
                }
                SshConnectionSegment segment = new SshConnectionSegment(connectionName);
                this.sshConnectionNameToSegmentMap.put(connectionName, segment);
                return segment;
            }
        }
    }

    public class SshConnectionSegment
    implements Segment {
        private final String name;

        public SshConnectionSegment(String name) {
            this.name = name;
        }

        @Override
        public String getPath() {
            return "sshRemoteAccess/sshConnections/" + this.name;
        }

        public ConfigurationKey displayName() {
            return new ConfigurationKey(){

                @Override
                public String getConfigurationKey() {
                    return "displayName";
                }
            };
        }

        public ConfigurationKey host() {
            return new ConfigurationKey(){

                @Override
                public String getConfigurationKey() {
                    return ConfigurationSegmentFactory.HOST;
                }
            };
        }

        public ConfigurationKey port() {
            return new ConfigurationKey(){

                @Override
                public String getConfigurationKey() {
                    return ConfigurationSegmentFactory.PORT;
                }
            };
        }

        public ConfigurationKey loginName() {
            return new ConfigurationKey(){

                @Override
                public String getConfigurationKey() {
                    return "loginName";
                }
            };
        }
    }

    public class SshRemoteAccessSegment
    implements Segment {
        private final SshConnectionListSegment sshConnections;

        public SshRemoteAccessSegment() {
            this.sshConnections = new SshConnectionListSegment();
        }

        @Override
        public String getPath() {
            return "sshRemoteAccess/";
        }

        public SshConnectionListSegment sshConnections() {
            return this.sshConnections;
        }
    }

    public class SshServerSegment
    implements Segment {
        private final SshAccountListSegment accounts;
        private final SshAccountRoleListSegment roles;

        public SshServerSegment() {
            this.accounts = new SshAccountListSegment();
            this.roles = new SshAccountRoleListSegment();
        }

        @Override
        public String getPath() {
            return "sshServer/";
        }

        public SshAccountListSegment getSshAccounts() {
            return this.accounts;
        }

        public SshAccountRoleListSegment getSshAccountRoles() {
            return this.roles;
        }

        public ConfigurationKey enabled() {
            return new ConfigurationKey(){

                @Override
                public String getConfigurationKey() {
                    return ConfigurationSegmentFactory.ENABLED;
                }
            };
        }

        public ConfigurationKey ip() {
            return new ConfigurationKey(){

                @Override
                public String getConfigurationKey() {
                    return ConfigurationSegmentFactory.IP;
                }
            };
        }

        public ConfigurationKey port() {
            return new ConfigurationKey(){

                @Override
                public String getConfigurationKey() {
                    return ConfigurationSegmentFactory.PORT;
                }
            };
        }
    }

    public class UplinkConnectionListSegment
    implements Segment {
        private Map<String, UplinkConnectionSegment> uplinkConnectionNameToSegmentMap = new HashMap<String, UplinkConnectionSegment>();

        @Override
        public String getPath() {
            return "uplink/uplinkConnections";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public UplinkConnectionSegment getOrCreateUplinkConnection(String connectionId) {
            Map<String, UplinkConnectionSegment> map = this.uplinkConnectionNameToSegmentMap;
            synchronized (map) {
                if (this.uplinkConnectionNameToSegmentMap.containsKey(connectionId)) {
                    return this.uplinkConnectionNameToSegmentMap.get(connectionId);
                }
                UplinkConnectionSegment segment = new UplinkConnectionSegment(connectionId);
                this.uplinkConnectionNameToSegmentMap.put(connectionId, segment);
                return segment;
            }
        }
    }

    public class UplinkConnectionSegment
    implements Segment {
        private final String id;

        public UplinkConnectionSegment(String id) {
            this.id = id;
        }

        @Override
        public String getPath() {
            return "uplink/uplinkConnections/" + this.id;
        }

        public ConfigurationKey displayName() {
            return () -> "displayName";
        }

        public ConfigurationKey host() {
            return () -> ConfigurationSegmentFactory.HOST;
        }

        public ConfigurationKey port() {
            return () -> ConfigurationSegmentFactory.PORT;
        }

        public ConfigurationKey loginName() {
            return () -> "loginName";
        }

        public ConfigurationKey clientID() {
            return () -> "clientID";
        }

        public ConfigurationKey connectOnStartup() {
            return () -> "connectOnStartup";
        }

        public ConfigurationKey autoRetry() {
            return () -> "autoRetry";
        }

        public ConfigurationKey isGateway() {
            return () -> "isGateway";
        }
    }

    public class UplinkSegment
    implements Segment {
        private final UplinkConnectionListSegment uplinkConnections;

        public UplinkSegment() {
            this.uplinkConnections = new UplinkConnectionListSegment();
        }

        @Override
        public String getPath() {
            return "uplink/";
        }

        public UplinkConnectionListSegment uplinkConnections() {
            return this.uplinkConnections;
        }
    }
}

