/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.view.timeline;

import de.rcenvironment.core.gui.workflow.view.timeline.TimelineComponentRow;
import de.rcenvironment.core.gui.workflow.view.timeline.TimelineView;
import java.util.ArrayList;
import java.util.List;

public class TimelineFilterTreeNode {
    private String componentID;
    private List<TimelineFilterTreeNode> children = new ArrayList<TimelineFilterTreeNode>();
    private TimelineComponentRow row = null;
    private TimelineFilterTreeNode parent;
    private boolean checked = true;

    public void setComponentID(String newComponentID) {
        this.componentID = newComponentID;
    }

    public List<TimelineFilterTreeNode> getChildren() {
        return this.children;
    }

    public void addChild(TimelineFilterTreeNode child) {
        this.children.add(child);
        child.setParent(this);
    }

    public TimelineFilterTreeNode getParent() {
        return this.parent;
    }

    public void setParent(TimelineFilterTreeNode parent) {
        this.parent = parent;
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
        if (!this.children.isEmpty()) {
            for (TimelineFilterTreeNode child : this.children) {
                child.setChecked(checked);
            }
        }
    }

    public boolean isChecked() {
        return this.checked;
    }

    public String getDisplayName() {
        if (this.hasRow()) {
            return this.row.getName();
        }
        return TimelineView.getComponentNameFromId(this.componentID, this);
    }

    public String getComponentID() {
        return this.componentID;
    }

    public boolean hasRow() {
        return this.row != null;
    }

    public TimelineFilterTreeNode hasChildWithComponentID(String checkComponentID) {
        for (TimelineFilterTreeNode current : this.getChildren()) {
            if (!current.getComponentID().equals(checkComponentID)) continue;
            return current;
        }
        return null;
    }

    public TimelineComponentRow getRow() {
        return this.row;
    }

    public void setRow(TimelineComponentRow row) {
        this.row = row;
    }
}

