/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.editor.validator;

import de.rcenvironment.core.component.validation.api.ComponentValidationMessage;
import de.rcenvironment.core.component.validation.api.ComponentValidationMessageStore;
import de.rcenvironment.core.component.workflow.model.api.Connection;
import de.rcenvironment.core.component.workflow.model.api.WorkflowDescription;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.gui.workflow.editor.commands.WorkflowNodeDeleteCommand;
import de.rcenvironment.core.gui.workflow.editor.validator.ValidationSupport;
import java.util.ArrayList;
import java.util.List;

public final class WorkflowDescriptionValidationUtils {
    private static final ComponentValidationMessageStore MESSAGE_STORE = ComponentValidationMessageStore.getInstance();

    private WorkflowDescriptionValidationUtils() {
    }

    public static void validateWorkflowDescription(WorkflowDescription workflowDescription, boolean onWorkflowStart, boolean cleanWorkflow) {
        WorkflowDescription workflowDescriptionClone = workflowDescription.clone();
        if (cleanWorkflow) {
            WorkflowDescriptionValidationUtils.cleanWorkflowDescription(workflowDescription, workflowDescriptionClone);
        }
        WorkflowDescriptionValidationUtils.validateWorkflowNodesAndUpdateValidState(workflowDescriptionClone.getWorkflowNodes(), onWorkflowStart);
    }

    private static void cleanWorkflowDescription(WorkflowDescription workflowDescription, WorkflowDescription workflowDescriptionClone) {
        WorkflowDescriptionValidationUtils.removeDisabledNodesAndMarkTargetsInvalid(workflowDescription, workflowDescriptionClone);
        WorkflowDescriptionValidationUtils.removeNotAvailableNodesAndMarkTargetsInvalid(workflowDescription, workflowDescriptionClone);
    }

    private static void removeDisabledNodesAndMarkTargetsInvalid(WorkflowDescription workflowDescription, WorkflowDescription workflowDescriptionClone) {
        ArrayList<WorkflowNode> nodesToDelete = new ArrayList<WorkflowNode>();
        for (WorkflowNode node : workflowDescriptionClone.getWorkflowNodes()) {
            if (node.isEnabled()) continue;
            nodesToDelete.add(node);
            WorkflowDescriptionValidationUtils.setTargetNodesInvalid(workflowDescription, node);
        }
        new WorkflowNodeDeleteCommand(workflowDescriptionClone, nodesToDelete).execute();
    }

    private static void removeNotAvailableNodesAndMarkTargetsInvalid(WorkflowDescription workflowDescription, WorkflowDescription workflowDescriptionClone) {
        ArrayList<WorkflowNode> nodesToDelete = new ArrayList<WorkflowNode>();
        for (WorkflowNode node : workflowDescriptionClone.getWorkflowNodes()) {
            if (!node.getComponentDescription().getIdentifier().startsWith("20ca0171b5e24e10a284af7c1d6d94e9missing_")) continue;
            nodesToDelete.add(node);
            WorkflowDescriptionValidationUtils.setTargetNodesInvalid(workflowDescription, node);
        }
        new WorkflowNodeDeleteCommand(workflowDescriptionClone, nodesToDelete).execute();
    }

    private static void validateWorkflowNodesAndUpdateValidState(List<WorkflowNode> nodes, boolean onWorkflowStart) {
        for (WorkflowNode node : nodes) {
            if (node.isValid()) continue;
            WorkflowDescriptionValidationUtils.validateComponent(node, onWorkflowStart);
        }
    }

    private static void setTargetNodesInvalid(WorkflowDescription workflowDescription, WorkflowNode node) {
        for (Connection connection : workflowDescription.getConnections()) {
            if (!connection.getSourceNode().getIdentifierAsObject().equals((Object)node.getIdentifierAsObject())) continue;
            connection.getTargetNode().setValid(false);
        }
    }

    public static void validateComponent(WorkflowNode workflowNode, boolean onWorkflowStart) {
        List<ComponentValidationMessage> messages = ValidationSupport.getInstance().validate(workflowNode.getComponentDescription(), onWorkflowStart);
        MESSAGE_STORE.addValidationMessagesByComponentId(workflowNode.getIdentifierAsObject().toString(), messages);
    }
}

