/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.log.internal;

import de.rcenvironment.core.gui.resources.api.ImageManager;
import de.rcenvironment.core.gui.resources.api.ImageSource;
import de.rcenvironment.core.gui.resources.api.StandardImages;
import de.rcenvironment.core.log.SerializableLogEntry;
import java.text.SimpleDateFormat;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class LogLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private Image infoImage = ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.INFORMATION_16);
    private Image warningImage = ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.WARNING_16);
    private Image errorImage = ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.ERROR_16);

    public Image getColumnImage(Object element, int columnIndex) {
        Image image = null;
        if (element instanceof SerializableLogEntry) {
            SerializableLogEntry logEntry = (SerializableLogEntry)element;
            if (columnIndex == 0) {
                if (3 == logEntry.getLevel()) {
                    image = this.infoImage;
                } else if (2 == logEntry.getLevel()) {
                    image = this.warningImage;
                } else if (1 == logEntry.getLevel()) {
                    image = this.errorImage;
                }
            }
        }
        return image;
    }

    public String getColumnText(Object element, int columnIndex) {
        String returnValue = "";
        if (element instanceof SerializableLogEntry) {
            SerializableLogEntry logEntry = (SerializableLogEntry)element;
            block0 : switch (columnIndex) {
                case 0: {
                    int level = logEntry.getLevel();
                    switch (level) {
                        case 1: {
                            returnValue = "ERROR";
                            break block0;
                        }
                        case 3: {
                            returnValue = "INFO";
                            break block0;
                        }
                        case 2: {
                            returnValue = "WARN";
                            break block0;
                        }
                    }
                    returnValue = "UNKNOWN";
                    break;
                }
                case 1: {
                    returnValue = logEntry.getMessage().replaceAll("#RCEn", " ");
                    break;
                }
                case 2: {
                    returnValue = logEntry.getBundleName();
                    break;
                }
                case 3: {
                    returnValue = logEntry.getPlatformIdentifer().getAssociatedDisplayName();
                    break;
                }
                case 4: {
                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS");
                    returnValue = df.format(logEntry.getTime());
                    break;
                }
            }
        }
        return returnValue;
    }
}

