/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.datamodel.types.internal;

import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.TypedDatum;
import de.rcenvironment.core.datamodel.internal.DefaultTypedDatumConverter;
import de.rcenvironment.core.datamodel.types.api.SmallTableTD;
import de.rcenvironment.core.datamodel.types.internal.AbstractTypedDatum;
import de.rcenvironment.core.utils.common.StringUtils;
import java.util.Arrays;

public class SmallTableTDImpl
extends AbstractTypedDatum
implements SmallTableTD {
    public static final int MAXIMUM_ENTRY_COUNT = 100000;
    private final TypedDatum[][] tableEntries;

    public SmallTableTDImpl(TypedDatum[][] tableEntries) {
        super(DataType.SmallTable);
        int rowCount = tableEntries.length;
        int columnCount = 0;
        if (rowCount > 0) {
            columnCount = tableEntries[0].length;
        }
        if (rowCount * columnCount > 100000) {
            throw new IllegalArgumentException(StringUtils.format((String)"Number of table cells (%d) exceeds the maximum (%d) allowed for %s", (Object[])new Object[]{rowCount * columnCount, 100000, this.getDataType()}));
        }
        this.tableEntries = tableEntries;
    }

    @Override
    public TypedDatum getTypedDatumOfCell(int rowIndex, int columnIndex) {
        return this.tableEntries[rowIndex][columnIndex];
    }

    @Override
    public void setTypedDatumForCell(TypedDatum typedDatum, int rowIndex, int columnIndex) {
        if (!this.isAllowedAsCellType(typedDatum)) {
            throw new IllegalArgumentException("Data type '" + (Object)((Object)typedDatum.getDataType()) + "' is not allowed in small tables.");
        }
        this.tableEntries[rowIndex][columnIndex] = typedDatum;
    }

    @Override
    public int getRowCount() {
        return this.tableEntries.length;
    }

    @Override
    public int getColumnCount() {
        int columnCount = 0;
        if (this.getRowCount() > 0) {
            columnCount = this.tableEntries[0].length;
        }
        return columnCount;
    }

    @Override
    public SmallTableTD getSubTable(int endRowIndex, int endColumnIndex) {
        return this.getSubTable(0, 0, endRowIndex, endColumnIndex);
    }

    @Override
    public SmallTableTD getSubTable(int beginRowIndex, int beginColumnIndex, int endRowIndex, int endColumnIndex) {
        TypedDatum[][] subTableEntries = new TypedDatum[endRowIndex - beginRowIndex][endColumnIndex - beginColumnIndex];
        int row = beginRowIndex;
        while (row < endRowIndex) {
            int column = beginColumnIndex;
            while (column < endColumnIndex) {
                subTableEntries[row - beginRowIndex][column - beginColumnIndex] = this.tableEntries[row][column];
                ++column;
            }
            ++row;
        }
        return new SmallTableTDImpl(subTableEntries);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Arrays.hashCode((Object[])this.tableEntries);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof SmallTableTD) {
            SmallTableTD other = (SmallTableTD)obj;
            TypedDatum[][] otherEntries = other.toArray();
            int i = 0;
            while (i < this.getRowCount()) {
                if (!Arrays.equals(this.tableEntries[i], otherEntries[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    @Override
    public TypedDatum[][] toArray() {
        TypedDatum[][] resultArray = new TypedDatum[this.getRowCount()][this.getColumnCount()];
        int i = 0;
        while (i < this.getRowCount()) {
            System.arraycopy(this.tableEntries[i], 0, resultArray[i], 0, this.getColumnCount());
            ++i;
        }
        return resultArray;
    }

    @Override
    public String toLengthLimitedString(int maxLength) {
        StringBuilder strBuilder = new StringBuilder("[");
        TypedDatum[][] tdArray = this.toArray();
        int j = 0;
        while (j < this.getColumnCount()) {
            strBuilder.append(tdArray[0][j].toString());
            strBuilder.append(",");
            if (strBuilder.length() > maxLength) break;
            ++j;
        }
        strBuilder.setLength(strBuilder.length() - 1);
        if (strBuilder.length() > maxLength) {
            strBuilder.setLength(maxLength);
            strBuilder.append("...");
        }
        strBuilder.append("]");
        if (tdArray.length > 1) {
            strBuilder.append(",...");
        }
        strBuilder.append(StringUtils.format((String)" (%dx%d)", (Object[])new Object[]{this.getRowCount(), this.getColumnCount()}));
        return strBuilder.toString();
    }

    public String toString() {
        StringBuilder strBuilder = new StringBuilder();
        TypedDatum[][] tdArray = this.toArray();
        int i = 0;
        while (i < this.getRowCount()) {
            int j = 0;
            while (j < this.getColumnCount()) {
                strBuilder.append(tdArray[i][j].toString());
                strBuilder.append(", ");
                ++j;
            }
            strBuilder.setLength(strBuilder.length() - 2);
            strBuilder.append(System.lineSeparator());
            ++i;
        }
        return strBuilder.toString();
    }

    private boolean isAllowedAsCellType(TypedDatum typedDatum) {
        DefaultTypedDatumConverter converter = new DefaultTypedDatumConverter();
        boolean convertibleToSmallTable = converter.isConvertibleTo(typedDatum.getDataType(), DataType.SmallTable);
        return convertibleToSmallTable && typedDatum.getDataType() != DataType.Matrix && typedDatum.getDataType() != DataType.Vector;
    }
}

