/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.uplink.network.channel.internal;

import de.rcenvironment.core.communication.uplink.client.execution.api.DirectoryDownloadReceiver;
import de.rcenvironment.core.communication.uplink.client.execution.api.DirectoryUploadContext;
import de.rcenvironment.core.communication.uplink.client.execution.api.DirectoryUploadProvider;
import de.rcenvironment.core.communication.uplink.client.execution.api.FileDataSource;
import de.rcenvironment.core.communication.uplink.common.internal.DataStreamDownloadWrapper;
import de.rcenvironment.core.communication.uplink.common.internal.DataStreamUploadWrapper;
import de.rcenvironment.core.communication.uplink.common.internal.MessageType;
import de.rcenvironment.core.communication.uplink.entities.FileHeader;
import de.rcenvironment.core.communication.uplink.entities.FileTransferSectionInfo;
import de.rcenvironment.core.communication.uplink.network.channel.internal.AbstractChannelEndpoint;
import de.rcenvironment.core.communication.uplink.network.channel.internal.ToolExecutionChannelState;
import de.rcenvironment.core.communication.uplink.network.internal.MessageBlock;
import de.rcenvironment.core.communication.uplink.session.api.UplinkSession;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.exception.ProtocolException;
import java.io.IOException;
import java.io.PipedInputStream;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Semaphore;

public abstract class AbstractExecutionChannelEndpoint
extends AbstractChannelEndpoint {
    protected ToolExecutionChannelState channelState = ToolExecutionChannelState.EXPECTING_NO_MESSAGES;

    public AbstractExecutionChannelEndpoint(UplinkSession session, long channelId) {
        super(session, session.getLocalSessionId(), channelId);
    }

    protected void validateExpectedChannelState(ToolExecutionChannelState expectedState, MessageBlock message) throws ProtocolException {
        if (this.channelState != expectedState) {
            throw new ProtocolException("Received a message of type " + (Object)((Object)message.getType()) + " in channel state " + this.channelState.name() + " when it should be " + expectedState.name());
        }
    }

    protected void validateActualVersusExpectedMessageType(MessageType actual, MessageType expected) throws ProtocolException {
        if (actual != expected) {
            throw new ProtocolException("Expected a message of type " + (Object)((Object)expected) + ", but received " + (Object)((Object)actual));
        }
    }

    protected void ensure(boolean condition) throws ProtocolException {
        if (!condition) {
            throw new ProtocolException("An internal check or condition was not in the required state; this indicates a protocol violation or an internal error");
        }
    }

    protected void ensureNotDefinedYet(Object object) throws ProtocolException {
        if (object != null) {
            throw new ProtocolException("An internal field was about to be initialized, but was already set; this indicates a protocol violation or an internal error");
        }
    }

    protected final class DirectoryDownloadWrapper {
        private DirectoryDownloadReceiver localReceiver;
        private boolean initialized;
        private DataStreamDownloadWrapper<FileDataSource> currentDownloadWrapper;
        private boolean receivedEndOfTransferMessage;
        private Semaphore receiveFileMethodsLock = new Semaphore(1);

        public DirectoryDownloadWrapper(DirectoryDownloadReceiver localReceiver) {
            this.localReceiver = localReceiver;
        }

        public void processMessageBlock(MessageBlock messageBlock) throws IOException {
            switch (messageBlock.getType()) {
                case FILE_TRANSFER_SECTION_START: {
                    AbstractExecutionChannelEndpoint.this.ensure(!this.initialized);
                    FileTransferSectionInfo fileTransferSectionInfo = AbstractExecutionChannelEndpoint.this.messageConverter.decodeFileTransferSectionStart(messageBlock);
                    Optional<List<String>> optionalListOfDirectories = fileTransferSectionInfo.getDirectoriesAsOptional();
                    if (optionalListOfDirectories.isPresent()) {
                        this.localReceiver.receiveDirectoryListing(optionalListOfDirectories.get());
                    }
                    this.initialized = true;
                    return;
                }
                case FILE_HEADER: {
                    AbstractExecutionChannelEndpoint.this.ensure(this.initialized);
                    AbstractExecutionChannelEndpoint.this.ensure(this.currentDownloadWrapper == null);
                    final FileHeader fileHeader = AbstractExecutionChannelEndpoint.this.messageConverter.decodeFileHeader(messageBlock);
                    try {
                        this.receiveFileMethodsLock.acquire();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                        AbstractExecutionChannelEndpoint.this.log.warn((Object)("Interrupted while preparing download of " + fileHeader.getPath()));
                    }
                    AbstractExecutionChannelEndpoint.this.log.debug((Object)StringUtils.format((String)"Starting download of file '%s', size: %d bytes", (Object[])new Object[]{fileHeader.getPath(), fileHeader.getSize()}));
                    this.currentDownloadWrapper = new DataStreamDownloadWrapper<FileDataSource>(){

                        @Override
                        public FileDataSource createReturnObject(long sizeParam, PipedInputStream inputStream) {
                            return new FileDataSource(fileHeader.getPath(), sizeParam, inputStream);
                        }
                    };
                    FileDataSource fileDataSource = this.currentDownloadWrapper.initialize(fileHeader.getSize(), MessageType.FILE_CONTENT);
                    if (fileHeader.getSize() == 0L) {
                        this.currentDownloadWrapper = null;
                    }
                    ConcurrencyUtils.getAsyncTaskService().execute("Uplink: receive a file download", () -> {
                        try {
                            try {
                                this.localReceiver.receiveFile(fileDataSource);
                            }
                            catch (IOException e) {
                                AbstractExecutionChannelEndpoint.this.log.error((Object)("Error while downloading file " + fileHeader.getPath()), (Throwable)e);
                                this.receiveFileMethodsLock.release();
                                AbstractExecutionChannelEndpoint.this.log.debug((Object)("Finished download of " + fileHeader.getPath()));
                            }
                        }
                        finally {
                            this.receiveFileMethodsLock.release();
                            AbstractExecutionChannelEndpoint.this.log.debug((Object)("Finished download of " + fileHeader.getPath()));
                        }
                    });
                    return;
                }
                case FILE_CONTENT: {
                    AbstractExecutionChannelEndpoint.this.ensure(this.currentDownloadWrapper != null);
                    boolean fileComplete = this.currentDownloadWrapper.processMessageBlock(messageBlock);
                    if (fileComplete) {
                        this.currentDownloadWrapper = null;
                    }
                    return;
                }
                case FILE_TRANSFER_SECTION_END: {
                    AbstractExecutionChannelEndpoint.this.ensure(this.initialized);
                    AbstractExecutionChannelEndpoint.this.ensure(this.currentDownloadWrapper == null);
                    this.receivedEndOfTransferMessage = true;
                    return;
                }
            }
            throw new ProtocolException("Unexpected message type during directory download: " + (Object)((Object)messageBlock.getType()));
        }

        public boolean isFinished() throws IOException {
            if (this.receivedEndOfTransferMessage) {
                try {
                    this.receiveFileMethodsLock.acquire();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    throw new IOException("Interrupted while waiting for all receiveFile() methods to complete");
                }
                return true;
            }
            return false;
        }
    }

    protected final class DirectoryUploadWrapper {
        private DirectoryUploadProvider localProvider;

        public DirectoryUploadWrapper(DirectoryUploadProvider localProvider) {
            this.localProvider = localProvider;
        }

        public void performDirectoryUpload() throws IOException {
            List<String> directoryListing = this.localProvider.provideDirectoryListing();
            AbstractExecutionChannelEndpoint.this.enqueueMessageBlockForSending(AbstractExecutionChannelEndpoint.this.messageConverter.encodeFileTransferSectionStart(new FileTransferSectionInfo(directoryListing)));
            this.localProvider.provideFiles(new DirectoryUploadContext(){

                @Override
                public void provideFile(FileDataSource dataSource) throws IOException {
                    FileHeader fileHeader = new FileHeader(dataSource.getSize(), dataSource.getRelativePath());
                    ((DirectoryUploadWrapper)DirectoryUploadWrapper.this).AbstractExecutionChannelEndpoint.this.log.debug((Object)StringUtils.format((String)"Starting upload of file '%s', size: %d bytes", (Object[])new Object[]{fileHeader.getPath(), fileHeader.getSize()}));
                    AbstractExecutionChannelEndpoint.this.enqueueMessageBlockForSending(((DirectoryUploadWrapper)DirectoryUploadWrapper.this).AbstractExecutionChannelEndpoint.this.messageConverter.encodeFileHeader(fileHeader));
                    new DataStreamUploadWrapper(((DirectoryUploadWrapper)DirectoryUploadWrapper.this).AbstractExecutionChannelEndpoint.this.asyncMessageBlockSender).uploadFromDataSource(((DirectoryUploadWrapper)DirectoryUploadWrapper.this).AbstractExecutionChannelEndpoint.this.channelId, MessageType.FILE_CONTENT, dataSource);
                }
            });
            AbstractExecutionChannelEndpoint.this.enqueueMessageBlockForSending(new MessageBlock(MessageType.FILE_TRANSFER_SECTION_END));
        }
    }
}

