/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.uplink.common.internal;

import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.exception.ProtocolException;

public enum MessageType {
    HANDSHAKE(121),
    HEARTBEAT(125),
    HEARTBEAT_RESPONSE(126),
    GOODBYE(127),
    TOOL_DESCRIPTOR_LIST_UPDATE(11),
    CHANNEL_INIT(21),
    CHANNEL_OFFER(22),
    CHANNEL_OFFER_RESPONSE(23),
    CHANNEL_INIT_RESPONSE(24),
    CHANNEL_CLOSE(24),
    TOOL_EXECUTION_REQUEST(31),
    TOOL_EXECUTION_REQUEST_RESPONSE(32),
    TOOL_EXECUTION_EVENTS(33),
    TOOL_EXECUTION_FINISHED(34),
    TOOL_CANCELLATION_REQUEST(35),
    FILE_TRANSFER_SECTION_START(41),
    FILE_HEADER(42),
    FILE_CONTENT(43),
    FILE_TRANSFER_SECTION_END(44),
    TOOL_DOCUMENTATION_REQUEST(51),
    TOOL_DOCUMENTATION_RESPONSE(52),
    TOOL_DOCUMENTATION_CONTENT(53),
    TEST(99);

    private final byte code;

    private MessageType(int code) {
        this.code = (byte)code;
        if (this.code < 1 || this.code > 127) {
            throw new IllegalArgumentException();
        }
    }

    public static MessageType resolve(byte code) throws ProtocolException {
        MessageType[] messageTypeArray = MessageType.values();
        int n = messageTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            MessageType type = messageTypeArray[n2];
            if (type.code == code) {
                return type;
            }
            ++n2;
        }
        throw new ProtocolException("Unrecognized message type: " + code);
    }

    public byte getCode() {
        return this.code;
    }

    public String toString() {
        return StringUtils.format((String)"%s (%d)", (Object[])new Object[]{this.name(), this.code});
    }
}

