/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.start.validators.internal;

import de.rcenvironment.core.configuration.ConfigurationSegment;
import de.rcenvironment.core.configuration.ConfigurationService;
import de.rcenvironment.core.start.common.validation.api.InstanceValidationResult;
import de.rcenvironment.core.start.common.validation.api.InstanceValidationResultFactory;
import de.rcenvironment.core.start.common.validation.spi.DefaultInstanceValidator;
import de.rcenvironment.core.start.validators.internal.Messages;
import de.rcenvironment.core.utils.common.StringUtils;
import java.util.Map;

public class HostConfigurationValidator
extends DefaultInstanceValidator {
    private static final String HOST = "host";
    private static final String INVALID_IP = "0.0.0.0";
    private static final String VALIDATIONNAME = "Connection configuration (host IP check)";
    private ConfigurationService configurationService;

    public InstanceValidationResult validate() {
        ConfigurationSegment configurationSegment = this.configurationService.getConfigurationSegment("network");
        Map connectionElements = configurationSegment.listElements("connections");
        for (Map.Entry entry : connectionElements.entrySet()) {
            ConfigurationSegment segment = (ConfigurationSegment)entry.getValue();
            String hostString = segment.getString(HOST);
            if (hostString == null || !hostString.equals(INVALID_IP)) continue;
            String message = StringUtils.format((String)Messages.invalidIPconfig, (Object[])new Object[]{entry.getKey()});
            return InstanceValidationResultFactory.createResultForFailureWhichRequiresInstanceShutdown((String)VALIDATIONNAME, (String)message, (String)message);
        }
        return InstanceValidationResultFactory.createResultForPassed((String)VALIDATIONNAME);
    }

    protected void bindConfigurationService(ConfigurationService configIn) {
        this.configurationService = configIn;
    }
}

