/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.instancemanagement.internal;

import de.rcenvironment.core.configuration.ConfigurationException;
import de.rcenvironment.core.configuration.ConfigurationSegment;
import de.rcenvironment.core.configuration.ConfigurationStoreFactory;
import de.rcenvironment.core.configuration.WritableConfigurationSegment;
import de.rcenvironment.core.configuration.internal.ConfigurationStore;
import de.rcenvironment.core.instancemanagement.internal.ConfigFilesCollection;
import de.rcenvironment.core.instancemanagement.internal.ConfigurationConnection;
import de.rcenvironment.core.instancemanagement.internal.ConfigurationSegmentFactory;
import de.rcenvironment.core.instancemanagement.internal.ConfigurationSshConnection;
import de.rcenvironment.core.instancemanagement.internal.ConfigurationUplinkConnection;
import de.rcenvironment.core.instancemanagement.internal.InstanceConfigurationException;
import de.rcenvironment.core.utils.common.StringUtils;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.mindrot.jbcrypt.BCrypt;

public class InstanceConfigurationImpl {
    private static final String SLASH = "/";
    private static final String DOT = ".";
    private static final String TO_UNPUBLISH_COMPONENT = "to unpublish component ";
    private static final String TO_PUBLISH_NEW_COMPONENT = "to publish new component.";
    private static final String ERROR_PATTERN = "Failed to %s";
    private final ConfigurationSegmentFactory.SegmentBuilder builder = ConfigurationSegmentFactory.getSegmentBuilder();
    private ConfigurationStore configurationStore;
    private ConfigurationSegment configurationSnapshot;
    private ConfigurationStore componentsStore;
    private ConfigurationSegment componentsSnapshot;
    private int profileVersion;

    public InstanceConfigurationImpl(ConfigFilesCollection files, int profileVersion) throws InstanceConfigurationException {
        this.profileVersion = profileVersion;
        this.configurationStore = ConfigurationStoreFactory.getConfigurationStore((File)files.getConfigurationFile());
        try {
            this.configurationSnapshot = this.configurationStore.getSnapshotOfRootSegment();
        }
        catch (IOException iOException) {
            throw new InstanceConfigurationException("Failed to create a snapshot of the configuration root segment.");
        }
        this.componentsStore = ConfigurationStoreFactory.getConfigurationStore((File)files.getComponentsFile());
        try {
            this.componentsSnapshot = this.componentsStore.getSnapshotOfRootSegment();
        }
        catch (IOException iOException) {
            throw new InstanceConfigurationException("Failed to create a snapshot of the components root segment.");
        }
    }

    public void setInstanceComment(String comment) throws InstanceConfigurationException {
        try {
            WritableConfigurationSegment writableSegment = this.configurationSnapshot.getOrCreateWritableSubSegment(this.builder.general().getPath());
            writableSegment.setString(this.builder.general().comment().getConfigurationKey(), comment);
        }
        catch (ConfigurationException e) {
            throw new InstanceConfigurationException(StringUtils.format((String)ERROR_PATTERN, (Object[])new Object[]{"set a comment."}), (Exception)((Object)e));
        }
    }

    public void setInstanceName(String name) throws InstanceConfigurationException {
        try {
            WritableConfigurationSegment writableSegment = this.configurationSnapshot.getOrCreateWritableSubSegment(this.builder.general().getPath());
            writableSegment.setString(this.builder.general().instanceName().getConfigurationKey(), name);
        }
        catch (ConfigurationException e) {
            throw new InstanceConfigurationException(StringUtils.format((String)ERROR_PATTERN, (Object[])new Object[]{"set an instance name."}), (Exception)((Object)e));
        }
    }

    public void setRelayFlag(boolean isRelay) throws InstanceConfigurationException {
        try {
            WritableConfigurationSegment writableSegment = this.configurationSnapshot.getOrCreateWritableSubSegment(this.builder.general().getPath());
            writableSegment.setBoolean(this.builder.general().isRelay().getConfigurationKey(), isRelay);
        }
        catch (ConfigurationException e) {
            throw new InstanceConfigurationException(StringUtils.format((String)ERROR_PATTERN, (Object[])new Object[]{"set the relay flag."}), (Exception)((Object)e));
        }
    }

    public void setWorkflowHostFlag(boolean isWorkflowHost) throws InstanceConfigurationException {
        try {
            WritableConfigurationSegment writableSegment = this.configurationSnapshot.getOrCreateWritableSubSegment(this.builder.general().getPath());
            writableSegment.setBoolean(this.builder.general().isWorkflowHost().getConfigurationKey(), isWorkflowHost);
        }
        catch (ConfigurationException e) {
            throw new InstanceConfigurationException(StringUtils.format((String)ERROR_PATTERN, (Object[])new Object[]{"set the workflow host flag."}), (Exception)((Object)e));
        }
    }

    public void setCustomNodeId(String customNodeId) throws InstanceConfigurationException {
        try {
            WritableConfigurationSegment writableSegment = this.configurationSnapshot.getOrCreateWritableSubSegment(this.builder.network().getPath());
            writableSegment.setString("customNodeId", customNodeId);
        }
        catch (ConfigurationException e) {
            throw new InstanceConfigurationException(StringUtils.format((String)ERROR_PATTERN, (Object[])new Object[]{"setting a custom node id"}), (Exception)((Object)e));
        }
    }

    public void setTempDirectory(String path) throws InstanceConfigurationException {
        try {
            WritableConfigurationSegment writableSegment = this.configurationSnapshot.getOrCreateWritableSubSegment(this.builder.general().getPath());
            writableSegment.setString(this.builder.general().tempDirectory().getConfigurationKey(), path);
        }
        catch (ConfigurationException e) {
            throw new InstanceConfigurationException(StringUtils.format((String)ERROR_PATTERN, (Object[])new Object[]{"set the temp directory"}), (Exception)((Object)e));
        }
    }

    public void setIpFilterFlag(boolean isFilterEnabled) throws InstanceConfigurationException {
        try {
            WritableConfigurationSegment writableSegment = this.configurationSnapshot.getOrCreateWritableSubSegment(this.builder.network().ipFilter().getPath());
            writableSegment.setBoolean(this.builder.network().ipFilter().enabled().getConfigurationKey(), isFilterEnabled);
        }
        catch (ConfigurationException e) {
            throw new InstanceConfigurationException(StringUtils.format((String)ERROR_PATTERN, (Object[])new Object[]{"to set the ip filter flag for a server instance."}), (Exception)((Object)e));
        }
    }

    public void addAllowedIp(String ip) throws InstanceConfigurationException {
        try {
            WritableConfigurationSegment writableSegment = this.configurationSnapshot.getOrCreateWritableSubSegment(this.builder.network().ipFilter().getPath());
            LinkedList<String> ipList = new LinkedList<String>();
            for (String presentIP : writableSegment.getStringArray(this.builder.network().ipFilter().allowedIps().getConfigurationKey())) {
                if (ip.equals(presentIP)) continue;
                ipList.add(presentIP);
            }
            ipList.add(ip);
            String[] array = new String[ipList.size()];
            array = ipList.toArray(array);
            writableSegment.setStringArray(this.builder.network().ipFilter().allowedIps().getConfigurationKey(), array);
        }
        catch (ConfigurationException e) {
            throw new InstanceConfigurationException(StringUtils.format((String)ERROR_PATTERN, (Object[])new Object[]{"to add an allowed ip adress to the ip filter."}), (Exception)((Object)e));
        }
    }

    public void removeAllowedIp(String ip) throws InstanceConfigurationException {
        try {
            WritableConfigurationSegment writableSegment = this.configurationSnapshot.getOrCreateWritableSubSegment(this.builder.network().ipFilter().getPath());
            List ipList = writableSegment.getStringArray(this.builder.network().ipFilter().allowedIps().getConfigurationKey());
            for (String s : ipList) {
                if (!s.equals(ip)) continue;
                ipList.remove(ip);
                String[] ipArray = new String[ipList.size()];
                ipArray = ipList.toArray(ipArray);
                writableSegment.setStringArray(this.builder.network().ipFilter().allowedIps().getConfigurationKey(), ipArray);
                return;
            }
            throw new InstanceConfigurationException("Couldn't remove ip: " + ip + " as it isn't present in the current configuration.");
        }
        catch (ConfigurationException e) {
            throw new InstanceConfigurationException(StringUtils.format((String)ERROR_PATTERN, (Object[])new Object[]{"to remove an allowed ip adress to the ip filter."}), (Exception)((Object)e));
        }
    }

    public void setBackgroundMonitoring(String id, int interval) throws InstanceConfigurationException {
        try {
            WritableConfigurationSegment writableSegment = this.configurationSnapshot.getOrCreateWritableSubSegment(this.builder.backgroundMonitoring().getPath());
            writableSegment.setString(this.builder.backgroundMonitoring().enableIds().getConfigurationKey(), id);
            writableSegment.setInteger(this.builder.backgroundMonitoring().intervalSeconds().getConfigurationKey(), Integer.valueOf(interval));
        }
        catch (ConfigurationException e) {
            throw new InstanceConfigurationException(StringUtils.format((String)ERROR_PATTERN, (Object[])new Object[]{"to set background monitoring service."}), (Exception)((Object)e));
        }
    }

    public void addConnection(ConfigurationConnection connection) throws InstanceConfigurationException {
        try {
            WritableConfigurationSegment writableSegment = this.configurationSnapshot.getOrCreateWritableSubSegment(this.builder.network().connections().getPath());
            ConfigurationSegment subsegment = writableSegment.getSubSegment(connection.getConnectionName());
            WritableConfigurationSegment newConnectionSegment = !subsegment.isPresentInCurrentConfiguration() ? writableSegment.createElement(connection.getConnectionName()) : writableSegment.getOrCreateWritableSubSegment(connection.getConnectionName());
            this.setConnectionFields(connection, newConnectionSegment);
        }
        catch (ConfigurationException e) {
            throw new InstanceConfigurationException(StringUtils.format((String)ERROR_PATTERN, (Object[])new Object[]{"to add new connection."}), (Exception)((Object)e));
        }
    }

    private void setConnectionFields(ConfigurationConnection connection, WritableConfigurationSegment segment) throws ConfigurationException {
        ConfigurationSegmentFactory.NetworkConnectionSegment connectionSegment = this.builder.network().connections().getOrCreateConnection(connection.getConnectionName());
        segment.setString(connectionSegment.host().getConfigurationKey(), connection.getHost());
        segment.setInteger(connectionSegment.port().getConfigurationKey(), Integer.valueOf(connection.getPort()));
        segment.setBoolean(connectionSegment.connectOnStartup().getConfigurationKey(), connection.getConnectOnStartup());
        segment.setLong(connectionSegment.autoRetryInitialDelay().getConfigurationKey(), Long.valueOf(connection.getAutoRetryInitialDelay()));
        segment.setLong(connectionSegment.autoRetryMaximumDelay().getConfigurationKey(), Long.valueOf(connection.getAutoRetryMaximumDelay()));
        segment.setFloat(connectionSegment.autoRetryDelayMultiplier().getConfigurationKey(), Float.valueOf(connection.getAutoRetryDelayMultiplier()));
    }

    public void removeConnection(String connection) throws InstanceConfigurationException {
        try {
            WritableConfigurationSegment writableSegment = this.configurationSnapshot.getOrCreateWritableSubSegment(this.builder.network().connections().getPath());
            ConfigurationSegment subsegment = writableSegment.getSubSegment(connection);
            if (!subsegment.isPresentInCurrentConfiguration()) {
                return;
            }
            boolean success = writableSegment.deleteElement(connection);
            if (!success) {
                throw new InstanceConfigurationException("Failed to delete connection with name: " + connection);
            }
        }
        catch (ConfigurationException e) {
            throw new InstanceConfigurationException(StringUtils.format((String)ERROR_PATTERN, (Object[])new Object[]{"to remove connection: " + connection}), (Exception)((Object)e));
        }
    }

    public void setRequestTimeout(long timeout) throws InstanceConfigurationException {
        try {
            WritableConfigurationSegment writableSegment = this.configurationSnapshot.getOrCreateWritableSubSegment(this.builder.network().getPath());
            writableSegment.setLong(this.builder.network().requestTimeoutMsec().getConfigurationKey(), Long.valueOf(timeout));
        }
        catch (ConfigurationException configurationException) {
            throw new InstanceConfigurationException(StringUtils.format((String)ERROR_PATTERN, (Object[])new Object[]{"to set request timeout."}));
        }
    }

    public void setForwardingTimeout(long timeout) throws InstanceConfigurationException {
        try {
            WritableConfigurationSegment writableSegment = this.configurationSnapshot.getOrCreateWritableSubSegment(this.builder.network().getPath());
            writableSegment.setLong(this.builder.network().forwardingTimeoutMsec().getConfigurationKey(), Long.valueOf(timeout));
        }
        catch (ConfigurationException configurationException) {
            throw new InstanceConfigurationException(StringUtils.format((String)ERROR_PATTERN, (Object[])new Object[]{"to set forwarding timeout."}));
        }
    }

    public void addServerPort(String portName, String ip, Integer port) throws InstanceConfigurationException {
        try {
            WritableConfigurationSegment writableSegment = this.configurationSnapshot.getOrCreateWritableSubSegment(this.builder.network().ports().getPath());
            WritableConfigurationSegment newPort = writableSegment.createElement(portName);
            newPort.setString(this.builder.network().ports().getOrCreateServerPort(portName).ip().getConfigurationKey(), ip);
            newPort.setInteger(this.builder.network().ports().getOrCreateServerPort(portName).port().getConfigurationKey(), port);
        }
        catch (ConfigurationException configurationException) {
            throw new InstanceConfigurationException(StringUtils.format((String)ERROR_PATTERN, (Object[])new Object[]{"to add server ports"}));
        }
    }

    public void addSshConnection(ConfigurationSshConnection sshConnection) throws InstanceConfigurationException {
        try {
            WritableConfigurationSegment writableSegment = this.configurationSnapshot.getOrCreateWritableSubSegment(this.builder.sshRemoteAccess().sshConnections().getPath());
            ConfigurationSegment subSegment = writableSegment.getSubSegment(sshConnection.getName());
            WritableConfigurationSegment newSegment = !subSegment.isPresentInCurrentConfiguration() ? writableSegment.createElement(sshConnection.getName()) : writableSegment.getOrCreateWritableSubSegment(sshConnection.getName());
            newSegment.setString(this.builder.sshRemoteAccess().sshConnections().getOrCreateSshConnection(sshConnection.getLoginName()).displayName().getConfigurationKey(), sshConnection.getDisplayName());
            newSegment.setString(this.builder.sshRemoteAccess().sshConnections().getOrCreateSshConnection(sshConnection.getLoginName()).host().getConfigurationKey(), sshConnection.getHost());
            newSegment.setInteger(this.builder.sshRemoteAccess().sshConnections().getOrCreateSshConnection(sshConnection.getLoginName()).port().getConfigurationKey(), Integer.valueOf(sshConnection.getPort()));
            newSegment.setString(this.builder.sshRemoteAccess().sshConnections().getOrCreateSshConnection(sshConnection.getLoginName()).loginName().getConfigurationKey(), sshConnection.getLoginName());
        }
        catch (ConfigurationException e) {
            throw new InstanceConfigurationException(StringUtils.format((String)ERROR_PATTERN, (Object[])new Object[]{"to add new ssh connection."}), (Exception)((Object)e));
        }
    }

    public void removeSshConnection(String configName) throws InstanceConfigurationException {
        try {
            WritableConfigurationSegment writableSegment = this.configurationSnapshot.getOrCreateWritableSubSegment(this.builder.sshRemoteAccess().sshConnections().getPath());
            ConfigurationSegment toRemove = writableSegment.getSubSegment(configName);
            if (!toRemove.isPresentInCurrentConfiguration()) {
                return;
            }
            boolean success = writableSegment.deleteElement(configName);
            if (!success) {
                throw new InstanceConfigurationException(StringUtils.format((String)ERROR_PATTERN, (Object[])new Object[]{"to remove ssh connection: " + configName}));
            }
        }
        catch (ConfigurationException configurationException) {
            throw new InstanceConfigurationException(StringUtils.format((String)ERROR_PATTERN, (Object[])new Object[]{"to remove ssh connection: " + configName}));
        }
    }

    public void addUplinkConnection(ConfigurationUplinkConnection uplinkConnection) throws InstanceConfigurationException {
        try {
            WritableConfigurationSegment writableSegment = this.configurationSnapshot.getOrCreateWritableSubSegment(this.builder.uplink().uplinkConnections().getPath());
            ConfigurationSegment subSegment = writableSegment.getSubSegment(uplinkConnection.getId());
            WritableConfigurationSegment newSegment = !subSegment.isPresentInCurrentConfiguration() ? writableSegment.createElement(uplinkConnection.getId()) : writableSegment.getOrCreateWritableSubSegment(uplinkConnection.getId());
            newSegment.setString(this.builder.uplink().uplinkConnections().getOrCreateUplinkConnection(uplinkConnection.getId()).displayName().getConfigurationKey(), uplinkConnection.getDisplayName());
            newSegment.setString(this.builder.uplink().uplinkConnections().getOrCreateUplinkConnection(uplinkConnection.getId()).host().getConfigurationKey(), uplinkConnection.getHost());
            newSegment.setInteger(this.builder.uplink().uplinkConnections().getOrCreateUplinkConnection(uplinkConnection.getId()).port().getConfigurationKey(), Integer.valueOf(uplinkConnection.getPort()));
            newSegment.setString(this.builder.uplink().uplinkConnections().getOrCreateUplinkConnection(uplinkConnection.getId()).loginName().getConfigurationKey(), uplinkConnection.getUser());
            newSegment.setString(this.builder.uplink().uplinkConnections().getOrCreateUplinkConnection(uplinkConnection.getId()).clientID().getConfigurationKey(), uplinkConnection.getClientID());
            newSegment.setBoolean(this.builder.uplink().uplinkConnections().getOrCreateUplinkConnection(uplinkConnection.getId()).isGateway().getConfigurationKey(), uplinkConnection.isGateway());
            newSegment.setBoolean(this.builder.uplink().uplinkConnections().getOrCreateUplinkConnection(uplinkConnection.getId()).connectOnStartup().getConfigurationKey(), uplinkConnection.getConnectOnStartup());
            newSegment.setBoolean(this.builder.uplink().uplinkConnections().getOrCreateUplinkConnection(uplinkConnection.getId()).autoRetry().getConfigurationKey(), uplinkConnection.getAutoRetry());
        }
        catch (ConfigurationException e) {
            throw new InstanceConfigurationException(StringUtils.format((String)ERROR_PATTERN, (Object[])new Object[]{"to add new ssh connection."}), (Exception)((Object)e));
        }
    }

    public void removeUplinkConnection(String id) throws InstanceConfigurationException {
        try {
            WritableConfigurationSegment writableSegment = this.configurationSnapshot.getOrCreateWritableSubSegment(this.builder.uplink().uplinkConnections().getPath());
            ConfigurationSegment toRemove = writableSegment.getSubSegment(id);
            if (!toRemove.isPresentInCurrentConfiguration()) {
                return;
            }
            boolean success = writableSegment.deleteElement(id);
            if (!success) {
                throw new InstanceConfigurationException(StringUtils.format((String)ERROR_PATTERN, (Object[])new Object[]{"to remove uplink connection: " + id}));
            }
        }
        catch (ConfigurationException configurationException) {
            throw new InstanceConfigurationException(StringUtils.format((String)ERROR_PATTERN, (Object[])new Object[]{"to remove uplink connection: " + id}));
        }
    }

    public void disableSshServer() throws InstanceConfigurationException {
        try {
            WritableConfigurationSegment writableSegment = this.configurationSnapshot.getOrCreateWritableSubSegment(this.builder.sshServer().getPath());
            writableSegment.setBoolean(this.builder.sshServer().enabled().getConfigurationKey(), false);
        }
        catch (ConfigurationException configurationException) {
            throw new InstanceConfigurationException(StringUtils.format((String)ERROR_PATTERN, (Object[])new Object[]{"to disable ssh server."}));
        }
    }

    public void enableSshServer() throws InstanceConfigurationException {
        try {
            WritableConfigurationSegment writableSegment = this.configurationSnapshot.getOrCreateWritableSubSegment(this.builder.sshServer().getPath());
            writableSegment.setBoolean(this.builder.sshServer().enabled().getConfigurationKey(), true);
        }
        catch (ConfigurationException configurationException) {
            throw new InstanceConfigurationException(StringUtils.format((String)ERROR_PATTERN, (Object[])new Object[]{"to enable ssh server."}));
        }
    }

    public void setSshServerIP(String ip) throws InstanceConfigurationException {
        try {
            WritableConfigurationSegment writableSegment = this.configurationSnapshot.getOrCreateWritableSubSegment(this.builder.sshServer().getPath());
            writableSegment.setString(this.builder.sshServer().ip().getConfigurationKey(), ip);
        }
        catch (ConfigurationException configurationException) {
            throw new InstanceConfigurationException(StringUtils.format((String)ERROR_PATTERN, (Object[])new Object[]{"to set ssh server ip adress."}));
        }
    }

    public void setSshServerPort(int port) throws InstanceConfigurationException {
        try {
            WritableConfigurationSegment writableSegment = this.configurationSnapshot.getOrCreateWritableSubSegment(this.builder.sshServer().getPath());
            writableSegment.setInteger(this.builder.sshServer().port().getConfigurationKey(), Integer.valueOf(port));
        }
        catch (ConfigurationException configurationException) {
            throw new InstanceConfigurationException(StringUtils.format((String)ERROR_PATTERN, (Object[])new Object[]{"to set ssh server port."}));
        }
    }

    public void addSshAccount(String username, String role, Boolean enabled, String password) throws InstanceConfigurationException {
        try {
            WritableConfigurationSegment writableSegment = this.configurationSnapshot.getOrCreateWritableSubSegment(this.builder.sshServer().getSshAccounts().getOrCreateSshAccount(username).getPath());
            writableSegment.setString(this.builder.sshServer().getSshAccounts().getOrCreateSshAccount(username).role().getConfigurationKey(), role);
            writableSegment.setBoolean(this.builder.sshServer().getSshAccounts().getOrCreateSshAccount(username).enabled().getConfigurationKey(), enabled.booleanValue());
            String passwordHash = BCrypt.hashpw((String)password, (String)BCrypt.gensalt((int)10));
            writableSegment.setString(this.builder.sshServer().getSshAccounts().getOrCreateSshAccount(username).passwordHash().getConfigurationKey(), passwordHash);
        }
        catch (ConfigurationException configurationException) {
            throw new InstanceConfigurationException(StringUtils.format((String)ERROR_PATTERN, (Object[])new Object[]{"to add SSH account."}));
        }
    }

    public void removeSshAccount(String username) throws InstanceConfigurationException {
        try {
            WritableConfigurationSegment writableSegment = this.configurationSnapshot.getOrCreateWritableSubSegment(this.builder.sshServer().getSshAccounts().getPath());
            ConfigurationSegment toRemove = writableSegment.getSubSegment(username);
            if (!toRemove.isPresentInCurrentConfiguration()) {
                return;
            }
            boolean success = writableSegment.deleteElement(username);
            if (!success) {
                throw new InstanceConfigurationException(StringUtils.format((String)ERROR_PATTERN, (Object[])new Object[]{"to remove SSH account: " + username}));
            }
        }
        catch (ConfigurationException configurationException) {
            throw new InstanceConfigurationException(StringUtils.format((String)ERROR_PATTERN, (Object[])new Object[]{"to remove SSH account: " + username}));
        }
    }

    public void enableImSshAccess(int port, String passphrase) throws InstanceConfigurationException {
        this.enableSshServer();
        if (this.getSshServerIp() == null) {
            this.setSshServerIP("127.0.0.1");
        }
        if (this.getSshServerPort() == null) {
            this.setSshServerPort(port);
        }
        try {
            WritableConfigurationSegment writableAccountsSegment = this.configurationSnapshot.getOrCreateWritableSubSegment(this.builder.sshServer().getSshAccounts().getPath());
            ConfigurationSegment accountSegment = writableAccountsSegment.getSubSegment("im_master");
            WritableConfigurationSegment newSegment = !accountSegment.isPresentInCurrentConfiguration() ? writableAccountsSegment.createElement("im_master") : writableAccountsSegment.getOrCreateWritableSubSegment("im_master");
            newSegment.setString(this.builder.sshServer().getSshAccounts().getOrCreateSshAccount("im_master").role().getConfigurationKey(), "instance_management_delegate_user");
            newSegment.setBoolean(this.builder.sshServer().getSshAccounts().getOrCreateSshAccount("im_master").enabled().getConfigurationKey(), true);
            newSegment.setString(this.builder.sshServer().getSshAccounts().getOrCreateSshAccount("im_master").passwordHash().getConfigurationKey(), passphrase);
        }
        catch (ConfigurationException configurationException) {
            throw new InstanceConfigurationException(StringUtils.format((String)ERROR_PATTERN, (Object[])new Object[]{"to add IM master account."}));
        }
    }

    public void removeServerPort(String name) throws InstanceConfigurationException {
        try {
            WritableConfigurationSegment writableSegment = this.configurationSnapshot.getOrCreateWritableSubSegment(this.builder.network().ports().getPath());
            boolean success = writableSegment.deleteElement(this.builder.network().ports().getOrCreateServerPort(name).getPath());
            if (!success) {
                throw new InstanceConfigurationException("Failed to remove server port :" + name);
            }
        }
        catch (ConfigurationException configurationException) {
            throw new InstanceConfigurationException(StringUtils.format((String)ERROR_PATTERN, (Object[])new Object[]{"to remove server port: " + name}));
        }
    }

    public void publishComponent(String name) throws InstanceConfigurationException {
        if (this.profileVersion <= 1) {
            if (name.contains(SLASH)) {
                throw new InstanceConfigurationException(StringUtils.format((String)ERROR_PATTERN, (Object[])new Object[]{"to publish new component. Use the name of the component instead of its component-id to publish the component."}));
            }
            try {
                WritableConfigurationSegment writableSegment = this.configurationSnapshot.getOrCreateWritableSubSegment(this.builder.publishing().getPath());
                LinkedList<String> componentList = new LinkedList<String>();
                for (String component : writableSegment.getStringArray(this.builder.publishing().components().getConfigurationKey())) {
                    if (component.equals(name)) continue;
                    componentList.add(component);
                }
                componentList.add(name);
                String[] array = new String[componentList.size()];
                array = componentList.toArray(array);
                writableSegment.setStringArray(this.builder.publishing().components().getConfigurationKey(), array);
            }
            catch (ConfigurationException e) {
                throw new InstanceConfigurationException(StringUtils.format((String)ERROR_PATTERN, (Object[])new Object[]{TO_PUBLISH_NEW_COMPONENT}), (Exception)((Object)e));
            }
        }
        if (this.profileVersion >= 2) {
            if (!name.contains(SLASH)) {
                name = "rce/" + name;
            }
            try {
                WritableConfigurationSegment writableSegment = this.componentsSnapshot.getOrCreateWritableSubSegment("authorization");
                writableSegment.setString(name, "public");
            }
            catch (ConfigurationException e) {
                throw new InstanceConfigurationException(StringUtils.format((String)ERROR_PATTERN, (Object[])new Object[]{TO_PUBLISH_NEW_COMPONENT}), (Exception)((Object)e));
            }
        }
    }

    public void unPublishComponent(String name) throws InstanceConfigurationException {
        if (this.profileVersion <= 1) {
            try {
                WritableConfigurationSegment writableSegment = this.configurationSnapshot.getOrCreateWritableSubSegment(this.builder.publishing().getPath());
                List ipList = writableSegment.getStringArray(this.builder.publishing().components().getConfigurationKey());
                for (String s : ipList) {
                    if (!s.equals(name)) continue;
                    ipList.remove(name);
                    String[] componentArray = new String[ipList.size()];
                    componentArray = ipList.toArray(componentArray);
                    writableSegment.setStringArray(this.builder.publishing().components().getConfigurationKey(), componentArray);
                    return;
                }
            }
            catch (ConfigurationException e) {
                throw new InstanceConfigurationException(StringUtils.format((String)ERROR_PATTERN, (Object[])new Object[]{TO_UNPUBLISH_COMPONENT + name + DOT}), (Exception)((Object)e));
            }
            throw new InstanceConfigurationException("Couldn't unpublish component: " + name + " as it isn't present in the current configuration.");
        }
        if (this.profileVersion >= 2) {
            if (!name.contains(SLASH)) {
                name = "rce/" + name;
            }
            boolean deleted = false;
            try {
                WritableConfigurationSegment writableSegment = this.componentsSnapshot.getOrCreateWritableSubSegment("authorization");
                deleted = writableSegment.deleteElement(name);
            }
            catch (ConfigurationException e) {
                throw new InstanceConfigurationException(StringUtils.format((String)ERROR_PATTERN, (Object[])new Object[]{TO_UNPUBLISH_COMPONENT + name + DOT}), (Exception)((Object)e));
            }
            if (!deleted) {
                throw new InstanceConfigurationException(StringUtils.format((String)ERROR_PATTERN, (Object[])new Object[]{TO_UNPUBLISH_COMPONENT + name + DOT + " This component is not published."}));
            }
        }
    }

    public Integer getSshServerPort() throws InstanceConfigurationException {
        ConfigurationSegment segment = this.configurationSnapshot.getSubSegment(this.builder.sshServer().getPath());
        return segment.getInteger(this.builder.sshServer().port().getConfigurationKey());
    }

    public String getSshServerIp() throws InstanceConfigurationException {
        ConfigurationSegment segment = this.configurationSnapshot.getSubSegment(this.builder.sshServer().getPath());
        return segment.getString(this.builder.sshServer().ip().getConfigurationKey());
    }

    public void update() throws InstanceConfigurationException {
        try {
            this.configurationStore.update(this.configurationSnapshot);
            if (this.profileVersion >= 2) {
                this.componentsStore.update(this.componentsSnapshot);
            }
        }
        catch (ConfigurationException | IOException throwable) {
            throw new InstanceConfigurationException("Failed to update configuration.");
        }
    }
}

